/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.config;

import java.util.HashMap;
import java.util.Map;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.apache.commons.beanutils.BeanUtils;
import org.pentaho.di.core.config.OgnlExpression;
import org.pentaho.di.core.exception.KettleConfigException;
import org.pentaho.di.i18n.BaseMessages;

public class PropertySetter {
    public static final String OGNL = "ognl";
    public static final String I18N = "i18n";
    private Map<String, OgnlExpression> ognlExpressions = new HashMap<String, OgnlExpression>();
    private OgnlContext octx = new OgnlContext();

    public void setProperty(Object obj, String property, String value) throws KettleConfigException {
        String[] expression = value.split(":");
        if (expression.length == 0) {
            throw new KettleConfigException("No value found for property [" + property + "] and obbject class [" + obj.getClass().getName() + "]");
        }
        String directive = expression[0];
        Object val = I18N.equalsIgnoreCase(directive) ? this.setI18nProperty(expression, value) : (OGNL.equalsIgnoreCase(directive) ? this.setOgnlProperty(expression, value) : value);
        try {
            BeanUtils.setProperty((Object)obj, (String)property, (Object)val);
        }
        catch (Exception e) {
            throw new KettleConfigException(e);
        }
    }

    private Object setI18nProperty(String[] expression, String value) throws KettleConfigException {
        if (expression.length == 3) {
            String packageName = expression[1];
            String key = expression[2];
            return BaseMessages.getString(packageName, key);
        }
        throw new KettleConfigException("the i18, directive need 3 parameters: i18n, the package name and the key, but " + expression.length + " parameters were found in [" + value + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object setOgnlProperty(String[] expression, String value) throws KettleConfigException {
        if (expression.length >= 2) {
            OgnlExpression expr = this.ognlExpressions.get(value);
            if (expr == null) {
                Map<String, OgnlExpression> map = this.ognlExpressions;
                synchronized (map) {
                    try {
                        expr = new OgnlExpression(expression[1]);
                        this.ognlExpressions.put(value, expr);
                    }
                    catch (OgnlException e) {
                        throw new KettleConfigException("Unable to parse expression [" + expression[1] + "] with Ognl", e);
                    }
                }
            }
            try {
                return expr.getValue(this.octx, this);
            }
            catch (OgnlException e) {
                throw new KettleConfigException("Unable to get value for expression [" + expression[1] + "] with Ognl", e);
            }
        }
        throw new KettleConfigException("the ognl, directive need at least 2 parameters: ongl and the expression but " + expression.length + " parameters were found in [" + value + "]");
    }
}

