/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.pentaho.di.core.database.MSSQLServerDatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.row.ValueMetaInterface;

public class AzureSqlDataBaseMeta
extends MSSQLServerDatabaseMeta {
    public static final String JDBC_AUTH_METHOD = "jdbcAuthMethod";
    public static final String IS_ALWAYS_ENCRYPTION_ENABLED = "azureAlwaysEncryptionEnabled";
    public static final String CLIENT_ID = "azureClientSecretId";
    public static final String CLIENT_SECRET_KEY = "azureClientSecretKey";
    public static final String SQL_AUTHENTICATION = "SQL Server Authentication";
    public static final String ACTIVE_DIRECTORY_PASSWORD = "Azure Active Directory - Password";
    public static final String ACTIVE_DIRECTORY_MFA = "Azure Active Directory - Universal With MFA";
    public static final String ACTIVE_DIRECTORY_INTEGRATED = "Azure Active Directory - Integrated";

    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 4};
    }

    @Override
    public String getDriverClass() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        String url = "jdbc:sqlserver://" + hostname + ":" + port + ";database=" + databaseName + ";encrypt=true;trustServerCertificate=false;hostNameInCertificate=*.database.windows.net;loginTimeout=30;";
        if (this.getAttribute(IS_ALWAYS_ENCRYPTION_ENABLED, "").equals("true")) {
            url = url + "columnEncryptionSetting=Enabled;keyVaultProviderClientId=" + this.getAttribute(CLIENT_ID, "") + ";keyVaultProviderClientKey=" + this.getAttribute(CLIENT_SECRET_KEY, "") + ";";
        }
        if (ACTIVE_DIRECTORY_PASSWORD.equals(this.getAttribute(JDBC_AUTH_METHOD, ""))) {
            return url + "authentication=ActiveDirectoryPassword;";
        }
        if (ACTIVE_DIRECTORY_MFA.equals(this.getAttribute(JDBC_AUTH_METHOD, ""))) {
            return url + "authentication=ActiveDirectoryInteractive;";
        }
        if (ACTIVE_DIRECTORY_INTEGRATED.equals(this.getAttribute(JDBC_AUTH_METHOD, ""))) {
            return url + "Authentication=ActiveDirectoryIntegrated;";
        }
        return url;
    }

    @Override
    public Object getValueFromResultSet(ResultSet rs, ValueMetaInterface val, int index) throws KettleDatabaseException {
        String data;
        try {
            if (val.getType() != 8) {
                return super.getValueFromResultSet(rs, val, index);
            }
            data = rs.getString(index + 1);
            if (rs.wasNull()) {
                data = null;
            }
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to get value '" + val.toStringMeta() + "' from database resultset, index " + index, e);
        }
        return data;
    }

    @Override
    public String getXulOverlayFile() {
        return "azuresqldb";
    }
}

