/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.util.Arrays;
import java.util.Map;
import org.pentaho.di.core.database.PostgreSQLDatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.util.Utils;

public class RedshiftDatabaseMeta
extends PostgreSQLDatabaseMeta {
    public static final String IAM_ROLE = "iamRole";
    public static final String AWS_ACCESS_KEY_ID = "awsAccessKeyId";
    public static final String AWS_ACCESS_KEY = "awsAccessKey";
    public static final String AUTHENTICATION_METHOD = "awsAuthenticationMethod";
    public static final String STANDARD_CREDENTIALS = "Standard";
    public static final String IAM_CREDENTIALS = "IAM Credentials";
    public static final String PROFILE_CREDENTIALS = "Profile";
    public static final String JDBC_AUTH_METHOD = "jdbcAuthMethod";
    public static final String IAM_ACCESS_KEY_ID = "iamAccessKeyId";
    public static final String IAM_SECRET_ACCESS_KEY = "iamSecretAccessKey";
    public static final String IAM_SESSION_TOKEN = "iamSessionToken";
    public static final String IAM_PROFILE_NAME = "iamProfileName";

    public RedshiftDatabaseMeta() {
        this.addExtraOption("REDSHIFT", "tcpKeepAlive", "true");
        this.addExtraOption("REDSHIFT", "loginTimeout", "10");
    }

    @Override
    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 5439;
        }
        return -1;
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "com.amazon.redshift.jdbc.Driver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + databaseName;
        }
        if (Arrays.asList(PROFILE_CREDENTIALS, IAM_CREDENTIALS).contains(this.getAttribute(JDBC_AUTH_METHOD, ""))) {
            return "jdbc:redshift:iam://" + hostname + ":" + port + "/" + databaseName;
        }
        return "jdbc:redshift://" + hostname + ":" + port + "/" + databaseName;
    }

    @Override
    public void putOptionalOptions(Map<String, String> extraOptions) {
        if (IAM_CREDENTIALS.equals(this.getAttribute(JDBC_AUTH_METHOD, ""))) {
            extraOptions.put("REDSHIFT.AccessKeyID", this.getAttribute(IAM_ACCESS_KEY_ID, ""));
            extraOptions.put("REDSHIFT.SecretAccessKey", Encr.decryptPassword(this.getAttribute(IAM_SECRET_ACCESS_KEY, "")));
            extraOptions.put("REDSHIFT.SessionToken", this.getAttribute(IAM_SESSION_TOKEN, ""));
        } else if (PROFILE_CREDENTIALS.equals(this.getAttribute(JDBC_AUTH_METHOD, ""))) {
            extraOptions.put("REDSHIFT.Profile", this.getAttribute(IAM_PROFILE_NAME, ""));
        }
    }

    @Override
    public String getExtraOptionsHelpText() {
        return "http://docs.aws.amazon.com/redshift/latest/mgmt/configure-jdbc-connection.html";
    }

    @Override
    public boolean isFetchSizeSupported() {
        return false;
    }

    @Override
    public boolean supportsSetMaxRows() {
        return false;
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"RedshiftJDBC4_1.0.10.1010.jar"};
    }

    public String getIamRole() {
        return this.getParamIfSet(IAM_ROLE, this.getAttributes().getProperty(IAM_ROLE));
    }

    public String getAwsAccessKeyId() {
        return this.getParamIfSet(AWS_ACCESS_KEY_ID, this.getAttributes().getProperty(AWS_ACCESS_KEY_ID));
    }

    public String getAwsAccessKey() {
        return this.getParamIfSet(AWS_ACCESS_KEY, this.getAttributes().getProperty(AWS_ACCESS_KEY));
    }

    public String getAwsAuthenticationMethod() {
        return this.getParamIfSet(AUTHENTICATION_METHOD, this.getAttributes().getProperty(AUTHENTICATION_METHOD));
    }

    @Override
    public String getXulOverlayFile() {
        return "redshift";
    }

    private String getParamIfSet(String param, String val) {
        if (!Utils.isEmpty(val)) {
            return "&" + param + "=" + val;
        }
        return "";
    }
}

