/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.net.URL;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginTypeInterface;

public class Plugin
implements PluginInterface,
Comparable<Plugin> {
    public static Comparator<PluginInterface> nullStringComparator = (p1, p2) -> new CompareToBuilder().append((Object)p1.getName(), (Object)p2.getName(), Comparator.nullsLast(String::compareToIgnoreCase)).append((Object[])p1.getIds(), (Object[])p2.getIds()).toComparison();
    private String category;
    private String name;
    private String description;
    private String[] ids;
    private Class<? extends PluginTypeInterface> pluginType;
    private String imageFile;
    private boolean separateClassLoaderNeeded;
    private String classLoaderGroup;
    private boolean nativePlugin;
    private Map<Class<?>, String> classMap;
    private List<String> libraries;
    private String errorHelpFile;
    private Class<?> mainType;
    private URL pluginFolder;
    private String documentationUrl;
    private String casesUrl;
    private String forumUrl;
    private String suggestion;

    public Plugin(String[] ids, Class<? extends PluginTypeInterface> pluginType, Class<?> mainType, String category, String name, String description, String imageFile, boolean separateClassLoaderNeeded, boolean nativePlugin, Map<Class<?>, String> classMap, List<String> libraries, String errorHelpFile, URL pluginFolder) {
        this(ids, pluginType, mainType, category, name, description, imageFile, separateClassLoaderNeeded, nativePlugin, classMap, libraries, errorHelpFile, pluginFolder, null, null, null);
    }

    public Plugin(String[] ids, Class<? extends PluginTypeInterface> pluginType, Class<?> mainType, String category, String name, String description, String imageFile, boolean separateClassLoaderNeeded, boolean nativePlugin, Map<Class<?>, String> classMap, List<String> libraries, String errorHelpFile, URL pluginFolder, String documentationUrl, String casesUrl, String forumUrl) {
        this(ids, pluginType, mainType, category, name, description, imageFile, separateClassLoaderNeeded, null, nativePlugin, classMap, libraries, errorHelpFile, pluginFolder, documentationUrl, casesUrl, forumUrl);
    }

    public Plugin(String[] ids, Class<? extends PluginTypeInterface> pluginType, Class<?> mainType, String category, String name, String description, String imageFile, boolean separateClassLoaderNeeded, String classLoaderGroup, boolean nativePlugin, Map<Class<?>, String> classMap, List<String> libraries, String errorHelpFile, URL pluginFolder, String documentationUrl, String casesUrl, String forumUrl) {
        this.ids = ids;
        this.pluginType = pluginType;
        this.mainType = mainType;
        this.category = category;
        this.name = name;
        this.description = description;
        this.imageFile = imageFile;
        this.separateClassLoaderNeeded = separateClassLoaderNeeded;
        this.classLoaderGroup = classLoaderGroup;
        this.nativePlugin = nativePlugin;
        this.classMap = classMap;
        this.libraries = libraries;
        this.errorHelpFile = errorHelpFile;
        this.pluginFolder = pluginFolder;
        this.documentationUrl = Const.getDocUrl(documentationUrl);
        this.casesUrl = casesUrl;
        this.forumUrl = forumUrl;
    }

    public Plugin(String[] ids, Class<? extends PluginTypeInterface> pluginType, Class<?> mainType, String category, String name, String description, String imageFile, boolean separateClassLoaderNeeded, String classLoaderGroup, boolean nativePlugin, Map<Class<?>, String> classMap, List<String> libraries, String errorHelpFile, URL pluginFolder, String documentationUrl, String casesUrl, String forumUrl, String suggestion) {
        this(ids, pluginType, mainType, category, name, description, imageFile, separateClassLoaderNeeded, classLoaderGroup, nativePlugin, classMap, libraries, errorHelpFile, pluginFolder, documentationUrl, casesUrl, forumUrl);
        this.suggestion = suggestion;
    }

    public Plugin(String[] ids, Class<? extends PluginTypeInterface> pluginType, Class<?> mainType, String category, String name, String description, String imageFile, boolean separateClassLoaderNeeded, boolean nativePlugin, Map<Class<?>, String> classMap, List<String> libraries, String errorHelpFile, URL pluginFolder, String documentationUrl, String casesUrl, String forumUrl, String suggestion) {
        this(ids, pluginType, mainType, category, name, description, imageFile, separateClassLoaderNeeded, null, nativePlugin, classMap, libraries, errorHelpFile, pluginFolder, documentationUrl, casesUrl, forumUrl);
        this.suggestion = suggestion;
    }

    public String toString() {
        return this.ids[0] + "/" + this.name + "{" + this.pluginType + "}";
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Plugin && this.compareTo((Plugin)obj) == 0;
    }

    public int hashCode() {
        return this.ids[0].hashCode();
    }

    @Override
    public int compareTo(Plugin o) {
        return nullStringComparator.compare(this, o);
    }

    @Override
    public boolean matches(String id) {
        return Const.indexOfString(id, this.ids) >= 0;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String[] getIds() {
        return this.ids;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    @Override
    public Class<? extends PluginTypeInterface> getPluginType() {
        return this.pluginType;
    }

    public void setPluginType(Class<? extends PluginTypeInterface> pluginType) {
        this.pluginType = pluginType;
    }

    @Override
    public String getImageFile() {
        return this.imageFile;
    }

    @Override
    public void setImageFile(String imageFile) {
        this.imageFile = imageFile;
    }

    @Override
    public boolean isSeparateClassLoaderNeeded() {
        return this.separateClassLoaderNeeded;
    }

    public void setSaperateClassLoaderNeeded(boolean separateClassLoaderNeeded) {
        this.separateClassLoaderNeeded = separateClassLoaderNeeded;
    }

    @Override
    public boolean isNativePlugin() {
        return this.nativePlugin;
    }

    public void setNativePlugin(boolean nativePlugin) {
        this.nativePlugin = nativePlugin;
    }

    @Override
    public Map<Class<?>, String> getClassMap() {
        return this.classMap;
    }

    public void setClassMap(Map<Class<?>, String> classMap) {
        this.classMap = classMap;
    }

    @Override
    public List<String> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<String> libraries) {
        this.libraries = libraries;
    }

    @Override
    public String getErrorHelpFile() {
        return this.errorHelpFile;
    }

    @Override
    public void setErrorHelpFile(String errorHelpFile) {
        this.errorHelpFile = errorHelpFile;
    }

    @Override
    public Class<?> getMainType() {
        return this.mainType;
    }

    @Override
    public URL getPluginDirectory() {
        return this.pluginFolder;
    }

    @Override
    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    @Override
    public void setDocumentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
    }

    @Override
    public String getCasesUrl() {
        return this.casesUrl;
    }

    @Override
    public void setCasesUrl(String casesUrl) {
        this.casesUrl = casesUrl;
    }

    @Override
    public String getForumUrl() {
        return this.forumUrl;
    }

    @Override
    public void setForumUrl(String forumUrl) {
        this.forumUrl = forumUrl;
    }

    @Override
    public String getClassLoaderGroup() {
        return this.classLoaderGroup;
    }

    @Override
    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    @Override
    public String getSuggestion() {
        return this.suggestion;
    }

    @Override
    public void setClassLoaderGroup(String classLoaderGroup) {
        this.classLoaderGroup = classLoaderGroup;
    }
}

