/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.sftp.SftpFileObject;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystem;
import org.apache.commons.vfs2.util.PosixPermissions;
import org.pentaho.di.core.vfs.SftpFileSystemWindows;

class SftpFileObjectWithWindowsSupport
extends SftpFileObject {
    private static final String FULL_ACCESS = "(F)";
    private static final String MODIFY_ACCESS = "(M)";
    private static final String READ_AND_EXECUTE_ACCESS = "(RX)";
    private static final String READ_ACCESS = "(R)";
    private static final String WRITE_ACCESS = "(W)";
    private static final String WRITE_DATA_ADD_FILES_ACCESS = "WD";
    private static final String READ_DATA_ADD_FILES_ACCESS = "RD";
    private String path;

    SftpFileObjectWithWindowsSupport(AbstractFileName name, SftpFileSystemWindows fileSystem) throws FileSystemException {
        super(name, (SftpFileSystem)fileSystem);
        this.path = name.getPath();
    }

    protected boolean doIsReadable() throws Exception {
        SftpFileSystemWindows fileSystem = (SftpFileSystemWindows)this.getAbstractFileSystem();
        if (!fileSystem.isRemoteHostWindows()) {
            return super.doIsReadable();
        }
        List<String> userGroups = fileSystem.getUserGroups();
        Map<String, String> filePermissions = fileSystem.getFilePermission(this.path);
        for (String group : userGroups) {
            String acl = filePermissions.get(group);
            if (acl == null) continue;
            return acl.contains(FULL_ACCESS) || acl.contains(MODIFY_ACCESS) || acl.contains(READ_AND_EXECUTE_ACCESS) || acl.contains(READ_ACCESS) || acl.contains(WRITE_ACCESS) || acl.contains(WRITE_DATA_ADD_FILES_ACCESS) || acl.contains(READ_DATA_ADD_FILES_ACCESS);
        }
        return false;
    }

    protected boolean doIsWriteable() throws Exception {
        SftpFileSystemWindows fileSystem = (SftpFileSystemWindows)this.getAbstractFileSystem();
        if (!fileSystem.isRemoteHostWindows()) {
            return super.doIsWriteable();
        }
        List<String> userGroups = fileSystem.getUserGroups();
        Map<String, String> filePermissions = fileSystem.getFilePermission(this.path);
        for (String group : userGroups) {
            String acl = filePermissions.get(group);
            if (acl == null) continue;
            return acl.contains(FULL_ACCESS) || acl.contains(MODIFY_ACCESS) || acl.contains(WRITE_ACCESS) || acl.contains(WRITE_DATA_ADD_FILES_ACCESS);
        }
        return false;
    }

    protected PosixPermissions getPermissions(boolean checkIds) throws Exception {
        if (checkIds && this.getAbstractFileSystem() instanceof SftpFileSystemWindows && ((SftpFileSystemWindows)this.getAbstractFileSystem()).isExecDisabled()) {
            return new PretendUserIsOwnerPosixPermissions();
        }
        return super.getPermissions(checkIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream doGetInputStream(int bufferSize) throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            return new CountedDelegatingInputStream(super.doGetInputStream(bufferSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            return new CountedDelegatingOutputStream(super.doGetOutputStream(bAppend));
        }
    }

    class CountedDelegatingOutputStream
    extends OutputStream {
        private OutputStream delegate;

        public CountedDelegatingOutputStream() {
        }

        public CountedDelegatingOutputStream(OutputStream out) {
            ((SftpFileSystemWindows)SftpFileObjectWithWindowsSupport.this.getAbstractFileSystem()).sftpBufferOpened();
            this.delegate = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
            ((SftpFileSystemWindows)SftpFileObjectWithWindowsSupport.this.getAbstractFileSystem()).sftpBufferOpened();
        }
    }

    class CountedDelegatingInputStream
    extends InputStream {
        InputStream delegate;

        public CountedDelegatingInputStream(InputStream in) {
            ((SftpFileSystemWindows)SftpFileObjectWithWindowsSupport.this.getAbstractFileSystem()).sftpBufferOpened();
            this.delegate = in;
        }

        public CountedDelegatingInputStream() {
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
            ((SftpFileSystemWindows)SftpFileObjectWithWindowsSupport.this.getAbstractFileSystem()).sftpBufferOpened();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }
    }

    public class PretendUserIsOwnerPosixPermissions
    extends PosixPermissions {
        public PretendUserIsOwnerPosixPermissions() {
            super(PosixPermissions.Type.UserReadable.getMask() + PosixPermissions.Type.UserWritable.getMask() + PosixPermissions.Type.UserExecutable.getMask() + PosixPermissions.Type.GroupReadable.getMask() + PosixPermissions.Type.GroupWritable.getMask() + PosixPermissions.Type.GroupExecutable.getMask() + PosixPermissions.Type.OtherReadable.getMask() + PosixPermissions.Type.OtherWritable.getMask() + PosixPermissions.Type.OtherExecutable.getMask(), true, true);
        }
    }
}

