/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.auth.core.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.pentaho.di.core.auth.core.AuthenticationConsumer;
import org.pentaho.di.core.auth.core.AuthenticationConsumerFactory;
import org.pentaho.di.core.auth.core.AuthenticationConsumerInvocationHandler;
import org.pentaho.di.core.auth.core.AuthenticationConsumptionException;
import org.pentaho.di.core.auth.core.AuthenticationPerformer;
import org.pentaho.di.core.auth.core.AuthenticationProvider;

public class ClassloaderBridgingAuthenticationPerformer<ReturnType, CreateArgType, ConsumedType>
implements AuthenticationPerformer<ReturnType, CreateArgType> {
    private final AuthenticationProvider provider;
    private final AuthenticationConsumerFactory<ReturnType, CreateArgType, ConsumedType> authenticationConsumerFactory;

    public ClassloaderBridgingAuthenticationPerformer(AuthenticationProvider provider, AuthenticationConsumerFactory<ReturnType, CreateArgType, ConsumedType> authenticationConsumerFactory) {
        this.provider = provider;
        this.authenticationConsumerFactory = authenticationConsumerFactory;
    }

    @Override
    public ReturnType perform(CreateArgType consumerCreateArg) throws AuthenticationConsumptionException {
        AuthenticationConsumer<ReturnType, Object> consumer = this.authenticationConsumerFactory.create(consumerCreateArg);
        Object providerProxy = Proxy.newProxyInstance(consumer.getClass().getClassLoader(), new Class[]{this.authenticationConsumerFactory.getConsumedType()}, (InvocationHandler)new AuthenticationConsumerInvocationHandler(this.provider));
        return consumer.consume(providerProxy);
    }

    @Override
    public String getDisplayName() {
        return this.provider.getDisplayName();
    }

    @Override
    public AuthenticationProvider getAuthenticationProvider() {
        return this.provider;
    }
}

