/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.injection.bean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.injection.bean.BeanLevelInfo;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;

public class BeanInjectionInfo {
    private static LogChannelInterface LOG = KettleLogStore.getLogChannelInterfaceFactory().create(BeanInjectionInfo.class);
    protected final Class<?> clazz;
    private final InjectionSupported clazzAnnotation;
    private Map<String, Property> properties = new HashMap<String, Property>();
    private List<Group> groupsList = new ArrayList<Group>();
    private Map<String, Group> groupsMap = new HashMap<String, Group>();
    private Set<String> hideProperties = new HashSet<String>();

    public static boolean isInjectionSupported(Class<?> clazz) {
        InjectionSupported annotation = clazz.getAnnotation(InjectionSupported.class);
        return annotation != null;
    }

    public BeanInjectionInfo(Class<?> clazz) {
        LOG.logDebug("Collect bean injection info for " + clazz);
        try {
            this.clazz = clazz;
            this.clazzAnnotation = clazz.getAnnotation(InjectionSupported.class);
            if (this.clazzAnnotation == null) {
                throw new RuntimeException("Injection not supported in " + clazz);
            }
            Group gr0 = new Group("");
            this.groupsList.add(gr0);
            this.groupsMap.put(gr0.getName(), gr0);
            for (String group : this.clazzAnnotation.groups()) {
                Group gr = new Group(group);
                this.groupsList.add(gr);
                this.groupsMap.put(gr.getName(), gr);
            }
            for (String p : this.clazzAnnotation.hide()) {
                this.hideProperties.add(p);
            }
            BeanLevelInfo root = new BeanLevelInfo();
            root.leafClass = clazz;
            root.init(this);
            this.properties = Collections.unmodifiableMap(this.properties);
            this.groupsList = Collections.unmodifiableList(this.groupsList);
            this.groupsMap = null;
        }
        catch (Throwable ex) {
            LOG.logError("Error bean injection info collection for " + clazz + ": " + ex.getMessage(), ex);
            throw ex;
        }
    }

    public String getLocalizationPrefix() {
        return this.clazzAnnotation.localizationPrefix();
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public List<Group> getGroups() {
        return this.groupsList;
    }

    protected void addInjectionProperty(Injection metaInj, BeanLevelInfo leaf) {
        if (StringUtils.isBlank((String)metaInj.name())) {
            throw new RuntimeException("Property name shouldn't be blank in the " + this.clazz);
        }
        String propertyName = this.calcPropertyName(metaInj, leaf);
        if (this.properties.containsKey(propertyName)) {
            throw new RuntimeException("Property '" + propertyName + "' already defined for " + this.clazz);
        }
        if (this.hideProperties.contains(propertyName)) {
            return;
        }
        Property prop = new Property(propertyName, metaInj.group(), leaf.createCallStack());
        this.properties.put(prop.name, prop);
        Group gr = this.groupsMap.get(metaInj.group());
        if (gr == null) {
            throw new RuntimeException("Group '" + metaInj.group() + "' for property '" + metaInj.name() + "' is not defined " + this.clazz);
        }
        gr.groupProperties.add(prop);
    }

    public String getDescription(String name) {
        String description = BaseMessages.getString(this.clazz, (String)(this.clazzAnnotation.localizationPrefix() + name), (String[])new String[0]);
        if (description != null && description.startsWith("!") && description.endsWith("!")) {
            for (Class<?> baseClass = this.clazz.getSuperclass(); baseClass != null; baseClass = baseClass.getSuperclass()) {
                InjectionSupported baseAnnotation = baseClass.getAnnotation(InjectionSupported.class);
                if (baseAnnotation == null || (description = BaseMessages.getString(baseClass, (String)(baseAnnotation.localizationPrefix() + name), (String[])new String[0])) == null || description.startsWith("!") || description.endsWith("!")) continue;
                return description;
            }
        }
        return description;
    }

    private String calcPropertyName(Injection metaInj, BeanLevelInfo leaf) {
        String name = metaInj.name();
        while (leaf != null) {
            if (StringUtils.isNotBlank((String)leaf.prefix)) {
                name = leaf.prefix + '.' + name;
            }
            leaf = leaf.parent;
        }
        if (!name.equals(metaInj.name()) && !metaInj.group().isEmpty()) {
            throw new RuntimeException("Group shouldn't be declared with prefix in " + this.clazz);
        }
        return name;
    }

    public String checkMetaDataInjectionBeanAgainstMessages() {
        ArrayList<String> propertiesWithNoLocalizedValues = new ArrayList<String>();
        for (String property : this.getProperties().keySet()) {
            String desc = this.getDescription(property);
            if (!desc.startsWith("!") || !desc.endsWith("!")) continue;
            propertiesWithNoLocalizedValues.add(property);
        }
        if (!propertiesWithNoLocalizedValues.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String property : propertiesWithNoLocalizedValues) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("\"").append(this.clazzAnnotation.localizationPrefix());
                sb.append(property).append("\"");
            }
            sb.insert(0, "The following Metadata Injection properties have no localized values set: ");
            sb.append(".  Add entries in the appropriate localized message properties file.");
            return sb.toString();
        }
        return null;
    }

    public class Group {
        private final String name;
        protected final List<Property> groupProperties = new ArrayList<Property>();

        public Group(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<Property> getGroupProperties() {
            return Collections.unmodifiableList(this.groupProperties);
        }

        public String getDescription() {
            return BeanInjectionInfo.this.getDescription(this.name);
        }
    }

    public class Property {
        private final String name;
        private final String groupName;
        protected final List<BeanLevelInfo> path;
        public final int pathArraysCount;

        public Property(String name, String groupName, List<BeanLevelInfo> path) {
            this.name = name;
            this.groupName = groupName;
            this.path = path;
            int ac = 0;
            for (BeanLevelInfo level : path) {
                if (level.dim == BeanLevelInfo.DIMENSION.NONE) continue;
                ++ac;
            }
            this.pathArraysCount = ac;
        }

        public String getName() {
            return this.name;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public List<BeanLevelInfo> getPath() {
            return this.path;
        }

        public String getDescription() {
            return BeanInjectionInfo.this.getDescription(this.name);
        }

        public Class<?> getPropertyClass() {
            return this.path.get((int)(this.path.size() - 1)).leafClass;
        }
    }
}

