/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.gui.JobTracker;
import org.pentaho.di.core.logging.BaseLogTable;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableCoreInterface;
import org.pentaho.di.core.logging.LogTableField;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryResult;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.w3c.dom.Node;

public class JobEntryLogTable
extends BaseLogTable
implements Cloneable,
LogTableInterface {
    private static Class<?> PKG = JobEntryLogTable.class;
    public static final String XML_TAG = "jobentry-log-table";

    private JobEntryLogTable(VariableSpace space, HasDatabasesInterface databasesInterface) {
        super(space, databasesInterface, null, null, null);
    }

    @Override
    public Object clone() {
        try {
            JobEntryLogTable table = (JobEntryLogTable)super.clone();
            table.fields = new ArrayList();
            for (LogTableField field : this.fields) {
                table.fields.add((LogTableField)field.clone());
            }
            return table;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("      ").append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        retval.append("        ").append(XMLHandler.addTagValue((String)"connection", (String)this.connectionName));
        retval.append("        ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("        ").append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append("        ").append(XMLHandler.addTagValue((String)"timeout_days", (String)this.timeoutInDays));
        retval.append(super.getFieldsXML());
        retval.append("      ").append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return retval.toString();
    }

    public void replaceMeta(LogTableCoreInterface logTableInterface) {
        if (!(logTableInterface instanceof JobEntryLogTable)) {
            return;
        }
        JobEntryLogTable logTable = (JobEntryLogTable)logTableInterface;
        super.replaceMeta(logTable);
    }

    @Override
    public void loadXML(Node jobnode, List<DatabaseMeta> databases, List<StepMeta> steps) {
        Node node = XMLHandler.getSubNode((Node)jobnode, (String)XML_TAG);
        if (node == null) {
            return;
        }
        this.connectionName = XMLHandler.getTagValue((Node)node, (String)"connection");
        this.schemaName = XMLHandler.getTagValue((Node)node, (String)"schema");
        this.tableName = XMLHandler.getTagValue((Node)node, (String)"table");
        this.timeoutInDays = XMLHandler.getTagValue((Node)node, (String)"timeout_days");
        super.loadFieldsXML(node);
    }

    public static JobEntryLogTable getDefault(VariableSpace space, HasDatabasesInterface databasesInterface) {
        JobEntryLogTable table = new JobEntryLogTable(space, databasesInterface);
        table.fields.add(new LogTableField(ID.ID_BATCH.id, true, false, "ID_BATCH", BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldName.IdBatch", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldDescription.IdBatch", (String[])new String[0]), 5, 8));
        table.fields.add(new LogTableField(ID.CHANNEL_ID.id, true, false, "CHANNEL_ID", BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldName.ChannelId", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldDescription.ChannelId", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.LOG_DATE.id, true, false, "LOG_DATE", BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldName.LogDate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldDescription.LogDate", (String[])new String[0]), 3, -1));
        table.fields.add(new LogTableField(ID.JOBNAME.id, true, false, "TRANSNAME", BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldName.JobName", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldDescription.JobName", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.JOBENTRYNAME.id, true, false, "STEPNAME", BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldName.JobEntryName", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldDescription.JobEntryName", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.LINES_READ.id, true, false, "LINES_READ", BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldName.LinesRead", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldDescription.LinesRead", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_WRITTEN.id, true, false, "LINES_WRITTEN", BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldName.LinesWritten", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldDescription.LinesWritten", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_UPDATED.id, true, false, "LINES_UPDATED", BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldName.LinesUpdated", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldDescription.LinesUpdated", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_INPUT.id, true, false, "LINES_INPUT", BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldName.LinesInput", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldDescription.LinesInput", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_OUTPUT.id, true, false, "LINES_OUTPUT", BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldName.LinesOutput", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldDescription.LinesOutput", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_REJECTED.id, true, false, "LINES_REJECTED", BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldName.LinesRejected", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldDescription.LinesRejected", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.ERRORS.id, true, false, "ERRORS", BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldName.Errors", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldDescription.Errors", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.RESULT.id, true, false, "RESULT", BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldName.Result", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldDescription.Result", (String[])new String[0]), 2, 5));
        table.fields.add(new LogTableField(ID.NR_RESULT_ROWS.id, true, false, "NR_RESULT_ROWS", BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldName.NrResultRows", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldDescription.NrResultRows", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.NR_RESULT_FILES.id, true, false, "NR_RESULT_FILES", BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldName.NrResultFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldDescription.NrResultFiles", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LOG_FIELD.id, false, false, "LOG_FIELD", BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldName.LogField", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldDescription.LogField", (String[])new String[0]), 2, 9999999));
        table.fields.add(new LogTableField(ID.COPY_NR.id, false, false, "COPY_NR", BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldName.CopyNr", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryLogTable.FieldDescription.CopyNr", (String[])new String[0]), 5, 8));
        table.findField(ID.JOBNAME.id).setNameField(true);
        table.findField(ID.LOG_DATE.id).setLogDateField(true);
        table.findField(ID.ID_BATCH.id).setKey(true);
        table.findField(ID.CHANNEL_ID.id).setVisible(false);
        table.findField(ID.LOG_FIELD.id).setLogField(true);
        table.findField(ID.ERRORS.id).setErrorsField(true);
        return table;
    }

    public RowMetaAndData getLogRecord(LogStatus status, Object subject, Object parent) {
        if (subject == null || subject instanceof JobEntryCopy) {
            JobEntryCopy jobEntryCopy = (JobEntryCopy)subject;
            Job parentJob = (Job)parent;
            RowMetaAndData row = new RowMetaAndData();
            for (LogTableField field : this.fields) {
                if (!field.isEnabled()) continue;
                Object value = null;
                if (subject != null) {
                    JobEntryInterface jobEntry = jobEntryCopy.getEntry();
                    JobTracker jobTracker = parentJob.getJobTracker();
                    JobTracker entryTracker = jobTracker.findJobTracker(jobEntryCopy);
                    JobEntryResult jobEntryResult = null;
                    if (entryTracker != null) {
                        jobEntryResult = entryTracker.getJobEntryResult();
                    }
                    Result result = null;
                    if (jobEntryResult != null) {
                        result = jobEntryResult.getResult();
                    }
                    switch (ID.valueOf(field.getId())) {
                        case ID_BATCH: {
                            value = new Long(parentJob.getBatchId());
                            break;
                        }
                        case CHANNEL_ID: {
                            value = jobEntry.getLogChannel().getLogChannelId();
                            break;
                        }
                        case LOG_DATE: {
                            value = new Date();
                            break;
                        }
                        case JOBNAME: {
                            value = parentJob.getJobname();
                            break;
                        }
                        case JOBENTRYNAME: {
                            value = jobEntry.getName();
                            break;
                        }
                        case LINES_READ: {
                            value = new Long(result != null ? result.getNrLinesRead() : 0L);
                            break;
                        }
                        case LINES_WRITTEN: {
                            value = new Long(result != null ? result.getNrLinesWritten() : 0L);
                            break;
                        }
                        case LINES_UPDATED: {
                            value = new Long(result != null ? result.getNrLinesUpdated() : 0L);
                            break;
                        }
                        case LINES_INPUT: {
                            value = new Long(result != null ? result.getNrLinesInput() : 0L);
                            break;
                        }
                        case LINES_OUTPUT: {
                            value = new Long(result != null ? result.getNrLinesOutput() : 0L);
                            break;
                        }
                        case LINES_REJECTED: {
                            value = new Long(result != null ? result.getNrLinesRejected() : 0L);
                            break;
                        }
                        case ERRORS: {
                            value = new Long(result != null ? result.getNrErrors() : 0L);
                            break;
                        }
                        case RESULT: {
                            value = new Boolean(result != null ? result.getResult() : false);
                            break;
                        }
                        case NR_RESULT_FILES: {
                            value = new Long(result != null && result.getResultFiles() != null ? (long)result.getResultFiles().size() : 0L);
                            break;
                        }
                        case NR_RESULT_ROWS: {
                            value = new Long(result != null && result.getRows() != null ? (long)result.getRows().size() : 0L);
                            break;
                        }
                        case LOG_FIELD: {
                            if (result == null) break;
                            value = result.getLogText();
                            break;
                        }
                        case COPY_NR: {
                            value = new Long(jobEntryCopy.getNr());
                            break;
                        }
                    }
                }
                row.addValue(field.getFieldName(), field.getDataType(), value);
                row.getRowMeta().getValueMeta(row.size() - 1).setLength(field.getLength());
            }
            return row;
        }
        return null;
    }

    @Override
    public String getLogTableCode() {
        return "JOB_ENTRY";
    }

    public String getLogTableType() {
        return BaseMessages.getString(PKG, (String)"JobEntryLogTable.Type.Description", (String[])new String[0]);
    }

    @Override
    public String getConnectionNameVariable() {
        return "KETTLE_JOBENTRY_LOG_DB";
    }

    @Override
    public String getSchemaNameVariable() {
        return "KETTLE_JOBENTRY_LOG_SCHEMA";
    }

    @Override
    public String getTableNameVariable() {
        return "KETTLE_JOBENTRY_LOG_TABLE";
    }

    public List<RowMetaInterface> getRecommendedIndexes() {
        ArrayList<RowMetaInterface> indexes = new ArrayList<RowMetaInterface>();
        LogTableField keyField = this.getKeyField();
        if (keyField.isEnabled()) {
            indexes.add(this.addFieldsToIndex(keyField));
        }
        indexes.add(this.addFieldsToIndex(this.findField(ID.JOBNAME.id), this.findField(ID.LOG_DATE.id)));
        return indexes;
    }

    public static enum ID {
        ID_BATCH("ID_BATCH"),
        CHANNEL_ID("CHANNEL_ID"),
        LOG_DATE("LOG_DATE"),
        JOBNAME("JOBNAME"),
        JOBENTRYNAME("JOBENTRYNAME"),
        LINES_READ("LINES_READ"),
        LINES_WRITTEN("LINES_WRITTEN"),
        LINES_UPDATED("LINES_UPDATED"),
        LINES_INPUT("LINES_INPUT"),
        LINES_OUTPUT("LINES_OUTPUT"),
        LINES_REJECTED("LINES_REJECTED"),
        ERRORS("ERRORS"),
        RESULT("RESULT"),
        NR_RESULT_ROWS("NR_RESULT_ROWS"),
        NR_RESULT_FILES("NR_RESULT_FILES"),
        LOG_FIELD("LOG_FIELD"),
        COPY_NR("COPY_NR");

        private String id;

        private ID(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }
}

