/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databasejoin;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.locks.ReentrantLock;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.databasejoin.DatabaseJoinData;
import org.pentaho.di.trans.steps.databasejoin.DatabaseJoinMeta;

public class DatabaseJoin
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = DatabaseJoinMeta.class;
    private final ReentrantLock dbLock = new ReentrantLock();

    public DatabaseJoin(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookupValues(DatabaseJoinMeta meta, DatabaseJoinData data, RowMetaInterface rowMeta, Object[] rowData) throws KettleException {
        this.dbLock.lock();
        try {
            int i;
            int newIndex;
            Object[] newRow;
            if (this.first) {
                this.first = false;
                data.outputRowMeta = rowMeta.clone();
                meta.getFields(data.outputRowMeta, this.getStepname(), new RowMetaInterface[]{meta.getTableFields()}, null, this, this.repository, this.metaStore);
                data.lookupRowMeta = new RowMeta();
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.CheckingRow", (String[])new String[0]) + rowMeta.getString(rowData));
                }
                data.keynrs = new int[meta.getParameterField().length];
                for (int i2 = 0; i2 < meta.getParameterField().length; ++i2) {
                    data.keynrs[i2] = rowMeta.indexOfValue(meta.getParameterField()[i2]);
                    if (data.keynrs[i2] < 0) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"DatabaseJoin.Exception.FieldNotFound", (String[])new String[]{meta.getParameterField()[i2]}));
                    }
                    data.lookupRowMeta.addValueMeta(rowMeta.getValueMeta(data.keynrs[i2]).clone());
                }
            }
            Object[] lookupRowData = new Object[data.lookupRowMeta.size()];
            for (int i3 = 0; i3 < data.keynrs.length; ++i3) {
                lookupRowData[i3] = rowData[data.keynrs[i3]];
            }
            ResultSet rs = data.db.openQuery(data.pstmt, data.lookupRowMeta, lookupRowData);
            Object[] add = data.db.getRow(rs);
            RowMetaInterface addMeta = data.db.getReturnRowMeta();
            this.incrementLinesInput();
            int counter = 0;
            while (add != null && (meta.getRowLimit() == 0 || counter < meta.getRowLimit())) {
                ++counter;
                newRow = RowDataUtil.resizeArray((Object[])rowData, (int)data.outputRowMeta.size());
                newIndex = rowMeta.size();
                for (i = 0; i < addMeta.size(); ++i) {
                    newRow[newIndex++] = add[i];
                }
                this.putRow(data.outputRowMeta, data.outputRowMeta.cloneRow(newRow));
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.PutoutRow", (String[])new String[0]) + data.outputRowMeta.getString(newRow));
                }
                if (meta.getRowLimit() != 0 && counter >= meta.getRowLimit()) continue;
                add = data.db.getRow(rs);
                this.incrementLinesInput();
            }
            if (counter == 0 && meta.isOuterJoin()) {
                if (data.notfound == null) {
                    data.notfound = new Object[data.db.getReturnRowMeta().size()];
                }
                newRow = RowDataUtil.resizeArray((Object[])rowData, (int)data.outputRowMeta.size());
                newIndex = rowMeta.size();
                for (i = 0; i < data.notfound.length; ++i) {
                    newRow[newIndex++] = data.notfound[i];
                }
                this.putRow(data.outputRowMeta, newRow);
            }
            data.db.closeQuery(rs);
        }
        finally {
            this.dbLock.unlock();
        }
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block5: {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            try {
                this.lookupValues((DatabaseJoinMeta)smi, (DatabaseJoinData)sdi, this.getInputRowMeta(), r);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.ErrorInStepRunning", (String[])new String[0]) + e.getMessage(), e);
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block5;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "DBJOIN001");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRunning(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.isStopped() || sdi.isDisposed()) {
            return;
        }
        DatabaseJoinData data = (DatabaseJoinData)sdi;
        this.dbLock.lock();
        try {
            if (data.db != null && data.db.getConnection() != null && !data.isCanceled) {
                data.db.cancelStatement((Statement)data.pstmt);
                this.setStopped(true);
                data.isCanceled = true;
            }
        }
        finally {
            this.dbLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        DatabaseJoinMeta meta = (DatabaseJoinMeta)smi;
        DatabaseJoinData data = (DatabaseJoinData)sdi;
        if (super.init(smi, sdi)) {
            if (meta.getDatabaseMeta() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"DatabaseJoin.Init.ConnectionMissing", (String[])new String[]{this.getStepname()}));
                return false;
            }
            this.dbLock.lock();
            try {
                data.db = new Database((LoggingObjectInterface)this, meta.getDatabaseMeta());
                data.db.shareVariablesWith((VariableSpace)this);
                try {
                    if (this.getTransMeta().isUsingUniqueConnections()) {
                        Trans trans = this.getTrans();
                        synchronized (trans) {
                            data.db.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                        }
                    } else {
                        data.db.connect(this.getPartitionID());
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.ConnectedToDB", (String[])new String[0]));
                    }
                    String sql = meta.getSql();
                    if (meta.isVariableReplace()) {
                        sql = this.environmentSubstitute(sql);
                    }
                    data.pstmt = data.db.prepareSQL(sql);
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.SQLStatement", (String[])new String[]{sql}));
                    }
                    data.db.setQueryLimit(meta.getRowLimit());
                    boolean bl = true;
                    return bl;
                }
                catch (KettleException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.DatabaseError", (String[])new String[0]) + e.getMessage(), e);
                    if (data.db != null) {
                        data.db.disconnect();
                    }
                    this.dbLock.unlock();
                }
            }
            finally {
                this.dbLock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        DatabaseJoinData data = (DatabaseJoinData)sdi;
        this.dbLock.lock();
        try {
            if (data.db != null) {
                data.db.disconnect();
            }
            super.dispose(smi, sdi);
        }
        finally {
            this.dbLock.unlock();
        }
    }
}

