/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput.poi;

import java.sql.Date;
import java.util.TimeZone;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.pentaho.di.core.spreadsheet.KCell;
import org.pentaho.di.core.spreadsheet.KCellType;

public class PoiCell
implements KCell {
    private Cell cell;

    public PoiCell(Cell cell) {
        this.cell = cell;
    }

    public KCellType getType() {
        CellType type = this.cell.getCellType();
        if (type == CellType.BOOLEAN) {
            return KCellType.BOOLEAN;
        }
        if (type == CellType.NUMERIC) {
            if (HSSFDateUtil.isCellDateFormatted((Cell)this.cell)) {
                return KCellType.DATE;
            }
            return KCellType.NUMBER;
        }
        if (type == CellType.STRING) {
            return KCellType.LABEL;
        }
        if (type == CellType.BLANK || type == CellType.ERROR) {
            return KCellType.EMPTY;
        }
        if (type == CellType.FORMULA) {
            CellType cachedFormulaResultType = this.cell.getCachedFormulaResultType();
            if (CellType.ERROR.equals((Object)cachedFormulaResultType)) {
                return KCellType.EMPTY;
            }
            if (CellType.BOOLEAN.equals((Object)cachedFormulaResultType)) {
                return KCellType.BOOLEAN_FORMULA;
            }
            if (CellType.STRING.equals((Object)cachedFormulaResultType)) {
                return KCellType.STRING_FORMULA;
            }
            if (CellType.NUMERIC.equals((Object)cachedFormulaResultType)) {
                if (HSSFDateUtil.isCellDateFormatted((Cell)this.cell)) {
                    return KCellType.DATE_FORMULA;
                }
                return KCellType.NUMBER_FORMULA;
            }
        }
        return null;
    }

    public Object getValue() {
        try {
            switch (this.getType()) {
                case BOOLEAN_FORMULA: 
                case BOOLEAN: {
                    return this.cell.getBooleanCellValue();
                }
                case DATE_FORMULA: 
                case DATE: {
                    long time = this.cell.getDateCellValue().getTime();
                    long tzOffset = TimeZone.getDefault().getOffset(time);
                    return new Date(time + tzOffset);
                }
                case NUMBER_FORMULA: 
                case NUMBER: {
                    return this.cell.getNumericCellValue();
                }
                case STRING_FORMULA: 
                case LABEL: {
                    return this.cell.getStringCellValue();
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get value of cell (" + this.cell.getColumnIndex() + ", " + this.cell.getRowIndex() + ")", e);
        }
    }

    public String getContents() {
        try {
            Object value = this.getValue();
            if (value == null) {
                return null;
            }
            return value.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get string content of cell (" + this.cell.getColumnIndex() + ", " + this.cell.getRowIndex() + ")", e);
        }
    }

    public int getRow() {
        Row row = this.cell.getRow();
        return row.getRowNum();
    }
}

