/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pentahoreporting.urlrepository;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.trans.steps.pentahoreporting.urlrepository.FileObjectContentLocation;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultMimeRegistry;
import org.pentaho.reporting.libraries.repository.MimeRegistry;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.UrlRepository;

public class FileObjectRepository
implements UrlRepository,
Serializable {
    private static final long serialVersionUID = -6221548332596506480L;
    private MimeRegistry mimeRegistry;
    private FileObjectContentLocation root;

    public FileObjectRepository(FileObject file) throws ContentIOException {
        this(file, (MimeRegistry)new DefaultMimeRegistry());
    }

    public FileObjectRepository(FileObject file, MimeRegistry mimeRegistry) throws ContentIOException {
        if (mimeRegistry == null) {
            throw new NullPointerException("MimeRegistry must be given");
        }
        if (file == null) {
            throw new NullPointerException("File must be given");
        }
        this.mimeRegistry = mimeRegistry;
        this.root = new FileObjectContentLocation((Repository)this, file);
    }

    public MimeRegistry getMimeRegistry() {
        return this.mimeRegistry;
    }

    public ContentLocation getRoot() throws ContentIOException {
        return this.root;
    }

    public URL getURL() throws MalformedURLException {
        try {
            return this.root.getBackend().getURL();
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
    }
}

