/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sasinput;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sasinput.SasInput;
import org.pentaho.di.trans.steps.sasinput.SasInputData;
import org.pentaho.di.trans.steps.sasinput.SasInputField;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class SasInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SasInputMeta.class;
    public static final String XML_TAG_FIELD = "field";
    private String acceptingField;
    private List<SasInputField> outputFields;

    @Override
    public void setDefault() {
        this.outputFields = new ArrayList<SasInputField>();
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            this.acceptingField = XMLHandler.getTagValue((Node)stepnode, (String)"accept_field");
            int nrFields = XMLHandler.countNodes((Node)stepnode, (String)XML_TAG_FIELD);
            this.outputFields = new ArrayList<SasInputField>();
            for (int i = 0; i < nrFields; ++i) {
                Node fieldNode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)XML_TAG_FIELD, (int)i);
                this.outputFields.add(new SasInputField(fieldNode));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"SASInputMeta.Exception.UnableToReadStepInformationFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public Object clone() {
        SasInputMeta retval = (SasInputMeta)super.clone();
        retval.setOutputFields(new ArrayList<SasInputField>());
        for (SasInputField field : this.outputFields) {
            retval.getOutputFields().add(field.clone());
        }
        return retval;
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        for (SasInputField field : this.outputFields) {
            try {
                ValueMetaInterface valueMeta = ValueMetaFactory.createValueMeta((String)field.getRename(), (int)field.getType());
                valueMeta.setLength(field.getLength(), field.getPrecision());
                valueMeta.setDecimalSymbol(field.getDecimalSymbol());
                valueMeta.setGroupingSymbol(field.getGroupingSymbol());
                valueMeta.setConversionMask(field.getConversionMask());
                valueMeta.setTrimType(field.getTrimType());
                valueMeta.setOrigin(name);
                row.addValueMeta(valueMeta);
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XMLHandler.addTagValue((String)"accept_field", (String)this.acceptingField));
        for (SasInputField field : this.outputFields) {
            retval.append(XMLHandler.openTag((String)XML_TAG_FIELD));
            retval.append(field.getXML());
            retval.append(XMLHandler.closeTag((String)XML_TAG_FIELD));
        }
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId stepId, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.acceptingField = rep.getStepAttributeString(stepId, "accept_field");
            this.outputFields = new ArrayList<SasInputField>();
            int nrFields = rep.countNrStepAttributes(stepId, "field_name");
            for (int i = 0; i < nrFields; ++i) {
                this.outputFields.add(new SasInputField(rep, stepId, i));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SASInputMeta.Exception.UnexpectedErrorReadingMetaDataFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "accept_field", this.acceptingField);
            for (int i = 0; i < this.outputFields.size(); ++i) {
                this.outputFields.get(i).saveRep(rep, metaStore, id_transformation, id_step, i);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SASInputMeta.Exception.UnableToSaveMetaDataToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (Utils.isEmpty((CharSequence)this.getAcceptingField())) {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SASInput.Log.Error.InvalidAcceptingFieldName", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new SasInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SasInputData();
    }

    public String getAcceptingField() {
        return this.acceptingField;
    }

    public void setAcceptingField(String acceptingField) {
        this.acceptingField = acceptingField;
    }

    public List<SasInputField> getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(List<SasInputField> outputFields) {
        this.outputFields = outputFields;
    }
}

