/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.script;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FileUtil;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.gui.SpoonInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.steps.script.Script;
import org.pentaho.di.trans.steps.script.ScriptDummy;
import org.pentaho.di.trans.steps.script.ScriptInterface;

public class ScriptAddedFunctions {
    public static Object undefinedValue = null;
    public static final long serialVersionUID = 1L;
    public static final int STRING_FUNCTION = 0;
    public static final int NUMERIC_FUNCTION = 1;
    public static final int DATE_FUNCTION = 2;
    public static final int LOGIC_FUNCTION = 3;
    public static final int SPECIAL_FUNCTION = 4;
    public static final int FILE_FUNCTION = 5;
    public static String[] jsFunctionList = new String[]{"appendToFile", "getTransformationName", "writeToLog", "getFiscalDate", "getProcessCount", "ceil", "floor", "abs", "getDayNumber", "isWorkingDay", "fireToDB", "getNextWorkingDay", "quarter", "dateDiff", "dateAdd", "fillString", "isCodepage", "ltrim", "rtrim", "lpad", "rpad", "week", "month", "year", "str2RegExp", "fileExists", "touch", "isRegExp", "date2str", "str2date", "sendMail", "replace", "decode", "isNum", "isDate", "lower", "upper", "str2num", "num2str", "Alert", "setEnvironmentVar", "getEnvironmentVar", "LoadScriptFile", "LoadScriptFromTab", "print", "println", "resolveIP", "trim", "substr", "getVariable", "setVariable", "LuhnCheck", "getDigitsOnly", "indexOf", "getOutputRowMeta", "getInputRowMeta", "createRowCopy", "putRow", "deleteFile", "createFolder", "copyFile", "getFileSize", "isFile", "isFolder", "getShortFilename", "getFileExtension", "getParentFoldername", "getLastModifiedTime", "trunc", "truncDate", "moveFile"};

    public static String getDigitsOnly(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 1) {
            return Const.getDigitsOnly((String)((String)ArgList[0]));
        }
        throw new RuntimeException("The function call getDigitsOnly requires 1 argument.");
    }

    public static boolean LuhnCheck(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        boolean returnCode = false;
        if (ArgList.length == 1) {
            if (!ScriptAddedFunctions.isNull(ArgList) && !ScriptAddedFunctions.isUndefined(ArgList)) {
                try {
                    int sum = 0;
                    int digit = 0;
                    int addend = 0;
                    boolean timesTwo = false;
                    String argstring = (String)ArgList[0];
                    for (int i = argstring.length() - 1; i >= 0; --i) {
                        digit = Integer.parseInt(argstring.substring(i, i + 1));
                        if (timesTwo) {
                            addend = digit * 2;
                            if (addend > 9) {
                                addend -= 9;
                            }
                        } else {
                            addend = digit;
                        }
                        sum += addend;
                        timesTwo = !timesTwo;
                    }
                    int modulus = sum % 10;
                    if (modulus == 0) {
                        returnCode = true;
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            throw new RuntimeException("The function call LuhnCheck requires 1 argument.");
        }
        return returnCode;
    }

    public static int indexOf(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        int returnIndex = -1;
        if (ArgList.length == 2 || ArgList.length == 3) {
            if (!ScriptAddedFunctions.isNull(ArgList) && !ScriptAddedFunctions.isUndefined(ArgList)) {
                String string = (String)ArgList[0];
                String subString = (String)ArgList[1];
                int fromIndex = 0;
                if (ArgList.length == 3) {
                    fromIndex = (int)Math.round((Double)ArgList[2]);
                }
                returnIndex = string.indexOf(subString, fromIndex);
            }
        } else {
            throw new RuntimeException("The function call indexOf requires 2 or 3 arguments");
        }
        return returnIndex;
    }

    public static Object getTransformationName(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            Object objTranName = actualObject.get("_TransformationName_");
            return objTranName;
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static void appendToFile(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (!ScriptAddedFunctions.isNull(ArgList) && !ScriptAddedFunctions.isUndefined(ArgList)) {
            try {
                FileOutputStream file = new FileOutputStream((String)ArgList[0], true);
                DataOutputStream out = new DataOutputStream(file);
                out.writeBytes((String)ArgList[1]);
                out.flush();
                out.close();
            }
            catch (Exception er) {
                throw new RuntimeException(er.toString());
            }
        } else {
            throw new RuntimeException("The function call appendToFile requires arguments.");
        }
    }

    public static Object getFiscalDate(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 2) {
            try {
                if (ScriptAddedFunctions.isNull(ArgList)) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList)) {
                    return undefinedValue;
                }
                Date dIn = (Date)ArgList[0];
                Calendar startDate = Calendar.getInstance();
                Calendar fisStartDate = Calendar.getInstance();
                Calendar fisOffsetDate = Calendar.getInstance();
                startDate.setTime(dIn);
                SimpleDateFormat dfFormatter = new SimpleDateFormat("dd.MM.yyyy");
                String strOffsetDate = (String)ArgList[1] + String.valueOf(startDate.get(1));
                Date dOffset = (Date)dfFormatter.parseObject(strOffsetDate);
                fisOffsetDate.setTime(dOffset);
                String strFisStartDate = "01.01." + String.valueOf(startDate.get(1) + 1);
                fisStartDate.setTime((Date)dfFormatter.parseObject(strFisStartDate));
                int iDaysToAdd = (int)((startDate.getTimeInMillis() - fisOffsetDate.getTimeInMillis()) / 86400000L);
                fisStartDate.add(5, iDaysToAdd);
                return fisStartDate.getTime();
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        throw new RuntimeException("The function call getFiscalDate requires 2 arguments.");
    }

    public static double getProcessCount(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 1) {
            try {
                Object scmO = actualObject.get("_step_");
                ScriptInterface scm = (ScriptInterface)scmO;
                String strType = ((String)ArgList[0]).toLowerCase();
                if (strType.equals("i")) {
                    return scm.getLinesInput();
                }
                if (strType.equals("o")) {
                    return scm.getLinesOutput();
                }
                if (strType.equals("r")) {
                    return scm.getLinesRead();
                }
                if (strType.equals("u")) {
                    return scm.getLinesUpdated();
                }
                if (strType.equals("w")) {
                    return scm.getLinesWritten();
                }
                if (strType.equals("e")) {
                    return scm.getLinesRejected();
                }
                return 0.0;
            }
            catch (Exception e) {
                return 0.0;
            }
        }
        throw new RuntimeException("The function call getProcessCount requires 1 argument.");
    }

    public static void writeToLog(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        switch (ArgList.length) {
            case 1: {
                try {
                    if (ScriptAddedFunctions.isNull(ArgList) || ScriptAddedFunctions.isUndefined(ArgList)) break;
                    Object scmO = actualObject.get("_step_");
                    Script scm = (Script)scmO;
                    String strMessage = (String)ArgList[0];
                    scm.logDebug(strMessage);
                }
                catch (Exception scmO) {}
                break;
            }
            case 2: {
                try {
                    if (ScriptAddedFunctions.isNull(ArgList) || ScriptAddedFunctions.isUndefined(ArgList)) break;
                    Object scmO = actualObject.get("_step_");
                    Script scm = (Script)scmO;
                    String strType = ((String)ArgList[0]).toLowerCase();
                    String strMessage = (String)ArgList[1];
                    if (strType.equals("b")) {
                        scm.logBasic(strMessage);
                        break;
                    }
                    if (strType.equals("d")) {
                        scm.logDebug(strMessage);
                        break;
                    }
                    if (strType.equals("l")) {
                        scm.logDetailed(strMessage);
                        break;
                    }
                    if (strType.equals("e")) {
                        scm.logError(strMessage);
                        break;
                    }
                    if (strType.equals("m")) {
                        scm.logMinimal(strMessage);
                        break;
                    }
                    if (!strType.equals("r")) break;
                    scm.logRowlevel(strMessage);
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                throw new RuntimeException("The function call writeToLog requires 1 or 2 arguments.");
            }
        }
    }

    private static boolean isUndefined(Object ArgList) {
        return ScriptAddedFunctions.isUndefined(new Object[]{ArgList}, new int[]{0});
    }

    private static boolean isUndefined(Object[] ArgList, int[] iArrToCheck) {
        for (int i = 0; i < iArrToCheck.length; ++i) {
            if (!ArgList[iArrToCheck[i]].equals(undefinedValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNull(Object ArgList) {
        return ScriptAddedFunctions.isNull(new Object[]{ArgList}, new int[]{0});
    }

    private static boolean isNull(Object[] ArgList) {
        for (int i = 0; i < ArgList.length; ++i) {
            if (ArgList[i] != null && !ArgList[i].equals(null)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNull(Object[] ArgList, int[] iArrToCheck) {
        for (int i = 0; i < iArrToCheck.length; ++i) {
            if (ArgList[iArrToCheck[i]] != null && !ArgList[iArrToCheck[i]].equals(null)) continue;
            return true;
        }
        return false;
    }

    public static Object abs(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 1) {
            try {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return new Double(Double.NaN);
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return undefinedValue;
                }
                return new Double(Math.abs((Double)ArgList[0]));
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new RuntimeException("The function call abs requires 1 argument.");
    }

    public static Object ceil(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 1) {
            try {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return new Double(Double.NaN);
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return undefinedValue;
                }
                return new Double(Math.ceil((Double)ArgList[0]));
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new RuntimeException("The function call ceil requires 1 argument.");
    }

    public static Object floor(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 1) {
            try {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return new Double(Double.NaN);
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return undefinedValue;
                }
                return new Double(Math.floor((Double)ArgList[0]));
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new RuntimeException("The function call floor requires 1 argument.");
    }

    public static Object getDayNumber(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 2) {
            try {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return new Double(Double.NaN);
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return undefinedValue;
                }
                Date dIn = (Date)ArgList[0];
                String strType = ((String)ArgList[1]).toLowerCase();
                Calendar startDate = Calendar.getInstance();
                startDate.setTime(dIn);
                if (strType.equals("y")) {
                    return new Double(startDate.get(6));
                }
                if (strType.equals("m")) {
                    return new Double(startDate.get(5));
                }
                if (strType.equals("w")) {
                    return new Double(startDate.get(7));
                }
                if (strType.equals("wm")) {
                    return new Double(startDate.get(8));
                }
                return new Double(startDate.get(6));
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new RuntimeException("The function call getDayNumber requires 2 arguments.");
    }

    public static Object isWorkingDay(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 1) {
            try {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return undefinedValue;
                }
                Date dIn = (Date)ArgList[0];
                Calendar startDate = Calendar.getInstance();
                startDate.setTime(dIn);
                if (startDate.get(7) != 7 && startDate.get(7) != 1) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new RuntimeException("The function call isWorkingDay requires 1 argument.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fireToDB(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        Object oRC;
        block14: {
            oRC = new Object();
            if (ArgList.length == 2) {
                try {
                    Object scmO = actualObject.get("_step_");
                    Script scm = (Script)scmO;
                    String strDBName = (String)ArgList[0];
                    String strSQL = (String)ArgList[1];
                    DatabaseMeta ci = DatabaseMeta.findDatabase(scm.getTransMeta().getDatabases(), (String)strDBName);
                    if (ci == null) {
                        throw new RuntimeException("Database connection not found: " + strDBName);
                    }
                    ci.shareVariablesWith((VariableSpace)scm);
                    Database db = new Database((LoggingObjectInterface)scm, ci);
                    db.setQueryLimit(0);
                    try {
                        if (scm.getTransMeta().isUsingUniqueConnections()) {
                            Trans trans = scm.getTrans();
                            synchronized (trans) {
                                db.connect(scm.getTrans().getTransactionId(), scm.getPartitionID());
                            }
                        } else {
                            db.connect(scm.getPartitionID());
                        }
                        ResultSet rs = db.openQuery(strSQL);
                        ResultSetMetaData resultSetMetaData = rs.getMetaData();
                        int columnCount = resultSetMetaData.getColumnCount();
                        if (rs != null) {
                            ArrayList<Object[]> list = new ArrayList<Object[]>();
                            while (rs.next()) {
                                Object[] objRow = new Object[columnCount];
                                for (int i = 0; i < columnCount; ++i) {
                                    objRow[i] = rs.getObject(i + 1);
                                }
                                list.add(objRow);
                            }
                            Object[][] resultArr = new Object[list.size()][];
                            list.toArray((T[])resultArr);
                            db.disconnect();
                            return resultArr;
                        }
                        break block14;
                    }
                    catch (Exception er) {
                        throw new RuntimeException(er.toString());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e.toString());
                }
            }
            throw new RuntimeException("The function call fireToDB requires 2 arguments.");
        }
        return oRC;
    }

    public static Object dateDiff(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 3) {
            try {
                if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1, 2})) {
                    return new Double(Double.NaN);
                }
                if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2})) {
                    return undefinedValue;
                }
                Date dIn1 = (Date)ArgList[0];
                Date dIn2 = (Date)ArgList[1];
                String strType = ((String)ArgList[2]).toLowerCase();
                int iRC = 0;
                Calendar startDate = Calendar.getInstance();
                Calendar endDate = Calendar.getInstance();
                startDate.setTime(dIn1);
                endDate.setTime(dIn2);
                long endL = endDate.getTimeInMillis() + (long)endDate.getTimeZone().getOffset(endDate.getTimeInMillis());
                long startL = startDate.getTimeInMillis() + (long)startDate.getTimeZone().getOffset(startDate.getTimeInMillis());
                if (strType.equals("y")) {
                    return new Double(endDate.get(1) - startDate.get(1));
                }
                if (strType.equals("m")) {
                    int iMonthsToAdd = (endDate.get(1) - startDate.get(1)) * 12;
                    return new Double(endDate.get(2) - startDate.get(2) + iMonthsToAdd);
                }
                if (strType.equals("d")) {
                    return new Double((endL - startL) / 86400000L);
                }
                if (strType.equals("wd")) {
                    int iOffset = -1;
                    if (endDate.before(startDate)) {
                        iOffset = 1;
                    }
                    while (iOffset == 1 && endL < startL || iOffset == -1 && endL > startL) {
                        int day = endDate.get(7);
                        if (day != 7 && day != 1) {
                            ++iRC;
                        }
                        endDate.add(5, iOffset);
                        endL = endDate.getTimeInMillis() + (long)endDate.getTimeZone().getOffset(endDate.getTimeInMillis());
                    }
                    return new Double(iRC);
                }
                if (strType.equals("w")) {
                    int iDays = (int)((endL - startL) / 86400000L);
                    return new Double(iDays / 7);
                }
                if (strType.equals("ss")) {
                    return new Double((endL - startL) / 1000L);
                }
                if (strType.equals("mi")) {
                    return new Double((endL - startL) / 60000L);
                }
                if (strType.equals("hh")) {
                    return new Double((endL - startL) / 3600000L);
                }
                return new Double((endL - startL) / 86400000L);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        throw new RuntimeException("The function call dateDiff requires 3 arguments.");
    }

    public static Object getNextWorkingDay(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 1) {
            try {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return undefinedValue;
                }
                Date dIn = (Date)ArgList[0];
                Calendar startDate = Calendar.getInstance();
                startDate.setTime(dIn);
                startDate.add(5, 1);
                while (startDate.get(7) == 7 || startDate.get(7) == 1) {
                    startDate.add(5, 1);
                }
                return startDate.getTime();
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        throw new RuntimeException("The function call getNextWorkingDay requires 1 argument.");
    }

    public static Object dateAdd(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 3) {
            try {
                if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1, 2})) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2})) {
                    return undefinedValue;
                }
                Date dIn = (Date)ArgList[0];
                String strType = ((String)ArgList[1]).toLowerCase();
                int iValue = (Integer)ArgList[2];
                Calendar cal = Calendar.getInstance();
                cal.setTime(dIn);
                if (strType.equals("y")) {
                    cal.add(1, iValue);
                } else if (strType.equals("m")) {
                    cal.add(2, iValue);
                } else if (strType.equals("d")) {
                    cal.add(5, iValue);
                } else if (strType.equals("w")) {
                    cal.add(3, iValue);
                } else if (strType.equals("wd")) {
                    int iOffset = 0;
                    while (iOffset < iValue) {
                        int day = cal.get(7);
                        cal.add(5, 1);
                        if (day == 7 || day == 1) continue;
                        ++iOffset;
                    }
                } else if (strType.equals("hh")) {
                    cal.add(10, iValue);
                } else if (strType.equals("mi")) {
                    cal.add(12, iValue);
                } else if (strType.equals("ss")) {
                    cal.add(13, iValue);
                }
                return cal.getTime();
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        throw new RuntimeException("The function call dateAdd requires 3 arguments.");
    }

    public static String fillString(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 2) {
            try {
                if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                    return (String)undefinedValue;
                }
                String fillChar = (String)ArgList[0];
                int count = (Integer)ArgList[1];
                if (fillChar.length() != 1) {
                    throw new RuntimeException("Please provide a valid Char to the fillString");
                }
                char[] chars = new char[count];
                while (count > 0) {
                    chars[--count] = fillChar.charAt(0);
                }
                return new String(chars);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        throw new RuntimeException("The function call fillString requires 2 arguments.");
    }

    public static Object isCodepage(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        boolean bRC = false;
        if (ArgList.length == 2) {
            try {
                if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                    return undefinedValue;
                }
                String strValueToCheck = (String)ArgList[0];
                String strCodePage = (String)ArgList[1];
                byte[] bytearray = strValueToCheck.getBytes();
                CharsetDecoder d = Charset.forName(strCodePage).newDecoder();
                CharBuffer r = d.decode(ByteBuffer.wrap(bytearray));
                r.toString();
                bRC = true;
            }
            catch (Exception e) {
                bRC = false;
            }
        } else {
            throw new RuntimeException("The function call isCodepage requires 2 arguments.");
        }
        return bRC;
    }

    public static String ltrim(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            if (ArgList.length == 1) {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return (String)undefinedValue;
                }
                String strValueToTrim = (String)ArgList[0];
                return strValueToTrim.replaceAll("^\\s+", "");
            }
            throw new RuntimeException("The function call ltrim requires 1 argument.");
        }
        catch (Exception e) {
            throw new RuntimeException("The function call ltrim is not valid : " + e.getMessage());
        }
    }

    public static String rtrim(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            if (ArgList.length == 1) {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return (String)undefinedValue;
                }
                String strValueToTrim = (String)ArgList[0];
                return strValueToTrim.replaceAll("\\s+$", "");
            }
            throw new RuntimeException("The function call rtrim requires 1 argument.");
        }
        catch (Exception e) {
            throw new RuntimeException("The function call rtrim is not valid : " + e.getMessage());
        }
    }

    public static String lpad(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            if (ArgList.length == 3) {
                if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1, 2})) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2})) {
                    return (String)undefinedValue;
                }
                String valueToPad = (String)ArgList[0];
                String filler = (String)ArgList[1];
                int size = (Integer)ArgList[2];
                while (valueToPad.length() < size) {
                    valueToPad = filler + valueToPad;
                }
                return valueToPad;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("The function call lpad requires 3 arguments.");
        }
        return null;
    }

    public static String rpad(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            if (ArgList.length == 3) {
                if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1, 2})) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2})) {
                    return (String)undefinedValue;
                }
                String valueToPad = (String)ArgList[0];
                String filler = (String)ArgList[1];
                int size = (Integer)ArgList[2];
                while (valueToPad.length() < size) {
                    valueToPad = valueToPad + filler;
                }
                return valueToPad;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("The function call rpad requires 3 arguments.");
        }
        return null;
    }

    public static Object year(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            if (ArgList.length == 1) {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return new Double(Double.NaN);
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return undefinedValue;
                }
                Date dArg1 = (Date)ArgList[0];
                Calendar cal = Calendar.getInstance();
                cal.setTime(dArg1);
                return new Double(cal.get(1));
            }
            throw new RuntimeException("The function call year requires 1 argument.");
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static Object month(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            if (ArgList.length == 1) {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return new Double(Double.NaN);
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return undefinedValue;
                }
                Date dArg1 = (Date)ArgList[0];
                Calendar cal = Calendar.getInstance();
                cal.setTime(dArg1);
                return new Double(cal.get(2));
            }
            throw new RuntimeException("The function call month requires 1 argument.");
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static Object quarter(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            if (ArgList.length == 1) {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return new Double(Double.NaN);
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return undefinedValue;
                }
                Date dArg1 = (Date)ArgList[0];
                Calendar cal = Calendar.getInstance();
                cal.setTime(dArg1);
                int iMonth = cal.get(2);
                if (iMonth <= 2) {
                    return new Double(1.0);
                }
                if (iMonth <= 5) {
                    return new Double(2.0);
                }
                if (iMonth <= 8) {
                    return new Double(3.0);
                }
                return new Double(4.0);
            }
            throw new RuntimeException("The function call quarter requires 1 argument.");
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static Object week(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            if (ArgList.length == 1) {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return new Double(Double.NaN);
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return undefinedValue;
                }
                Date dArg1 = (Date)ArgList[0];
                Calendar cal = Calendar.getInstance();
                cal.setTime(dArg1);
                return new Double(cal.get(3));
            }
            throw new RuntimeException("The function call week requires 1 argument.");
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object str2RegExp(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        String[] strArr = null;
        if (ArgList.length != 2) throw new RuntimeException("The function call str2RegExp requires 2 arguments.");
        try {
            if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                return null;
            }
            if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                return undefinedValue;
            }
            String strToMatch = (String)ArgList[0];
            Pattern p = Pattern.compile((String)ArgList[1]);
            Matcher m = p.matcher(strToMatch);
            if (!m.matches() || m.groupCount() <= 0) return strArr;
            strArr = new String[m.groupCount()];
            for (int i = 1; i <= m.groupCount(); ++i) {
                strArr[i - 1] = m.group(i);
            }
            return strArr;
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static void touch(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        block4: {
            try {
                if (ArgList.length == 1 && !ScriptAddedFunctions.isNull(ArgList[0]) && !ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    File file = new File((String)ArgList[0]);
                    boolean success = file.createNewFile();
                    if (!success) {
                        file.setLastModified(System.currentTimeMillis());
                    }
                    break block4;
                }
                throw new RuntimeException("The function call touch requires 1 valid argument.");
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
    }

    public static Object fileExists(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            if (ArgList.length == 1 && !ScriptAddedFunctions.isNull(ArgList[0]) && !ScriptAddedFunctions.isUndefined(ArgList[0])) {
                if (ArgList[0].equals(null)) {
                    return null;
                }
                File file = new File((String)ArgList[0]);
                return file.isFile();
            }
            throw new RuntimeException("The function call fileExists requires 1 valid argument.");
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static Object str2date(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        Object oRC = new Object();
        String sArg1 = "";
        String sArg2 = "";
        String sArg3 = "";
        String sArg4 = "";
        switch (ArgList.length) {
            case 0: {
                throw new RuntimeException("Please provide a valid string to the function call str2date.");
            }
            case 1: {
                try {
                    if (ScriptAddedFunctions.isNull(ArgList[0])) {
                        return null;
                    }
                    if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                        return undefinedValue;
                    }
                    sArg1 = (String)ArgList[0];
                    SimpleDateFormat dfFormatter = new SimpleDateFormat();
                    oRC = dfFormatter.parseObject(sArg1);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not apply local format for " + sArg1 + " : " + e.getMessage());
                }
            }
            case 2: {
                try {
                    if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                        return null;
                    }
                    if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                        return undefinedValue;
                    }
                    sArg1 = (String)ArgList[0];
                    sArg2 = (String)ArgList[1];
                    SimpleDateFormat dfFormatter = new SimpleDateFormat(sArg2);
                    oRC = dfFormatter.parseObject(sArg1);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not apply the given format " + sArg2 + " on the string for " + sArg1 + " : " + e.getMessage());
                }
            }
            case 3: {
                try {
                    if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1, 2})) {
                        return null;
                    }
                    if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2})) {
                        return undefinedValue;
                    }
                    sArg1 = (String)ArgList[0];
                    sArg2 = (String)ArgList[1];
                    sArg3 = (String)ArgList[2];
                    if (sArg3.length() != 2) {
                        throw new RuntimeException("Locale " + sArg3 + " is not 2 characters long.");
                    }
                    Locale dfLocale = EnvUtil.createLocale((String)sArg3);
                    SimpleDateFormat dfFormatter = new SimpleDateFormat(sArg2, dfLocale);
                    oRC = dfFormatter.parseObject(sArg1);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not apply the local format for locale " + sArg3 + " with the given format " + sArg2 + " on the string for " + sArg1 + " : " + e.getMessage());
                }
            }
            case 4: {
                try {
                    if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1, 2, 3})) {
                        return null;
                    }
                    if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2, 3})) {
                        return undefinedValue;
                    }
                    sArg1 = (String)ArgList[0];
                    sArg2 = (String)ArgList[1];
                    sArg3 = (String)ArgList[2];
                    sArg4 = (String)ArgList[3];
                    TimeZone tz = TimeZone.getTimeZone(sArg4);
                    if (sArg3.length() != 2) {
                        throw new RuntimeException("Locale " + sArg3 + " is not 2 characters long.");
                    }
                    Locale dfLocale = EnvUtil.createLocale((String)sArg3);
                    SimpleDateFormat dfFormatter = new SimpleDateFormat(sArg2, dfLocale);
                    dfFormatter.setTimeZone(tz);
                    oRC = dfFormatter.parseObject(sArg1);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not apply the local format for locale " + sArg3 + " with the given format " + sArg2 + " on the string for " + sArg1 + " : " + e.getMessage());
                }
            }
            default: {
                throw new RuntimeException("The function call str2date requires 1, 2, 3, or 4 arguments.");
            }
        }
        return oRC;
    }

    public static Object date2str(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        Object oRC = new Object();
        switch (ArgList.length) {
            case 0: {
                throw new RuntimeException("Please provide a valid date to the function call date2str.");
            }
            case 1: {
                try {
                    if (ScriptAddedFunctions.isNull(ArgList)) {
                        return null;
                    }
                    if (ScriptAddedFunctions.isUndefined(ArgList)) {
                        return undefinedValue;
                    }
                    Date dArg1 = (Date)ArgList[0];
                    if (dArg1.equals(null)) {
                        return null;
                    }
                    SimpleDateFormat dfFormatter = new SimpleDateFormat();
                    oRC = dfFormatter.format((Object)dArg1);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not convert to local format.");
                }
            }
            case 2: {
                try {
                    if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                        return null;
                    }
                    if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                        return undefinedValue;
                    }
                    Date dArg1 = (Date)ArgList[0];
                    String sArg2 = (String)ArgList[1];
                    SimpleDateFormat dfFormatter = new SimpleDateFormat(sArg2);
                    oRC = dfFormatter.format((Object)dArg1);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not convert to the given format.");
                }
            }
            case 3: {
                try {
                    if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1, 2})) {
                        return null;
                    }
                    if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2})) {
                        return undefinedValue;
                    }
                    Date dArg1 = (Date)ArgList[0];
                    String sArg2 = (String)ArgList[1];
                    String sArg3 = (String)ArgList[2];
                    if (sArg3.length() != 2) {
                        throw new RuntimeException("Locale is not 2 characters long.");
                    }
                    Locale dfLocale = EnvUtil.createLocale((String)sArg3.toLowerCase());
                    SimpleDateFormat dfFormatter = new SimpleDateFormat(sArg2, dfLocale);
                    oRC = dfFormatter.format(dArg1);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not convert to the given local format.");
                }
            }
            case 4: {
                try {
                    if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1, 2, 3})) {
                        return null;
                    }
                    if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2, 3})) {
                        return undefinedValue;
                    }
                    Date dArg1 = (Date)ArgList[0];
                    String sArg2 = (String)ArgList[1];
                    String sArg3 = (String)ArgList[2];
                    String sArg4 = (String)ArgList[3];
                    TimeZone tz = TimeZone.getTimeZone(sArg4);
                    if (sArg3.length() != 2) {
                        throw new RuntimeException("Locale is not 2 characters long.");
                    }
                    Locale dfLocale = EnvUtil.createLocale((String)sArg3.toLowerCase());
                    SimpleDateFormat dfFormatter = new SimpleDateFormat(sArg2, dfLocale);
                    dfFormatter.setTimeZone(tz);
                    oRC = dfFormatter.format(dArg1);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not convert to the given local format.");
                }
            }
            default: {
                throw new RuntimeException("The function call date2str requires 1, 2, 3, or 4 arguments.");
            }
        }
        return oRC;
    }

    public static Object isRegExp(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length >= 2) {
            if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                return null;
            }
            if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                return undefinedValue;
            }
            String strToMatch = (String)ArgList[0];
            for (int i = 1; i < ArgList.length; ++i) {
                Pattern p = Pattern.compile((String)ArgList[i]);
                Matcher m = p.matcher(strToMatch);
                if (!m.matches()) continue;
                return new Double(i);
            }
        }
        return new Double(-1.0);
    }

    public static void sendMail(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        boolean debug = false;
        if (ArgList.length == 5) {
            try {
                Properties props = new Properties();
                props.put("mail.smtp.host", ArgList[0]);
                Session session = Session.getDefaultInstance((Properties)props, null);
                session.setDebug(debug);
                MimeMessage msg = new MimeMessage(session);
                InternetAddress addressFrom = new InternetAddress((String)ArgList[1]);
                msg.setFrom((Address)addressFrom);
                String[] strArrRecipients = ((String)ArgList[2]).split(",");
                InternetAddress[] addressTo = new InternetAddress[strArrRecipients.length];
                for (int i = 0; i < strArrRecipients.length; ++i) {
                    addressTo[i] = new InternetAddress(strArrRecipients[i]);
                }
                msg.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
                msg.addHeader("MyHeaderName", "myHeaderValue");
                msg.setSubject((String)ArgList[3]);
                msg.setContent(ArgList[4], "text/plain");
                Transport.send((Message)msg);
            }
            catch (Exception e) {
                throw new RuntimeException("sendMail: " + e.toString());
            }
        } else {
            throw new RuntimeException("The function call sendMail requires 5 arguments.");
        }
    }

    public static String upper(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        String sRC = "";
        if (ArgList.length == 1) {
            try {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return (String)undefinedValue;
                }
                sRC = (String)ArgList[0];
                sRC = sRC.toUpperCase();
            }
            catch (Exception e) {
                throw new RuntimeException("The function call upper is not valid : " + e.getMessage());
            }
        } else {
            throw new RuntimeException("The function call upper requires 1 argument.");
        }
        return sRC;
    }

    public static String lower(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        String sRC = "";
        if (ArgList.length == 1) {
            try {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return (String)undefinedValue;
                }
                sRC = (String)ArgList[0];
                sRC = sRC.toLowerCase();
            }
            catch (Exception e) {
                throw new RuntimeException("The function call lower is not valid : " + e.getMessage());
            }
        } else {
            throw new RuntimeException("The function call lower requires 1 argument.");
        }
        return sRC;
    }

    public static String num2str(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        String sRC = "";
        switch (ArgList.length) {
            case 0: {
                throw new RuntimeException("The function call num2str requires at least 1 argument.");
            }
            case 1: {
                try {
                    if (ScriptAddedFunctions.isNull(ArgList[0])) {
                        return null;
                    }
                    if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                        return (String)undefinedValue;
                    }
                    double sArg1 = (Double)ArgList[0];
                    if (Double.isNaN(sArg1)) {
                        throw new RuntimeException("The first Argument must be a Number.");
                    }
                    DecimalFormat formatter = new DecimalFormat();
                    sRC = formatter.format(sArg1);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Could not apply the given format on the number : " + e.getMessage());
                }
            }
            case 2: {
                try {
                    if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                        return null;
                    }
                    if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                        return (String)undefinedValue;
                    }
                    double sArg1 = (Double)ArgList[0];
                    if (Double.isNaN(sArg1)) {
                        throw new RuntimeException("The first Argument must be a Number.");
                    }
                    String sArg2 = (String)ArgList[1];
                    DecimalFormat formatter = new DecimalFormat(sArg2);
                    sRC = formatter.format(sArg1);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Could not apply the given format on the number : " + e.getMessage());
                }
            }
            case 3: {
                try {
                    if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1, 2})) {
                        return null;
                    }
                    if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2})) {
                        return (String)undefinedValue;
                    }
                    double sArg1 = (Double)ArgList[0];
                    if (Double.isNaN(sArg1)) {
                        throw new RuntimeException("The first Argument must be a Number.");
                    }
                    String sArg2 = (String)ArgList[1];
                    String sArg3 = (String)ArgList[2];
                    if (sArg3.length() != 2) break;
                    DecimalFormatSymbols dfs = new DecimalFormatSymbols(EnvUtil.createLocale((String)sArg3.toLowerCase()));
                    DecimalFormat formatter = new DecimalFormat(sArg2, dfs);
                    sRC = formatter.format(sArg1);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.toString());
                }
            }
            default: {
                throw new RuntimeException("The function call num2str requires 1, 2, or 3 arguments.");
            }
        }
        return sRC;
    }

    public static Object str2num(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        double dRC = 0.0;
        switch (ArgList.length) {
            case 0: {
                throw new RuntimeException("The function call str2num requires at least 1 argument.");
            }
            case 1: {
                try {
                    if (ScriptAddedFunctions.isNull(ArgList[0])) {
                        return new Double(Double.NaN);
                    }
                    if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                        return undefinedValue;
                    }
                    if (ArgList[0].equals(null)) {
                        return null;
                    }
                    String sArg1 = (String)ArgList[0];
                    DecimalFormat formatter = new DecimalFormat();
                    dRC = formatter.parse(Const.ltrim((String)sArg1)).doubleValue();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not convert the given String : " + e.getMessage());
                }
            }
            case 2: {
                try {
                    if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                        return new Double(Double.NaN);
                    }
                    if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                        return undefinedValue;
                    }
                    String sArg1 = (String)ArgList[0];
                    String sArg2 = (String)ArgList[1];
                    if (sArg1.equals("null") || sArg2.equals("null")) {
                        return null;
                    }
                    DecimalFormat formatter = new DecimalFormat(sArg2);
                    dRC = formatter.parse(sArg1).doubleValue();
                    return new Double(dRC);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not convert the String with the given format :" + e.getMessage());
                }
            }
            case 3: {
                try {
                    if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1, 2})) {
                        return new Double(Double.NaN);
                    }
                    if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1, 2})) {
                        return undefinedValue;
                    }
                    String sArg1 = (String)ArgList[0];
                    String sArg2 = (String)ArgList[1];
                    String sArg3 = (String)ArgList[2];
                    if (sArg3.length() == 2) {
                        DecimalFormatSymbols dfs = new DecimalFormatSymbols(EnvUtil.createLocale((String)sArg3.toLowerCase()));
                        DecimalFormat formatter = new DecimalFormat(sArg2, dfs);
                        dRC = formatter.parse(sArg1).doubleValue();
                        return new Double(dRC);
                    }
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            default: {
                throw new RuntimeException("The function call str2num requires 1, 2, or 3 arguments.");
            }
        }
        return new Double(dRC);
    }

    public static Object isNum(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 1) {
            try {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return undefinedValue;
                }
                double sArg1 = (Double)ArgList[0];
                if (Double.isNaN(sArg1)) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        throw new RuntimeException("The function call isNum requires 1 argument.");
    }

    public static Object isDate(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 1) {
            try {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return undefinedValue;
                }
                return Boolean.TRUE;
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        throw new RuntimeException("The function call isDate requires 1 argument.");
    }

    public static Object decode(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            if (ArgList.length >= 2) {
                if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                    return undefinedValue;
                }
                Object objToCompare = ArgList[0];
                for (int i = 1; i < ArgList.length - 1; i += 2) {
                    if (!ArgList[i].equals(objToCompare)) continue;
                    return ArgList[i + 1];
                }
                if (ArgList.length % 2 == 0) {
                    return ArgList[ArgList.length - 1];
                }
                return objToCompare;
            }
            throw new RuntimeException("The function call decode requires more than 1 argument.");
        }
        catch (Exception e) {
            throw new RuntimeException("The function call decode is not valid : " + e.getMessage());
        }
    }

    public static String replace(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            if (ArgList.length >= 2 && (ArgList.length - 1) % 2 == 0) {
                if (ScriptAddedFunctions.isNull(ArgList, new int[]{0, 1})) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList, new int[]{0, 1})) {
                    return (String)undefinedValue;
                }
                String objForReplace = (String)ArgList[0];
                for (int i = 1; i < ArgList.length - 1; i += 2) {
                    objForReplace = objForReplace.replaceAll((String)ArgList[i], (String)ArgList[i + 1]);
                }
                return objForReplace;
            }
            throw new RuntimeException("The function call replace is not valid (wrong number of arguments)");
        }
        catch (Exception e) {
            throw new RuntimeException("Function call replace is not valid : " + e.getMessage());
        }
    }

    public static String Alert(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        SpoonInterface spoon = SpoonFactory.getInstance();
        if (ArgList.length == 1 && spoon != null) {
            String strMessage = (String)ArgList[0];
            spoon.messageBox(strMessage, "Alert", false, 3);
        }
        return "";
    }

    public static void setEnvironmentVar(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        String sArg1 = "";
        String sArg2 = "";
        if (ArgList.length == 2) {
            try {
                sArg1 = (String)ArgList[0];
                sArg2 = (String)ArgList[1];
                System.setProperty(sArg1, sArg2);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        } else {
            throw new RuntimeException("The function call setEnvironmentVar requires 2 arguments.");
        }
    }

    public static String getEnvironmentVar(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        String sRC = "";
        if (ArgList.length == 1) {
            try {
                String sArg1 = (String)ArgList[0];
                sRC = System.getProperty(sArg1, "");
            }
            catch (Exception e) {
                sRC = "";
            }
        } else {
            throw new RuntimeException("The function call getEnvironmentVar requires 1 argument.");
        }
        return sRC;
    }

    public static String trim(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        String sRC = "";
        if (ArgList.length == 1) {
            try {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return (String)undefinedValue;
                }
                sRC = (String)ArgList[0];
                sRC = Const.trim((String)sRC);
            }
            catch (Exception e) {
                throw new RuntimeException("The function call trim is not valid : " + e.getMessage());
            }
        } else {
            throw new RuntimeException("The function call trim requires 1 argument.");
        }
        return sRC;
    }

    public static String substr(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        String sRC = "";
        if (ArgList.length == 2) {
            try {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return (String)undefinedValue;
                }
                sRC = (String)ArgList[0];
                int from = (int)Math.round((Double)ArgList[1]);
                sRC = sRC.substring(from);
            }
            catch (Exception e) {
                throw new RuntimeException("The function call substr is not valid : " + e.getMessage());
            }
        } else if (ArgList.length == 3) {
            try {
                int strLen;
                int to;
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return (String)undefinedValue;
                }
                sRC = (String)ArgList[0];
                int from = (int)Math.round((Double)ArgList[1]);
                int len = (int)Math.round((Double)ArgList[2]);
                if (from < 0) {
                    throw new RuntimeException("start smaller than 0");
                }
                if (len < 0) {
                    len = 0;
                }
                if ((to = from + len) > (strLen = sRC.length())) {
                    to = strLen;
                }
                sRC = sRC.substring(from, to);
            }
            catch (Exception e) {
                throw new RuntimeException("The function call substr is not valid : " + e.getMessage());
            }
        } else {
            throw new RuntimeException("The function call substr requires 2 or 3 arguments.");
        }
        return sRC;
    }

    public static String resolveIP(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        String sRC = "";
        if (ArgList.length == 2) {
            try {
                InetAddress addr = InetAddress.getByName((String)ArgList[0]);
                sRC = ((String)ArgList[1]).equals("IP") ? addr.getHostName() : addr.getHostAddress();
                if (sRC.equals(ArgList[0])) {
                    sRC = "-";
                }
            }
            catch (Exception e) {
                sRC = "-";
            }
        } else {
            throw new RuntimeException("The function call resolveIP requires 2 arguments.");
        }
        return sRC;
    }

    public static void LoadScriptFile(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        for (int i = 0; i < ArgList.length; ++i) {
            ScriptAddedFunctions.checkAndLoadJSFile(actualContext, actualObject, (String)ArgList[i]);
        }
    }

    public static void LoadScriptFromTab(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            for (int i = 0; i < ArgList.length; ++i) {
                String strToLoad = (String)ArgList[i];
                String strScript = actualObject.get(strToLoad).toString();
                actualContext.eval(strScript, actualObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void print(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        for (int i = 0; i < ArgList.length; ++i) {
            System.out.print((String)ArgList[i]);
        }
    }

    public static void println(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        ScriptAddedFunctions.print(actualContext, actualObject, ArgList, FunctionContext);
        System.out.println();
    }

    public String getClassName() {
        return "SciptValuesAddedFunctions";
    }

    private static void checkAndLoadJSFile(ScriptEngine actualContext, Bindings eval_scope, String fileName) {
        InputStreamReader inStream = null;
        try {
            inStream = new InputStreamReader(KettleVFS.getInputStream((String)fileName));
            actualContext.eval((Reader)inStream, eval_scope);
        }
        catch (KettleFileException Signal) {
            throw new RuntimeException("Error while reading file \"" + fileName + "\" (reason: \"" + Signal.getMessage() + "\")");
        }
        catch (ScriptException Signal) {
            throw new RuntimeException("Error while reading file \"" + fileName + "\" (reason: \"" + Signal.getMessage() + "\")");
        }
        finally {
            try {
                if (inStream != null) {
                    ((Reader)inStream).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setVariable(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        String sArg1 = "";
        String sArg2 = "";
        String sArg3 = "";
        if (ArgList.length != 3) throw new RuntimeException("The function call setVariable requires 3 arguments.");
        try {
            Object scmo;
            Object scmO = scmo = actualObject.get("_step_");
            if (!(scmO instanceof ScriptInterface)) return;
            ScriptInterface scm = (ScriptInterface)scmO;
            sArg1 = (String)ArgList[0];
            sArg2 = (String)ArgList[1];
            sArg3 = (String)ArgList[2];
            if ("s".equals(sArg3)) {
                System.setProperty(sArg1, sArg2);
                scm.setVariable(sArg1, sArg2);
                for (VariableSpace parentSpace = scm.getParentVariableSpace(); parentSpace != null; parentSpace = parentSpace.getParentVariableSpace()) {
                    parentSpace.setVariable(sArg1, sArg2);
                }
                return;
            } else if ("r".equals(sArg3)) {
                scm.setVariable(sArg1, sArg2);
                for (VariableSpace parentSpace = scm.getParentVariableSpace(); parentSpace != null; parentSpace = parentSpace.getParentVariableSpace()) {
                    parentSpace.setVariable(sArg1, sArg2);
                }
                return;
            } else if ("p".equals(sArg3)) {
                scm.setVariable(sArg1, sArg2);
                VariableSpace parentSpace = scm.getParentVariableSpace();
                if (parentSpace == null) return;
                parentSpace.setVariable(sArg1, sArg2);
                return;
            } else {
                if (!"g".equals(sArg3)) throw new RuntimeException("The argument type of function call setVariable should either be \"s\", \"r\", \"p\", or \"g\".");
                scm.setVariable(sArg1, sArg2);
                VariableSpace parentSpace = scm.getParentVariableSpace();
                if (parentSpace == null) return;
                parentSpace.setVariable(sArg1, sArg2);
                VariableSpace grandParentSpace = parentSpace.getParentVariableSpace();
                if (grandParentSpace == null) return;
                grandParentSpace.setVariable(sArg1, sArg2);
                return;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static String getVariable(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        String sRC = "";
        String sArg1 = "";
        String sArg2 = "";
        if (ArgList.length == 2) {
            try {
                Object scmo;
                Object scmO = scmo = actualObject.get("_step_");
                if (scmO instanceof Script) {
                    Script scm = (Script)scmO;
                    sArg1 = (String)ArgList[0];
                    sArg2 = (String)ArgList[1];
                    return scm.getVariable(sArg1, sArg2);
                }
                sArg2 = (String)ArgList[1];
                return sArg2;
            }
            catch (Exception e) {
                sRC = "";
            }
        } else {
            throw new RuntimeException("The function call getVariable requires 2 arguments.");
        }
        return sRC;
    }

    public static RowMetaInterface getOutputRowMeta(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 0) {
            try {
                Object scmO = actualObject.get("_step_");
                try {
                    Script scm = (Script)scmO;
                    return scm.getOutputRowMeta();
                }
                catch (Exception e) {
                    ScriptDummy scm = (ScriptDummy)scmO;
                    return scm.getOutputRowMeta();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to get the output row metadata because of an error: " + Const.CR + e.toString());
            }
        }
        throw new RuntimeException("The function call getOutputRowMeta doesn't require arguments.");
    }

    public static RowMetaInterface getInputRowMeta(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 0) {
            try {
                Object scmO = actualObject.get("_step_");
                try {
                    Script scm = (Script)scmO;
                    return scm.getInputRowMeta();
                }
                catch (Exception e) {
                    ScriptDummy scm = (ScriptDummy)scmO;
                    return scm.getInputRowMeta();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to get the input row metadata because of an error: " + Const.CR + e.toString());
            }
        }
        throw new RuntimeException("The function call getInputRowMeta doesn't require arguments.");
    }

    public static Object[] createRowCopy(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 1) {
            try {
                int newSize = (int)Math.round((Double)ArgList[0]);
                Object scmO = actualObject.get("row");
                Object[] row = (Object[])scmO;
                return RowDataUtil.createResizedCopy((Object[])row, (int)newSize);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create a row copy: " + Const.CR + e.toString());
            }
        }
        throw new RuntimeException("The function call createRowCopy requires a single arguments : the new size of the row");
    }

    public static void putRow(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 1) {
            try {
                Object[] newRow = (Object[])ArgList[0];
                Object scmO = actualObject.get("_step_");
                try {
                    Script step = (Script)scmO;
                    step.putRow(step.getOutputRowMeta(), newRow);
                }
                catch (Exception e) {
                    ScriptDummy step = (ScriptDummy)scmO;
                    step.putRow(step.getOutputRowMeta(), newRow);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to pass the new row to the next step(s) because of an error: " + Const.CR + e.toString());
            }
        } else {
            throw new RuntimeException("The function call putRow requires 1 argument : the output row data (Object[])");
        }
    }

    public static void deleteFile(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        block15: {
            try {
                if (ArgList.length == 1 && !ScriptAddedFunctions.isNull(ArgList[0]) && !ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    FileObject fileObject = null;
                    try {
                        fileObject = KettleVFS.getFileObject((String)((String)ArgList[0]));
                        if (fileObject.exists()) {
                            if (fileObject.getType() == FileType.FILE && !fileObject.delete()) {
                                throw new RuntimeException("We can not delete file [" + (String)ArgList[0] + "]!");
                            }
                            break block15;
                        }
                        throw new RuntimeException("file [" + ArgList[0] + "] can not be found!");
                    }
                    catch (IOException e) {
                        throw new RuntimeException("The function call deleteFile is not valid.");
                    }
                    finally {
                        if (fileObject != null) {
                            try {
                                fileObject.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                throw new RuntimeException("The function call deleteFile is not valid.");
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
    }

    public static void createFolder(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        block14: {
            try {
                if (ArgList.length == 1 && !ScriptAddedFunctions.isNull(ArgList[0]) && !ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    FileObject fileObject = null;
                    try {
                        fileObject = KettleVFS.getFileObject((String)((String)ArgList[0]));
                        if (!fileObject.exists()) {
                            fileObject.createFolder();
                            break block14;
                        }
                        throw new RuntimeException("folder [" + ArgList[0] + "] already exist!");
                    }
                    catch (IOException e) {
                        throw new RuntimeException("The function call createFolder is not valid.");
                    }
                    finally {
                        if (fileObject != null) {
                            try {
                                fileObject.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                throw new RuntimeException("The function call createFolder is not valid.");
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
    }

    public static void copyFile(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        block22: {
            try {
                if (!(ArgList.length != 3 || ScriptAddedFunctions.isNull(ArgList[0]) || ScriptAddedFunctions.isNull(ArgList[1]) || ScriptAddedFunctions.isUndefined(ArgList[0]) || ScriptAddedFunctions.isUndefined(ArgList[1]))) {
                    FileObject fileSource = null;
                    FileObject fileDestination = null;
                    try {
                        fileSource = KettleVFS.getFileObject((String)((String)ArgList[0]));
                        fileDestination = KettleVFS.getFileObject((String)((String)ArgList[1]));
                        if (fileSource.exists()) {
                            if (fileSource.getType() == FileType.FILE) {
                                boolean destinationExists;
                                boolean overwrite = false;
                                if (!ArgList[1].equals(null)) {
                                    overwrite = (Boolean)ArgList[2];
                                }
                                if ((destinationExists = fileDestination.exists()) && overwrite || !destinationExists) {
                                    FileUtil.copyContent((FileObject)fileSource, (FileObject)fileDestination);
                                }
                            }
                            break block22;
                        }
                        throw new RuntimeException("file to copy [" + ArgList[0] + "] can not be found!");
                    }
                    catch (IOException e) {
                        throw new RuntimeException("The function call copyFile throw an error : " + e.toString());
                    }
                    finally {
                        if (fileSource != null) {
                            try {
                                fileSource.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (fileDestination != null) {
                            try {
                                fileDestination.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                throw new RuntimeException("The function call copyFileis not valid.");
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double getFileSize(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length != 1 || ScriptAddedFunctions.isNull(ArgList[0]) || ScriptAddedFunctions.isUndefined(ArgList[0])) throw new RuntimeException("The function call getFileSize is not valid.");
        if (ArgList[0].equals(null)) {
            return 0.0;
        }
        FileObject file = null;
        try {
            file = KettleVFS.getFileObject((String)((String)ArgList[0]));
            long filesize = 0L;
            if (!file.exists()) throw new RuntimeException("file [" + ArgList[0] + "] can not be found!");
            if (!file.getType().equals((Object)FileType.FILE)) {
                throw new RuntimeException("[" + ArgList[0] + "] is not a file!");
            }
            filesize = file.getContent().getSize();
            double d = filesize;
            return d;
        }
        catch (IOException e) {
            throw new RuntimeException("The function call getFileSize throw an error : " + e.toString());
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception exception) {}
            }
        }
        {
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isFile(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            if (ArgList.length != 1) throw new RuntimeException("The function call isFile is not valid.");
            if (ScriptAddedFunctions.isNull(ArgList[0])) throw new RuntimeException("The function call isFile is not valid.");
            if (ScriptAddedFunctions.isUndefined(ArgList[0])) throw new RuntimeException("The function call isFile is not valid.");
            if (ArgList[0].equals(null)) {
                return false;
            }
            FileObject file = null;
            try {
                file = KettleVFS.getFileObject((String)((String)ArgList[0]));
                boolean isafile = false;
                if (!file.exists()) throw new RuntimeException("file [" + ArgList[0] + "] can not be found!");
                if (!file.getType().equals((Object)FileType.FILE)) throw new RuntimeException("[" + ArgList[0] + "] is not a file!");
                isafile = true;
                boolean bl = isafile;
                return bl;
            }
            catch (IOException e) {
                throw new RuntimeException("The function call is File throw an error : " + e.toString());
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isFolder(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            if (ArgList.length != 1) throw new RuntimeException("The function call isFolder is not valid.");
            if (ScriptAddedFunctions.isNull(ArgList[0])) throw new RuntimeException("The function call isFolder is not valid.");
            if (ScriptAddedFunctions.isUndefined(ArgList[0])) throw new RuntimeException("The function call isFolder is not valid.");
            if (ArgList[0].equals(null)) {
                return false;
            }
            FileObject file = null;
            try {
                file = KettleVFS.getFileObject((String)((String)ArgList[0]));
                boolean isafolder = false;
                if (!file.exists()) throw new RuntimeException("folder [" + ArgList[0] + "] can not be found!");
                if (!file.getType().equals((Object)FileType.FOLDER)) throw new RuntimeException("[" + ArgList[0] + "] is not a folder!");
                isafolder = true;
                boolean bl = isafolder;
                return bl;
            }
            catch (IOException e) {
                throw new RuntimeException("The function call isFolder throw an error : " + e.toString());
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getShortFilename(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            if (ArgList.length != 1) throw new RuntimeException("The function call getShortFilename is not valid.");
            if (ScriptAddedFunctions.isNull(ArgList[0])) throw new RuntimeException("The function call getShortFilename is not valid.");
            if (ScriptAddedFunctions.isUndefined(ArgList[0])) throw new RuntimeException("The function call getShortFilename is not valid.");
            if (ArgList[0].equals(null)) {
                return null;
            }
            FileObject file = null;
            try {
                file = KettleVFS.getFileObject((String)((String)ArgList[0]));
                String Filename = null;
                if (!file.exists()) throw new RuntimeException("file [" + ArgList[0] + "] can not be found!");
                Filename = file.getName().getBaseName();
                String string = Filename;
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("The function call getShortFilename throw an error : " + e.toString());
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileExtension(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            if (ArgList.length != 1) throw new RuntimeException("The function call getFileExtension is not valid.");
            if (ScriptAddedFunctions.isNull(ArgList[0])) throw new RuntimeException("The function call getFileExtension is not valid.");
            if (ScriptAddedFunctions.isUndefined(ArgList[0])) throw new RuntimeException("The function call getFileExtension is not valid.");
            if (ArgList[0].equals(null)) {
                return null;
            }
            FileObject file = null;
            try {
                file = KettleVFS.getFileObject((String)((String)ArgList[0]));
                String Extension = null;
                if (!file.exists()) throw new RuntimeException("file [" + ArgList[0] + "] can not be found!");
                Extension = file.getName().getExtension();
                String string = Extension;
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("The function call getFileExtension throw an error : " + e.toString());
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getParentFoldername(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            if (ArgList.length != 1) throw new RuntimeException("The function call getParentFoldername is not valid.");
            if (ScriptAddedFunctions.isNull(ArgList[0])) throw new RuntimeException("The function call getParentFoldername is not valid.");
            if (ScriptAddedFunctions.isUndefined(ArgList[0])) throw new RuntimeException("The function call getParentFoldername is not valid.");
            if (ArgList[0].equals(null)) {
                return null;
            }
            FileObject file = null;
            try {
                file = KettleVFS.getFileObject((String)((String)ArgList[0]));
                String foldername = null;
                if (!file.exists()) throw new RuntimeException("file [" + ArgList[0] + "] can not be found!");
                foldername = KettleVFS.getFilename((FileObject)file.getParent());
                String string = foldername;
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("The function call getParentFoldername throw an error : " + e.toString());
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLastModifiedTime(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            if (ArgList.length != 2) throw new RuntimeException("The function call getLastModifiedTime is not valid.");
            if (ScriptAddedFunctions.isNull(ArgList[0])) throw new RuntimeException("The function call getLastModifiedTime is not valid.");
            if (ScriptAddedFunctions.isUndefined(ArgList[0])) throw new RuntimeException("The function call getLastModifiedTime is not valid.");
            if (ArgList[0].equals(null)) {
                return null;
            }
            FileObject file = null;
            try {
                file = KettleVFS.getFileObject((String)((String)ArgList[0]));
                String dateformat = (String)ArgList[1];
                if (ScriptAddedFunctions.isNull(dateformat)) {
                    dateformat = "yyyy-MM-dd";
                }
                String lastmodifiedtime = null;
                if (!file.exists()) throw new RuntimeException("file [" + ArgList[0] + "] can not be found!");
                Date lastmodifiedtimedate = new Date(file.getContent().getLastModifiedTime());
                SimpleDateFormat dateFormat = new SimpleDateFormat(dateformat);
                lastmodifiedtime = dateFormat.format(lastmodifiedtimedate);
                String string = lastmodifiedtime;
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("The function call getLastModifiedTime throw an error : " + e.toString());
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static Object trunc(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        try {
            if (ArgList.length == 1) {
                if (ScriptAddedFunctions.isNull(ArgList[0])) {
                    return null;
                }
                if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                    return undefinedValue;
                }
                Double dArg1 = (Double)ArgList[0];
                return Math.floor(dArg1);
            }
            throw new RuntimeException("The function call trunc requires 1 argument, a number.");
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static Object truncDate(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        if (ArgList.length == 2) {
            if (ScriptAddedFunctions.isNull(ArgList[0])) {
                return null;
            }
            if (ScriptAddedFunctions.isUndefined(ArgList[0])) {
                return undefinedValue;
            }
            Date dArg1 = null;
            Integer level = null;
            try {
                dArg1 = (Date)ArgList[0];
                level = (Integer)ArgList[1];
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
            return ScriptAddedFunctions.truncDate(dArg1, level);
        }
        throw new RuntimeException("The function call truncDate requires 2 arguments: a date and a level (int)");
    }

    @VisibleForTesting
    static Date truncDate(Date dArg1, Integer level) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dArg1);
        switch (level) {
            case 5: {
                cal.set(2, 0);
            }
            case 4: {
                cal.set(5, 1);
            }
            case 3: {
                cal.set(11, 0);
            }
            case 2: {
                cal.set(12, 0);
            }
            case 1: {
                cal.set(13, 0);
            }
            case 0: {
                cal.set(14, 0);
                break;
            }
            default: {
                throw new RuntimeException("Argument of TRUNC of date has to be between 0 and 5");
            }
        }
        return cal.getTime();
    }

    public static void moveFile(ScriptEngine actualContext, Bindings actualObject, Object[] ArgList, Object FunctionContext) {
        block22: {
            try {
                if (!(ArgList.length != 3 || ScriptAddedFunctions.isNull(ArgList[0]) || ScriptAddedFunctions.isNull(ArgList[1]) || ScriptAddedFunctions.isUndefined(ArgList[0]) || ScriptAddedFunctions.isUndefined(ArgList[1]))) {
                    FileObject fileSource = null;
                    FileObject fileDestination = null;
                    try {
                        fileSource = KettleVFS.getFileObject((String)((String)ArgList[0]));
                        fileDestination = KettleVFS.getFileObject((String)((String)ArgList[1]));
                        if (fileSource.exists()) {
                            if (fileSource.getType() == FileType.FILE) {
                                boolean destinationExists;
                                boolean overwrite = false;
                                if (!ArgList[1].equals(null)) {
                                    overwrite = (Boolean)ArgList[2];
                                }
                                if ((destinationExists = fileDestination.exists()) && overwrite || !destinationExists) {
                                    fileSource.moveTo(fileDestination);
                                }
                            }
                            break block22;
                        }
                        throw new RuntimeException("file to move [" + ArgList[0] + "] can not be found!");
                    }
                    catch (IOException e) {
                        throw new RuntimeException("The function call moveFile throw an error : " + e.toString());
                    }
                    finally {
                        if (fileSource != null) {
                            try {
                                fileSource.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (fileDestination != null) {
                            try {
                                fileDestination.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                throw new RuntimeException("The function call copyFile is not valid.");
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
    }
}

