/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.encoder.Encode;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelFileWriter;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.util.FileUtil;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransAdapter;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;

@Deprecated
public class AddTransServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static final long serialVersionUID = -6850701762586992604L;
    public static final String CONTEXT_PATH = "/kettle/addTrans";

    public AddTransServlet() {
    }

    public AddTransServlet(TransformationMap transformationMap, SocketRepository socketRepository) {
        super(transformationMap, socketRepository);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getRequestURI().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug("Addition of transformation requested");
        }
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        PrintWriter out = response.getWriter();
        BufferedReader in = request.getReader();
        if (this.log.isDetailed()) {
            this.logDetailed("Encoding: " + request.getCharacterEncoding());
        }
        if (useXML) {
            response.setContentType("text/xml");
            out.print(XMLHandler.getXMLHeader());
        } else {
            response.setContentType("text/html");
            out.println("<HTML>");
            out.println("<HEAD><TITLE>Add transformation</TITLE></HEAD>");
            out.println("<BODY>");
        }
        response.setStatus(200);
        String realLogFilename = null;
        TransExecutionConfiguration transExecutionConfiguration = null;
        try {
            int c;
            StringBuilder xml = new StringBuilder(request.getContentLength());
            while ((c = in.read()) != -1) {
                xml.append((char)c);
            }
            TransConfiguration transConfiguration = TransConfiguration.fromXML(xml.toString());
            TransMeta transMeta = transConfiguration.getTransMeta();
            transExecutionConfiguration = transConfiguration.getTransExecutionConfiguration();
            transMeta.setLogLevel(transExecutionConfiguration.getLogLevel());
            if (this.log.isDetailed()) {
                this.logDetailed("Logging level set to " + this.log.getLogLevel().getDescription());
            }
            transMeta.injectVariables(transExecutionConfiguration.getVariables());
            Map<String, String> params = transExecutionConfiguration.getParams();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                transMeta.setParameterValue(entry.getKey(), entry.getValue());
            }
            final Repository repository = transExecutionConfiguration.getRepository();
            String carteObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.CARTE, null);
            servletLoggingObject.setContainerObjectId(carteObjectId);
            servletLoggingObject.setLogLevel(transExecutionConfiguration.getLogLevel());
            Trans trans = new Trans(transMeta, (LoggingObjectInterface)servletLoggingObject);
            if (transExecutionConfiguration.isSetLogfile()) {
                realLogFilename = transExecutionConfiguration.getLogFileName();
                try {
                    FileUtil.createParentFolder(AddTransServlet.class, realLogFilename, transExecutionConfiguration.isCreateParentFolder(), trans.getLogChannel(), trans);
                    final LogChannelFileWriter logChannelFileWriter = new LogChannelFileWriter(servletLoggingObject.getLogChannelId(), KettleVFS.getFileObject((String)realLogFilename), transExecutionConfiguration.isSetAppendLogfile());
                    logChannelFileWriter.startLogging();
                    trans.addTransListener(new TransAdapter(){

                        @Override
                        public void transFinished(Trans trans) throws KettleException {
                            if (logChannelFileWriter != null) {
                                logChannelFileWriter.stopLogging();
                            }
                        }
                    });
                }
                catch (KettleException e) {
                    this.logError(Const.getStackTracker((Throwable)e));
                }
            }
            trans.setRepository(repository);
            trans.setSocketRepository(this.getSocketRepository());
            this.getTransformationMap().addTransformation(transMeta.getName(), carteObjectId, trans, transConfiguration);
            trans.setContainerObjectId(carteObjectId);
            if (repository != null) {
                trans.addTransListener(new TransAdapter(){

                    @Override
                    public void transFinished(Trans trans) {
                        repository.disconnect();
                    }
                });
            }
            String message = Encode.forHtml((String)("Transformation '" + trans.getName() + "' was added to Carte with id " + carteObjectId));
            if (useXML) {
                out.println(new WebResult("OK", message, carteObjectId));
            } else {
                out.println("<H1>" + message + "</H1>");
                out.println("<p><a href=\"" + this.convertContextPath("/kettle/transStatus") + "?name=" + Encode.forUriComponent((String)trans.getName()) + "&id=" + carteObjectId + "\">Go to the transformation status page</a><p>");
            }
        }
        catch (Exception ex) {
            if (useXML) {
                out.println(new WebResult("ERROR", Const.getStackTracker((Throwable)ex)));
            }
            out.println("<p>");
            out.println("<pre>");
            ex.printStackTrace(out);
            out.println("</pre>");
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Add Transformation";
    }

    @Override
    public String getService() {
        return "/kettle/addTrans (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

