/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.encoder.Encode;
import org.pentaho.di.cluster.HttpUtil;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.SlaveServerJobStatus;
import org.pentaho.di.www.StatusServletUtils;
import org.pentaho.di.www.WebResult;
import org.pentaho.di.www.cache.CarteStatusCache;
import org.pentaho.di.www.exception.DuplicateKeyException;

public class GetJobStatusServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static final String TEXT_XML = "text/xml";
    private static final String HREF = "<a href=\"";
    private static Class<?> PKG = GetJobStatusServlet.class;
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/jobStatus";
    private static final byte[] XML_HEADER = XMLHandler.getXMLHeader((String)"UTF-8").getBytes(Charset.forName("UTF-8"));
    @VisibleForTesting
    CarteStatusCache cache = CarteStatusCache.getInstance();

    public GetJobStatusServlet() {
    }

    public GetJobStatusServlet(JobMap jobMap) {
        super(jobMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Job job;
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GetJobStatusServlet.Log.JobStatusRequested", (String[])new String[0]));
        }
        String jobName = request.getParameter("name");
        String id = request.getParameter("id");
        String root = request.getRequestURI() == null ? "/pentaho" : request.getRequestURI().substring(0, request.getRequestURI().indexOf(CONTEXT_PATH));
        String prefix = this.isJettyMode() ? "/static" : root + "/content/common-ui/resources/themes";
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        int startLineNr = Const.toInt((String)request.getParameter("from"), (int)0);
        response.setStatus(200);
        if (useXML) {
            response.setContentType(TEXT_XML);
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setContentType("text/html;charset=UTF-8");
        }
        if (jobName == null) {
            PrintWriter out = response.getWriter();
            response.setStatus(400);
            String message = BaseMessages.getString(PKG, (String)"GetJobStatusServlet.Error.JobNameIsMandatory", (String[])new String[0]);
            this.printResponse(response, useXML, out, message);
            return;
        }
        if (Utils.isEmpty((CharSequence)id)) {
            if (this.isConflictingName(jobName)) {
                PrintWriter out = response.getWriter();
                response.setStatus(409);
                String message = BaseMessages.getString(PKG, (String)"GetJobStatusServlet.Error.ConflictingJobName", (String[])new String[0]);
                this.printResponse(response, useXML, out, message);
                return;
            }
            CarteObjectEntry entry = this.getJobMap().getFirstCarteObjectEntry(jobName);
            if (entry == null) {
                job = null;
            } else {
                id = entry.getId();
                job = this.getJobMap().getJob(entry);
            }
        } else if (Utils.isEmpty((CharSequence)jobName)) {
            job = this.getJobMap().findJob(id);
        } else {
            CarteObjectEntry entry = new CarteObjectEntry(jobName, id);
            job = this.getJobMap().getJob(entry);
            if (job != null) {
                jobName = job.getJobname();
            }
        }
        if (job != null) {
            if (useXML) {
                try {
                    boolean finishedOrStopped;
                    ServletOutputStream out = null;
                    byte[] data = null;
                    String logId = job.getLogChannelId();
                    boolean bl = finishedOrStopped = job.isFinished() || job.isStopped();
                    if (finishedOrStopped && (data = this.cache.get(logId, startLineNr)) != null) {
                        response.setContentLength(XML_HEADER.length + data.length);
                        out = response.getOutputStream();
                        out.write(XML_HEADER);
                        out.write(data);
                        out.flush();
                    } else {
                        int lastLineNr = KettleLogStore.getLastBufferLineNr();
                        String logText = this.getLogText(job, startLineNr, lastLineNr);
                        response.setContentType(TEXT_XML);
                        response.setCharacterEncoding("UTF-8");
                        SlaveServerJobStatus jobStatus = new SlaveServerJobStatus(jobName, id, job.getStatus());
                        jobStatus.setFirstLoggingLineNr(startLineNr);
                        jobStatus.setLastLoggingLineNr(lastLineNr);
                        jobStatus.setLogDate(job.getLogDate());
                        String loggingString = HttpUtil.encodeBase64ZippedString((String)logText);
                        jobStatus.setLoggingString(loggingString);
                        jobStatus.setResult(job.getResult());
                        String xml = jobStatus.getXML();
                        data = xml.getBytes(Charset.forName("UTF-8"));
                        out = response.getOutputStream();
                        response.setContentLength(XML_HEADER.length + data.length);
                        out.write(XML_HEADER);
                        out.write(data);
                        out.flush();
                        if (finishedOrStopped && (jobStatus.isFinished() || jobStatus.isStopped()) && logId != null) {
                            this.cache.put(logId, xml, startLineNr);
                        }
                    }
                    response.flushBuffer();
                }
                catch (KettleException e) {
                    response.setStatus(500);
                    throw new ServletException(BaseMessages.getString(PKG, (String)"GetJobStatusServlet.Error.UnableToGetJobStatusInXML", (String[])new String[0]), (Throwable)e);
                }
            }
            PrintWriter out = response.getWriter();
            int lastLineNr = KettleLogStore.getLastBufferLineNr();
            int tableBorder = 0;
            response.setContentType("text/html");
            out.println("<HTML>");
            out.println("<HEAD>");
            out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"GetJobStatusServlet.KettleJobStatus", (String[])new String[0]) + "</TITLE>");
            if (EnvUtil.getSystemProperty((String)"KETTLE_CARTE_REFRESH_STATUS", (String)"N").equalsIgnoreCase("Y")) {
                out.println("<META http-equiv=\"Refresh\" content=\"10;url=" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(Const.NVL((String)jobName, (String)""), "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">");
            }
            out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            if (this.isJettyMode()) {
                out.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/css/carte.css\" />");
            } else {
                out.print(StatusServletUtils.getPentahoStyles(root));
            }
            out.println("</HEAD>");
            out.println("<BODY style=\"overflow: auto;\">");
            out.println("<div class=\"row\" id=\"pucHeader\">");
            out.println("<div class=\"workspaceHeading\" style=\"padding: 0px 0px 0px 10px;\">" + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"GetJobStatusServlet.JobStatus", (String[])new String[]{jobName})) + "</div>");
            out.println("</div>");
            try {
                out.println("<div class=\"row\" style=\"padding: 0px 0px 0px 30px\">");
                out.println("<div class=\"row\" style=\"padding-top: 30px;\">");
                out.print(HREF + this.convertContextPath("/kettle/status") + "\">");
                out.print("<img src=\"" + prefix + "/images/back.svg\" style=\"margin-right: 5px; width: 16px; height: 16px; vertical-align: middle;\">");
                out.print(BaseMessages.getString(PKG, (String)"CarteStatusServlet.BackToCarteStatus", (String[])new String[0]) + "</a>");
                out.println("</div>");
                out.println("<div class=\"row\" style=\"padding: 30px 0px 75px 0px; display: table;\">");
                out.println("<div style=\"display: table-row;\">");
                out.println("<div style=\"padding: 0px 30px 0px 0px; width: 60px; display: table-cell; vertical-align: top;\">");
                out.println("<img src=\"" + prefix + "/images/job.svg\" style=\"width: 60px; height: 60px;\"></img>");
                out.println("</div>");
                out.println("<div style=\"vertical-align: top; display: table-cell;\">");
                out.println("<table style=\"border-collapse: collapse;\" border=\"" + tableBorder + "\">");
                out.print("<tr class=\"cellTableRow\" style=\"border: solid; border-width: 1px 0; border-top: none; border-color: #E3E3E3; font-size: 12; text-align: left;\"> <th style=\"font-weight: normal; padding: 8px 10px 10px 10px\" class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.CarteObjectId", (String[])new String[0]) + "</th> <th style=\"font-weight: normal; padding: 8px 10px 10px 10px\" class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.TransStatus", (String[])new String[0]) + "</th> <th style=\"font-weight: normal; padding: 8px 10px 10px 10px\" class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.LastLogDate", (String[])new String[0]) + "</th> </tr>");
                out.print("<tr class=\"cellTableRow\" style=\"border: solid; border-width: 1px 0; border-bottom: none; font-size: 12; text-align:left\">");
                out.print("<td style=\"padding: 8px 10px 10px 10px\" class=\"cellTableCell cellTableFirstColumn\">" + Const.NVL((String)Encode.forHtml((String)id), (String)"") + "</td>");
                out.print("<td style=\"padding: 8px 10px 10px 10px\" class=\"cellTableCell\" id=\"statusColor\" style=\"font-weight: bold;\">" + job.getStatus() + "</td>");
                String dateStr = XMLHandler.date2string((Date)job.getLogDate());
                dateStr = dateStr == null ? "-" : dateStr.substring(0, dateStr.indexOf(32));
                out.print("<td style=\"padding: 8px 10px 10px 10px\" class=\"cellTableCell cellTableLastColumn\">" + dateStr + "</td>");
                out.print("</tr>");
                out.print("</table>");
                out.print("</div>");
                out.println("<div style=\"padding: 0px 0px 0px 20px; width: 90px; display: table-cell; vertical-align: top;\">");
                out.print("<div style=\"display: block; margin-left: auto; margin-right: auto; padding: 5px 0px;\">");
                out.print("<a target=\"_blank\" href=\"" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(jobName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "&xml=y\"><img src=\"" + prefix + "/images/view-as-xml.svg\" style=\"display: block; margin: auto; width: 22px; height: 22px;\"></a>");
                out.print("</div>");
                out.println("<div style=\"text-align: center; padding-top: 12px; font-size: 12px;\">");
                out.print("<a target=\"_blank\" href=\"" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(jobName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "&xml=y\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.ShowAsXml", (String[])new String[0]) + "</a>");
                out.print("</div>");
                out.print("</div>");
                out.print("</div>");
                out.print("</div>");
                out.print("<div class=\"row\" style=\"padding: 0px 0px 75px 0px;\">");
                out.print("<div class=\"workspaceHeading\">Canvas preview</div>");
                Point max = job.getJobMeta().getMaximum();
                max.y += 20;
                out.print("<iframe height=\"" + max.y + "\" width=\"" + 875 + "\" seamless src=\"" + this.convertContextPath("/kettle/jobImage") + "?name=" + URLEncoder.encode(jobName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\"></iframe>");
                out.print("</div>");
                out.print("<div class=\"row\" style=\"padding: 0px 0px 30px 0px;\">");
                out.print("<div class=\"workspaceHeading\">Job log</div>");
                out.println("<textarea id=\"joblog\" cols=\"120\" rows=\"20\" wrap=\"off\" name=\"Job log\" readonly=\"readonly\" style=\"height: auto;\">" + Encode.forHtml((String)this.getLogText(job, startLineNr, lastLineNr)) + "</textarea>");
                out.print("</div>");
                out.println("<script type=\"text/javascript\">");
                out.println("element = document.getElementById( 'statusColor' );");
                out.println("if( element.innerHTML == 'Running' || element.innerHTML == 'Finished' ){");
                out.println("element.style.color = '#009900';");
                out.println("} else if( element.innerHTML == 'Stopped' ) {");
                out.println("element.style.color = '#7C0B2B';");
                out.println("} else {");
                out.println("element.style.color = '#F1C40F';");
                out.println("}");
                out.println("</script>");
                out.println("<script type=\"text/javascript\"> ");
                out.println("  joblog.scrollTop=joblog.scrollHeight; ");
                out.println("</script> ");
            }
            catch (Exception ex) {
                response.setStatus(500);
                out.println("<pre>");
                out.println(Encode.forHtml((String)Const.getStackTracker((Throwable)ex)));
                out.println("</pre>");
            }
            out.println("</div>");
            out.println("</BODY>");
            out.println("</HTML>");
        } else {
            PrintWriter out = response.getWriter();
            response.setStatus(404);
            String message = BaseMessages.getString(PKG, (String)"StartJobServlet.Log.SpecifiedJobNotFound", (String[])new String[]{jobName, id});
            if (useXML) {
                out.println(new WebResult("ERROR", message));
            } else {
                out.println("<H1>" + Encode.forHtml((String)message) + "</H1>");
                out.println(HREF + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"JobStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
            }
        }
    }

    private void printResponse(HttpServletResponse response, boolean useXML, PrintWriter out, String message) {
        if (useXML) {
            response.setContentType(TEXT_XML);
            response.setCharacterEncoding("UTF-8");
            out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
            out.println(new WebResult("ERROR", message));
        } else {
            String h1End = "</H1>";
            String h1 = "<H1>";
            String hrefEnd = "</a><p>";
            response.setContentType("text/html;charset=UTF-8");
            out.println("<HTML>");
            out.println("<HEAD>");
            out.println("<TITLE>Start job</TITLE>");
            out.println("<META http-equiv=\"Refresh\" content=\"2;url=" + this.convertContextPath("/kettle/status") + "\">");
            out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            out.println("</HEAD>");
            out.println("<BODY>");
            out.println(h1 + Encode.forHtml((String)message) + h1End);
            out.println(HREF + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"JobStatusServlet.BackToStatusPage", (String[])new String[0]) + hrefEnd);
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Job Status Handler";
    }

    @Override
    public String getService() {
        return "/kettle/jobStatus (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }

    private String getLogText(Job job, int startLineNr, int lastLineNr) throws KettleException {
        try {
            int totalLogLinesForJob = KettleLogStore.getLogBufferFromTo((String)job.getLogChannelId(), (boolean)false, (int)0, (int)lastLineNr).size();
            int startLineForJob = lastLineNr - totalLogLinesForJob;
            int start = startLineForJob + startLineNr - 1 > lastLineNr ? 0 : startLineForJob + startLineNr - 1;
            return KettleLogStore.getAppender().getBuffer(job.getLogChannel().getLogChannelId(), false, start, lastLineNr).toString();
        }
        catch (OutOfMemoryError error) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GetJobStatusServlet.Error.LogStringIsTooLong", (String[])new String[0]));
        }
    }

    private boolean isConflictingName(String jobName) {
        try {
            this.getJobMap().getUniqueCarteObjectEntry(jobName);
        }
        catch (DuplicateKeyException ex) {
            return true;
        }
        return false;
    }
}

