/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.StaleMetadataException;
import org.apache.kafka.clients.admin.AbstractOptions;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterClientQuotasOptions;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsResult;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsOptions;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.CreateAclsOptions;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.CreateDelegationTokenResult;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsOptions;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.DescribeClientQuotasOptions;
import org.apache.kafka.clients.admin.DescribeClientQuotasResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeDelegationTokenOptions;
import org.apache.kafka.clients.admin.DescribeDelegationTokenResult;
import org.apache.kafka.clients.admin.DescribeFeaturesOptions;
import org.apache.kafka.clients.admin.DescribeFeaturesResult;
import org.apache.kafka.clients.admin.DescribeLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsOptions;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.ExpireDelegationTokenOptions;
import org.apache.kafka.clients.admin.ExpireDelegationTokenResult;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.LogDirDescription;
import org.apache.kafka.clients.admin.MemberAssignment;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.MemberToRemove;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.clients.admin.RenewDelegationTokenOptions;
import org.apache.kafka.clients.admin.RenewDelegationTokenResult;
import org.apache.kafka.clients.admin.ReplicaInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.SupportedVersionRange;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.clients.admin.UnregisterBrokerOptions;
import org.apache.kafka.clients.admin.UnregisterBrokerResult;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.clients.admin.UpdateFeaturesResult;
import org.apache.kafka.clients.admin.UserScramCredentialAlteration;
import org.apache.kafka.clients.admin.UserScramCredentialDeletion;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.clients.admin.internals.ConsumerGroupOperationContext;
import org.apache.kafka.clients.admin.internals.MetadataOperationContext;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnacceptableCredentialException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedSaslMechanismException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.AlterReplicaLogDirsRequestData;
import org.apache.kafka.common.message.AlterReplicaLogDirsResponseData;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.CreateAclsRequestData;
import org.apache.kafka.common.message.CreateAclsResponseData;
import org.apache.kafka.common.message.CreateDelegationTokenRequestData;
import org.apache.kafka.common.message.CreateDelegationTokenResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteAclsRequestData;
import org.apache.kafka.common.message.DeleteAclsResponseData;
import org.apache.kafka.common.message.DeleteGroupsRequestData;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.message.DescribeGroupsRequestData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.DescribeLogDirsRequestData;
import org.apache.kafka.common.message.DescribeLogDirsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.ExpireDelegationTokenRequestData;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.RenewDelegationTokenRequestData;
import org.apache.kafka.common.message.UnregisterBrokerRequestData;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.CreateDelegationTokenRequest;
import org.apache.kafka.common.requests.CreateDelegationTokenResponse;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DeleteGroupsRequest;
import org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.requests.DescribeClientQuotasRequest;
import org.apache.kafka.common.requests.DescribeClientQuotasResponse;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.DescribeDelegationTokenRequest;
import org.apache.kafka.common.requests.DescribeDelegationTokenResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.DescribeLogDirsRequest;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.common.requests.ElectLeadersRequest;
import org.apache.kafka.common.requests.ElectLeadersResponse;
import org.apache.kafka.common.requests.ExpireDelegationTokenRequest;
import org.apache.kafka.common.requests.ExpireDelegationTokenResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.ListPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetDeleteRequest;
import org.apache.kafka.common.requests.OffsetDeleteResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.RenewDelegationTokenRequest;
import org.apache.kafka.common.requests.RenewDelegationTokenResponse;
import org.apache.kafka.common.requests.UnregisterBrokerRequest;
import org.apache.kafka.common.requests.UnregisterBrokerResponse;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

@InterfaceStability.Evolving
public class KafkaAdminClient
extends AdminClient {
    private static final AtomicInteger ADMIN_CLIENT_ID_SEQUENCE = new AtomicInteger(1);
    private static final String JMX_PREFIX = "kafka.admin.client";
    private static final long INVALID_SHUTDOWN_TIME = -1L;
    static final String NETWORK_THREAD_PREFIX = "kafka-admin-client-thread";
    private final Logger log;
    private final int defaultApiTimeoutMs;
    private final int requestTimeoutMs;
    private final String clientId;
    private final Time time;
    private final AdminMetadataManager metadataManager;
    private final Metrics metrics;
    private final KafkaClient client;
    private final AdminClientRunnable runnable;
    private final Thread thread;
    private final AtomicLong hardShutdownTimeMs = new AtomicLong(-1L);
    private final TimeoutProcessorFactory timeoutProcessorFactory;
    private final int maxRetries;
    private final long retryBackoffMs;

    static <K, V> List<V> getOrCreateListValue(Map<K, List<V>> map, K key) {
        return map.computeIfAbsent(key, k -> new LinkedList());
    }

    private static <T> void completeAllExceptionally(Collection<KafkaFutureImpl<T>> futures, Throwable exc) {
        KafkaAdminClient.completeAllExceptionally(futures.stream(), exc);
    }

    private static <T> void completeAllExceptionally(Stream<KafkaFutureImpl<T>> futures, Throwable exc) {
        futures.forEach(future -> future.completeExceptionally(exc));
    }

    static int calcTimeoutMsRemainingAsInt(long now, long deadlineMs) {
        long deltaMs = deadlineMs - now;
        if (deltaMs > Integer.MAX_VALUE) {
            deltaMs = Integer.MAX_VALUE;
        } else if (deltaMs < Integer.MIN_VALUE) {
            deltaMs = Integer.MIN_VALUE;
        }
        return (int)deltaMs;
    }

    static String generateClientId(AdminClientConfig config) {
        String clientId = config.getString("client.id");
        if (!clientId.isEmpty()) {
            return clientId;
        }
        return "adminclient-" + ADMIN_CLIENT_ID_SEQUENCE.getAndIncrement();
    }

    private long calcDeadlineMs(long now, Integer optionTimeoutMs) {
        if (optionTimeoutMs != null) {
            return now + (long)Math.max(0, optionTimeoutMs);
        }
        return now + (long)this.defaultApiTimeoutMs;
    }

    static String prettyPrintException(Throwable throwable) {
        if (throwable == null) {
            return "Null exception.";
        }
        if (throwable.getMessage() != null) {
            return throwable.getClass().getSimpleName() + ": " + throwable.getMessage();
        }
        return throwable.getClass().getSimpleName();
    }

    static KafkaAdminClient createInternal(AdminClientConfig config, TimeoutProcessorFactory timeoutProcessorFactory) {
        Metrics metrics = null;
        NetworkClient networkClient = null;
        Time time = Time.SYSTEM;
        String clientId = KafkaAdminClient.generateClientId(config);
        ChannelBuilder channelBuilder = null;
        Selector selector = null;
        ApiVersions apiVersions = new ApiVersions();
        LogContext logContext = KafkaAdminClient.createLogContext(clientId);
        try {
            AdminMetadataManager metadataManager = new AdminMetadataManager(logContext, config.getLong("retry.backoff.ms"), config.getLong("metadata.max.age.ms"));
            List<InetSocketAddress> addresses = ClientUtils.parseAndValidateAddresses(config.getList("bootstrap.servers"), config.getString("client.dns.lookup"));
            metadataManager.update(Cluster.bootstrap(addresses), time.milliseconds());
            List<MetricsReporter> reporters = config.getConfiguredInstances("metric.reporters", MetricsReporter.class, Collections.singletonMap("client.id", clientId));
            Map<String, String> metricTags = Collections.singletonMap("client-id", clientId);
            MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples")).timeWindow(config.getLong("metrics.sample.window.ms"), TimeUnit.MILLISECONDS).recordLevel(Sensor.RecordingLevel.forName(config.getString("metrics.recording.level"))).tags(metricTags);
            JmxReporter jmxReporter = new JmxReporter();
            jmxReporter.configure(config.originals());
            reporters.add(jmxReporter);
            KafkaMetricsContext metricsContext = new KafkaMetricsContext(JMX_PREFIX, config.originalsWithPrefix("metrics.context."));
            metrics = new Metrics(metricConfig, reporters, time, metricsContext);
            String metricGrpPrefix = "admin-client";
            channelBuilder = ClientUtils.createChannelBuilder(config, time, logContext);
            selector = new Selector(config.getInt("max.receive.size"), config.getLong("connections.max.idle.ms"), metrics, time, metricGrpPrefix, channelBuilder, logContext);
            networkClient = new NetworkClient((Selectable)selector, metadataManager.updater(), clientId, 1, (long)config.getLong("reconnect.backoff.ms"), (long)config.getLong("reconnect.backoff.max.ms"), (int)config.getInt("send.buffer.bytes"), (int)config.getInt("receive.buffer.bytes"), (int)TimeUnit.HOURS.toMillis(1L), (long)config.getLong("socket.connection.setup.timeout.ms"), (long)config.getLong("socket.connection.setup.timeout.max.ms"), ClientDnsLookup.forConfig(config.getString("client.dns.lookup")), time, true, apiVersions, logContext);
            return new KafkaAdminClient(config, clientId, time, metadataManager, metrics, networkClient, timeoutProcessorFactory, logContext);
        }
        catch (Throwable exc) {
            Utils.closeQuietly(metrics, "Metrics");
            Utils.closeQuietly(networkClient, "NetworkClient");
            Utils.closeQuietly(selector, "Selector");
            Utils.closeQuietly(channelBuilder, "ChannelBuilder");
            throw new KafkaException("Failed to create new KafkaAdminClient", exc);
        }
    }

    static KafkaAdminClient createInternal(AdminClientConfig config, AdminMetadataManager metadataManager, KafkaClient client, Time time) {
        Metrics metrics = null;
        String clientId = KafkaAdminClient.generateClientId(config);
        try {
            metrics = new Metrics(new MetricConfig(), new LinkedList<MetricsReporter>(), time);
            LogContext logContext = KafkaAdminClient.createLogContext(clientId);
            return new KafkaAdminClient(config, clientId, time, metadataManager, metrics, client, null, logContext);
        }
        catch (Throwable exc) {
            Utils.closeQuietly(metrics, "Metrics");
            throw new KafkaException("Failed to create new KafkaAdminClient", exc);
        }
    }

    static LogContext createLogContext(String clientId) {
        return new LogContext("[AdminClient clientId=" + clientId + "] ");
    }

    private KafkaAdminClient(AdminClientConfig config, String clientId, Time time, AdminMetadataManager metadataManager, Metrics metrics, KafkaClient client, TimeoutProcessorFactory timeoutProcessorFactory, LogContext logContext) {
        this.clientId = clientId;
        this.log = logContext.logger(KafkaAdminClient.class);
        this.requestTimeoutMs = config.getInt("request.timeout.ms");
        this.defaultApiTimeoutMs = this.configureDefaultApiTimeoutMs(config);
        this.time = time;
        this.metadataManager = metadataManager;
        this.metrics = metrics;
        this.client = client;
        this.runnable = new AdminClientRunnable();
        String threadName = "kafka-admin-client-thread | " + clientId;
        this.thread = new KafkaThread(threadName, (Runnable)this.runnable, true);
        this.timeoutProcessorFactory = timeoutProcessorFactory == null ? new TimeoutProcessorFactory() : timeoutProcessorFactory;
        this.maxRetries = config.getInt("retries");
        this.retryBackoffMs = config.getLong("retry.backoff.ms");
        config.logUnused();
        AppInfoParser.registerAppInfo(JMX_PREFIX, clientId, metrics, time.milliseconds());
        this.log.debug("Kafka admin client initialized");
        this.thread.start();
    }

    private int configureDefaultApiTimeoutMs(AdminClientConfig config) {
        int requestTimeoutMs = config.getInt("request.timeout.ms");
        int defaultApiTimeoutMs = config.getInt("default.api.timeout.ms");
        if (defaultApiTimeoutMs < requestTimeoutMs) {
            if (config.originals().containsKey("default.api.timeout.ms")) {
                throw new ConfigException("The specified value of default.api.timeout.ms must be no smaller than the value of request.timeout.ms.");
            }
            this.log.warn("Overriding the default value for {} ({}) with the explicitly configured request timeout {}", new Object[]{"default.api.timeout.ms", this.defaultApiTimeoutMs, requestTimeoutMs});
            return requestTimeoutMs;
        }
        return defaultApiTimeoutMs;
    }

    @Override
    public void close(Duration timeout) {
        long newHardShutdownTimeMs;
        long waitTimeMs;
        block8: {
            waitTimeMs = timeout.toMillis();
            if (waitTimeMs < 0L) {
                throw new IllegalArgumentException("The timeout cannot be negative.");
            }
            waitTimeMs = Math.min(TimeUnit.DAYS.toMillis(365L), waitTimeMs);
            long now = this.time.milliseconds();
            newHardShutdownTimeMs = now + waitTimeMs;
            long prev = -1L;
            do {
                if (!this.hardShutdownTimeMs.compareAndSet(prev, newHardShutdownTimeMs)) continue;
                if (prev == -1L) {
                    this.log.debug("Initiating close operation.");
                } else {
                    this.log.debug("Moving hard shutdown time forward.");
                }
                this.client.wakeup();
                break block8;
            } while ((prev = this.hardShutdownTimeMs.get()) >= newHardShutdownTimeMs);
            this.log.debug("Hard shutdown time is already earlier than requested.");
            newHardShutdownTimeMs = prev;
        }
        if (this.log.isDebugEnabled()) {
            long deltaMs = Math.max(0L, newHardShutdownTimeMs - this.time.milliseconds());
            this.log.debug("Waiting for the I/O thread to exit. Hard shutdown in {} ms.", (Object)deltaMs);
        }
        try {
            if (Thread.currentThread() != this.thread) {
                this.thread.join(waitTimeMs);
            }
            this.log.debug("Kafka admin client closed.");
        }
        catch (InterruptedException e) {
            this.log.debug("Interrupted while joining I/O thread", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private static boolean topicNameIsUnrepresentable(String topicName) {
        return topicName == null || topicName.isEmpty();
    }

    private static boolean groupIdIsUnrepresentable(String groupId) {
        return groupId == null;
    }

    int numPendingCalls() {
        return this.runnable.pendingCalls.size();
    }

    private static <K, V> void completeUnrealizedFutures(Stream<Map.Entry<K, KafkaFutureImpl<V>>> futures, Function<K, String> messageFormatter) {
        futures.filter(entry -> !((KafkaFutureImpl)entry.getValue()).isDone()).forEach(entry -> ((KafkaFutureImpl)entry.getValue()).completeExceptionally(new ApiException((String)messageFormatter.apply(entry.getKey()))));
    }

    private static <K, V> void maybeCompleteQuotaExceededException(boolean shouldRetryOnQuotaViolation, Throwable throwable, Map<K, KafkaFutureImpl<V>> futures, Map<K, ThrottlingQuotaExceededException> quotaExceededExceptions, int throttleTimeDelta) {
        if (shouldRetryOnQuotaViolation && throwable instanceof TimeoutException) {
            quotaExceededExceptions.forEach((key, value) -> ((KafkaFutureImpl)futures.get(key)).completeExceptionally(new ThrottlingQuotaExceededException(Math.max(0, value.throttleTimeMs() - throttleTimeDelta), value.getMessage())));
        }
    }

    @Override
    public CreateTopicsResult createTopics(Collection<NewTopic> newTopics, CreateTopicsOptions options) {
        HashMap<String, KafkaFutureImpl<CreateTopicsResult.TopicMetadataAndConfig>> topicFutures = new HashMap<String, KafkaFutureImpl<CreateTopicsResult.TopicMetadataAndConfig>>(newTopics.size());
        CreateTopicsRequestData.CreatableTopicCollection topics = new CreateTopicsRequestData.CreatableTopicCollection();
        for (NewTopic newTopic : newTopics) {
            if (KafkaAdminClient.topicNameIsUnrepresentable(newTopic.name())) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally(new InvalidTopicException("The given topic name '" + newTopic.name() + "' cannot be represented in a request."));
                topicFutures.put(newTopic.name(), future);
                continue;
            }
            if (topicFutures.containsKey(newTopic.name())) continue;
            topicFutures.put(newTopic.name(), new KafkaFutureImpl());
            topics.add(newTopic.convertToCreatableTopic());
        }
        if (!topics.isEmpty()) {
            long now = this.time.milliseconds();
            long deadline = this.calcDeadlineMs(now, options.timeoutMs());
            Call call = this.getCreateTopicsCall(options, topicFutures, topics, Collections.emptyMap(), now, deadline);
            this.runnable.call(call, now);
        }
        return new CreateTopicsResult(new HashMap<String, KafkaFuture<CreateTopicsResult.TopicMetadataAndConfig>>(topicFutures));
    }

    private Call getCreateTopicsCall(final CreateTopicsOptions options, final Map<String, KafkaFutureImpl<CreateTopicsResult.TopicMetadataAndConfig>> futures, final CreateTopicsRequestData.CreatableTopicCollection topics, final Map<String, ThrottlingQuotaExceededException> quotaExceededExceptions, final long now, final long deadline) {
        return new Call("createTopics", deadline, new ControllerNodeProvider()){

            @Override
            public CreateTopicsRequest.Builder createRequest(int timeoutMs) {
                return new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTopics(topics).setTimeoutMs(timeoutMs).setValidateOnly(options.shouldValidateOnly()));
            }

            @Override
            public void handleResponse(AbstractResponse abstractResponse) {
                KafkaAdminClient.this.handleNotControllerError(abstractResponse);
                CreateTopicsResponse response = (CreateTopicsResponse)abstractResponse;
                CreateTopicsRequestData.CreatableTopicCollection retryTopics = new CreateTopicsRequestData.CreatableTopicCollection();
                HashMap<String, ThrottlingQuotaExceededException> retryTopicQuotaExceededExceptions = new HashMap<String, ThrottlingQuotaExceededException>();
                for (CreateTopicsResponseData.CreatableTopicResult result : response.data().topics()) {
                    CreateTopicsResult.TopicMetadataAndConfig topicMetadataAndConfig;
                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(result.name());
                    if (future == null) {
                        KafkaAdminClient.this.log.warn("Server response mentioned unknown topic {}", (Object)result.name());
                        continue;
                    }
                    ApiError error = new ApiError(result.errorCode(), result.errorMessage());
                    if (error.isFailure()) {
                        if (error.is(Errors.THROTTLING_QUOTA_EXCEEDED)) {
                            ThrottlingQuotaExceededException quotaExceededException = new ThrottlingQuotaExceededException(response.throttleTimeMs(), error.messageWithFallback());
                            if (options.shouldRetryOnQuotaViolation()) {
                                retryTopics.add(topics.find(result.name()).duplicate());
                                retryTopicQuotaExceededExceptions.put(result.name(), quotaExceededException);
                                continue;
                            }
                            future.completeExceptionally(quotaExceededException);
                            continue;
                        }
                        future.completeExceptionally(error.exception());
                        continue;
                    }
                    if (result.topicConfigErrorCode() != Errors.NONE.code()) {
                        topicMetadataAndConfig = new CreateTopicsResult.TopicMetadataAndConfig(Errors.forCode(result.topicConfigErrorCode()).exception());
                    } else if (result.numPartitions() == -1) {
                        topicMetadataAndConfig = new CreateTopicsResult.TopicMetadataAndConfig(new UnsupportedVersionException("Topic metadata and configs in CreateTopics response not supported"));
                    } else {
                        List<CreateTopicsResponseData.CreatableTopicConfigs> configs = result.configs();
                        Config topicConfig = new Config(configs.stream().map(this::configEntry).collect(Collectors.toSet()));
                        topicMetadataAndConfig = new CreateTopicsResult.TopicMetadataAndConfig(result.topicId(), result.numPartitions(), result.replicationFactor(), topicConfig);
                    }
                    future.complete(topicMetadataAndConfig);
                }
                if (retryTopics.isEmpty()) {
                    KafkaAdminClient.completeUnrealizedFutures(futures.entrySet().stream(), topic -> "The controller response did not contain a result for topic " + topic);
                } else {
                    long now2 = KafkaAdminClient.this.time.milliseconds();
                    Call call = KafkaAdminClient.this.getCreateTopicsCall(options, futures, retryTopics, retryTopicQuotaExceededExceptions, now2, deadline);
                    KafkaAdminClient.this.runnable.call(call, now2);
                }
            }

            private ConfigEntry configEntry(CreateTopicsResponseData.CreatableTopicConfigs config) {
                return new ConfigEntry(config.name(), config.value(), KafkaAdminClient.this.configSource(DescribeConfigsResponse.ConfigSource.forId(config.configSource())), config.isSensitive(), config.readOnly(), Collections.emptyList(), null, null);
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.maybeCompleteQuotaExceededException(options.shouldRetryOnQuotaViolation(), throwable, futures, quotaExceededExceptions, (int)(KafkaAdminClient.this.time.milliseconds() - now));
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        };
    }

    @Override
    public DeleteTopicsResult deleteTopics(Collection<String> topicNames, DeleteTopicsOptions options) {
        HashMap<String, KafkaFutureImpl<Void>> topicFutures = new HashMap<String, KafkaFutureImpl<Void>>(topicNames.size());
        ArrayList<String> validTopicNames = new ArrayList<String>(topicNames.size());
        for (String topicName : topicNames) {
            if (KafkaAdminClient.topicNameIsUnrepresentable(topicName)) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally(new InvalidTopicException("The given topic name '" + topicName + "' cannot be represented in a request."));
                topicFutures.put(topicName, future);
                continue;
            }
            if (topicFutures.containsKey(topicName)) continue;
            topicFutures.put(topicName, new KafkaFutureImpl());
            validTopicNames.add(topicName);
        }
        if (!validTopicNames.isEmpty()) {
            long now = this.time.milliseconds();
            long deadline = this.calcDeadlineMs(now, options.timeoutMs());
            Call call = this.getDeleteTopicsCall(options, topicFutures, validTopicNames, Collections.emptyMap(), now, deadline);
            this.runnable.call(call, now);
        }
        return new DeleteTopicsResult(new HashMap<String, KafkaFuture<Void>>(topicFutures));
    }

    private Call getDeleteTopicsCall(final DeleteTopicsOptions options, final Map<String, KafkaFutureImpl<Void>> futures, final List<String> topics, final Map<String, ThrottlingQuotaExceededException> quotaExceededExceptions, final long now, final long deadline) {
        return new Call("deleteTopics", deadline, new ControllerNodeProvider()){

            @Override
            DeleteTopicsRequest.Builder createRequest(int timeoutMs) {
                return new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(topics).setTimeoutMs(timeoutMs));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                KafkaAdminClient.this.handleNotControllerError(abstractResponse);
                DeleteTopicsResponse response = (DeleteTopicsResponse)abstractResponse;
                ArrayList<String> retryTopics = new ArrayList<String>();
                HashMap<String, ThrottlingQuotaExceededException> retryTopicQuotaExceededExceptions = new HashMap<String, ThrottlingQuotaExceededException>();
                for (DeleteTopicsResponseData.DeletableTopicResult result : response.data().responses()) {
                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(result.name());
                    if (future == null) {
                        KafkaAdminClient.this.log.warn("Server response mentioned unknown topic {}", (Object)result.name());
                        continue;
                    }
                    ApiError error = new ApiError(result.errorCode(), result.errorMessage());
                    if (error.isFailure()) {
                        if (error.is(Errors.THROTTLING_QUOTA_EXCEEDED)) {
                            ThrottlingQuotaExceededException quotaExceededException = new ThrottlingQuotaExceededException(response.throttleTimeMs(), error.messageWithFallback());
                            if (options.shouldRetryOnQuotaViolation()) {
                                retryTopics.add(result.name());
                                retryTopicQuotaExceededExceptions.put(result.name(), quotaExceededException);
                                continue;
                            }
                            future.completeExceptionally(quotaExceededException);
                            continue;
                        }
                        future.completeExceptionally(error.exception());
                        continue;
                    }
                    future.complete(null);
                }
                if (retryTopics.isEmpty()) {
                    KafkaAdminClient.completeUnrealizedFutures(futures.entrySet().stream(), topic -> "The controller response did not contain a result for topic " + topic);
                } else {
                    long now2 = KafkaAdminClient.this.time.milliseconds();
                    Call call = KafkaAdminClient.this.getDeleteTopicsCall(options, futures, retryTopics, retryTopicQuotaExceededExceptions, now2, deadline);
                    KafkaAdminClient.this.runnable.call(call, now2);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.maybeCompleteQuotaExceededException(options.shouldRetryOnQuotaViolation(), throwable, futures, quotaExceededExceptions, (int)(KafkaAdminClient.this.time.milliseconds() - now));
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        };
    }

    @Override
    public ListTopicsResult listTopics(final ListTopicsOptions options) {
        final KafkaFutureImpl<Map<String, TopicListing>> topicListingFuture = new KafkaFutureImpl<Map<String, TopicListing>>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("listTopics", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            @Override
            MetadataRequest.Builder createRequest(int timeoutMs) {
                return MetadataRequest.Builder.allTopics();
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                MetadataResponse response = (MetadataResponse)abstractResponse;
                HashMap<String, TopicListing> topicListing = new HashMap<String, TopicListing>();
                for (MetadataResponse.TopicMetadata topicMetadata : response.topicMetadata()) {
                    String topicName = topicMetadata.topic();
                    boolean isInternal = topicMetadata.isInternal();
                    if (topicMetadata.isInternal() && !options.shouldListInternal()) continue;
                    topicListing.put(topicName, new TopicListing(topicName, isInternal));
                }
                topicListingFuture.complete(topicListing);
            }

            @Override
            void handleFailure(Throwable throwable) {
                topicListingFuture.completeExceptionally(throwable);
            }
        }, now);
        return new ListTopicsResult(topicListingFuture);
    }

    @Override
    public DescribeTopicsResult describeTopics(Collection<String> topicNames, final DescribeTopicsOptions options) {
        final HashMap topicFutures = new HashMap(topicNames.size());
        final ArrayList<String> topicNamesList = new ArrayList<String>();
        for (String topicName : topicNames) {
            if (KafkaAdminClient.topicNameIsUnrepresentable(topicName)) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally(new InvalidTopicException("The given topic name '" + topicName + "' cannot be represented in a request."));
                topicFutures.put(topicName, future);
                continue;
            }
            if (topicFutures.containsKey(topicName)) continue;
            topicFutures.put(topicName, new KafkaFutureImpl());
            topicNamesList.add(topicName);
        }
        long now = this.time.milliseconds();
        Call call = new Call("describeTopics", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){
            private boolean supportsDisablingTopicCreation;
            {
                super(callName, deadlineMs, nodeProvider);
                this.supportsDisablingTopicCreation = true;
            }

            @Override
            MetadataRequest.Builder createRequest(int timeoutMs) {
                if (this.supportsDisablingTopicCreation) {
                    return new MetadataRequest.Builder(new MetadataRequestData().setTopics(MetadataRequest.convertToMetadataRequestTopic(topicNamesList)).setAllowAutoTopicCreation(false).setIncludeTopicAuthorizedOperations(options.includeAuthorizedOperations()));
                }
                return MetadataRequest.Builder.allTopics();
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                MetadataResponse response = (MetadataResponse)abstractResponse;
                Cluster cluster = response.buildCluster();
                Map<String, Errors> errors = response.errors();
                for (Map.Entry entry : topicFutures.entrySet()) {
                    String topicName = (String)entry.getKey();
                    KafkaFutureImpl future = (KafkaFutureImpl)entry.getValue();
                    Errors topicError = errors.get(topicName);
                    if (topicError != null) {
                        future.completeExceptionally(topicError.exception());
                        continue;
                    }
                    if (!cluster.topics().contains(topicName)) {
                        future.completeExceptionally(new UnknownTopicOrPartitionException("Topic " + topicName + " not found."));
                        continue;
                    }
                    boolean isInternal = cluster.internalTopics().contains(topicName);
                    List<PartitionInfo> partitionInfos = cluster.partitionsForTopic(topicName);
                    ArrayList<TopicPartitionInfo> partitions = new ArrayList<TopicPartitionInfo>(partitionInfos.size());
                    for (PartitionInfo partitionInfo : partitionInfos) {
                        TopicPartitionInfo topicPartitionInfo = new TopicPartitionInfo(partitionInfo.partition(), this.leader(partitionInfo), Arrays.asList(partitionInfo.replicas()), Arrays.asList(partitionInfo.inSyncReplicas()));
                        partitions.add(topicPartitionInfo);
                    }
                    partitions.sort(Comparator.comparingInt(TopicPartitionInfo::partition));
                    TopicDescription topicDescription = new TopicDescription(topicName, isInternal, partitions, KafkaAdminClient.this.validAclOperations(response.topicAuthorizedOperations(topicName).get()), cluster.topicId(topicName));
                    future.complete(topicDescription);
                }
            }

            private Node leader(PartitionInfo partitionInfo) {
                if (partitionInfo.leader() == null || partitionInfo.leader().id() == Node.noNode().id()) {
                    return null;
                }
                return partitionInfo.leader();
            }

            @Override
            boolean handleUnsupportedVersionException(UnsupportedVersionException exception) {
                if (this.supportsDisablingTopicCreation) {
                    this.supportsDisablingTopicCreation = false;
                    return true;
                }
                return false;
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(topicFutures.values(), throwable);
            }
        };
        if (!topicNamesList.isEmpty()) {
            this.runnable.call(call, now);
        }
        return new DescribeTopicsResult(new HashMap<String, KafkaFuture<TopicDescription>>(topicFutures));
    }

    @Override
    public DescribeClusterResult describeCluster(final DescribeClusterOptions options) {
        final KafkaFutureImpl<Collection<Node>> describeClusterFuture = new KafkaFutureImpl<Collection<Node>>();
        final KafkaFutureImpl<Node> controllerFuture = new KafkaFutureImpl<Node>();
        final KafkaFutureImpl<String> clusterIdFuture = new KafkaFutureImpl<String>();
        final KafkaFutureImpl<Set<AclOperation>> authorizedOperationsFuture = new KafkaFutureImpl<Set<AclOperation>>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("listNodes", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){
            private boolean useMetadataRequest;
            {
                super(callName, deadlineMs, nodeProvider);
                this.useMetadataRequest = false;
            }

            @Override
            AbstractRequest.Builder createRequest(int timeoutMs) {
                if (!this.useMetadataRequest) {
                    return new DescribeClusterRequest.Builder(new DescribeClusterRequestData().setIncludeClusterAuthorizedOperations(options.includeAuthorizedOperations()));
                }
                return new MetadataRequest.Builder(new MetadataRequestData().setTopics(Collections.emptyList()).setAllowAutoTopicCreation(true).setIncludeClusterAuthorizedOperations(options.includeAuthorizedOperations()));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                if (!this.useMetadataRequest) {
                    DescribeClusterResponse response = (DescribeClusterResponse)abstractResponse;
                    Errors error = Errors.forCode(response.data().errorCode());
                    if (error != Errors.NONE) {
                        ApiError apiError = new ApiError(error, response.data().errorMessage());
                        this.handleFailure(apiError.exception());
                        return;
                    }
                    Map<Integer, Node> nodes = response.nodes();
                    describeClusterFuture.complete(nodes.values());
                    controllerFuture.complete(nodes.get(response.data().controllerId()));
                    clusterIdFuture.complete(response.data().clusterId());
                    authorizedOperationsFuture.complete(KafkaAdminClient.this.validAclOperations(response.data().clusterAuthorizedOperations()));
                } else {
                    MetadataResponse response = (MetadataResponse)abstractResponse;
                    describeClusterFuture.complete(response.brokers());
                    controllerFuture.complete(this.controller(response));
                    clusterIdFuture.complete(response.clusterId());
                    authorizedOperationsFuture.complete(KafkaAdminClient.this.validAclOperations(response.clusterAuthorizedOperations()));
                }
            }

            private Node controller(MetadataResponse response) {
                if (response.controller() == null || response.controller().id() == -1) {
                    return null;
                }
                return response.controller();
            }

            @Override
            void handleFailure(Throwable throwable) {
                describeClusterFuture.completeExceptionally(throwable);
                controllerFuture.completeExceptionally(throwable);
                clusterIdFuture.completeExceptionally(throwable);
                authorizedOperationsFuture.completeExceptionally(throwable);
            }

            @Override
            boolean handleUnsupportedVersionException(UnsupportedVersionException exception) {
                if (this.useMetadataRequest) {
                    return false;
                }
                this.useMetadataRequest = true;
                return true;
            }
        }, now);
        return new DescribeClusterResult(describeClusterFuture, controllerFuture, clusterIdFuture, authorizedOperationsFuture);
    }

    @Override
    public DescribeAclsResult describeAcls(final AclBindingFilter filter, DescribeAclsOptions options) {
        if (filter.isUnknown()) {
            KafkaFutureImpl<Collection<AclBinding>> future = new KafkaFutureImpl<Collection<AclBinding>>();
            future.completeExceptionally(new InvalidRequestException("The AclBindingFilter must not contain UNKNOWN elements."));
            return new DescribeAclsResult(future);
        }
        long now = this.time.milliseconds();
        final KafkaFutureImpl<Collection<AclBinding>> future = new KafkaFutureImpl<Collection<AclBinding>>();
        this.runnable.call(new Call("describeAcls", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            @Override
            DescribeAclsRequest.Builder createRequest(int timeoutMs) {
                return new DescribeAclsRequest.Builder(filter);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeAclsResponse response = (DescribeAclsResponse)abstractResponse;
                if (response.error().isFailure()) {
                    future.completeExceptionally(response.error().exception());
                } else {
                    future.complete(DescribeAclsResponse.aclBindings(response.acls()));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        }, now);
        return new DescribeAclsResult(future);
    }

    @Override
    public CreateAclsResult createAcls(Collection<AclBinding> acls, CreateAclsOptions options) {
        long now = this.time.milliseconds();
        final HashMap futures = new HashMap();
        ArrayList<CreateAclsRequestData.AclCreation> aclCreations = new ArrayList<CreateAclsRequestData.AclCreation>();
        final ArrayList<AclBinding> aclBindingsSent = new ArrayList<AclBinding>();
        for (AclBinding acl : acls) {
            if (futures.get(acl) != null) continue;
            KafkaFutureImpl future = new KafkaFutureImpl();
            futures.put(acl, future);
            String indefinite = acl.toFilter().findIndefiniteField();
            if (indefinite == null) {
                aclCreations.add(CreateAclsRequest.aclCreation(acl));
                aclBindingsSent.add(acl);
                continue;
            }
            future.completeExceptionally(new InvalidRequestException("Invalid ACL creation: " + indefinite));
        }
        final CreateAclsRequestData data = new CreateAclsRequestData().setCreations(aclCreations);
        this.runnable.call(new Call("createAcls", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            @Override
            CreateAclsRequest.Builder createRequest(int timeoutMs) {
                return new CreateAclsRequest.Builder(data);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                CreateAclsResponse response = (CreateAclsResponse)abstractResponse;
                List<CreateAclsResponseData.AclCreationResult> responses = response.results();
                Iterator<CreateAclsResponseData.AclCreationResult> iter = responses.iterator();
                for (AclBinding aclBinding : aclBindingsSent) {
                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(aclBinding);
                    if (!iter.hasNext()) {
                        future.completeExceptionally(new UnknownServerException("The broker reported no creation result for the given ACL: " + aclBinding));
                        continue;
                    }
                    CreateAclsResponseData.AclCreationResult creation = iter.next();
                    Errors error = Errors.forCode(creation.errorCode());
                    ApiError apiError = new ApiError(error, creation.errorMessage());
                    if (apiError.isFailure()) {
                        future.completeExceptionally(apiError.exception());
                        continue;
                    }
                    future.complete(null);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        }, now);
        return new CreateAclsResult(new HashMap<AclBinding, KafkaFuture<Void>>(futures));
    }

    @Override
    public DeleteAclsResult deleteAcls(Collection<AclBindingFilter> filters, DeleteAclsOptions options) {
        long now = this.time.milliseconds();
        final HashMap futures = new HashMap();
        final ArrayList<AclBindingFilter> aclBindingFiltersSent = new ArrayList<AclBindingFilter>();
        ArrayList<DeleteAclsRequestData.DeleteAclsFilter> deleteAclsFilters = new ArrayList<DeleteAclsRequestData.DeleteAclsFilter>();
        for (AclBindingFilter filter : filters) {
            if (futures.get(filter) != null) continue;
            aclBindingFiltersSent.add(filter);
            deleteAclsFilters.add(DeleteAclsRequest.deleteAclsFilter(filter));
            futures.put(filter, new KafkaFutureImpl());
        }
        final DeleteAclsRequestData data = new DeleteAclsRequestData().setFilters(deleteAclsFilters);
        this.runnable.call(new Call("deleteAcls", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            @Override
            DeleteAclsRequest.Builder createRequest(int timeoutMs) {
                return new DeleteAclsRequest.Builder(data);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DeleteAclsResponse response = (DeleteAclsResponse)abstractResponse;
                List<DeleteAclsResponseData.DeleteAclsFilterResult> results = response.filterResults();
                Iterator<DeleteAclsResponseData.DeleteAclsFilterResult> iter = results.iterator();
                for (AclBindingFilter bindingFilter : aclBindingFiltersSent) {
                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(bindingFilter);
                    if (!iter.hasNext()) {
                        future.completeExceptionally(new UnknownServerException("The broker reported no deletion result for the given filter."));
                        continue;
                    }
                    DeleteAclsResponseData.DeleteAclsFilterResult filterResult = iter.next();
                    ApiError error = new ApiError(Errors.forCode(filterResult.errorCode()), filterResult.errorMessage());
                    if (error.isFailure()) {
                        future.completeExceptionally(error.exception());
                        continue;
                    }
                    ArrayList<DeleteAclsResult.FilterResult> filterResults = new ArrayList<DeleteAclsResult.FilterResult>();
                    for (DeleteAclsResponseData.DeleteAclsMatchingAcl matchingAcl : filterResult.matchingAcls()) {
                        ApiError aclError = new ApiError(Errors.forCode(matchingAcl.errorCode()), matchingAcl.errorMessage());
                        AclBinding aclBinding = DeleteAclsResponse.aclBinding(matchingAcl);
                        filterResults.add(new DeleteAclsResult.FilterResult(aclBinding, aclError.exception()));
                    }
                    future.complete(new DeleteAclsResult.FilterResults(filterResults));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        }, now);
        return new DeleteAclsResult(new HashMap<AclBindingFilter, KafkaFuture<DeleteAclsResult.FilterResults>>(futures));
    }

    @Override
    public DescribeConfigsResult describeConfigs(Collection<ConfigResource> configResources, final DescribeConfigsOptions options) {
        HashMap<Integer, Map> brokerFutures = new HashMap<Integer, Map>(configResources.size());
        for (ConfigResource resource : configResources) {
            Integer broker = this.nodeFor(resource);
            brokerFutures.compute(broker, (key, value) -> {
                if (value == null) {
                    value = new HashMap();
                }
                value.put(resource, new KafkaFutureImpl());
                return value;
            });
        }
        long now = this.time.milliseconds();
        for (Map.Entry entry : brokerFutures.entrySet()) {
            final Integer broker = (Integer)entry.getKey();
            final Map unified = (Map)entry.getValue();
            this.runnable.call(new Call("describeConfigs", this.calcDeadlineMs(now, options.timeoutMs()), broker != null ? new ConstantNodeIdProvider(broker) : new LeastLoadedNodeProvider()){

                @Override
                DescribeConfigsRequest.Builder createRequest(int timeoutMs) {
                    return new DescribeConfigsRequest.Builder(new DescribeConfigsRequestData().setResources(unified.keySet().stream().map(config -> new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(config.name()).setResourceType(config.type().id()).setConfigurationKeys(null)).collect(Collectors.toList())).setIncludeSynonyms(options.includeSynonyms()).setIncludeDocumentation(options.includeDocumentation()));
                }

                @Override
                void handleResponse(AbstractResponse abstractResponse) {
                    DescribeConfigsResponse response = (DescribeConfigsResponse)abstractResponse;
                    for (Map.Entry<ConfigResource, DescribeConfigsResponseData.DescribeConfigsResult> entry : response.resultMap().entrySet()) {
                        ConfigResource configResource2 = entry.getKey();
                        DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult = entry.getValue();
                        KafkaFutureImpl future = (KafkaFutureImpl)unified.get(configResource2);
                        if (future == null) {
                            if (broker != null) {
                                KafkaAdminClient.this.log.warn("The config {} in the response from broker {} is not in the request", (Object)configResource2, (Object)broker);
                                continue;
                            }
                            KafkaAdminClient.this.log.warn("The config {} in the response from the least loaded broker is not in the request", (Object)configResource2);
                            continue;
                        }
                        if (describeConfigsResult.errorCode() != Errors.NONE.code()) {
                            future.completeExceptionally(Errors.forCode(describeConfigsResult.errorCode()).exception(describeConfigsResult.errorMessage()));
                            continue;
                        }
                        future.complete(KafkaAdminClient.this.describeConfigResult(describeConfigsResult));
                    }
                    KafkaAdminClient.completeUnrealizedFutures(unified.entrySet().stream(), configResource -> "The broker response did not contain a result for config resource " + configResource);
                }

                @Override
                void handleFailure(Throwable throwable) {
                    KafkaAdminClient.completeAllExceptionally(unified.values(), throwable);
                }
            }, now);
        }
        return new DescribeConfigsResult(new HashMap<ConfigResource, KafkaFuture<Config>>(brokerFutures.entrySet().stream().flatMap(x -> ((Map)x.getValue()).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
    }

    private Config describeConfigResult(DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult) {
        return new Config(describeConfigsResult.configs().stream().map(config -> new ConfigEntry(config.name(), config.value(), DescribeConfigsResponse.ConfigSource.forId(config.configSource()).source(), config.isSensitive(), config.readOnly(), config.synonyms().stream().map(synonym -> new ConfigEntry.ConfigSynonym(synonym.name(), synonym.value(), DescribeConfigsResponse.ConfigSource.forId(synonym.source()).source())).collect(Collectors.toList()), DescribeConfigsResponse.ConfigType.forId(config.configType()).type(), config.documentation())).collect(Collectors.toList()));
    }

    private ConfigEntry.ConfigSource configSource(DescribeConfigsResponse.ConfigSource source) {
        ConfigEntry.ConfigSource configSource;
        switch (source) {
            case TOPIC_CONFIG: {
                configSource = ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG;
                break;
            }
            case DYNAMIC_BROKER_CONFIG: {
                configSource = ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG;
                break;
            }
            case DYNAMIC_DEFAULT_BROKER_CONFIG: {
                configSource = ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG;
                break;
            }
            case STATIC_BROKER_CONFIG: {
                configSource = ConfigEntry.ConfigSource.STATIC_BROKER_CONFIG;
                break;
            }
            case DYNAMIC_BROKER_LOGGER_CONFIG: {
                configSource = ConfigEntry.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG;
                break;
            }
            case DEFAULT_CONFIG: {
                configSource = ConfigEntry.ConfigSource.DEFAULT_CONFIG;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected config source " + (Object)((Object)source));
            }
        }
        return configSource;
    }

    @Override
    @Deprecated
    public AlterConfigsResult alterConfigs(Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
        HashMap<ConfigResource, KafkaFutureImpl<Void>> allFutures = new HashMap<ConfigResource, KafkaFutureImpl<Void>>();
        ArrayList<ConfigResource> unifiedRequestResources = new ArrayList<ConfigResource>();
        for (ConfigResource resource : configs.keySet()) {
            Integer node = this.nodeFor(resource);
            if (node != null) {
                ConstantNodeIdProvider nodeProvider = new ConstantNodeIdProvider(node);
                allFutures.putAll(this.alterConfigs(configs, options, Collections.singleton(resource), nodeProvider));
                continue;
            }
            unifiedRequestResources.add(resource);
        }
        if (!unifiedRequestResources.isEmpty()) {
            allFutures.putAll(this.alterConfigs(configs, options, unifiedRequestResources, new LeastLoadedNodeProvider()));
        }
        return new AlterConfigsResult(new HashMap<ConfigResource, KafkaFuture<Void>>(allFutures));
    }

    private Map<ConfigResource, KafkaFutureImpl<Void>> alterConfigs(Map<ConfigResource, Config> configs, final AlterConfigsOptions options, Collection<ConfigResource> resources, NodeProvider nodeProvider) {
        final HashMap<ConfigResource, KafkaFutureImpl<Void>> futures = new HashMap<ConfigResource, KafkaFutureImpl<Void>>();
        final HashMap<ConfigResource, AlterConfigsRequest.Config> requestMap = new HashMap<ConfigResource, AlterConfigsRequest.Config>(resources.size());
        for (ConfigResource resource : resources) {
            ArrayList<AlterConfigsRequest.ConfigEntry> configEntries = new ArrayList<AlterConfigsRequest.ConfigEntry>();
            for (ConfigEntry configEntry : configs.get(resource).entries()) {
                configEntries.add(new AlterConfigsRequest.ConfigEntry(configEntry.name(), configEntry.value()));
            }
            requestMap.put(resource, new AlterConfigsRequest.Config(configEntries));
            futures.put(resource, new KafkaFutureImpl());
        }
        long now = this.time.milliseconds();
        this.runnable.call(new Call("alterConfigs", this.calcDeadlineMs(now, options.timeoutMs()), nodeProvider){

            @Override
            public AlterConfigsRequest.Builder createRequest(int timeoutMs) {
                return new AlterConfigsRequest.Builder(requestMap, options.shouldValidateOnly());
            }

            @Override
            public void handleResponse(AbstractResponse abstractResponse) {
                AlterConfigsResponse response = (AlterConfigsResponse)abstractResponse;
                for (Map.Entry entry : futures.entrySet()) {
                    KafkaFutureImpl future = (KafkaFutureImpl)entry.getValue();
                    ApiException exception = response.errors().get(entry.getKey()).exception();
                    if (exception != null) {
                        future.completeExceptionally(exception);
                        continue;
                    }
                    future.complete(null);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        }, now);
        return futures;
    }

    @Override
    public AlterConfigsResult incrementalAlterConfigs(Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
        HashMap<ConfigResource, KafkaFutureImpl<Void>> allFutures = new HashMap<ConfigResource, KafkaFutureImpl<Void>>();
        ArrayList<ConfigResource> unifiedRequestResources = new ArrayList<ConfigResource>();
        for (ConfigResource resource : configs.keySet()) {
            Integer node = this.nodeFor(resource);
            if (node != null) {
                ConstantNodeIdProvider nodeProvider = new ConstantNodeIdProvider(node);
                allFutures.putAll(this.incrementalAlterConfigs(configs, options, Collections.singleton(resource), nodeProvider));
                continue;
            }
            unifiedRequestResources.add(resource);
        }
        if (!unifiedRequestResources.isEmpty()) {
            allFutures.putAll(this.incrementalAlterConfigs(configs, options, unifiedRequestResources, new LeastLoadedNodeProvider()));
        }
        return new AlterConfigsResult(new HashMap<ConfigResource, KafkaFuture<Void>>(allFutures));
    }

    private Map<ConfigResource, KafkaFutureImpl<Void>> incrementalAlterConfigs(final Map<ConfigResource, Collection<AlterConfigOp>> configs, final AlterConfigsOptions options, final Collection<ConfigResource> resources, NodeProvider nodeProvider) {
        final HashMap<ConfigResource, KafkaFutureImpl<Void>> futures = new HashMap<ConfigResource, KafkaFutureImpl<Void>>();
        for (ConfigResource resource : resources) {
            futures.put(resource, new KafkaFutureImpl());
        }
        long now = this.time.milliseconds();
        this.runnable.call(new Call("incrementalAlterConfigs", this.calcDeadlineMs(now, options.timeoutMs()), nodeProvider){

            @Override
            public IncrementalAlterConfigsRequest.Builder createRequest(int timeoutMs) {
                return new IncrementalAlterConfigsRequest.Builder(resources, configs, options.shouldValidateOnly());
            }

            @Override
            public void handleResponse(AbstractResponse abstractResponse) {
                IncrementalAlterConfigsResponse response = (IncrementalAlterConfigsResponse)abstractResponse;
                Map<ConfigResource, ApiError> errors = IncrementalAlterConfigsResponse.fromResponseData(response.data());
                for (Map.Entry entry : futures.entrySet()) {
                    KafkaFutureImpl future = (KafkaFutureImpl)entry.getValue();
                    ApiException exception = errors.get(entry.getKey()).exception();
                    if (exception != null) {
                        future.completeExceptionally(exception);
                        continue;
                    }
                    future.complete(null);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        }, now);
        return futures;
    }

    @Override
    public AlterReplicaLogDirsResult alterReplicaLogDirs(Map<TopicPartitionReplica, String> replicaAssignment, AlterReplicaLogDirsOptions options) {
        int brokerId;
        final HashMap futures = new HashMap(replicaAssignment.size());
        for (TopicPartitionReplica topicPartitionReplica : replicaAssignment.keySet()) {
            futures.put(topicPartitionReplica, new KafkaFutureImpl());
        }
        HashMap<Integer, AlterReplicaLogDirsRequestData> replicaAssignmentByBroker = new HashMap<Integer, AlterReplicaLogDirsRequestData>();
        for (Map.Entry<TopicPartitionReplica, String> entry : replicaAssignment.entrySet()) {
            AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopic alterReplicaLogDirTopic;
            TopicPartitionReplica replica = entry.getKey();
            String logDir = entry.getValue();
            brokerId = replica.brokerId();
            AlterReplicaLogDirsRequestData value = replicaAssignmentByBroker.computeIfAbsent(brokerId, key -> new AlterReplicaLogDirsRequestData());
            AlterReplicaLogDirsRequestData.AlterReplicaLogDir alterReplicaLogDir = value.dirs().find(logDir);
            if (alterReplicaLogDir == null) {
                alterReplicaLogDir = new AlterReplicaLogDirsRequestData.AlterReplicaLogDir();
                alterReplicaLogDir.setPath(logDir);
                value.dirs().add(alterReplicaLogDir);
            }
            if ((alterReplicaLogDirTopic = alterReplicaLogDir.topics().find(replica.topic())) == null) {
                alterReplicaLogDirTopic = new AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopic().setName(replica.topic());
                alterReplicaLogDir.topics().add(alterReplicaLogDirTopic);
            }
            alterReplicaLogDirTopic.partitions().add(replica.partition());
        }
        long l = this.time.milliseconds();
        for (Map.Entry entry : replicaAssignmentByBroker.entrySet()) {
            brokerId = (Integer)entry.getKey();
            final AlterReplicaLogDirsRequestData assignment = (AlterReplicaLogDirsRequestData)entry.getValue();
            this.runnable.call(new Call("alterReplicaLogDirs", this.calcDeadlineMs(l, options.timeoutMs()), new ConstantNodeIdProvider(brokerId)){

                @Override
                public AlterReplicaLogDirsRequest.Builder createRequest(int timeoutMs) {
                    return new AlterReplicaLogDirsRequest.Builder(assignment);
                }

                @Override
                public void handleResponse(AbstractResponse abstractResponse) {
                    AlterReplicaLogDirsResponse response = (AlterReplicaLogDirsResponse)abstractResponse;
                    for (AlterReplicaLogDirsResponseData.AlterReplicaLogDirTopicResult topicResult : response.data().results()) {
                        for (AlterReplicaLogDirsResponseData.AlterReplicaLogDirPartitionResult partitionResult : topicResult.partitions()) {
                            TopicPartitionReplica replica2 = new TopicPartitionReplica(topicResult.topicName(), partitionResult.partitionIndex(), brokerId);
                            KafkaFutureImpl future = (KafkaFutureImpl)futures.get(replica2);
                            if (future == null) {
                                KafkaAdminClient.this.log.warn("The partition {} in the response from broker {} is not in the request", (Object)new TopicPartition(topicResult.topicName(), partitionResult.partitionIndex()), (Object)brokerId);
                                continue;
                            }
                            if (partitionResult.errorCode() == Errors.NONE.code()) {
                                future.complete(null);
                                continue;
                            }
                            future.completeExceptionally(Errors.forCode(partitionResult.errorCode()).exception());
                        }
                    }
                    KafkaAdminClient.completeUnrealizedFutures(futures.entrySet().stream().filter(entry -> ((TopicPartitionReplica)entry.getKey()).brokerId() == brokerId), replica -> "The response from broker " + brokerId + " did not contain a result for replica " + replica);
                }

                @Override
                void handleFailure(Throwable throwable) {
                    KafkaAdminClient.completeAllExceptionally(futures.entrySet().stream().filter(entry -> ((TopicPartitionReplica)entry.getKey()).brokerId() == brokerId).map(Map.Entry::getValue), throwable);
                }
            }, l);
        }
        return new AlterReplicaLogDirsResult(new HashMap<TopicPartitionReplica, KafkaFuture<Void>>(futures));
    }

    @Override
    public DescribeLogDirsResult describeLogDirs(Collection<Integer> brokers, DescribeLogDirsOptions options) {
        HashMap futures = new HashMap(brokers.size());
        long now = this.time.milliseconds();
        for (Integer brokerId : brokers) {
            final KafkaFutureImpl future = new KafkaFutureImpl();
            futures.put(brokerId, future);
            this.runnable.call(new Call("describeLogDirs", this.calcDeadlineMs(now, options.timeoutMs()), new ConstantNodeIdProvider(brokerId)){

                @Override
                public DescribeLogDirsRequest.Builder createRequest(int timeoutMs) {
                    return new DescribeLogDirsRequest.Builder(new DescribeLogDirsRequestData().setTopics(null));
                }

                @Override
                public void handleResponse(AbstractResponse abstractResponse) {
                    DescribeLogDirsResponse response = (DescribeLogDirsResponse)abstractResponse;
                    Map descriptions = KafkaAdminClient.logDirDescriptions(response);
                    if (descriptions.size() > 0) {
                        future.complete(descriptions);
                    } else {
                        future.completeExceptionally(Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
                    }
                }

                @Override
                void handleFailure(Throwable throwable) {
                    future.completeExceptionally(throwable);
                }
            }, now);
        }
        return new DescribeLogDirsResult(new HashMap<Integer, KafkaFuture<Map<String, LogDirDescription>>>(futures));
    }

    private static Map<String, LogDirDescription> logDirDescriptions(DescribeLogDirsResponse response) {
        HashMap<String, LogDirDescription> result = new HashMap<String, LogDirDescription>(response.data().results().size());
        for (DescribeLogDirsResponseData.DescribeLogDirsResult logDirResult : response.data().results()) {
            HashMap<TopicPartition, ReplicaInfo> replicaInfoMap = new HashMap<TopicPartition, ReplicaInfo>();
            for (DescribeLogDirsResponseData.DescribeLogDirsTopic t : logDirResult.topics()) {
                for (DescribeLogDirsResponseData.DescribeLogDirsPartition p : t.partitions()) {
                    replicaInfoMap.put(new TopicPartition(t.name(), p.partitionIndex()), new ReplicaInfo(p.partitionSize(), p.offsetLag(), p.isFutureKey()));
                }
            }
            result.put(logDirResult.logDir(), new LogDirDescription(Errors.forCode(logDirResult.errorCode()).exception(), replicaInfoMap));
        }
        return result;
    }

    @Override
    public DescribeReplicaLogDirsResult describeReplicaLogDirs(Collection<TopicPartitionReplica> replicas, DescribeReplicaLogDirsOptions options) {
        final HashMap futures = new HashMap(replicas.size());
        for (TopicPartitionReplica topicPartitionReplica : replicas) {
            futures.put(topicPartitionReplica, new KafkaFutureImpl());
        }
        HashMap<Integer, DescribeLogDirsRequestData> partitionsByBroker = new HashMap<Integer, DescribeLogDirsRequestData>();
        for (TopicPartitionReplica replica : replicas) {
            DescribeLogDirsRequestData requestData = partitionsByBroker.computeIfAbsent(replica.brokerId(), brokerId -> new DescribeLogDirsRequestData());
            DescribeLogDirsRequestData.DescribableLogDirTopic describableLogDirTopic = requestData.topics().find(replica.topic());
            if (describableLogDirTopic == null) {
                ArrayList<Integer> partitionIndex = new ArrayList<Integer>();
                partitionIndex.add(replica.partition());
                describableLogDirTopic = new DescribeLogDirsRequestData.DescribableLogDirTopic().setTopic(replica.topic()).setPartitionIndex(partitionIndex);
                requestData.topics().add(describableLogDirTopic);
                continue;
            }
            describableLogDirTopic.partitionIndex().add(replica.partition());
        }
        long l = this.time.milliseconds();
        for (Map.Entry entry : partitionsByBroker.entrySet()) {
            final int brokerId2 = (Integer)entry.getKey();
            final DescribeLogDirsRequestData topicPartitions = (DescribeLogDirsRequestData)entry.getValue();
            final HashMap<TopicPartition, DescribeReplicaLogDirsResult.ReplicaLogDirInfo> replicaDirInfoByPartition = new HashMap<TopicPartition, DescribeReplicaLogDirsResult.ReplicaLogDirInfo>();
            for (DescribeLogDirsRequestData.DescribableLogDirTopic topicPartition : topicPartitions.topics()) {
                for (Integer partitionId : topicPartition.partitionIndex()) {
                    replicaDirInfoByPartition.put(new TopicPartition(topicPartition.topic(), partitionId), new DescribeReplicaLogDirsResult.ReplicaLogDirInfo());
                }
            }
            this.runnable.call(new Call("describeReplicaLogDirs", this.calcDeadlineMs(l, options.timeoutMs()), new ConstantNodeIdProvider(brokerId2)){

                @Override
                public DescribeLogDirsRequest.Builder createRequest(int timeoutMs) {
                    return new DescribeLogDirsRequest.Builder(topicPartitions);
                }

                @Override
                public void handleResponse(AbstractResponse abstractResponse) {
                    DescribeLogDirsResponse response = (DescribeLogDirsResponse)abstractResponse;
                    for (Map.Entry responseEntry : KafkaAdminClient.logDirDescriptions(response).entrySet()) {
                        String logDir = (String)responseEntry.getKey();
                        LogDirDescription logDirInfo = (LogDirDescription)responseEntry.getValue();
                        if (logDirInfo.error() instanceof KafkaStorageException) continue;
                        if (logDirInfo.error() != null) {
                            this.handleFailure(new IllegalStateException("The error " + logDirInfo.error().getClass().getName() + " for log directory " + logDir + " in the response from broker " + brokerId2 + " is illegal"));
                        }
                        for (Map.Entry<TopicPartition, ReplicaInfo> replicaInfoEntry : logDirInfo.replicaInfos().entrySet()) {
                            TopicPartition tp = replicaInfoEntry.getKey();
                            ReplicaInfo replicaInfo = replicaInfoEntry.getValue();
                            DescribeReplicaLogDirsResult.ReplicaLogDirInfo replicaLogDirInfo = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)replicaDirInfoByPartition.get(tp);
                            if (replicaLogDirInfo == null) {
                                KafkaAdminClient.this.log.warn("Server response from broker {} mentioned unknown partition {}", (Object)brokerId2, (Object)tp);
                                continue;
                            }
                            if (replicaInfo.isFuture()) {
                                replicaDirInfoByPartition.put(tp, new DescribeReplicaLogDirsResult.ReplicaLogDirInfo(replicaLogDirInfo.getCurrentReplicaLogDir(), replicaLogDirInfo.getCurrentReplicaOffsetLag(), logDir, replicaInfo.offsetLag()));
                                continue;
                            }
                            replicaDirInfoByPartition.put(tp, new DescribeReplicaLogDirsResult.ReplicaLogDirInfo(logDir, replicaInfo.offsetLag(), replicaLogDirInfo.getFutureReplicaLogDir(), replicaLogDirInfo.getFutureReplicaOffsetLag()));
                        }
                    }
                    for (Map.Entry entry : replicaDirInfoByPartition.entrySet()) {
                        TopicPartition tp = (TopicPartition)entry.getKey();
                        KafkaFutureImpl future = (KafkaFutureImpl)futures.get(new TopicPartitionReplica(tp.topic(), tp.partition(), brokerId2));
                        future.complete(entry.getValue());
                    }
                }

                @Override
                void handleFailure(Throwable throwable) {
                    KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
                }
            }, l);
        }
        return new DescribeReplicaLogDirsResult(new HashMap<TopicPartitionReplica, KafkaFuture<DescribeReplicaLogDirsResult.ReplicaLogDirInfo>>(futures));
    }

    @Override
    public CreatePartitionsResult createPartitions(Map<String, NewPartitions> newPartitions, CreatePartitionsOptions options) {
        HashMap<String, KafkaFutureImpl<Void>> futures = new HashMap<String, KafkaFutureImpl<Void>>(newPartitions.size());
        CreatePartitionsRequestData.CreatePartitionsTopicCollection topics = new CreatePartitionsRequestData.CreatePartitionsTopicCollection(newPartitions.size());
        for (Map.Entry<String, NewPartitions> entry : newPartitions.entrySet()) {
            String topic = entry.getKey();
            NewPartitions newPartition = entry.getValue();
            List<List<Integer>> newAssignments = newPartition.assignments();
            List<CreatePartitionsRequestData.CreatePartitionsAssignment> assignments = newAssignments == null ? null : newAssignments.stream().map(brokerIds -> new CreatePartitionsRequestData.CreatePartitionsAssignment().setBrokerIds((List<Integer>)brokerIds)).collect(Collectors.toList());
            topics.add(new CreatePartitionsRequestData.CreatePartitionsTopic().setName(topic).setCount(newPartition.totalCount()).setAssignments(assignments));
            futures.put(topic, new KafkaFutureImpl());
        }
        if (!topics.isEmpty()) {
            long now = this.time.milliseconds();
            long deadline = this.calcDeadlineMs(now, options.timeoutMs());
            Call call = this.getCreatePartitionsCall(options, futures, topics, Collections.emptyMap(), now, deadline);
            this.runnable.call(call, now);
        }
        return new CreatePartitionsResult(new HashMap<String, KafkaFuture<Void>>(futures));
    }

    private Call getCreatePartitionsCall(final CreatePartitionsOptions options, final Map<String, KafkaFutureImpl<Void>> futures, final CreatePartitionsRequestData.CreatePartitionsTopicCollection topics, final Map<String, ThrottlingQuotaExceededException> quotaExceededExceptions, final long now, final long deadline) {
        return new Call("createPartitions", deadline, new ControllerNodeProvider()){

            @Override
            public CreatePartitionsRequest.Builder createRequest(int timeoutMs) {
                return new CreatePartitionsRequest.Builder(new CreatePartitionsRequestData().setTopics(topics).setValidateOnly(options.validateOnly()).setTimeoutMs(timeoutMs));
            }

            @Override
            public void handleResponse(AbstractResponse abstractResponse) {
                KafkaAdminClient.this.handleNotControllerError(abstractResponse);
                CreatePartitionsResponse response = (CreatePartitionsResponse)abstractResponse;
                CreatePartitionsRequestData.CreatePartitionsTopicCollection retryTopics = new CreatePartitionsRequestData.CreatePartitionsTopicCollection();
                HashMap<String, ThrottlingQuotaExceededException> retryTopicQuotaExceededExceptions = new HashMap<String, ThrottlingQuotaExceededException>();
                for (CreatePartitionsResponseData.CreatePartitionsTopicResult result : response.data().results()) {
                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(result.name());
                    if (future == null) {
                        KafkaAdminClient.this.log.warn("Server response mentioned unknown topic {}", (Object)result.name());
                        continue;
                    }
                    ApiError error = new ApiError(result.errorCode(), result.errorMessage());
                    if (error.isFailure()) {
                        if (error.is(Errors.THROTTLING_QUOTA_EXCEEDED)) {
                            ThrottlingQuotaExceededException quotaExceededException = new ThrottlingQuotaExceededException(response.throttleTimeMs(), error.messageWithFallback());
                            if (options.shouldRetryOnQuotaViolation()) {
                                retryTopics.add(topics.find(result.name()).duplicate());
                                retryTopicQuotaExceededExceptions.put(result.name(), quotaExceededException);
                                continue;
                            }
                            future.completeExceptionally(quotaExceededException);
                            continue;
                        }
                        future.completeExceptionally(error.exception());
                        continue;
                    }
                    future.complete(null);
                }
                if (retryTopics.isEmpty()) {
                    KafkaAdminClient.completeUnrealizedFutures(futures.entrySet().stream(), topic -> "The controller response did not contain a result for topic " + topic);
                } else {
                    long now2 = KafkaAdminClient.this.time.milliseconds();
                    Call call = KafkaAdminClient.this.getCreatePartitionsCall(options, futures, retryTopics, retryTopicQuotaExceededExceptions, now2, deadline);
                    KafkaAdminClient.this.runnable.call(call, now2);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.maybeCompleteQuotaExceededException(options.shouldRetryOnQuotaViolation(), throwable, futures, quotaExceededExceptions, (int)(KafkaAdminClient.this.time.milliseconds() - now));
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        };
    }

    @Override
    public DeleteRecordsResult deleteRecords(final Map<TopicPartition, RecordsToDelete> recordsToDelete, DeleteRecordsOptions options) {
        final HashMap futures = new HashMap(recordsToDelete.size());
        for (TopicPartition topicPartition : recordsToDelete.keySet()) {
            futures.put(topicPartition, new KafkaFutureImpl());
        }
        final HashSet<String> topics = new HashSet<String>();
        for (TopicPartition topicPartition : recordsToDelete.keySet()) {
            topics.add(topicPartition.topic());
        }
        long l = this.time.milliseconds();
        final long deadline = this.calcDeadlineMs(l, options.timeoutMs());
        this.runnable.call(new Call("topicsMetadata", deadline, new LeastLoadedNodeProvider()){

            @Override
            MetadataRequest.Builder createRequest(int timeoutMs) {
                return new MetadataRequest.Builder(new MetadataRequestData().setTopics(MetadataRequest.convertToMetadataRequestTopic(topics)).setAllowAutoTopicCreation(false));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                MetadataResponse response = (MetadataResponse)abstractResponse;
                Map<String, Errors> errors = response.errors();
                Cluster cluster = response.buildCluster();
                HashMap<Node, Map> leaders = new HashMap<Node, Map>();
                for (Map.Entry entry : recordsToDelete.entrySet()) {
                    TopicPartition topicPartition = (TopicPartition)entry.getKey();
                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(topicPartition);
                    Errors topicError = errors.get(topicPartition.topic());
                    if (errors.containsKey(topicPartition.topic())) {
                        future.completeExceptionally(topicError.exception());
                        continue;
                    }
                    Node node = cluster.leaderFor(topicPartition);
                    if (node != null) {
                        Map deletionsForLeader = leaders.computeIfAbsent(node, key -> new HashMap());
                        DeleteRecordsRequestData.DeleteRecordsTopic deleteRecords = (DeleteRecordsRequestData.DeleteRecordsTopic)deletionsForLeader.get(topicPartition.topic());
                        if (deleteRecords == null) {
                            deleteRecords = new DeleteRecordsRequestData.DeleteRecordsTopic().setName(topicPartition.topic());
                            deletionsForLeader.put(topicPartition.topic(), deleteRecords);
                        }
                        deleteRecords.partitions().add(new DeleteRecordsRequestData.DeleteRecordsPartition().setPartitionIndex(topicPartition.partition()).setOffset(((RecordsToDelete)entry.getValue()).beforeOffset()));
                        continue;
                    }
                    future.completeExceptionally(Errors.LEADER_NOT_AVAILABLE.exception());
                }
                long deleteRecordsCallTimeMs = KafkaAdminClient.this.time.milliseconds();
                for (Map.Entry entry : leaders.entrySet()) {
                    final Map partitionDeleteOffsets = (Map)entry.getValue();
                    int brokerId = ((Node)entry.getKey()).id();
                    KafkaAdminClient.this.runnable.call(new Call("deleteRecords", deadline, new ConstantNodeIdProvider(brokerId)){

                        @Override
                        DeleteRecordsRequest.Builder createRequest(int timeoutMs) {
                            return new DeleteRecordsRequest.Builder(new DeleteRecordsRequestData().setTimeoutMs(timeoutMs).setTopics(new ArrayList<DeleteRecordsRequestData.DeleteRecordsTopic>(partitionDeleteOffsets.values())));
                        }

                        @Override
                        void handleResponse(AbstractResponse abstractResponse) {
                            DeleteRecordsResponse response = (DeleteRecordsResponse)abstractResponse;
                            for (DeleteRecordsResponseData.DeleteRecordsTopicResult topicResult : response.data().topics()) {
                                for (DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult : topicResult.partitions()) {
                                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(new TopicPartition(topicResult.name(), partitionResult.partitionIndex()));
                                    if (partitionResult.errorCode() == Errors.NONE.code()) {
                                        future.complete(new DeletedRecords(partitionResult.lowWatermark()));
                                        continue;
                                    }
                                    future.completeExceptionally(Errors.forCode(partitionResult.errorCode()).exception());
                                }
                            }
                        }

                        @Override
                        void handleFailure(Throwable throwable) {
                            Stream<KafkaFutureImpl> callFutures = partitionDeleteOffsets.values().stream().flatMap(recordsToDelete -> recordsToDelete.partitions().stream().map(partitionsToDelete -> new TopicPartition(recordsToDelete.name(), partitionsToDelete.partitionIndex()))).map(futures::get);
                            KafkaAdminClient.completeAllExceptionally(callFutures, throwable);
                        }
                    }, deleteRecordsCallTimeMs);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        }, l);
        return new DeleteRecordsResult(new HashMap<TopicPartition, KafkaFuture<DeletedRecords>>(futures));
    }

    @Override
    public CreateDelegationTokenResult createDelegationToken(final CreateDelegationTokenOptions options) {
        final KafkaFutureImpl<DelegationToken> delegationTokenFuture = new KafkaFutureImpl<DelegationToken>();
        long now = this.time.milliseconds();
        final ArrayList<CreateDelegationTokenRequestData.CreatableRenewers> renewers = new ArrayList<CreateDelegationTokenRequestData.CreatableRenewers>();
        for (KafkaPrincipal principal : options.renewers()) {
            renewers.add(new CreateDelegationTokenRequestData.CreatableRenewers().setPrincipalName(principal.getName()).setPrincipalType(principal.getPrincipalType()));
        }
        this.runnable.call(new Call("createDelegationToken", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            @Override
            CreateDelegationTokenRequest.Builder createRequest(int timeoutMs) {
                return new CreateDelegationTokenRequest.Builder(new CreateDelegationTokenRequestData().setRenewers(renewers).setMaxLifetimeMs(options.maxlifeTimeMs()));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                CreateDelegationTokenResponse response = (CreateDelegationTokenResponse)abstractResponse;
                if (response.hasError()) {
                    delegationTokenFuture.completeExceptionally(response.error().exception());
                } else {
                    CreateDelegationTokenResponseData data = response.data();
                    TokenInformation tokenInfo = new TokenInformation(data.tokenId(), new KafkaPrincipal(data.principalType(), data.principalName()), options.renewers(), data.issueTimestampMs(), data.maxTimestampMs(), data.expiryTimestampMs());
                    DelegationToken token = new DelegationToken(tokenInfo, data.hmac());
                    delegationTokenFuture.complete(token);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                delegationTokenFuture.completeExceptionally(throwable);
            }
        }, now);
        return new CreateDelegationTokenResult(delegationTokenFuture);
    }

    @Override
    public RenewDelegationTokenResult renewDelegationToken(final byte[] hmac, final RenewDelegationTokenOptions options) {
        final KafkaFutureImpl<Long> expiryTimeFuture = new KafkaFutureImpl<Long>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("renewDelegationToken", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            @Override
            RenewDelegationTokenRequest.Builder createRequest(int timeoutMs) {
                return new RenewDelegationTokenRequest.Builder(new RenewDelegationTokenRequestData().setHmac(hmac).setRenewPeriodMs(options.renewTimePeriodMs()));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                RenewDelegationTokenResponse response = (RenewDelegationTokenResponse)abstractResponse;
                if (response.hasError()) {
                    expiryTimeFuture.completeExceptionally(response.error().exception());
                } else {
                    expiryTimeFuture.complete(response.expiryTimestamp());
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                expiryTimeFuture.completeExceptionally(throwable);
            }
        }, now);
        return new RenewDelegationTokenResult(expiryTimeFuture);
    }

    @Override
    public ExpireDelegationTokenResult expireDelegationToken(final byte[] hmac, final ExpireDelegationTokenOptions options) {
        final KafkaFutureImpl<Long> expiryTimeFuture = new KafkaFutureImpl<Long>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("expireDelegationToken", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            @Override
            ExpireDelegationTokenRequest.Builder createRequest(int timeoutMs) {
                return new ExpireDelegationTokenRequest.Builder(new ExpireDelegationTokenRequestData().setHmac(hmac).setExpiryTimePeriodMs(options.expiryTimePeriodMs()));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                ExpireDelegationTokenResponse response = (ExpireDelegationTokenResponse)abstractResponse;
                if (response.hasError()) {
                    expiryTimeFuture.completeExceptionally(response.error().exception());
                } else {
                    expiryTimeFuture.complete(response.expiryTimestamp());
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                expiryTimeFuture.completeExceptionally(throwable);
            }
        }, now);
        return new ExpireDelegationTokenResult(expiryTimeFuture);
    }

    @Override
    public DescribeDelegationTokenResult describeDelegationToken(final DescribeDelegationTokenOptions options) {
        final KafkaFutureImpl<List<DelegationToken>> tokensFuture = new KafkaFutureImpl<List<DelegationToken>>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("describeDelegationToken", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            @Override
            DescribeDelegationTokenRequest.Builder createRequest(int timeoutMs) {
                return new DescribeDelegationTokenRequest.Builder(options.owners());
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeDelegationTokenResponse response = (DescribeDelegationTokenResponse)abstractResponse;
                if (response.hasError()) {
                    tokensFuture.completeExceptionally(response.error().exception());
                } else {
                    tokensFuture.complete(response.tokens());
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                tokensFuture.completeExceptionally(throwable);
            }
        }, now);
        return new DescribeDelegationTokenResult(tokensFuture);
    }

    private void rescheduleFindCoordinatorTask(ConsumerGroupOperationContext<?, ?> context, Supplier<Call> nextCall, Call failedCall) {
        this.log.info("Node {} is no longer the Coordinator. Retrying with new coordinator.", context.node().orElse(null));
        context.setNode(null);
        Call call = nextCall.get();
        call.tries = failedCall.tries + 1;
        call.nextAllowedTryMs = this.calculateNextAllowedRetryMs();
        Call findCoordinatorCall = this.getFindCoordinatorCall(context, nextCall);
        this.runnable.call(findCoordinatorCall, this.time.milliseconds());
    }

    private void rescheduleMetadataTask(MetadataOperationContext<?, ?> context, Supplier<List<Call>> nextCalls) {
        this.log.info("Retrying to fetch metadata.");
        context.setResponse(Optional.empty());
        Call metadataCall = this.getMetadataCall(context, nextCalls);
        this.runnable.call(metadataCall, this.time.milliseconds());
    }

    private static <T> Map<String, KafkaFutureImpl<T>> createFutures(Collection<String> groupIds) {
        return new HashSet<String>(groupIds).stream().collect(Collectors.toMap(groupId -> groupId, groupId -> {
            if (KafkaAdminClient.groupIdIsUnrepresentable(groupId)) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally(new InvalidGroupIdException("The given group id '" + groupId + "' cannot be represented in a request."));
                return future;
            }
            return new KafkaFutureImpl();
        }));
    }

    @Override
    public DescribeConsumerGroupsResult describeConsumerGroups(Collection<String> groupIds, DescribeConsumerGroupsOptions options) {
        Map futures = KafkaAdminClient.createFutures(groupIds);
        for (Map.Entry entry : futures.entrySet()) {
            if (entry.getValue().isCompletedExceptionally()) continue;
            String groupId = entry.getKey();
            long startFindCoordinatorMs = this.time.milliseconds();
            long deadline = this.calcDeadlineMs(startFindCoordinatorMs, options.timeoutMs());
            ConsumerGroupOperationContext context = new ConsumerGroupOperationContext(groupId, options, deadline, futures.get(groupId));
            Call findCoordinatorCall = this.getFindCoordinatorCall(context, () -> this.getDescribeConsumerGroupsCall(context));
            this.runnable.call(findCoordinatorCall, startFindCoordinatorMs);
        }
        return new DescribeConsumerGroupsResult(new HashMap<String, KafkaFuture<ConsumerGroupDescription>>(futures));
    }

    private <T, O extends AbstractOptions<O>> Call getFindCoordinatorCall(final ConsumerGroupOperationContext<T, O> context, final Supplier<Call> nextCall) {
        return new Call("findCoordinator", context.deadline(), new LeastLoadedNodeProvider()){

            @Override
            FindCoordinatorRequest.Builder createRequest(int timeoutMs) {
                return new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.GROUP.id()).setKey(context.groupId()));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                FindCoordinatorResponse response = (FindCoordinatorResponse)abstractResponse;
                if (KafkaAdminClient.this.handleGroupRequestError(response.error(), context.future())) {
                    return;
                }
                context.setNode(response.node());
                KafkaAdminClient.this.runnable.call((Call)nextCall.get(), KafkaAdminClient.this.time.milliseconds());
            }

            @Override
            void handleFailure(Throwable throwable) {
                context.future().completeExceptionally(throwable);
            }
        };
    }

    private Call getDescribeConsumerGroupsCall(final ConsumerGroupOperationContext<ConsumerGroupDescription, DescribeConsumerGroupsOptions> context) {
        return new Call("describeConsumerGroups", context.deadline(), new ConstantNodeIdProvider(context.node().get().id())){

            @Override
            DescribeGroupsRequest.Builder createRequest(int timeoutMs) {
                return new DescribeGroupsRequest.Builder(new DescribeGroupsRequestData().setGroups(Collections.singletonList(context.groupId())).setIncludeAuthorizedOperations(((DescribeConsumerGroupsOptions)context.options()).includeAuthorizedOperations()));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeGroupsResponse response = (DescribeGroupsResponse)abstractResponse;
                List<DescribeGroupsResponseData.DescribedGroup> describedGroups = response.data().groups();
                if (describedGroups.isEmpty()) {
                    context.future().completeExceptionally(new InvalidGroupIdException("No consumer group found for GroupId: " + context.groupId()));
                    return;
                }
                if (describedGroups.size() > 1 || !describedGroups.get(0).groupId().equals(context.groupId())) {
                    String ids = Arrays.toString(describedGroups.stream().map(DescribeGroupsResponseData.DescribedGroup::groupId).toArray());
                    context.future().completeExceptionally(new InvalidGroupIdException("DescribeConsumerGroup request for GroupId: " + context.groupId() + " returned " + ids));
                    return;
                }
                DescribeGroupsResponseData.DescribedGroup describedGroup = describedGroups.get(0);
                if (ConsumerGroupOperationContext.hasCoordinatorMoved(response)) {
                    Call call = KafkaAdminClient.this.getDescribeConsumerGroupsCall(context);
                    KafkaAdminClient.this.rescheduleFindCoordinatorTask(context, () -> call, this);
                    return;
                }
                Errors groupError = Errors.forCode(describedGroup.errorCode());
                if (KafkaAdminClient.this.handleGroupRequestError(groupError, context.future())) {
                    return;
                }
                String protocolType = describedGroup.protocolType();
                if (protocolType.equals("consumer") || protocolType.isEmpty()) {
                    List<DescribeGroupsResponseData.DescribedGroupMember> members = describedGroup.members();
                    ArrayList<MemberDescription> memberDescriptions = new ArrayList<MemberDescription>(members.size());
                    Set authorizedOperations = KafkaAdminClient.this.validAclOperations(describedGroup.authorizedOperations());
                    for (DescribeGroupsResponseData.DescribedGroupMember groupMember : members) {
                        Set<TopicPartition> partitions = Collections.emptySet();
                        if (groupMember.memberAssignment().length > 0) {
                            ConsumerPartitionAssignor.Assignment assignment = ConsumerProtocol.deserializeAssignment(ByteBuffer.wrap(groupMember.memberAssignment()));
                            partitions = new HashSet<TopicPartition>(assignment.partitions());
                        }
                        MemberDescription memberDescription = new MemberDescription(groupMember.memberId(), Optional.ofNullable(groupMember.groupInstanceId()), groupMember.clientId(), groupMember.clientHost(), new MemberAssignment(partitions));
                        memberDescriptions.add(memberDescription);
                    }
                    ConsumerGroupDescription consumerGroupDescription = new ConsumerGroupDescription(context.groupId(), protocolType.isEmpty(), memberDescriptions, describedGroup.protocolData(), ConsumerGroupState.parse(describedGroup.groupState()), context.node().get(), authorizedOperations);
                    context.future().complete(consumerGroupDescription);
                } else {
                    context.future().completeExceptionally(new IllegalArgumentException(String.format("GroupId %s is not a consumer group (%s).", context.groupId(), protocolType)));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                context.future().completeExceptionally(throwable);
            }
        };
    }

    private <T, O extends AbstractOptions<O>> Call getMetadataCall(final MetadataOperationContext<T, O> context, final Supplier<List<Call>> nextCalls) {
        return new Call("metadata", context.deadline(), new LeastLoadedNodeProvider()){

            @Override
            MetadataRequest.Builder createRequest(int timeoutMs) {
                return new MetadataRequest.Builder(new MetadataRequestData().setTopics(MetadataRequest.convertToMetadataRequestTopic(context.topics())).setAllowAutoTopicCreation(false));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                MetadataResponse response = (MetadataResponse)abstractResponse;
                MetadataOperationContext.handleMetadataErrors(response);
                context.setResponse(Optional.of(response));
                for (Call call : (List)nextCalls.get()) {
                    KafkaAdminClient.this.runnable.call(call, KafkaAdminClient.this.time.milliseconds());
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                for (KafkaFutureImpl future : context.futures().values()) {
                    future.completeExceptionally(throwable);
                }
            }
        };
    }

    private Set<AclOperation> validAclOperations(int authorizedOperations) {
        if (authorizedOperations == Integer.MIN_VALUE) {
            return null;
        }
        return Utils.from32BitField(authorizedOperations).stream().map(AclOperation::fromCode).filter(operation -> operation != AclOperation.UNKNOWN && operation != AclOperation.ALL && operation != AclOperation.ANY).collect(Collectors.toSet());
    }

    private boolean handleGroupRequestError(Errors error, KafkaFutureImpl<?> future) {
        if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS || error == Errors.COORDINATOR_NOT_AVAILABLE) {
            throw error.exception();
        }
        if (error != Errors.NONE) {
            future.completeExceptionally(error.exception());
            return true;
        }
        return false;
    }

    @Override
    public ListConsumerGroupsResult listConsumerGroups(final ListConsumerGroupsOptions options) {
        final KafkaFutureImpl<Collection<Object>> all = new KafkaFutureImpl<Collection<Object>>();
        long nowMetadata = this.time.milliseconds();
        final long deadline = this.calcDeadlineMs(nowMetadata, options.timeoutMs());
        this.runnable.call(new Call("findAllBrokers", deadline, new LeastLoadedNodeProvider()){

            @Override
            MetadataRequest.Builder createRequest(int timeoutMs) {
                return new MetadataRequest.Builder(new MetadataRequestData().setTopics(Collections.emptyList()).setAllowAutoTopicCreation(true));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                MetadataResponse metadataResponse = (MetadataResponse)abstractResponse;
                Collection<Node> nodes = metadataResponse.brokers();
                if (nodes.isEmpty()) {
                    throw new StaleMetadataException("Metadata fetch failed due to missing broker list");
                }
                HashSet<Node> allNodes = new HashSet<Node>(nodes);
                final ListConsumerGroupsResults results = new ListConsumerGroupsResults(allNodes, all);
                for (final Node node : allNodes) {
                    long nowList = KafkaAdminClient.this.time.milliseconds();
                    KafkaAdminClient.this.runnable.call(new Call("listConsumerGroups", deadline, new ConstantNodeIdProvider(node.id())){

                        @Override
                        ListGroupsRequest.Builder createRequest(int timeoutMs) {
                            List<String> states = options.states().stream().map(s -> s.toString()).collect(Collectors.toList());
                            return new ListGroupsRequest.Builder(new ListGroupsRequestData().setStatesFilter(states));
                        }

                        private void maybeAddConsumerGroup(ListGroupsResponseData.ListedGroup group) {
                            String protocolType = group.protocolType();
                            if (protocolType.equals("consumer") || protocolType.isEmpty()) {
                                String groupId = group.groupId();
                                Optional<ConsumerGroupState> state = group.groupState().equals("") ? Optional.empty() : Optional.of(ConsumerGroupState.parse(group.groupState()));
                                ConsumerGroupListing groupListing = new ConsumerGroupListing(groupId, protocolType.isEmpty(), state);
                                results.addListing(groupListing);
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        void handleResponse(AbstractResponse abstractResponse) {
                            ListGroupsResponse response = (ListGroupsResponse)abstractResponse;
                            ListConsumerGroupsResults listConsumerGroupsResults = results;
                            synchronized (listConsumerGroupsResults) {
                                Errors error = Errors.forCode(response.data().errorCode());
                                if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS || error == Errors.COORDINATOR_NOT_AVAILABLE) {
                                    throw error.exception();
                                }
                                if (error != Errors.NONE) {
                                    results.addError(error.exception(), node);
                                } else {
                                    for (ListGroupsResponseData.ListedGroup group : response.data().groups()) {
                                        this.maybeAddConsumerGroup(group);
                                    }
                                }
                                results.tryComplete(node);
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        void handleFailure(Throwable throwable) {
                            ListConsumerGroupsResults listConsumerGroupsResults = results;
                            synchronized (listConsumerGroupsResults) {
                                results.addError(throwable, node);
                                results.tryComplete(node);
                            }
                        }
                    }, nowList);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaException exception = new KafkaException("Failed to find brokers to send ListGroups", throwable);
                all.complete(Collections.singletonList(exception));
            }
        }, nowMetadata);
        return new ListConsumerGroupsResult(all);
    }

    @Override
    public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(String groupId, ListConsumerGroupOffsetsOptions options) {
        KafkaFutureImpl<Map<TopicPartition, OffsetAndMetadata>> groupOffsetListingFuture = new KafkaFutureImpl<Map<TopicPartition, OffsetAndMetadata>>();
        long startFindCoordinatorMs = this.time.milliseconds();
        long deadline = this.calcDeadlineMs(startFindCoordinatorMs, options.timeoutMs());
        ConsumerGroupOperationContext context = new ConsumerGroupOperationContext(groupId, options, deadline, groupOffsetListingFuture);
        Call findCoordinatorCall = this.getFindCoordinatorCall(context, () -> this.getListConsumerGroupOffsetsCall(context));
        this.runnable.call(findCoordinatorCall, startFindCoordinatorMs);
        return new ListConsumerGroupOffsetsResult(groupOffsetListingFuture);
    }

    private Call getListConsumerGroupOffsetsCall(final ConsumerGroupOperationContext<Map<TopicPartition, OffsetAndMetadata>, ListConsumerGroupOffsetsOptions> context) {
        return new Call("listConsumerGroupOffsets", context.deadline(), new ConstantNodeIdProvider(context.node().get().id())){

            @Override
            OffsetFetchRequest.Builder createRequest(int timeoutMs) {
                return new OffsetFetchRequest.Builder(context.groupId(), false, ((ListConsumerGroupOffsetsOptions)context.options()).topicPartitions(), false);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                OffsetFetchResponse response = (OffsetFetchResponse)abstractResponse;
                HashMap<TopicPartition, OffsetAndMetadata> groupOffsetsListing = new HashMap<TopicPartition, OffsetAndMetadata>();
                if (ConsumerGroupOperationContext.hasCoordinatorMoved(response)) {
                    Call call = KafkaAdminClient.this.getListConsumerGroupOffsetsCall(context);
                    KafkaAdminClient.this.rescheduleFindCoordinatorTask(context, () -> call, this);
                    return;
                }
                if (KafkaAdminClient.this.handleGroupRequestError(response.error(), context.future())) {
                    return;
                }
                for (Map.Entry<TopicPartition, OffsetFetchResponse.PartitionData> entry : response.responseData().entrySet()) {
                    TopicPartition topicPartition = entry.getKey();
                    OffsetFetchResponse.PartitionData partitionData = entry.getValue();
                    Errors error = partitionData.error;
                    if (error == Errors.NONE) {
                        Long offset = partitionData.offset;
                        String metadata = partitionData.metadata;
                        Optional<Integer> leaderEpoch = partitionData.leaderEpoch;
                        if (offset < 0L) {
                            groupOffsetsListing.put(topicPartition, null);
                            continue;
                        }
                        groupOffsetsListing.put(topicPartition, new OffsetAndMetadata(offset, leaderEpoch, metadata));
                        continue;
                    }
                    KafkaAdminClient.this.log.warn("Skipping return offset for {} due to error {}.", (Object)topicPartition, (Object)error);
                }
                context.future().complete(groupOffsetsListing);
            }

            @Override
            void handleFailure(Throwable throwable) {
                context.future().completeExceptionally(throwable);
            }
        };
    }

    @Override
    public DeleteConsumerGroupsResult deleteConsumerGroups(Collection<String> groupIds, DeleteConsumerGroupsOptions options) {
        Map futures = KafkaAdminClient.createFutures(groupIds);
        for (String groupId : groupIds) {
            KafkaFutureImpl future = futures.get(groupId);
            if (future.isCompletedExceptionally()) continue;
            long startFindCoordinatorMs = this.time.milliseconds();
            long deadline = this.calcDeadlineMs(startFindCoordinatorMs, options.timeoutMs());
            ConsumerGroupOperationContext context = new ConsumerGroupOperationContext(groupId, options, deadline, future);
            Call findCoordinatorCall = this.getFindCoordinatorCall(context, () -> this.getDeleteConsumerGroupsCall(context));
            this.runnable.call(findCoordinatorCall, startFindCoordinatorMs);
        }
        return new DeleteConsumerGroupsResult(new HashMap<String, KafkaFuture<Void>>(futures));
    }

    private Call getDeleteConsumerGroupsCall(final ConsumerGroupOperationContext<Void, DeleteConsumerGroupsOptions> context) {
        return new Call("deleteConsumerGroups", context.deadline(), new ConstantNodeIdProvider(context.node().get().id())){

            @Override
            DeleteGroupsRequest.Builder createRequest(int timeoutMs) {
                return new DeleteGroupsRequest.Builder(new DeleteGroupsRequestData().setGroupsNames(Collections.singletonList(context.groupId())));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DeleteGroupsResponse response = (DeleteGroupsResponse)abstractResponse;
                if (ConsumerGroupOperationContext.hasCoordinatorMoved(response)) {
                    Call call = KafkaAdminClient.this.getDeleteConsumerGroupsCall(context);
                    KafkaAdminClient.this.rescheduleFindCoordinatorTask(context, () -> call, this);
                    return;
                }
                Errors groupError = response.get(context.groupId());
                if (KafkaAdminClient.this.handleGroupRequestError(groupError, context.future())) {
                    return;
                }
                context.future().complete(null);
            }

            @Override
            void handleFailure(Throwable throwable) {
                context.future().completeExceptionally(throwable);
            }
        };
    }

    @Override
    public DeleteConsumerGroupOffsetsResult deleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions, DeleteConsumerGroupOffsetsOptions options) {
        KafkaFutureImpl<Map<TopicPartition, Errors>> future = new KafkaFutureImpl<Map<TopicPartition, Errors>>();
        if (KafkaAdminClient.groupIdIsUnrepresentable(groupId)) {
            future.completeExceptionally(new InvalidGroupIdException("The given group id '" + groupId + "' cannot be represented in a request."));
            return new DeleteConsumerGroupOffsetsResult(future, partitions);
        }
        long startFindCoordinatorMs = this.time.milliseconds();
        long deadline = this.calcDeadlineMs(startFindCoordinatorMs, options.timeoutMs());
        ConsumerGroupOperationContext context = new ConsumerGroupOperationContext(groupId, options, deadline, future);
        Call findCoordinatorCall = this.getFindCoordinatorCall(context, () -> this.getDeleteConsumerGroupOffsetsCall(context, partitions));
        this.runnable.call(findCoordinatorCall, startFindCoordinatorMs);
        return new DeleteConsumerGroupOffsetsResult(future, partitions);
    }

    private Call getDeleteConsumerGroupOffsetsCall(final ConsumerGroupOperationContext<Map<TopicPartition, Errors>, DeleteConsumerGroupOffsetsOptions> context, final Set<TopicPartition> partitions) {
        return new Call("deleteConsumerGroupOffsets", context.deadline(), new ConstantNodeIdProvider(context.node().get().id())){

            @Override
            OffsetDeleteRequest.Builder createRequest(int timeoutMs) {
                OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection topics = new OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection();
                partitions.stream().collect(Collectors.groupingBy(TopicPartition::topic)).forEach((topic, topicPartitions) -> topics.add(new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName((String)topic).setPartitions(topicPartitions.stream().map(tp -> new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(tp.partition())).collect(Collectors.toList()))));
                return new OffsetDeleteRequest.Builder(new OffsetDeleteRequestData().setGroupId(context.groupId()).setTopics(topics));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                OffsetDeleteResponse response = (OffsetDeleteResponse)abstractResponse;
                if (ConsumerGroupOperationContext.hasCoordinatorMoved(response)) {
                    Call call = KafkaAdminClient.this.getDeleteConsumerGroupOffsetsCall(context, partitions);
                    KafkaAdminClient.this.rescheduleFindCoordinatorTask(context, () -> call, this);
                    return;
                }
                Errors groupError = Errors.forCode(response.data().errorCode());
                if (KafkaAdminClient.this.handleGroupRequestError(groupError, context.future())) {
                    return;
                }
                HashMap partitions2 = new HashMap();
                response.data().topics().forEach(topic -> topic.partitions().forEach(partition -> partitions2.put(new TopicPartition(topic.name(), partition.partitionIndex()), Errors.forCode(partition.errorCode()))));
                context.future().complete(partitions2);
            }

            @Override
            void handleFailure(Throwable throwable) {
                context.future().completeExceptionally(throwable);
            }
        };
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() {
        return Collections.unmodifiableMap(this.metrics.metrics());
    }

    @Override
    public ElectLeadersResult electLeaders(final ElectionType electionType, final Set<TopicPartition> topicPartitions, ElectLeadersOptions options) {
        final KafkaFutureImpl<Map<TopicPartition, Optional<Throwable>>> electionFuture = new KafkaFutureImpl<Map<TopicPartition, Optional<Throwable>>>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("electLeaders", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            @Override
            public ElectLeadersRequest.Builder createRequest(int timeoutMs) {
                return new ElectLeadersRequest.Builder(electionType, topicPartitions, timeoutMs);
            }

            @Override
            public void handleResponse(AbstractResponse abstractResponse) {
                ElectLeadersResponse response = (ElectLeadersResponse)abstractResponse;
                Map<TopicPartition, Optional<Throwable>> result = ElectLeadersResponse.electLeadersResult(response.data());
                Errors error = Errors.forCode(response.data().errorCode());
                if (error != Errors.NONE) {
                    electionFuture.completeExceptionally(error.exception());
                    return;
                }
                electionFuture.complete(result);
            }

            @Override
            void handleFailure(Throwable throwable) {
                electionFuture.completeExceptionally(throwable);
            }
        }, now);
        return new ElectLeadersResult(electionFuture);
    }

    @Override
    public AlterPartitionReassignmentsResult alterPartitionReassignments(Map<TopicPartition, Optional<NewPartitionReassignment>> reassignments, AlterPartitionReassignmentsOptions options) {
        final HashMap futures = new HashMap();
        final TreeMap<String, TreeMap<Integer, Optional<NewPartitionReassignment>>> topicsToReassignments = new TreeMap<String, TreeMap<Integer, Optional<NewPartitionReassignment>>>();
        for (Map.Entry<TopicPartition, Optional<NewPartitionReassignment>> entry : reassignments.entrySet()) {
            String topic = entry.getKey().topic();
            int partition = entry.getKey().partition();
            TopicPartition topicPartition = new TopicPartition(topic, partition);
            Optional<NewPartitionReassignment> reassignment = entry.getValue();
            KafkaFutureImpl future = new KafkaFutureImpl();
            futures.put(topicPartition, future);
            if (KafkaAdminClient.topicNameIsUnrepresentable(topic)) {
                future.completeExceptionally(new InvalidTopicException("The given topic name '" + topic + "' cannot be represented in a request."));
                continue;
            }
            if (topicPartition.partition() < 0) {
                future.completeExceptionally(new InvalidTopicException("The given partition index " + topicPartition.partition() + " is not valid."));
                continue;
            }
            TreeMap<Integer, Optional<NewPartitionReassignment>> partitionReassignments = (TreeMap<Integer, Optional<NewPartitionReassignment>>)topicsToReassignments.get(topicPartition.topic());
            if (partitionReassignments == null) {
                partitionReassignments = new TreeMap<Integer, Optional<NewPartitionReassignment>>();
                topicsToReassignments.put(topic, partitionReassignments);
            }
            partitionReassignments.put(partition, reassignment);
        }
        long now = this.time.milliseconds();
        Call call = new Call("alterPartitionReassignments", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            @Override
            public AlterPartitionReassignmentsRequest.Builder createRequest(int timeoutMs) {
                AlterPartitionReassignmentsRequestData data = new AlterPartitionReassignmentsRequestData();
                for (Map.Entry entry : topicsToReassignments.entrySet()) {
                    String topicName = (String)entry.getKey();
                    Map partitionsToReassignments = (Map)entry.getValue();
                    ArrayList<AlterPartitionReassignmentsRequestData.ReassignablePartition> reassignablePartitions = new ArrayList<AlterPartitionReassignmentsRequestData.ReassignablePartition>();
                    for (Map.Entry partitionEntry : partitionsToReassignments.entrySet()) {
                        int partitionIndex = (Integer)partitionEntry.getKey();
                        Optional reassignment = (Optional)partitionEntry.getValue();
                        AlterPartitionReassignmentsRequestData.ReassignablePartition reassignablePartition = new AlterPartitionReassignmentsRequestData.ReassignablePartition().setPartitionIndex(partitionIndex).setReplicas(reassignment.map(NewPartitionReassignment::targetReplicas).orElse(null));
                        reassignablePartitions.add(reassignablePartition);
                    }
                    AlterPartitionReassignmentsRequestData.ReassignableTopic reassignableTopic = new AlterPartitionReassignmentsRequestData.ReassignableTopic().setName(topicName).setPartitions(reassignablePartitions);
                    data.topics().add(reassignableTopic);
                }
                data.setTimeoutMs(timeoutMs);
                return new AlterPartitionReassignmentsRequest.Builder(data);
            }

            @Override
            public void handleResponse(AbstractResponse abstractResponse) {
                AlterPartitionReassignmentsResponse response = (AlterPartitionReassignmentsResponse)abstractResponse;
                HashMap<TopicPartition, ApiException> errors = new HashMap<TopicPartition, ApiException>();
                int receivedResponsesCount = 0;
                Errors topLevelError = Errors.forCode(response.data().errorCode());
                switch (topLevelError) {
                    case NONE: {
                        receivedResponsesCount += this.validateTopicResponses(response.data().responses(), errors);
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(topLevelError);
                        break;
                    }
                    default: {
                        for (AlterPartitionReassignmentsResponseData.ReassignableTopicResponse reassignableTopicResponse : response.data().responses()) {
                            String topicName = reassignableTopicResponse.name();
                            for (AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse partition : reassignableTopicResponse.partitions()) {
                                errors.put(new TopicPartition(topicName, partition.partitionIndex()), new ApiError(topLevelError, response.data().errorMessage()).exception());
                                ++receivedResponsesCount;
                            }
                        }
                    }
                }
                this.assertResponseCountMatch(errors, receivedResponsesCount);
                for (Map.Entry entry : errors.entrySet()) {
                    ApiException exception = (ApiException)entry.getValue();
                    if (exception == null) {
                        ((KafkaFutureImpl)futures.get(entry.getKey())).complete(null);
                        continue;
                    }
                    ((KafkaFutureImpl)futures.get(entry.getKey())).completeExceptionally(exception);
                }
            }

            private void assertResponseCountMatch(Map<TopicPartition, ApiException> errors, int receivedResponsesCount) {
                int expectedResponsesCount = topicsToReassignments.values().stream().mapToInt(Map::size).sum();
                if (errors.values().stream().noneMatch(Objects::nonNull) && receivedResponsesCount != expectedResponsesCount) {
                    String quantifier = receivedResponsesCount > expectedResponsesCount ? "many" : "less";
                    throw new UnknownServerException("The server returned too " + quantifier + " results.Expected " + expectedResponsesCount + " but received " + receivedResponsesCount);
                }
            }

            private int validateTopicResponses(List<AlterPartitionReassignmentsResponseData.ReassignableTopicResponse> topicResponses, Map<TopicPartition, ApiException> errors) {
                int receivedResponsesCount = 0;
                for (AlterPartitionReassignmentsResponseData.ReassignableTopicResponse topicResponse : topicResponses) {
                    String topicName = topicResponse.name();
                    for (AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse partResponse : topicResponse.partitions()) {
                        Errors partitionError = Errors.forCode(partResponse.errorCode());
                        TopicPartition tp = new TopicPartition(topicName, partResponse.partitionIndex());
                        if (partitionError == Errors.NONE) {
                            errors.put(tp, null);
                        } else {
                            errors.put(tp, new ApiError(partitionError, partResponse.errorMessage()).exception());
                        }
                        ++receivedResponsesCount;
                    }
                }
                return receivedResponsesCount;
            }

            @Override
            void handleFailure(Throwable throwable) {
                for (KafkaFutureImpl future : futures.values()) {
                    future.completeExceptionally(throwable);
                }
            }
        };
        if (!topicsToReassignments.isEmpty()) {
            this.runnable.call(call, now);
        }
        return new AlterPartitionReassignmentsResult(new HashMap<TopicPartition, KafkaFuture<Void>>(futures));
    }

    @Override
    public ListPartitionReassignmentsResult listPartitionReassignments(final Optional<Set<TopicPartition>> partitions, ListPartitionReassignmentsOptions options) {
        final KafkaFutureImpl<Map<TopicPartition, PartitionReassignment>> partitionReassignmentsFuture = new KafkaFutureImpl<Map<TopicPartition, PartitionReassignment>>();
        if (partitions.isPresent()) {
            for (TopicPartition tp : partitions.get()) {
                String topic = tp.topic();
                int partition = tp.partition();
                if (KafkaAdminClient.topicNameIsUnrepresentable(topic)) {
                    partitionReassignmentsFuture.completeExceptionally(new InvalidTopicException("The given topic name '" + topic + "' cannot be represented in a request."));
                } else if (partition < 0) {
                    partitionReassignmentsFuture.completeExceptionally(new InvalidTopicException("The given partition index " + partition + " is not valid."));
                }
                if (!partitionReassignmentsFuture.isCompletedExceptionally()) continue;
                return new ListPartitionReassignmentsResult(partitionReassignmentsFuture);
            }
        }
        long now = this.time.milliseconds();
        this.runnable.call(new Call("listPartitionReassignments", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            @Override
            ListPartitionReassignmentsRequest.Builder createRequest(int timeoutMs) {
                ListPartitionReassignmentsRequestData listData = new ListPartitionReassignmentsRequestData();
                listData.setTimeoutMs(timeoutMs);
                if (partitions.isPresent()) {
                    HashMap<String, ListPartitionReassignmentsRequestData.ListPartitionReassignmentsTopics> reassignmentTopicByTopicName = new HashMap<String, ListPartitionReassignmentsRequestData.ListPartitionReassignmentsTopics>();
                    for (TopicPartition tp : (Set)partitions.get()) {
                        if (!reassignmentTopicByTopicName.containsKey(tp.topic())) {
                            reassignmentTopicByTopicName.put(tp.topic(), new ListPartitionReassignmentsRequestData.ListPartitionReassignmentsTopics().setName(tp.topic()));
                        }
                        ((ListPartitionReassignmentsRequestData.ListPartitionReassignmentsTopics)reassignmentTopicByTopicName.get(tp.topic())).partitionIndexes().add(tp.partition());
                    }
                    listData.setTopics(new ArrayList<ListPartitionReassignmentsRequestData.ListPartitionReassignmentsTopics>(reassignmentTopicByTopicName.values()));
                }
                return new ListPartitionReassignmentsRequest.Builder(listData);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                ListPartitionReassignmentsResponse response = (ListPartitionReassignmentsResponse)abstractResponse;
                Errors error = Errors.forCode(response.data().errorCode());
                switch (error) {
                    case NONE: {
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(error);
                        break;
                    }
                    default: {
                        partitionReassignmentsFuture.completeExceptionally(new ApiError(error, response.data().errorMessage()).exception());
                    }
                }
                HashMap<TopicPartition, PartitionReassignment> reassignmentMap = new HashMap<TopicPartition, PartitionReassignment>();
                for (ListPartitionReassignmentsResponseData.OngoingTopicReassignment topicReassignment : response.data().topics()) {
                    String topicName = topicReassignment.name();
                    for (ListPartitionReassignmentsResponseData.OngoingPartitionReassignment partitionReassignment : topicReassignment.partitions()) {
                        reassignmentMap.put(new TopicPartition(topicName, partitionReassignment.partitionIndex()), new PartitionReassignment(partitionReassignment.replicas(), partitionReassignment.addingReplicas(), partitionReassignment.removingReplicas()));
                    }
                }
                partitionReassignmentsFuture.complete(reassignmentMap);
            }

            @Override
            void handleFailure(Throwable throwable) {
                partitionReassignmentsFuture.completeExceptionally(throwable);
            }
        }, now);
        return new ListPartitionReassignmentsResult(partitionReassignmentsFuture);
    }

    private long calculateNextAllowedRetryMs() {
        return this.time.milliseconds() + this.retryBackoffMs;
    }

    private void handleNotControllerError(AbstractResponse response) throws ApiException {
        if (response.errorCounts().containsKey((Object)Errors.NOT_CONTROLLER)) {
            this.handleNotControllerError(Errors.NOT_CONTROLLER);
        }
    }

    private void handleNotControllerError(Errors error) throws ApiException {
        this.metadataManager.clearController();
        this.metadataManager.requestUpdate();
        throw error.exception();
    }

    private Integer nodeFor(ConfigResource resource) {
        if (resource.type() == ConfigResource.Type.BROKER && !resource.isDefault() || resource.type() == ConfigResource.Type.BROKER_LOGGER) {
            return Integer.valueOf(resource.name());
        }
        return null;
    }

    private List<LeaveGroupRequestData.MemberIdentity> getMembersFromGroup(String groupId) {
        Collection<MemberDescription> members;
        try {
            members = this.describeConsumerGroups(Collections.singleton(groupId)).describedGroups().get(groupId).get().members();
        }
        catch (Exception ex) {
            throw new KafkaException("Encounter exception when trying to get members from group: " + groupId, ex);
        }
        ArrayList<LeaveGroupRequestData.MemberIdentity> membersToRemove = new ArrayList<LeaveGroupRequestData.MemberIdentity>();
        for (MemberDescription member : members) {
            if (member.groupInstanceId().isPresent()) {
                membersToRemove.add(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId(member.groupInstanceId().get()));
                continue;
            }
            membersToRemove.add(new LeaveGroupRequestData.MemberIdentity().setMemberId(member.consumerId()));
        }
        return membersToRemove;
    }

    @Override
    public RemoveMembersFromConsumerGroupResult removeMembersFromConsumerGroup(String groupId, RemoveMembersFromConsumerGroupOptions options) {
        long startFindCoordinatorMs = this.time.milliseconds();
        long deadline = this.calcDeadlineMs(startFindCoordinatorMs, options.timeoutMs());
        KafkaFutureImpl<Map<LeaveGroupRequestData.MemberIdentity, Errors>> future = new KafkaFutureImpl<Map<LeaveGroupRequestData.MemberIdentity, Errors>>();
        ConsumerGroupOperationContext context = new ConsumerGroupOperationContext(groupId, options, deadline, future);
        List<LeaveGroupRequestData.MemberIdentity> members = options.removeAll() ? this.getMembersFromGroup(groupId) : options.members().stream().map(MemberToRemove::toMemberIdentity).collect(Collectors.toList());
        Call findCoordinatorCall = this.getFindCoordinatorCall(context, () -> this.getRemoveMembersFromGroupCall(context, members));
        this.runnable.call(findCoordinatorCall, startFindCoordinatorMs);
        return new RemoveMembersFromConsumerGroupResult(future, options.members());
    }

    private Call getRemoveMembersFromGroupCall(final ConsumerGroupOperationContext<Map<LeaveGroupRequestData.MemberIdentity, Errors>, RemoveMembersFromConsumerGroupOptions> context, final List<LeaveGroupRequestData.MemberIdentity> members) {
        return new Call("leaveGroup", context.deadline(), new ConstantNodeIdProvider(context.node().get().id())){

            @Override
            LeaveGroupRequest.Builder createRequest(int timeoutMs) {
                return new LeaveGroupRequest.Builder(context.groupId(), members);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                LeaveGroupResponse response = (LeaveGroupResponse)abstractResponse;
                if (ConsumerGroupOperationContext.hasCoordinatorMoved(response)) {
                    Call call = KafkaAdminClient.this.getRemoveMembersFromGroupCall(context, members);
                    KafkaAdminClient.this.rescheduleFindCoordinatorTask(context, () -> call, this);
                    return;
                }
                if (KafkaAdminClient.this.handleGroupRequestError(response.topLevelError(), context.future())) {
                    return;
                }
                HashMap<LeaveGroupRequestData.MemberIdentity, Errors> memberErrors = new HashMap<LeaveGroupRequestData.MemberIdentity, Errors>();
                for (LeaveGroupResponseData.MemberResponse memberResponse : response.memberResponses()) {
                    memberErrors.put(new LeaveGroupRequestData.MemberIdentity().setMemberId(memberResponse.memberId()).setGroupInstanceId(memberResponse.groupInstanceId()), Errors.forCode(memberResponse.errorCode()));
                }
                context.future().complete(memberErrors);
            }

            @Override
            void handleFailure(Throwable throwable) {
                context.future().completeExceptionally(throwable);
            }
        };
    }

    @Override
    public AlterConsumerGroupOffsetsResult alterConsumerGroupOffsets(String groupId, Map<TopicPartition, OffsetAndMetadata> offsets, AlterConsumerGroupOffsetsOptions options) {
        KafkaFutureImpl<Map<TopicPartition, Errors>> future = new KafkaFutureImpl<Map<TopicPartition, Errors>>();
        long startFindCoordinatorMs = this.time.milliseconds();
        long deadline = this.calcDeadlineMs(startFindCoordinatorMs, options.timeoutMs());
        ConsumerGroupOperationContext context = new ConsumerGroupOperationContext(groupId, options, deadline, future);
        Call findCoordinatorCall = this.getFindCoordinatorCall(context, () -> this.getAlterConsumerGroupOffsetsCall(context, offsets));
        this.runnable.call(findCoordinatorCall, startFindCoordinatorMs);
        return new AlterConsumerGroupOffsetsResult(future);
    }

    private Call getAlterConsumerGroupOffsetsCall(final ConsumerGroupOperationContext<Map<TopicPartition, Errors>, AlterConsumerGroupOffsetsOptions> context, final Map<TopicPartition, OffsetAndMetadata> offsets) {
        return new Call("commitOffsets", context.deadline(), new ConstantNodeIdProvider(context.node().get().id())){

            @Override
            OffsetCommitRequest.Builder createRequest(int timeoutMs) {
                Object topic;
                ArrayList<OffsetCommitRequestData.OffsetCommitRequestTopic> topics = new ArrayList<OffsetCommitRequestData.OffsetCommitRequestTopic>();
                HashMap<String, List> offsetData = new HashMap<String, List>();
                for (Map.Entry entry : offsets.entrySet()) {
                    topic = ((TopicPartition)entry.getKey()).topic();
                    OffsetAndMetadata oam = (OffsetAndMetadata)entry.getValue();
                    offsetData.compute((String)topic, (key, value) -> {
                        if (value == null) {
                            value = new ArrayList<OffsetCommitRequestData.OffsetCommitRequestPartition>();
                        }
                        OffsetCommitRequestData.OffsetCommitRequestPartition partition = new OffsetCommitRequestData.OffsetCommitRequestPartition().setCommittedOffset(oam.offset()).setCommittedLeaderEpoch(oam.leaderEpoch().orElse(-1)).setCommittedMetadata(oam.metadata()).setPartitionIndex(((TopicPartition)entry.getKey()).partition());
                        value.add(partition);
                        return value;
                    });
                }
                for (Map.Entry entry : offsetData.entrySet()) {
                    topic = new OffsetCommitRequestData.OffsetCommitRequestTopic().setName((String)entry.getKey()).setPartitions((List)entry.getValue());
                    topics.add((OffsetCommitRequestData.OffsetCommitRequestTopic)topic);
                }
                OffsetCommitRequestData data = new OffsetCommitRequestData().setGroupId(context.groupId()).setTopics(topics);
                return new OffsetCommitRequest.Builder(data);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                OffsetCommitResponse response = (OffsetCommitResponse)abstractResponse;
                Map<Errors, Integer> errorCounts = response.errorCounts();
                if (ConsumerGroupOperationContext.hasCoordinatorMoved(errorCounts) || ConsumerGroupOperationContext.shouldRefreshCoordinator(errorCounts)) {
                    Call call = KafkaAdminClient.this.getAlterConsumerGroupOffsetsCall(context, offsets);
                    KafkaAdminClient.this.rescheduleFindCoordinatorTask(context, () -> call, this);
                    return;
                }
                HashMap<TopicPartition, Errors> partitions = new HashMap<TopicPartition, Errors>();
                for (OffsetCommitResponseData.OffsetCommitResponseTopic topic : response.data().topics()) {
                    for (OffsetCommitResponseData.OffsetCommitResponsePartition partition : topic.partitions()) {
                        TopicPartition tp = new TopicPartition(topic.name(), partition.partitionIndex());
                        Errors error = Errors.forCode(partition.errorCode());
                        partitions.put(tp, error);
                    }
                }
                context.future().complete(partitions);
            }

            @Override
            void handleFailure(Throwable throwable) {
                context.future().completeExceptionally(throwable);
            }
        };
    }

    @Override
    public ListOffsetsResult listOffsets(Map<TopicPartition, OffsetSpec> topicPartitionOffsets, ListOffsetsOptions options) {
        HashMap futures = new HashMap(topicPartitionOffsets.size());
        HashSet<String> topics = new HashSet<String>();
        for (TopicPartition topicPartition : topicPartitionOffsets.keySet()) {
            topics.add(topicPartition.topic());
            futures.put(topicPartition, new KafkaFutureImpl());
        }
        long nowMetadata = this.time.milliseconds();
        long deadline = this.calcDeadlineMs(nowMetadata, options.timeoutMs());
        MetadataOperationContext context = new MetadataOperationContext(topics, options, deadline, futures);
        Call metadataCall = this.getMetadataCall(context, () -> this.getListOffsetsCalls(context, topicPartitionOffsets, futures));
        this.runnable.call(metadataCall, nowMetadata);
        return new ListOffsetsResult(new HashMap<TopicPartition, KafkaFuture<ListOffsetsResult.ListOffsetsResultInfo>>(futures));
    }

    private List<Call> getListOffsetsCalls(final MetadataOperationContext<ListOffsetsResult.ListOffsetsResultInfo, ListOffsetsOptions> context, final Map<TopicPartition, OffsetSpec> topicPartitionOffsets, final Map<TopicPartition, KafkaFutureImpl<ListOffsetsResult.ListOffsetsResultInfo>> futures) {
        MetadataResponse mr = context.response().orElseThrow(() -> new IllegalStateException("No Metadata response"));
        Cluster clusterSnapshot = mr.buildCluster();
        ArrayList<Call> calls = new ArrayList<Call>();
        HashMap<Node, Map> leaders = new HashMap<Node, Map>();
        for (Map.Entry<TopicPartition, OffsetSpec> entry : topicPartitionOffsets.entrySet()) {
            long offsetQuery;
            OffsetSpec offsetSpec = entry.getValue();
            TopicPartition tp = entry.getKey();
            KafkaFutureImpl<ListOffsetsResult.ListOffsetsResultInfo> future = futures.get(tp);
            long l = offsetSpec instanceof OffsetSpec.TimestampSpec ? ((OffsetSpec.TimestampSpec)offsetSpec).timestamp() : (offsetQuery = offsetSpec instanceof OffsetSpec.EarliestSpec ? -2L : -1L);
            if (!mr.errors().containsKey(tp.topic())) {
                Node node = clusterSnapshot.leaderFor(tp);
                if (node != null) {
                    Map leadersOnNode = leaders.computeIfAbsent(node, k -> new HashMap());
                    ListOffsetsRequestData.ListOffsetsTopic topic = leadersOnNode.computeIfAbsent(tp.topic(), k -> new ListOffsetsRequestData.ListOffsetsTopic().setName(tp.topic()));
                    topic.partitions().add(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(tp.partition()).setTimestamp(offsetQuery));
                    continue;
                }
                future.completeExceptionally(Errors.LEADER_NOT_AVAILABLE.exception());
                continue;
            }
            future.completeExceptionally(mr.errors().get(tp.topic()).exception());
        }
        for (final Map.Entry<TopicPartition, OffsetSpec> entry : leaders.entrySet()) {
            final int brokerId = ((Node)((Object)entry.getKey())).id();
            calls.add(new Call("listOffsets on broker " + brokerId, context.deadline(), new ConstantNodeIdProvider(brokerId)){
                final List<ListOffsetsRequestData.ListOffsetsTopic> partitionsToQuery;
                {
                    super(callName, deadlineMs, nodeProvider);
                    this.partitionsToQuery = new ArrayList(((Map)entry.getValue()).values());
                }

                @Override
                ListOffsetsRequest.Builder createRequest(int timeoutMs) {
                    return ListOffsetsRequest.Builder.forConsumer(true, ((ListOffsetsOptions)context.options()).isolationLevel()).setTargetTimes(this.partitionsToQuery);
                }

                @Override
                void handleResponse(AbstractResponse abstractResponse) {
                    TopicPartition tp;
                    ListOffsetsResponse response = (ListOffsetsResponse)abstractResponse;
                    HashMap<TopicPartition, OffsetSpec> retryTopicPartitionOffsets = new HashMap<TopicPartition, OffsetSpec>();
                    for (ListOffsetsResponseData.ListOffsetsTopicResponse listOffsetsTopicResponse : response.topics()) {
                        for (ListOffsetsResponseData.ListOffsetsPartitionResponse listOffsetsPartitionResponse : listOffsetsTopicResponse.partitions()) {
                            tp = new TopicPartition(listOffsetsTopicResponse.name(), listOffsetsPartitionResponse.partitionIndex());
                            KafkaFutureImpl future = (KafkaFutureImpl)futures.get(tp);
                            Errors error = Errors.forCode(listOffsetsPartitionResponse.errorCode());
                            OffsetSpec offsetRequestSpec = (OffsetSpec)topicPartitionOffsets.get(tp);
                            if (offsetRequestSpec == null) {
                                KafkaAdminClient.this.log.warn("Server response mentioned unknown topic partition {}", (Object)tp);
                                continue;
                            }
                            if (MetadataOperationContext.shouldRefreshMetadata(error)) {
                                retryTopicPartitionOffsets.put(tp, offsetRequestSpec);
                                continue;
                            }
                            if (error == Errors.NONE) {
                                Optional<Integer> leaderEpoch = listOffsetsPartitionResponse.leaderEpoch() == -1 ? Optional.empty() : Optional.of(listOffsetsPartitionResponse.leaderEpoch());
                                future.complete(new ListOffsetsResult.ListOffsetsResultInfo(listOffsetsPartitionResponse.offset(), listOffsetsPartitionResponse.timestamp(), leaderEpoch));
                                continue;
                            }
                            future.completeExceptionally(error.exception());
                        }
                    }
                    if (retryTopicPartitionOffsets.isEmpty()) {
                        for (ListOffsetsRequestData.ListOffsetsTopic listOffsetsTopic : this.partitionsToQuery) {
                            for (ListOffsetsRequestData.ListOffsetsPartition listOffsetsPartition : listOffsetsTopic.partitions()) {
                                tp = new TopicPartition(listOffsetsTopic.name(), listOffsetsPartition.partitionIndex());
                                ApiException error = new ApiException("The response from broker " + brokerId + " did not contain a result for topic partition " + tp);
                                ((KafkaFutureImpl)futures.get(tp)).completeExceptionally(error);
                            }
                        }
                    } else {
                        Set<String> retryTopics = retryTopicPartitionOffsets.keySet().stream().map(TopicPartition::topic).collect(Collectors.toSet());
                        MetadataOperationContext metadataOperationContext = new MetadataOperationContext(retryTopics, context.options(), context.deadline(), futures);
                        KafkaAdminClient.this.rescheduleMetadataTask(metadataOperationContext, () -> KafkaAdminClient.this.getListOffsetsCalls(retryContext, retryTopicPartitionOffsets, futures));
                    }
                }

                @Override
                void handleFailure(Throwable throwable) {
                    for (ListOffsetsRequestData.ListOffsetsTopic topic : ((Map)entry.getValue()).values()) {
                        for (ListOffsetsRequestData.ListOffsetsPartition partition : topic.partitions()) {
                            TopicPartition tp = new TopicPartition(topic.name(), partition.partitionIndex());
                            KafkaFutureImpl future = (KafkaFutureImpl)futures.get(tp);
                            future.completeExceptionally(throwable);
                        }
                    }
                }
            });
        }
        return calls;
    }

    @Override
    public DescribeClientQuotasResult describeClientQuotas(final ClientQuotaFilter filter, DescribeClientQuotasOptions options) {
        final KafkaFutureImpl<Map<ClientQuotaEntity, Map<String, Double>>> future = new KafkaFutureImpl<Map<ClientQuotaEntity, Map<String, Double>>>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("describeClientQuotas", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            @Override
            DescribeClientQuotasRequest.Builder createRequest(int timeoutMs) {
                return new DescribeClientQuotasRequest.Builder(filter);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeClientQuotasResponse response = (DescribeClientQuotasResponse)abstractResponse;
                response.complete(future);
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        }, now);
        return new DescribeClientQuotasResult(future);
    }

    @Override
    public AlterClientQuotasResult alterClientQuotas(final Collection<ClientQuotaAlteration> entries, final AlterClientQuotasOptions options) {
        final HashMap futures = new HashMap(entries.size());
        for (ClientQuotaAlteration entry : entries) {
            futures.put(entry.entity(), new KafkaFutureImpl());
        }
        long now = this.time.milliseconds();
        this.runnable.call(new Call("alterClientQuotas", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            @Override
            AlterClientQuotasRequest.Builder createRequest(int timeoutMs) {
                return new AlterClientQuotasRequest.Builder(entries, options.validateOnly());
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                AlterClientQuotasResponse response = (AlterClientQuotasResponse)abstractResponse;
                response.complete(futures);
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        }, now);
        return new AlterClientQuotasResult(Collections.unmodifiableMap(futures));
    }

    @Override
    public DescribeUserScramCredentialsResult describeUserScramCredentials(final List<String> users, DescribeUserScramCredentialsOptions options) {
        final KafkaFutureImpl<DescribeUserScramCredentialsResponseData> dataFuture = new KafkaFutureImpl<DescribeUserScramCredentialsResponseData>();
        long now = this.time.milliseconds();
        Call call = new Call("describeUserScramCredentials", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            @Override
            public DescribeUserScramCredentialsRequest.Builder createRequest(int timeoutMs) {
                DescribeUserScramCredentialsRequestData requestData = new DescribeUserScramCredentialsRequestData();
                if (users != null && !users.isEmpty()) {
                    ArrayList<DescribeUserScramCredentialsRequestData.UserName> userNames = new ArrayList<DescribeUserScramCredentialsRequestData.UserName>(users.size());
                    for (String user : users) {
                        if (user == null) continue;
                        userNames.add(new DescribeUserScramCredentialsRequestData.UserName().setName(user));
                    }
                    requestData.setUsers(userNames);
                }
                return new DescribeUserScramCredentialsRequest.Builder(requestData);
            }

            @Override
            public void handleResponse(AbstractResponse abstractResponse) {
                DescribeUserScramCredentialsResponse response = (DescribeUserScramCredentialsResponse)abstractResponse;
                DescribeUserScramCredentialsResponseData data = response.data();
                short messageLevelErrorCode = data.errorCode();
                if (messageLevelErrorCode != Errors.NONE.code()) {
                    dataFuture.completeExceptionally(Errors.forCode(messageLevelErrorCode).exception(data.errorMessage()));
                } else {
                    dataFuture.complete(data);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                dataFuture.completeExceptionally(throwable);
            }
        };
        this.runnable.call(call, now);
        return new DescribeUserScramCredentialsResult(dataFuture);
    }

    @Override
    public AlterUserScramCredentialsResult alterUserScramCredentials(final List<UserScramCredentialAlteration> alterations, AlterUserScramCredentialsOptions options) {
        long now = this.time.milliseconds();
        final HashMap futures = new HashMap();
        for (UserScramCredentialAlteration alteration2 : alterations) {
            futures.put(alteration2.user(), new KafkaFutureImpl());
        }
        final HashMap userIllegalAlterationExceptions = new HashMap();
        String usernameMustNotBeEmptyMsg = "Username must not be empty";
        String passwordMustNotBeEmptyMsg = "Password must not be empty";
        String unknownScramMechanismMsg = "Unknown SCRAM mechanism";
        alterations.stream().filter(a -> a instanceof UserScramCredentialDeletion).forEach(alteration -> {
            String user = alteration.user();
            if (user == null || user.isEmpty()) {
                userIllegalAlterationExceptions.put(alteration.user(), new UnacceptableCredentialException("Username must not be empty"));
            } else {
                UserScramCredentialDeletion deletion = (UserScramCredentialDeletion)alteration;
                ScramMechanism mechanism = deletion.mechanism();
                if (mechanism == null || mechanism == ScramMechanism.UNKNOWN) {
                    userIllegalAlterationExceptions.put(user, new UnsupportedSaslMechanismException("Unknown SCRAM mechanism"));
                }
            }
        });
        final HashMap userInsertions = new HashMap();
        alterations.stream().filter(a -> a instanceof UserScramCredentialUpsertion).filter(alteration -> !userIllegalAlterationExceptions.containsKey(alteration.user())).forEach(alteration -> {
            String user = alteration.user();
            if (user == null || user.isEmpty()) {
                userIllegalAlterationExceptions.put(alteration.user(), new UnacceptableCredentialException("Username must not be empty"));
            } else {
                UserScramCredentialUpsertion upsertion = (UserScramCredentialUpsertion)alteration;
                try {
                    byte[] password = upsertion.password();
                    if (password == null || password.length == 0) {
                        userIllegalAlterationExceptions.put(user, new UnacceptableCredentialException(passwordMustNotBeEmptyMsg));
                    } else {
                        ScramMechanism mechanism = upsertion.credentialInfo().mechanism();
                        if (mechanism == null || mechanism == ScramMechanism.UNKNOWN) {
                            userIllegalAlterationExceptions.put(user, new UnsupportedSaslMechanismException("Unknown SCRAM mechanism"));
                        } else {
                            userInsertions.putIfAbsent(user, new HashMap());
                            ((Map)userInsertions.get(user)).put(mechanism, KafkaAdminClient.getScramCredentialUpsertion(upsertion));
                        }
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    userIllegalAlterationExceptions.put(user, new UnsupportedSaslMechanismException("Unknown SCRAM mechanism"));
                }
                catch (InvalidKeyException e) {
                    userIllegalAlterationExceptions.put(user, new UnacceptableCredentialException(e.getMessage(), e));
                }
            }
        });
        Call call = new Call("alterUserScramCredentials", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            @Override
            public AlterUserScramCredentialsRequest.Builder createRequest(int timeoutMs) {
                return new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setUpsertions(alterations.stream().filter(a -> a instanceof UserScramCredentialUpsertion).filter(a -> !userIllegalAlterationExceptions.containsKey(a.user())).map(a -> (AlterUserScramCredentialsRequestData.ScramCredentialUpsertion)((Map)userInsertions.get(a.user())).get((Object)((UserScramCredentialUpsertion)a).credentialInfo().mechanism())).collect(Collectors.toList())).setDeletions(alterations.stream().filter(a -> a instanceof UserScramCredentialDeletion).filter(a -> !userIllegalAlterationExceptions.containsKey(a.user())).map(d -> KafkaAdminClient.getScramCredentialDeletion((UserScramCredentialDeletion)d)).collect(Collectors.toList())));
            }

            @Override
            public void handleResponse(AbstractResponse abstractResponse) {
                AlterUserScramCredentialsResponse response = (AlterUserScramCredentialsResponse)abstractResponse;
                for (Errors error : response.errorCounts().keySet()) {
                    if (error != Errors.NOT_CONTROLLER) continue;
                    KafkaAdminClient.this.handleNotControllerError(error);
                }
                userIllegalAlterationExceptions.entrySet().stream().forEach(entry -> ((KafkaFutureImpl)futures.get(entry.getKey())).completeExceptionally((Throwable)entry.getValue()));
                response.data().results().forEach(result -> {
                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(result.user());
                    if (future == null) {
                        KafkaAdminClient.this.log.warn("Server response mentioned unknown user {}", (Object)result.user());
                    } else {
                        Errors error = Errors.forCode(result.errorCode());
                        if (error != Errors.NONE) {
                            future.completeExceptionally(error.exception(result.errorMessage()));
                        } else {
                            future.complete(null);
                        }
                    }
                });
                KafkaAdminClient.completeUnrealizedFutures(futures.entrySet().stream(), user -> "The broker response did not contain a result for user " + user);
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        };
        this.runnable.call(call, now);
        return new AlterUserScramCredentialsResult(new HashMap<String, KafkaFuture<Void>>(futures));
    }

    private static AlterUserScramCredentialsRequestData.ScramCredentialUpsertion getScramCredentialUpsertion(UserScramCredentialUpsertion u) throws InvalidKeyException, NoSuchAlgorithmException {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion retval = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion();
        return retval.setName(u.user()).setMechanism(u.credentialInfo().mechanism().type()).setIterations(u.credentialInfo().iterations()).setSalt(u.salt()).setSaltedPassword(KafkaAdminClient.getSaltedPasword(u.credentialInfo().mechanism(), u.password(), u.salt(), u.credentialInfo().iterations()));
    }

    private static AlterUserScramCredentialsRequestData.ScramCredentialDeletion getScramCredentialDeletion(UserScramCredentialDeletion d) {
        return new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(d.user()).setMechanism(d.mechanism().type());
    }

    private static byte[] getSaltedPasword(ScramMechanism publicScramMechanism, byte[] password, byte[] salt, int iterations) throws NoSuchAlgorithmException, InvalidKeyException {
        return new ScramFormatter(org.apache.kafka.common.security.scram.internals.ScramMechanism.forMechanismName(publicScramMechanism.mechanismName())).hi(password, salt, iterations);
    }

    @Override
    public DescribeFeaturesResult describeFeatures(DescribeFeaturesOptions options) {
        final KafkaFutureImpl<FeatureMetadata> future = new KafkaFutureImpl<FeatureMetadata>();
        long now = this.time.milliseconds();
        Call call = new Call("describeFeatures", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            private FeatureMetadata createFeatureMetadata(ApiVersionsResponse response) {
                HashMap<String, FinalizedVersionRange> finalizedFeatures = new HashMap<String, FinalizedVersionRange>();
                for (ApiVersionsResponseData.FinalizedFeatureKey key : response.data().finalizedFeatures().valuesSet()) {
                    finalizedFeatures.put(key.name(), new FinalizedVersionRange(key.minVersionLevel(), key.maxVersionLevel()));
                }
                Optional<Long> finalizedFeaturesEpoch = response.data().finalizedFeaturesEpoch() >= 0L ? Optional.of(response.data().finalizedFeaturesEpoch()) : Optional.empty();
                HashMap<String, SupportedVersionRange> supportedFeatures = new HashMap<String, SupportedVersionRange>();
                for (ApiVersionsResponseData.SupportedFeatureKey key : response.data().supportedFeatures().valuesSet()) {
                    supportedFeatures.put(key.name(), new SupportedVersionRange(key.minVersion(), key.maxVersion()));
                }
                return new FeatureMetadata(finalizedFeatures, finalizedFeaturesEpoch, supportedFeatures);
            }

            @Override
            ApiVersionsRequest.Builder createRequest(int timeoutMs) {
                return new ApiVersionsRequest.Builder();
            }

            @Override
            void handleResponse(AbstractResponse response) {
                ApiVersionsResponse apiVersionsResponse = (ApiVersionsResponse)response;
                if (apiVersionsResponse.data().errorCode() == Errors.NONE.code()) {
                    future.complete(this.createFeatureMetadata(apiVersionsResponse));
                } else {
                    future.completeExceptionally(Errors.forCode(apiVersionsResponse.data().errorCode()).exception());
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(Collections.singletonList(future), throwable);
            }
        };
        this.runnable.call(call, now);
        return new DescribeFeaturesResult(future);
    }

    @Override
    public UpdateFeaturesResult updateFeatures(final Map<String, FeatureUpdate> featureUpdates, UpdateFeaturesOptions options) {
        if (featureUpdates.isEmpty()) {
            throw new IllegalArgumentException("Feature updates can not be null or empty.");
        }
        final HashMap updateFutures = new HashMap();
        for (Map.Entry<String, FeatureUpdate> entry : featureUpdates.entrySet()) {
            String feature = entry.getKey();
            if (feature.trim().isEmpty()) {
                throw new IllegalArgumentException("Provided feature can not be empty.");
            }
            updateFutures.put(entry.getKey(), new KafkaFutureImpl());
        }
        long now = this.time.milliseconds();
        Call call = new Call("updateFeatures", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            @Override
            UpdateFeaturesRequest.Builder createRequest(int timeoutMs) {
                UpdateFeaturesRequestData.FeatureUpdateKeyCollection featureUpdatesRequestData = new UpdateFeaturesRequestData.FeatureUpdateKeyCollection();
                for (Map.Entry entry : featureUpdates.entrySet()) {
                    String feature = (String)entry.getKey();
                    FeatureUpdate update = (FeatureUpdate)entry.getValue();
                    UpdateFeaturesRequestData.FeatureUpdateKey requestItem = new UpdateFeaturesRequestData.FeatureUpdateKey();
                    requestItem.setFeature(feature);
                    requestItem.setMaxVersionLevel(update.maxVersionLevel());
                    requestItem.setAllowDowngrade(update.allowDowngrade());
                    featureUpdatesRequestData.add(requestItem);
                }
                return new UpdateFeaturesRequest.Builder(new UpdateFeaturesRequestData().setTimeoutMs(timeoutMs).setFeatureUpdates(featureUpdatesRequestData));
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                UpdateFeaturesResponse response = (UpdateFeaturesResponse)abstractResponse;
                ApiError topLevelError = response.topLevelError();
                switch (topLevelError.error()) {
                    case NONE: {
                        for (UpdateFeaturesResponseData.UpdatableFeatureResult result : response.data().results()) {
                            KafkaFutureImpl future = (KafkaFutureImpl)updateFutures.get(result.feature());
                            if (future == null) {
                                KafkaAdminClient.this.log.warn("Server response mentioned unknown feature {}", (Object)result.feature());
                                continue;
                            }
                            Errors error = Errors.forCode(result.errorCode());
                            if (error == Errors.NONE) {
                                future.complete(null);
                                continue;
                            }
                            future.completeExceptionally(error.exception(result.errorMessage()));
                        }
                        KafkaAdminClient.completeUnrealizedFutures(updateFutures.entrySet().stream(), feature -> "The controller response did not contain a result for feature " + feature);
                        break;
                    }
                    case NOT_CONTROLLER: {
                        KafkaAdminClient.this.handleNotControllerError(topLevelError.error());
                        break;
                    }
                    default: {
                        for (Map.Entry entry : updateFutures.entrySet()) {
                            ((KafkaFutureImpl)entry.getValue()).completeExceptionally(topLevelError.exception());
                        }
                    }
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(updateFutures.values(), throwable);
            }
        };
        this.runnable.call(call, now);
        return new UpdateFeaturesResult(new HashMap<String, KafkaFuture<Void>>(updateFutures));
    }

    @Override
    public UnregisterBrokerResult unregisterBroker(final int brokerId, UnregisterBrokerOptions options) {
        final KafkaFutureImpl<Void> future = new KafkaFutureImpl<Void>();
        long now = this.time.milliseconds();
        Call call = new Call("unregisterBroker", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            @Override
            UnregisterBrokerRequest.Builder createRequest(int timeoutMs) {
                UnregisterBrokerRequestData data = new UnregisterBrokerRequestData().setBrokerId(brokerId);
                return new UnregisterBrokerRequest.Builder(data);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                UnregisterBrokerResponse response = (UnregisterBrokerResponse)abstractResponse;
                Errors error = Errors.forCode(response.data().errorCode());
                switch (error) {
                    case NONE: {
                        future.complete(null);
                        break;
                    }
                    case REQUEST_TIMED_OUT: {
                        throw error.exception();
                    }
                    default: {
                        KafkaAdminClient.this.log.error("Unregister broker request for broker ID {} failed: {}", (Object)brokerId, (Object)error.message());
                        future.completeExceptionally(error.exception());
                    }
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
        this.runnable.call(call, now);
        return new UnregisterBrokerResult(future);
    }

    static <K> Throwable getSubLevelError(Map<K, Errors> subLevelErrors, K subKey, String keyNotFoundMsg) {
        if (!subLevelErrors.containsKey(subKey)) {
            return new IllegalArgumentException(keyNotFoundMsg);
        }
        return subLevelErrors.get(subKey).exception();
    }

    private static final class ListConsumerGroupsResults {
        private final List<Throwable> errors = new ArrayList<Throwable>();
        private final HashMap<String, ConsumerGroupListing> listings = new HashMap();
        private final HashSet<Node> remaining;
        private final KafkaFutureImpl<Collection<Object>> future;

        ListConsumerGroupsResults(Collection<Node> leaders, KafkaFutureImpl<Collection<Object>> future) {
            this.remaining = new HashSet<Node>(leaders);
            this.future = future;
            this.tryComplete();
        }

        synchronized void addError(Throwable throwable, Node node) {
            ApiError error = ApiError.fromThrowable(throwable);
            if (error.message() == null || error.message().isEmpty()) {
                this.errors.add(error.error().exception("Error listing groups on " + node));
            } else {
                this.errors.add(error.error().exception("Error listing groups on " + node + ": " + error.message()));
            }
        }

        synchronized void addListing(ConsumerGroupListing listing) {
            this.listings.put(listing.groupId(), listing);
        }

        synchronized void tryComplete(Node leader) {
            this.remaining.remove(leader);
            this.tryComplete();
        }

        private synchronized void tryComplete() {
            if (this.remaining.isEmpty()) {
                ArrayList<ConsumerGroupListing> results = new ArrayList<ConsumerGroupListing>(this.listings.values());
                results.addAll(this.errors);
                this.future.complete(results);
            }
        }
    }

    private final class AdminClientRunnable
    implements Runnable {
        private final ArrayList<Call> pendingCalls = new ArrayList();
        private final Map<Node, List<Call>> callsToSend = new HashMap<Node, List<Call>>();
        private final Map<String, List<Call>> callsInFlight = new HashMap<String, List<Call>>();
        private final Map<Integer, Call> correlationIdToCalls = new HashMap<Integer, Call>();
        private List<Call> newCalls = new LinkedList<Call>();

        private AdminClientRunnable() {
        }

        private void timeoutPendingCalls(TimeoutProcessor processor) {
            int numTimedOut = processor.handleTimeouts(this.pendingCalls, "Timed out waiting for a node assignment.");
            if (numTimedOut > 0) {
                KafkaAdminClient.this.log.debug("Timed out {} pending calls.", (Object)numTimedOut);
            }
        }

        private int timeoutCallsToSend(TimeoutProcessor processor) {
            int numTimedOut = 0;
            for (List<Call> callList : this.callsToSend.values()) {
                numTimedOut += processor.handleTimeouts(callList, "Timed out waiting to send the call.");
            }
            if (numTimedOut > 0) {
                KafkaAdminClient.this.log.debug("Timed out {} call(s) with assigned nodes.", (Object)numTimedOut);
            }
            return numTimedOut;
        }

        private synchronized void drainNewCalls() {
            if (!this.newCalls.isEmpty()) {
                this.pendingCalls.addAll(this.newCalls);
                this.newCalls.clear();
            }
        }

        private long maybeDrainPendingCalls(long now) {
            long pollTimeout = Long.MAX_VALUE;
            KafkaAdminClient.this.log.trace("Trying to choose nodes for {} at {}", this.pendingCalls, (Object)now);
            Iterator<Call> pendingIter = this.pendingCalls.iterator();
            while (pendingIter.hasNext()) {
                Call call = pendingIter.next();
                if (now < call.nextAllowedTryMs) {
                    pollTimeout = Math.min(pollTimeout, call.nextAllowedTryMs - now);
                    continue;
                }
                if (!this.maybeDrainPendingCall(call, now)) continue;
                pendingIter.remove();
            }
            return pollTimeout;
        }

        private boolean maybeDrainPendingCall(Call call, long now) {
            try {
                Node node = call.nodeProvider.provide();
                if (node != null) {
                    KafkaAdminClient.this.log.trace("Assigned {} to node {}", (Object)call, (Object)node);
                    call.curNode = node;
                    KafkaAdminClient.getOrCreateListValue(this.callsToSend, node).add(call);
                    return true;
                }
                KafkaAdminClient.this.log.trace("Unable to assign {} to a node.", (Object)call);
                return false;
            }
            catch (Throwable t) {
                KafkaAdminClient.this.log.debug("Unable to choose node for {}", (Object)call, (Object)t);
                call.fail(now, t);
                return true;
            }
        }

        private long sendEligibleCalls(long now) {
            long pollTimeout = Long.MAX_VALUE;
            Iterator<Map.Entry<Node, List<Call>>> iter = this.callsToSend.entrySet().iterator();
            while (iter.hasNext()) {
                AbstractRequest.Builder requestBuilder;
                Map.Entry<Node, List<Call>> entry = iter.next();
                List<Call> calls = entry.getValue();
                if (calls.isEmpty()) {
                    iter.remove();
                    continue;
                }
                Node node = entry.getKey();
                if (!KafkaAdminClient.this.client.ready(node, now)) {
                    long nodeTimeout = KafkaAdminClient.this.client.pollDelayMs(node, now);
                    pollTimeout = Math.min(pollTimeout, nodeTimeout);
                    KafkaAdminClient.this.log.trace("Client is not ready to send to {}. Must delay {} ms", (Object)node, (Object)nodeTimeout);
                    continue;
                }
                Call call = calls.remove(0);
                int requestTimeoutMs = Math.min(KafkaAdminClient.this.requestTimeoutMs, KafkaAdminClient.calcTimeoutMsRemainingAsInt(now, call.deadlineMs));
                try {
                    requestBuilder = call.createRequest(requestTimeoutMs);
                }
                catch (Throwable throwable) {
                    call.fail(now, new KafkaException(String.format("Internal error sending %s to %s.", call.callName, node)));
                    continue;
                }
                ClientRequest clientRequest = KafkaAdminClient.this.client.newClientRequest(node.idString(), requestBuilder, now, true, requestTimeoutMs, null);
                KafkaAdminClient.this.log.debug("Sending {} to {}. correlationId={}", new Object[]{requestBuilder, node, clientRequest.correlationId()});
                KafkaAdminClient.this.client.send(clientRequest, now);
                KafkaAdminClient.getOrCreateListValue(this.callsInFlight, node.idString()).add(call);
                this.correlationIdToCalls.put(clientRequest.correlationId(), call);
            }
            return pollTimeout;
        }

        private void timeoutCallsInFlight(TimeoutProcessor processor) {
            int numTimedOut = 0;
            for (Map.Entry<String, List<Call>> entry : this.callsInFlight.entrySet()) {
                List<Call> contexts = entry.getValue();
                if (contexts.isEmpty()) continue;
                String nodeId = entry.getKey();
                Call call = contexts.get(0);
                if (!processor.callHasExpired(call)) continue;
                if (call.aborted) {
                    KafkaAdminClient.this.log.warn("Aborted call {} is still in callsInFlight.", (Object)call);
                    continue;
                }
                KafkaAdminClient.this.log.debug("Closing connection to {} to time out {}", (Object)nodeId, (Object)call);
                call.aborted = true;
                KafkaAdminClient.this.client.disconnect(nodeId);
                ++numTimedOut;
            }
            if (numTimedOut > 0) {
                KafkaAdminClient.this.log.debug("Timed out {} call(s) in flight.", (Object)numTimedOut);
            }
        }

        private void handleResponses(long now, List<ClientResponse> responses) {
            for (ClientResponse response : responses) {
                int correlationId = response.requestHeader().correlationId();
                Call call = this.correlationIdToCalls.get(correlationId);
                if (call == null) {
                    KafkaAdminClient.this.log.error("Internal server error on {}: server returned information about unknown correlation ID {}, requestHeader = {}", new Object[]{response.destination(), correlationId, response.requestHeader()});
                    KafkaAdminClient.this.client.disconnect(response.destination());
                    continue;
                }
                this.correlationIdToCalls.remove(correlationId);
                List<Call> calls = this.callsInFlight.get(response.destination());
                if (calls == null || !calls.remove(call)) {
                    KafkaAdminClient.this.log.error("Internal server error on {}: ignoring call {} in correlationIdToCall that did not exist in callsInFlight", (Object)response.destination(), (Object)call);
                    continue;
                }
                if (response.versionMismatch() != null) {
                    call.fail(now, response.versionMismatch());
                    continue;
                }
                if (response.wasDisconnected()) {
                    AuthenticationException authException = KafkaAdminClient.this.client.authenticationException(call.curNode());
                    if (authException != null) {
                        call.fail(now, authException);
                        continue;
                    }
                    call.fail(now, new DisconnectException(String.format("Cancelled %s request with correlation id %s due to node %s being disconnected", call.callName, correlationId, response.destination())));
                    continue;
                }
                try {
                    call.handleResponse(response.responseBody());
                    if (!KafkaAdminClient.this.log.isTraceEnabled()) continue;
                    KafkaAdminClient.this.log.trace("{} got response {}", (Object)call, (Object)response.responseBody());
                }
                catch (Throwable t) {
                    if (KafkaAdminClient.this.log.isTraceEnabled()) {
                        KafkaAdminClient.this.log.trace("{} handleResponse failed with {}", (Object)call, (Object)KafkaAdminClient.prettyPrintException(t));
                    }
                    call.fail(now, t);
                }
            }
        }

        private void unassignUnsentCalls(Predicate<Node> shouldUnassign) {
            Iterator<Map.Entry<Node, List<Call>>> iter = this.callsToSend.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Node, List<Call>> entry = iter.next();
                Node node = entry.getKey();
                List<Call> awaitingCalls = entry.getValue();
                if (awaitingCalls.isEmpty()) {
                    iter.remove();
                    continue;
                }
                if (!shouldUnassign.test(node)) continue;
                this.pendingCalls.addAll(awaitingCalls);
                iter.remove();
            }
        }

        private boolean hasActiveExternalCalls(Collection<Call> calls) {
            for (Call call : calls) {
                if (call.isInternal()) continue;
                return true;
            }
            return false;
        }

        private boolean hasActiveExternalCalls() {
            if (this.hasActiveExternalCalls(this.pendingCalls)) {
                return true;
            }
            for (List<Call> callList : this.callsToSend.values()) {
                if (!this.hasActiveExternalCalls(callList)) continue;
                return true;
            }
            return this.hasActiveExternalCalls(this.correlationIdToCalls.values());
        }

        private boolean threadShouldExit(long now, long curHardShutdownTimeMs) {
            if (!this.hasActiveExternalCalls()) {
                KafkaAdminClient.this.log.trace("All work has been completed, and the I/O thread is now exiting.");
                return true;
            }
            if (now >= curHardShutdownTimeMs) {
                KafkaAdminClient.this.log.info("Forcing a hard I/O thread shutdown. Requests in progress will be aborted.");
                return true;
            }
            KafkaAdminClient.this.log.debug("Hard shutdown in {} ms.", (Object)(curHardShutdownTimeMs - now));
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            KafkaAdminClient.this.log.trace("Thread starting");
            try {
                this.processRequests();
            }
            finally {
                AppInfoParser.unregisterAppInfo(KafkaAdminClient.JMX_PREFIX, KafkaAdminClient.this.clientId, KafkaAdminClient.this.metrics);
                int numTimedOut = 0;
                TimeoutProcessor timeoutProcessor = new TimeoutProcessor(Long.MAX_VALUE);
                AdminClientRunnable adminClientRunnable = this;
                synchronized (adminClientRunnable) {
                    numTimedOut += timeoutProcessor.handleTimeouts(this.newCalls, "The AdminClient thread has exited.");
                    this.newCalls = null;
                }
                numTimedOut += timeoutProcessor.handleTimeouts(this.pendingCalls, "The AdminClient thread has exited.");
                numTimedOut += this.timeoutCallsToSend(timeoutProcessor);
                if ((numTimedOut += timeoutProcessor.handleTimeouts(this.correlationIdToCalls.values(), "The AdminClient thread has exited.")) > 0) {
                    KafkaAdminClient.this.log.debug("Timed out {} remaining operation(s).", (Object)numTimedOut);
                }
                Utils.closeQuietly(KafkaAdminClient.this.client, "KafkaClient");
                Utils.closeQuietly(KafkaAdminClient.this.metrics, "Metrics");
                KafkaAdminClient.this.log.debug("Exiting AdminClientRunnable thread.");
            }
        }

        private void processRequests() {
            long now = KafkaAdminClient.this.time.milliseconds();
            while (true) {
                this.drainNewCalls();
                long curHardShutdownTimeMs = KafkaAdminClient.this.hardShutdownTimeMs.get();
                if (curHardShutdownTimeMs != -1L && this.threadShouldExit(now, curHardShutdownTimeMs)) break;
                TimeoutProcessor timeoutProcessor = KafkaAdminClient.this.timeoutProcessorFactory.create(now);
                this.timeoutPendingCalls(timeoutProcessor);
                this.timeoutCallsToSend(timeoutProcessor);
                this.timeoutCallsInFlight(timeoutProcessor);
                long pollTimeout = Math.min(1200000, timeoutProcessor.nextTimeoutMs());
                if (curHardShutdownTimeMs != -1L) {
                    pollTimeout = Math.min(pollTimeout, curHardShutdownTimeMs - now);
                }
                pollTimeout = Math.min(pollTimeout, this.maybeDrainPendingCalls(now));
                long metadataFetchDelayMs = KafkaAdminClient.this.metadataManager.metadataFetchDelayMs(now);
                if (metadataFetchDelayMs == 0L) {
                    KafkaAdminClient.this.metadataManager.transitionToUpdatePending(now);
                    Call metadataCall = this.makeMetadataCall(now);
                    if (!this.maybeDrainPendingCall(metadataCall, now)) {
                        this.pendingCalls.add(metadataCall);
                    }
                }
                pollTimeout = Math.min(pollTimeout, this.sendEligibleCalls(now));
                if (metadataFetchDelayMs > 0L) {
                    pollTimeout = Math.min(pollTimeout, metadataFetchDelayMs);
                }
                if (!this.pendingCalls.isEmpty()) {
                    pollTimeout = Math.min(pollTimeout, KafkaAdminClient.this.retryBackoffMs);
                }
                KafkaAdminClient.this.log.trace("Entering KafkaClient#poll(timeout={})", (Object)pollTimeout);
                List<ClientResponse> responses = KafkaAdminClient.this.client.poll(pollTimeout, now);
                KafkaAdminClient.this.log.trace("KafkaClient#poll retrieved {} response(s)", (Object)responses.size());
                this.unassignUnsentCalls(KafkaAdminClient.this.client::connectionFailed);
                now = KafkaAdminClient.this.time.milliseconds();
                this.handleResponses(now, responses);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enqueue(Call call, long now) {
            if (call.tries > KafkaAdminClient.this.maxRetries) {
                KafkaAdminClient.this.log.debug("Max retries {} for {} reached", (Object)KafkaAdminClient.this.maxRetries, (Object)call);
                call.fail(KafkaAdminClient.this.time.milliseconds(), new TimeoutException());
                return;
            }
            if (KafkaAdminClient.this.log.isDebugEnabled()) {
                KafkaAdminClient.this.log.debug("Queueing {} with a timeout {} ms from now.", (Object)call, (Object)(call.deadlineMs - now));
            }
            boolean accepted = false;
            AdminClientRunnable adminClientRunnable = this;
            synchronized (adminClientRunnable) {
                if (this.newCalls != null) {
                    this.newCalls.add(call);
                    accepted = true;
                }
            }
            if (accepted) {
                KafkaAdminClient.this.client.wakeup();
            } else {
                KafkaAdminClient.this.log.debug("The AdminClient thread has exited. Timing out {}.", (Object)call);
                call.fail(Long.MAX_VALUE, new TimeoutException("The AdminClient thread has exited."));
            }
        }

        void call(Call call, long now) {
            if (KafkaAdminClient.this.hardShutdownTimeMs.get() != -1L) {
                KafkaAdminClient.this.log.debug("The AdminClient is not accepting new calls. Timing out {}.", (Object)call);
                call.fail(Long.MAX_VALUE, new TimeoutException("The AdminClient thread is not accepting new calls."));
            } else {
                this.enqueue(call, now);
            }
        }

        private Call makeMetadataCall(long now) {
            return new Call(true, "fetchMetadata", KafkaAdminClient.this.calcDeadlineMs(now, KafkaAdminClient.this.requestTimeoutMs), (NodeProvider)new MetadataUpdateNodeIdProvider()){

                @Override
                public MetadataRequest.Builder createRequest(int timeoutMs) {
                    return new MetadataRequest.Builder(new MetadataRequestData().setTopics(Collections.emptyList()).setAllowAutoTopicCreation(true));
                }

                @Override
                public void handleResponse(AbstractResponse abstractResponse) {
                    MetadataResponse response = (MetadataResponse)abstractResponse;
                    long now = KafkaAdminClient.this.time.milliseconds();
                    KafkaAdminClient.this.metadataManager.update(response.buildCluster(), now);
                    AdminClientRunnable.this.unassignUnsentCalls(node -> true);
                }

                @Override
                public void handleFailure(Throwable e) {
                    KafkaAdminClient.this.metadataManager.updateFailed(e);
                }
            };
        }
    }

    static class TimeoutProcessor {
        private final long now;
        private int nextTimeoutMs;

        TimeoutProcessor(long now) {
            this.now = now;
            this.nextTimeoutMs = Integer.MAX_VALUE;
        }

        int handleTimeouts(Collection<Call> calls, String msg) {
            int numTimedOut = 0;
            Iterator<Call> iter = calls.iterator();
            while (iter.hasNext()) {
                Call call = iter.next();
                int remainingMs = KafkaAdminClient.calcTimeoutMsRemainingAsInt(this.now, call.deadlineMs);
                if (remainingMs < 0) {
                    call.fail(this.now, new TimeoutException(msg + " Call: " + call.callName));
                    iter.remove();
                    ++numTimedOut;
                    continue;
                }
                this.nextTimeoutMs = Math.min(this.nextTimeoutMs, remainingMs);
            }
            return numTimedOut;
        }

        boolean callHasExpired(Call call) {
            int remainingMs = KafkaAdminClient.calcTimeoutMsRemainingAsInt(this.now, call.deadlineMs);
            if (remainingMs < 0) {
                return true;
            }
            this.nextTimeoutMs = Math.min(this.nextTimeoutMs, remainingMs);
            return false;
        }

        int nextTimeoutMs() {
            return this.nextTimeoutMs;
        }
    }

    static class TimeoutProcessorFactory {
        TimeoutProcessorFactory() {
        }

        TimeoutProcessor create(long now) {
            return new TimeoutProcessor(now);
        }
    }

    abstract class Call {
        private final boolean internal;
        private final String callName;
        private final long deadlineMs;
        private final NodeProvider nodeProvider;
        private int tries = 0;
        private boolean aborted = false;
        private Node curNode = null;
        private long nextAllowedTryMs = 0L;

        Call(boolean internal, String callName, long deadlineMs, NodeProvider nodeProvider) {
            this.internal = internal;
            this.callName = callName;
            this.deadlineMs = deadlineMs;
            this.nodeProvider = nodeProvider;
        }

        Call(String callName, long deadlineMs, NodeProvider nodeProvider) {
            this(false, callName, deadlineMs, nodeProvider);
        }

        protected Node curNode() {
            return this.curNode;
        }

        final void fail(long now, Throwable throwable) {
            if (this.aborted) {
                ++this.tries;
                this.failWithTimeout(now, throwable);
                return;
            }
            if (throwable instanceof UnsupportedVersionException && this.handleUnsupportedVersionException((UnsupportedVersionException)throwable)) {
                KafkaAdminClient.this.log.debug("{} attempting protocol downgrade and then retry.", (Object)this);
                KafkaAdminClient.this.runnable.enqueue(this, now);
                return;
            }
            ++this.tries;
            this.nextAllowedTryMs = now + KafkaAdminClient.this.retryBackoffMs;
            if (KafkaAdminClient.calcTimeoutMsRemainingAsInt(now, this.deadlineMs) < 0) {
                this.failWithTimeout(now, throwable);
                return;
            }
            if (!(throwable instanceof RetriableException)) {
                if (KafkaAdminClient.this.log.isDebugEnabled()) {
                    KafkaAdminClient.this.log.debug("{} failed with non-retriable exception after {} attempt(s)", new Object[]{this, this.tries, new Exception(KafkaAdminClient.prettyPrintException(throwable))});
                }
                this.handleFailure(throwable);
                return;
            }
            if (this.tries > KafkaAdminClient.this.maxRetries) {
                this.failWithTimeout(now, throwable);
                return;
            }
            if (KafkaAdminClient.this.log.isDebugEnabled()) {
                KafkaAdminClient.this.log.debug("{} failed: {}. Beginning retry #{}", new Object[]{this, KafkaAdminClient.prettyPrintException(throwable), this.tries});
            }
            KafkaAdminClient.this.runnable.enqueue(this, now);
        }

        private void failWithTimeout(long now, Throwable cause) {
            if (KafkaAdminClient.this.log.isDebugEnabled()) {
                KafkaAdminClient.this.log.debug("{} timed out at {} after {} attempt(s)", new Object[]{this, now, this.tries, new Exception(KafkaAdminClient.prettyPrintException(cause))});
            }
            this.handleFailure(new TimeoutException(this + " timed out at " + now + " after " + this.tries + " attempt(s)", cause));
        }

        abstract AbstractRequest.Builder createRequest(int var1);

        abstract void handleResponse(AbstractResponse var1);

        abstract void handleFailure(Throwable var1);

        boolean handleUnsupportedVersionException(UnsupportedVersionException exception) {
            return false;
        }

        public String toString() {
            return "Call(callName=" + this.callName + ", deadlineMs=" + this.deadlineMs + ", tries=" + this.tries + ", nextAllowedTryMs=" + this.nextAllowedTryMs + ")";
        }

        public boolean isInternal() {
            return this.internal;
        }
    }

    private class LeastLoadedNodeProvider
    implements NodeProvider {
        private LeastLoadedNodeProvider() {
        }

        @Override
        public Node provide() {
            if (KafkaAdminClient.this.metadataManager.isReady()) {
                return KafkaAdminClient.this.client.leastLoadedNode(KafkaAdminClient.this.time.milliseconds());
            }
            KafkaAdminClient.this.metadataManager.requestUpdate();
            return null;
        }
    }

    private class ControllerNodeProvider
    implements NodeProvider {
        private ControllerNodeProvider() {
        }

        @Override
        public Node provide() {
            if (KafkaAdminClient.this.metadataManager.isReady() && KafkaAdminClient.this.metadataManager.controller() != null) {
                return KafkaAdminClient.this.metadataManager.controller();
            }
            KafkaAdminClient.this.metadataManager.requestUpdate();
            return null;
        }
    }

    private class ConstantNodeIdProvider
    implements NodeProvider {
        private final int nodeId;

        ConstantNodeIdProvider(int nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public Node provide() {
            if (KafkaAdminClient.this.metadataManager.isReady() && KafkaAdminClient.this.metadataManager.nodeById(this.nodeId) != null) {
                return KafkaAdminClient.this.metadataManager.nodeById(this.nodeId);
            }
            KafkaAdminClient.this.metadataManager.requestUpdate();
            return null;
        }
    }

    private class MetadataUpdateNodeIdProvider
    implements NodeProvider {
        private MetadataUpdateNodeIdProvider() {
        }

        @Override
        public Node provide() {
            return KafkaAdminClient.this.client.leastLoadedNode(KafkaAdminClient.this.time.milliseconds());
        }
    }

    private static interface NodeProvider {
        public Node provide();
    }
}

