/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.clients.producer.internals.ListOffsetsRecord;
import org.apache.kafka.clients.producer.internals.ListOffsetsRequestFuture;
import org.apache.kafka.clients.producer.internals.RecordAccumulator;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.CopyOnWriteMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListOffsetsAccumulator {
    private static final Logger log = LoggerFactory.getLogger(RecordAccumulator.class);
    private final ConcurrentMap<TopicPartition, Deque<ListOffsetsRecord>> batches = new CopyOnWriteMap<TopicPartition, Deque<ListOffsetsRecord>>();
    int drainIndex = 0;
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListOffsetReadyCheckResult ready(Cluster cluster) {
        HashSet<Node> readyNodes = new HashSet<Node>();
        boolean unknownLeadersExist = false;
        for (Map.Entry entry : this.batches.entrySet()) {
            TopicPartition part = (TopicPartition)entry.getKey();
            Deque deque = (Deque)entry.getValue();
            Node leader = cluster.leaderFor(part);
            if (leader == null) {
                unknownLeadersExist = true;
                continue;
            }
            if (readyNodes.contains(leader)) continue;
            Deque deque2 = deque;
            synchronized (deque2) {
                ListOffsetsRecord batch = (ListOffsetsRecord)deque.peekFirst();
                if (batch != null) {
                    readyNodes.add(leader);
                    log.debug("new leader {} have add the ready node", (Object)leader.toString());
                }
            }
        }
        return new ListOffsetReadyCheckResult(readyNodes, unknownLeadersExist);
    }

    private Deque<ListOffsetsRecord> dequeFor(TopicPartition tp) {
        Deque d = (Deque)this.batches.get(tp);
        if (d != null) {
            return d;
        }
        this.batches.putIfAbsent(tp, new ArrayDeque());
        return (Deque)this.batches.get(tp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListOffsetsRequestFuture append(TopicPartition tp, long timestamp) throws InterruptedException {
        Deque<ListOffsetsRecord> dq;
        if (this.closed) {
            throw new IllegalStateException("Cannot send after the producer is closed.");
        }
        Deque<ListOffsetsRecord> deque = dq = this.dequeFor(tp);
        synchronized (deque) {
            ListOffsetsRequestFuture future = new ListOffsetsRequestFuture();
            ListOffsetsRecord batch = new ListOffsetsRecord(tp, timestamp, future);
            dq.addLast(batch);
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, List<ListOffsetsRecord>> drain(Cluster cluster, Set<Node> nodes) {
        if (nodes.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<ListOffsetsRecord>> batches = new HashMap<Integer, List<ListOffsetsRecord>>();
        for (Node node : nodes) {
            List<PartitionInfo> parts = cluster.partitionsForNode(node.id());
            ArrayList<ListOffsetsRecord> records = new ArrayList<ListOffsetsRecord>();
            int start = this.drainIndex %= parts.size();
            do {
                PartitionInfo part;
                Deque<ListOffsetsRecord> deque;
                if ((deque = this.dequeFor(new TopicPartition((part = parts.get(this.drainIndex)).topic(), part.partition()))) != null) {
                    Deque<ListOffsetsRecord> deque2 = deque;
                    synchronized (deque2) {
                        ListOffsetsRecord first = deque.peekFirst();
                        if (first != null) {
                            ListOffsetsRecord record = deque.pollFirst();
                            records.add(record);
                        }
                    }
                }
                this.drainIndex = (this.drainIndex + 1) % parts.size();
            } while (start != this.drainIndex);
            batches.put(node.id(), records);
        }
        return batches;
    }

    public void close() {
        this.closed = true;
    }

    public static final class ListOffsetReadyCheckResult {
        public final Set<Node> readyNodes;
        public final boolean unknownLeadersExist;

        public ListOffsetReadyCheckResult(Set<Node> readyNodes, boolean unknownLeadersExist) {
            this.readyNodes = readyNodes;
            this.unknownLeadersExist = unknownLeadersExist;
        }
    }
}

