/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.clients.StaleMetadataException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListOffsetsRequestFuture<T>
implements RequestCompletionHandler {
    private static final Logger log = LoggerFactory.getLogger(ListOffsetsRequestFuture.class);
    private boolean isDone = false;
    private RuntimeException exception;
    private long value;
    private TopicPartition topicPartition;

    public static <T> ListOffsetsRequestFuture<T> failure(RuntimeException e) {
        ListOffsetsRequestFuture<T> future = new ListOffsetsRequestFuture<T>();
        future.raise(e);
        return future;
    }

    public static ListOffsetsRequestFuture<Void> voidSuccess() {
        ListOffsetsRequestFuture<Void> future = new ListOffsetsRequestFuture<Void>();
        future.complete(null);
        return future;
    }

    public static <T> ListOffsetsRequestFuture<T> leaderNotAvailable() {
        return ListOffsetsRequestFuture.failure(Errors.LEADER_NOT_AVAILABLE.exception());
    }

    public static <T> ListOffsetsRequestFuture<T> staleMetadata() {
        return ListOffsetsRequestFuture.failure(new StaleMetadataException());
    }

    public void topicPartitionSet(TopicPartition topicPartition) {
        this.topicPartition = topicPartition;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public long value() {
        return this.value;
    }

    public boolean succeeded() {
        return this.isDone && this.exception == null;
    }

    public boolean failed() {
        return this.isDone && this.exception != null;
    }

    public boolean isRetriable() {
        return this.exception instanceof RetriableException;
    }

    public void raise(Errors error) {
        this.raise(error.exception());
    }

    public void raise(RuntimeException e) {
        if (this.isDone) {
            throw new IllegalStateException("Invalid attempt to complete a request future which is already complete");
        }
        this.exception = e;
        this.isDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void complete(ClientResponse clientResponse) {
        try {
            if (this.isDone()) {
                throw new IllegalStateException("Invalid attempt to complete a request future which is already complete");
            }
            if (clientResponse.wasDisconnected()) {
                this.raise(new DisconnectException());
            } else {
                ListOffsetsResponse lor = (ListOffsetsResponse)clientResponse.responseBody();
                for (ListOffsetsResponseData.ListOffsetsTopicResponse topicResponse : lor.topics()) {
                    for (ListOffsetsResponseData.ListOffsetsPartitionResponse partitionResponse : topicResponse.partitions()) {
                        Errors error = Errors.forCode(partitionResponse.errorCode());
                        if (error == Errors.NONE) {
                            Long offset = partitionResponse.offset();
                            this.value = offset;
                            this.isDone = true;
                            log.debug("Fetched offset {} for partition {}", (Object)offset, (Object)this.topicPartition);
                            continue;
                        }
                        if (error == Errors.NOT_LEADER_OR_FOLLOWER || error == Errors.UNKNOWN_TOPIC_OR_PARTITION) {
                            log.warn("Attempt to fetch offsets for partition {} failed due to obsolete leadership information, retrying.", (Object)this.topicPartition);
                            this.raise(error);
                            continue;
                        }
                        log.error("Attempt to fetch offsets for partition {} failed due to: {}", (Object)this.topicPartition, (Object)error.exception().getMessage());
                        this.raise(new StaleMetadataException());
                    }
                }
            }
        }
        finally {
            this.notifyAll();
        }
    }

    public synchronized void await(long maxWaitMs) throws InterruptedException, TimeoutException {
        if (maxWaitMs < 0L) {
            throw new IllegalArgumentException("Max time to wait for metadata updates should not be < 0 milli seconds");
        }
        long begin = System.currentTimeMillis();
        long remainingWaitMs = maxWaitMs;
        while (!this.isDone()) {
            long elapsed;
            if (remainingWaitMs != 0L) {
                this.wait(remainingWaitMs);
            }
            if ((elapsed = System.currentTimeMillis() - begin) >= maxWaitMs) {
                throw new TimeoutException("Failed to fetch offSet after " + maxWaitMs + " ms.");
            }
            remainingWaitMs = maxWaitMs - elapsed;
        }
    }

    public RuntimeException exception() {
        return this.exception;
    }

    @Override
    public void onComplete(ClientResponse response) {
        this.complete(response);
    }
}

