/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.DeleteGroupCommitOffsetRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DeleteGroupCommitOffsetResponse;

public class DeleteGroupCommitOffsetRequest
extends AbstractRequest {
    private final DeleteGroupCommitOffsetRequestData data;

    public DeleteGroupCommitOffsetRequest(DeleteGroupCommitOffsetRequestData data, short version, ApiKeys apiKeys) {
        super(apiKeys, version);
        this.data = data;
    }

    public DeleteGroupCommitOffsetRequest(DeleteGroupCommitOffsetRequestData data, short version) {
        super(ApiKeys.DELETE_GROUP_COMMIT_OFFSET, version);
        this.data = data;
    }

    public static DeleteGroupCommitOffsetRequest parse(ByteBuffer buffer, short version) {
        return new DeleteGroupCommitOffsetRequest(new DeleteGroupCommitOffsetRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static DeleteGroupCommitOffsetRequest parse(ByteBuffer buffer) {
        return DeleteGroupCommitOffsetRequest.parse(buffer, ApiKeys.DELETE_GROUP_COMMIT_OFFSET.latestVersion());
    }

    public String groupName() {
        return this.data.groupName();
    }

    public String topicName() {
        return this.data.topicName();
    }

    @Override
    public AbstractResponse getErrorResponse(Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                Errors error = Errors.forException(e);
                return new DeleteGroupCommitOffsetResponse(error, "false");
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.DELETE_GROUP_COMMIT_OFFSET.latestVersion()));
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return this.getErrorResponse(e);
    }

    @Override
    public ApiMessage data() {
        return this.data;
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteGroupCommitOffsetRequest> {
        private final DeleteGroupCommitOffsetRequestData data;

        public Builder(DeleteGroupCommitOffsetRequestData data) {
            super(ApiKeys.DELETE_GROUP_COMMIT_OFFSET);
            this.data = data;
        }

        @Override
        public DeleteGroupCommitOffsetRequest build(short version) {
            return new DeleteGroupCommitOffsetRequest(this.data, version, ApiKeys.DELETE_GROUP_COMMIT_OFFSET);
        }

        public String toString() {
            return "(type=DeleteGroupCommitOffsetRequest, topicName=" + this.data.topicName() + ", groupName=" + this.data.groupName() + ")";
        }
    }
}

