/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security;

import java.lang.reflect.Method;
import org.apache.kafka.common.security.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaweiCipher
implements Cipher {
    private static final Logger LOG = LoggerFactory.getLogger(HuaweiCipher.class);
    private final String REMOTE_KEY = "common_remote";
    private String WORKKEY_NAME = "common_local";
    private final String KEY_TYPE_PATH = "com.huawei.paas.encrypt.cbb.KeyType";
    private final String KEY_MODE_PATH = "com.huawei.paas.encrypt.cbb.KeyMode";
    private final String CIPHER_MANAGER_EXTEND_PATH = "com.huawei.paas.encrypt.cbb.impl.CipherManagerExtend";
    private final String CIPHER_MANAGER_TWO_PATH = "com.huawei.paas.encrypt.cbb.impl.CipherManager2";
    private Class<?> cipherManagerClass = null;

    @Override
    public void init() {
        try {
            this.setCipherManager();
        }
        catch (ClassNotFoundException cls) {
            LOG.error("FAILED to set cipher manager.", (Throwable)cls);
        }
        catch (Exception e) {
            LOG.error("FAILED to set cipher manager with Exception.", (Throwable)e);
        }
    }

    @Override
    public void init(String workKeyName) {
        this.WORKKEY_NAME = workKeyName;
        try {
            this.setCipherManager();
        }
        catch (ClassNotFoundException cls) {
            LOG.error("FAILED to set cipher manager.", (Throwable)cls);
        }
        catch (Exception e) {
            LOG.error("FAILED to set cipher manager with Exception.", (Throwable)e);
        }
    }

    public void setCipherManager() throws ClassNotFoundException {
        try {
            this.cipherManagerClass = Class.forName("com.huawei.paas.encrypt.cbb.impl.CipherManager2");
            LOG.warn("USE {}", (Object)"com.huawei.paas.encrypt.cbb.impl.CipherManager2");
        }
        catch (ClassNotFoundException cls) {
            this.cipherManagerClass = Class.forName("com.huawei.paas.encrypt.cbb.impl.CipherManagerExtend");
            LOG.warn("USE {}.", (Object)"com.huawei.paas.encrypt.cbb.impl.CipherManagerExtend");
        }
    }

    public Object getKeyType(int num) {
        if (null == this.cipherManagerClass) {
            this.init();
        }
        if (null != this.cipherManagerClass) {
            try {
                Class<?> keyTypeClass = Class.forName("com.huawei.paas.encrypt.cbb.KeyType");
                ?[] objects = keyTypeClass.getEnumConstants();
                return objects[num];
            }
            catch (Exception e) {
                LOG.error("getKeyType error.", (Throwable)e);
                return null;
            }
        }
        LOG.error("FAILED to get cipher manager.");
        return null;
    }

    public Object getKeyMode(int mode) {
        if (null == this.cipherManagerClass) {
            this.init();
        }
        if (null != this.cipherManagerClass) {
            try {
                Class<?> keyModeClass = Class.forName("com.huawei.paas.encrypt.cbb.KeyMode");
                ?[] objects = keyModeClass.getEnumConstants();
                return objects[mode];
            }
            catch (Exception e) {
                LOG.error("getKeyMode error.", (Throwable)e);
                return null;
            }
        }
        LOG.error("FAILED to get cipher manager.");
        return null;
    }

    @Override
    public char[] encrypt(String encryptStr) {
        if (null == this.cipherManagerClass) {
            this.init();
        }
        if (null == encryptStr || 0 == encryptStr.length()) {
            LOG.error("KeyUtilsImpl encrypt error, error message: the method parameter is empty");
            return null;
        }
        if (null == this.cipherManagerClass) {
            LOG.error("FAILED to get cipher manager.");
            return null;
        }
        try {
            if (this.WORKKEY_NAME.equals("common_remote")) {
                Method method = this.cipherManagerClass.getMethod("encryptRemoteV2ForKafka", char[].class, Object.class, Object.class, String.class, String.class);
                return (char[])method.invoke(this.cipherManagerClass.newInstance(), encryptStr.toCharArray(), this.getKeyType(1), this.getKeyMode(2), this.WORKKEY_NAME, null);
            }
            Method method = this.cipherManagerClass.getMethod("encryptV2ForKafka", char[].class, Object.class, String.class);
            return (char[])method.invoke(this.cipherManagerClass.newInstance(), encryptStr.toCharArray(), this.getKeyType(3), this.WORKKEY_NAME);
        }
        catch (Exception e) {
            LOG.error("encrypt error.", (Throwable)e);
            return null;
        }
    }

    @Override
    public char[] decrypt(String decryptStr) {
        if (null == this.cipherManagerClass) {
            this.init();
        }
        if (null == decryptStr || 0 == decryptStr.length()) {
            LOG.error("KeyUtilsImpl decrypt error, error message: the method parameter is empty");
            return null;
        }
        if (null == this.cipherManagerClass) {
            LOG.error("FAILED to get cipher manager.");
            return null;
        }
        try {
            Method method = this.cipherManagerClass.getMethod("decryptV2ForKafka", char[].class, Object.class, String.class);
            return (char[])method.invoke(this.cipherManagerClass.newInstance(), decryptStr.toCharArray(), this.getKeyType(1), this.WORKKEY_NAME);
        }
        catch (Exception exp) {
            LOG.error("KeyUtilsImpl decrypt error. ", (Throwable)exp);
            return null;
        }
    }

    @Override
    public byte[] encrypt(byte[] encryptByte) {
        if (null == this.cipherManagerClass) {
            this.init();
        }
        if (null == encryptByte || 0 == encryptByte.length) {
            LOG.warn("KeyUtilsImpl encrypt error, error message: the method parameter is empty");
            return encryptByte;
        }
        if (null == this.cipherManagerClass) {
            LOG.error("FAILED to get cipher manager.");
            return null;
        }
        try {
            if (this.WORKKEY_NAME.equals("common_remote")) {
                Method method = this.cipherManagerClass.getMethod("encryptRemoteV2ForKafka", byte[].class, Object.class, Object.class, String.class, String.class);
                return (byte[])method.invoke(this.cipherManagerClass.newInstance(), encryptByte, this.getKeyType(1), this.getKeyMode(2), this.WORKKEY_NAME, null);
            }
            Method method = this.cipherManagerClass.getMethod("encryptV2ForKafka", byte[].class, Object.class, String.class);
            return (byte[])method.invoke(this.cipherManagerClass.newInstance(), encryptByte, this.getKeyType(3), this.WORKKEY_NAME);
        }
        catch (Exception e) {
            LOG.error("encrypt error.", (Throwable)e);
            return null;
        }
    }

    @Override
    public byte[] decrypt(byte[] decryptByte) {
        if (null == this.cipherManagerClass) {
            this.init();
        }
        if (null == decryptByte || 0 == decryptByte.length) {
            LOG.warn("KeyUtilsImpl decrypt error, error message: the method parameter is empty");
            return decryptByte;
        }
        if (null == this.cipherManagerClass) {
            LOG.error("FAILED to get cipher manager.");
            return null;
        }
        try {
            Method method = this.cipherManagerClass.getMethod("decryptV2ForKafka", byte[].class, Object.class, String.class);
            return (byte[])method.invoke(this.cipherManagerClass.newInstance(), decryptByte, this.getKeyType(1), this.WORKKEY_NAME);
        }
        catch (Exception e) {
            LOG.error("decrypt error.", (Throwable)e);
            return null;
        }
    }
}

