/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.net.Socket;
import java.security.cert.CRL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.SslCertificationCrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaX509TrustManager
extends X509ExtendedTrustManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultSslEngineFactory.class);
    private X509ExtendedTrustManager trustManager;
    private boolean ifValidateCertDate;

    public KafkaX509TrustManager(X509ExtendedTrustManager trustManager, boolean certDateValidation) {
        this.trustManager = trustManager;
        this.ifValidateCertDate = certDateValidation;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.optionalValidation(chain);
        this.trustManager.checkClientTrusted(chain, authType, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.optionalValidation(chain);
        this.trustManager.checkServerTrusted(chain, authType, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.optionalValidation(chain);
        this.trustManager.checkClientTrusted(chain, authType, engine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.optionalValidation(chain);
        this.trustManager.checkServerTrusted(chain, authType, engine);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.optionalValidation(chain);
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.optionalValidation(chain);
        this.trustManager.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    private void optionalValidation(X509Certificate[] chain) throws CertificateException {
        if (this.ifValidateCertDate) {
            this.verifyDate(chain);
        }
        if (SslCertificationCrl.INSTANCE.getCrls() != null && SslCertificationCrl.INSTANCE.getCrls().length != 0) {
            this.checkCRL(chain);
        }
    }

    private void verifyDate(X509Certificate[] chain) throws CertificateException {
        Date date = new Date();
        for (X509Certificate certificate : chain) {
            certificate.checkValidity(date);
        }
    }

    private void checkCRL(X509Certificate[] chain) throws CertificateException {
        if (this.isRevoked(chain)) {
            log.error("certificate revoked.");
            throw new CertificateException("certificate revoked");
        }
    }

    private boolean isRevoked(X509Certificate[] chain) {
        CRL[] crls = SslCertificationCrl.INSTANCE.getCrls();
        if (crls == null || crls.length == 0) {
            return false;
        }
        for (X509Certificate cert : chain) {
            for (CRL crl : crls) {
                if (!crl.isRevoked(cert)) continue;
                return true;
            }
        }
        return false;
    }
}

