/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SslCertificationCrl {
    INSTANCE;

    private static final Logger log;
    private CRL[] crls = null;

    public void crlInit(String crlPath) {
        if (this.crls != null) {
            return;
        }
        File file = new File(crlPath);
        if (!file.exists()) {
            this.crls = new CRL[0];
            return;
        }
        this.crls = SslCertificationCrl.createCRL(crlPath);
    }

    private static CRL[] createCRL(String crlFile) {
        CRL[] crls;
        FileInputStream fileInputStream = null;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            fileInputStream = new FileInputStream(crlFile);
            Collection<? extends CRL> collection = certificateFactory.generateCRLs(fileInputStream);
            crls = collection.toArray(new CRL[collection.size()]);
        }
        catch (CertificateException certificateException) {
            throw new IllegalArgumentException("bad cert file.");
        }
        catch (IOException ioException) {
            throw new IllegalArgumentException("crl file not found.");
        }
        catch (CRLException crlException) {
            throw new IllegalArgumentException("bad crl file.");
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ioException) {
                    log.error("unable to close fileInputStream while creating CRL");
                }
            }
        }
        return crls;
    }

    public CRL[] getCrls() {
        return this.crls;
    }

    static {
        log = LoggerFactory.getLogger(SslCertificationCrl.class);
    }
}

