/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nce.common.snmpagenttarter.migrate;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnmpAgentSQLBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpAgentSQLBuilder.class);
    private static final Map<String, String> YANG_TO_SQL = new HashMap<String, String>();
    private static final Map<String, String> YANG_TO_DELETE_SQL = new HashMap<String, String>();

    private SnmpAgentSQLBuilder() {
    }

    public static boolean matchConvertTable(String yangPath) {
        return YANG_TO_SQL.containsKey(yangPath);
    }

    public static String getInsertSql(String yangPath) {
        if (YANG_TO_SQL.containsKey(yangPath)) {
            return YANG_TO_SQL.get(yangPath);
        }
        String err = "[SnmpAgent]Can't find inserting sql for " + yangPath;
        LOG.error(err);
        throw new IllegalArgumentException(err);
    }

    public static String getDeleteSql(String yangPath) {
        return YANG_TO_DELETE_SQL.getOrDefault(yangPath, null);
    }

    public static String queryYangPathByTableName(String tableName) {
        return SnmpAgentSQLBuilder.formatSQL("select yang_path from yang_schema where table_name = '{0}'", tableName);
    }

    public static String getJsdocQuerySql(String tableName) {
        return SnmpAgentSQLBuilder.formatSQL("select jsdoc from {0}", tableName);
    }

    public static String formatSQL(String sql, String ... params) {
        if (params == null || params.length == 0) {
            return sql;
        }
        String trueSQL = sql;
        for (int i = 0; i < params.length; ++i) {
            String replaceStr = "{" + i + "}";
            trueSQL = trueSQL.replace(replaceStr, params[i]);
        }
        return trueSQL;
    }

    static {
        YANG_TO_SQL.put("urn_huawei_yang_huawei_ac_snmp_augment_cfg_engine", "INSERT IGNORE INTO T_SNMP_AGENT_ENGINE (ID, ENGINE_ID, LISTEN_PORT, VERSION, ENABLED, SYNC_ENABLE) VALUES (default, ?, ?, ?, ?, ?)");
        YANG_TO_SQL.put("urn_huawei_yang_huawei_ac_snmp_snmp_agent_cfg_vacm_view", "INSERT IGNORE INTO T_SNMP_AGENT_VACM_VIEW (ID, NAME, INCLUDE, EXCLUDE) VALUES (default, ?, ?, ?)");
        YANG_TO_SQL.put("urn_huawei_yang_huawei_ac_snmp_snmp_agent_cfg_vacm_group_access", "INSERT IGNORE INTO T_SNMP_AGENT_VACM_GROUP (ID, NAME, SECURITY_MODEL, SECURITY_LEVEL, CONTEXT, CONTEXT_MATCH, READ_VIEW, WRITE_VIEW, NOTIFY_VIEW) VALUES (default, ?, ?, ?, ?, ?, ?, ?, ?)");
        YANG_TO_SQL.put("urn_huawei_yang_huawei_ac_snmp_snmp_agent_cfg_vacm_group", "INSERT IGNORE INTO T_SNMP_AGENT_VACM_GROUP (ID, NAME, SECURITY_MODEL, SECURITY_LEVEL, CONTEXT, CONTEXT_MATCH, READ_VIEW, WRITE_VIEW, NOTIFY_VIEW) VALUES (default, ?, ?, ?, ?, ?, ?, ?, ?)");
        YANG_TO_SQL.put("urn_huawei_yang_huawei_ac_snmp_snmp_agent_cfg_usm_local_user", "INSERT IGNORE INTO T_SNMP_AGENT_USM_LOCAL_USER (ID, NAME, ENGINE_ID, GROUP_NAME, PRIV_PROTOCOL, PRIV_KEY, AUTH_PROTOCOL, AUTH_KEY) VALUES (default, ?, ?, ?, ?, ?, ?, ?)");
        YANG_TO_SQL.put("urn_huawei_yang_huawei_ac_snmp_snmp_agent_cfg_target_params", "INSERT IGNORE INTO T_SNMP_AGENT_USM_TARGET_PARAMS (ID, NAME, SECURITY_MODEL, USER_NAME, SECURITY_LEVEL) VALUES (default, ?, ?, ?, ?)");
        YANG_TO_SQL.put("urn_huawei_yang_huawei_ac_snmp_snmp_agent_cfg_target", "INSERT IGNORE INTO T_SNMP_AGENT_USM_TARGET_NOTIFY (ID, NAME, NOTIFY_TYPE, IP, PORT, PREFIX_LENGTH, TIMEOUT, RETRIES, TARGET_PARAMS) VALUES (default, ?, ?, ?, ?, ?, ?, ?, ?)");
        YANG_TO_SQL.put("urn_huawei_yang_huawei_ac_snmp_snmp_agent_cfg_notify", "INSERT IGNORE INTO T_SNMP_AGENT_USM_TARGET_NOTIFY (ID, NAME, NOTIFY_TYPE, IP, PORT, PREFIX_LENGTH, TIMEOUT, RETRIES, TARGET_PARAMS) VALUES (default, ?, ?, ?, ?, ?, ?, ?, ?)");
        YANG_TO_SQL.put("urn_huawei_yang_huawei_ac_iui_snmp_statistics_snmpagent_packet_statistics_packet_statistics_packet_statistics_info", "INSERT IGNORE INTO T_SNMP_AGENT_PACKET_STATISTICS (ID, AC_IP, OP_TYPE, DROP_NUM, SEND_ERROR_NUM, RECV_TOTAL_NUM, RECV_ERROR_NUM, SEND_TOTAL_NUM) VALUES (default, ?, ?, ?, ?, ?, ?, ?)");
        YANG_TO_SQL.put("urn_huawei_yang_huawei_ac_iui_snmp_statistics_snmpagent_packet_statistics_fault_statistics_fault_statistics_info", "INSERT IGNORE INTO T_SNMP_AGENT_FAULT_STATISTICS (ID, AC_IP, NE_IP, OP_TYPE, FIRST_FAULT_TIME, CURRENT_FAULT_TIME, CONTINUOUS_FAULT_NUM, FAULT_REASON, USER_NAME, COMMENTS) VALUES (default, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        YANG_TO_DELETE_SQL.put("urn_huawei_yang_huawei_ac_snmp_augment_cfg_engine", "DELETE FROM T_SNMP_AGENT_ENGINE");
        YANG_TO_DELETE_SQL.put("urn_huawei_yang_huawei_ac_iui_snmp_statistics_snmpagent_packet_statistics_packet_statistics_packet_statistics_info", "DELETE FROM T_SNMP_AGENT_PACKET_STATISTICS");
        YANG_TO_DELETE_SQL.put("urn_huawei_yang_huawei_ac_iui_snmp_statistics_snmpagent_packet_statistics_fault_statistics_fault_statistics_info", "DELETE FROM T_SNMP_AGENT_FAULT_STATISTICS");
    }
}

