/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nce.common.sshclientstarter.migrate;

public final class SshSQLBuilder {
    private static final String QUERY_YANG_PATH = "select yang_path from yang_schema where table_name = '{0}'";
    private static final String QUERY_COMMON_SWITCH_CHECK = "select '{0}' as key_name, jsdoc->>'switch' as key_value from {1}";
    private static final String QUERY_COMMON_SWITCH_CHECK_ZENITH = "select '{0}' as key_name, json_value(jsdoc, '$.\"switch\"') as key_value from {1}";
    private static final String QUERY_WEAK_HMAC = "select '{0}' as key_name, jsdoc->>'weak-hmac' as key_value from {1}";
    private static final String QUERY_WEAK_HMAC_ZENITH = "select '{0}' as key_name, json_value(jsdoc, '$.\"weak-hmac\"') as key_value from {1}";
    private static final String QUERY_WEAK_KEX = "select '{0}' as key_name, jsdoc->>'weak-key-exchange' as key_value from {1}";
    private static final String QUERY_WEAK_KEX_ZENITH = "select '{0}' as key_name, json_value(jsdoc, '$.\"weak-key-exchange\"') as key_value from {1}";
    private static final String INSERT_CONFIG_DATA = "insert ignore into t_bp_sshclient_config(key_name, key_value) values(?, ?)";

    private SshSQLBuilder() {
    }

    public static String getInsertConfigData() {
        return INSERT_CONFIG_DATA;
    }

    public static String queryYangPathByTableName(String tableName) {
        return SshSQLBuilder.formatSQL(QUERY_YANG_PATH, tableName);
    }

    public static String queryFingerPrintCheck(String tableName, boolean isZenith) {
        return SshSQLBuilder.formatSQL(isZenith ? QUERY_COMMON_SWITCH_CHECK_ZENITH : QUERY_COMMON_SWITCH_CHECK, "fingerprint_check", tableName);
    }

    public static String queryRiskSwitch(String tableName, boolean isZenith) {
        return SshSQLBuilder.formatSQL(isZenith ? QUERY_COMMON_SWITCH_CHECK_ZENITH : QUERY_COMMON_SWITCH_CHECK, "risk_switch", tableName);
    }

    public static String queryTrustSelfLearn(String tableName, boolean isZenith) {
        return SshSQLBuilder.formatSQL(isZenith ? QUERY_COMMON_SWITCH_CHECK_ZENITH : QUERY_COMMON_SWITCH_CHECK, "trust_self_learn_fingerprint", tableName);
    }

    public static String queryWeakHmac(String tableName, boolean isZenith) {
        return SshSQLBuilder.formatSQL(isZenith ? QUERY_WEAK_HMAC_ZENITH : QUERY_WEAK_HMAC, "weak_algorithm_hmac", tableName);
    }

    public static String queryWeakKex(String tableName, boolean isZenith) {
        return SshSQLBuilder.formatSQL(isZenith ? QUERY_WEAK_KEX_ZENITH : QUERY_WEAK_KEX, "weak_algorithm_kex", tableName);
    }

    public static String formatSQL(String sql, String ... params) {
        if (params == null || params.length == 0) {
            return sql;
        }
        String trueSQL = sql;
        for (int i = 0; i < params.length; ++i) {
            String replaceStr = "{" + i + "}";
            trueSQL = trueSQL.replace(replaceStr, params[i]);
        }
        return trueSQL;
    }
}

