/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.io.File;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;

public class FileUtil {
    private FileUtil() {
    }

    public static boolean createParentFolder(Class<?> pkg, String filename, boolean createParentFolder, LogChannelInterface log, VariableSpace vs) {
        boolean isParentFolderCreated = true;
        String parentFolderName = null;
        try (FileObject parentFolder = KettleVFS.getFileObject((String)filename, (VariableSpace)vs).getParent();){
            parentFolderName = parentFolder.getName().toString();
            if (!parentFolder.exists()) {
                if (createParentFolder) {
                    if (log.isDebug()) {
                        log.logDebug(BaseMessages.getString(pkg, (String)"JobTrans.Log.ParentLogFolderNotExist", (String[])new String[]{parentFolder.getName().toString()}));
                    }
                    parentFolder.createFolder();
                    if (log.isDebug()) {
                        log.logDebug(BaseMessages.getString(pkg, (String)"JobTrans.Log.ParentLogFolderCreated", (String[])new String[]{parentFolder.getName().toString()}));
                    }
                } else {
                    log.logError(BaseMessages.getString(pkg, (String)"JobTrans.Log.ParentLogFolderNotExist", (String[])new String[]{parentFolder.getName().toString()}));
                    isParentFolderCreated = false;
                }
            } else if (log.isDebug()) {
                log.logDebug(BaseMessages.getString(pkg, (String)"JobTrans.Log.ParentLogFolderExists", (String[])new String[]{parentFolder.getName().toString()}));
            }
        }
        catch (Exception e) {
            isParentFolderCreated = false;
            log.logError(BaseMessages.getString(pkg, (String)"JobTrans.Error.ChekingParentLogFolderTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(pkg, (String)"JobTrans.Error.ChekingParentLogFolder", (String[])new String[]{parentFolderName}), e});
        }
        return isParentFolderCreated;
    }

    public static boolean isFullyQualified(String pathname) {
        return new File(pathname).isAbsolute() || pathname.startsWith("/") || pathname.startsWith("\\");
    }
}

