/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.creditcardvalidator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.creditcardvalidator.CreditCardValidatorMeta;
import org.pentaho.di.trans.steps.creditcardvalidator.ReturnIndicator;

public class CreditCardVerifier {
    private static Class<?> PKG = CreditCardValidatorMeta.class;
    public static final int INVALID = -1;
    public static final int VISA = 0;
    public static final int MASTERCARD = 1;
    public static final int AMERICAN_EXPRESS = 2;
    public static final int EN_ROUTE = 3;
    public static final int DINERS_CLUB = 4;
    public static final int DISCOVER = 5;
    public static final int JCB1 = 6;
    public static final int JCB2 = 7;
    public static final int BANKCARD = 8;
    public static final int MAESTRO = 9;
    public static final int SOLO = 10;
    public static final int SWITCH = 11;
    public static final int AIRPLUS = 12;
    public static final int LASER = 13;
    public static final int VOYAGER = 14;
    private static final String[] cardNames = new String[]{"Visa", "Mastercard", "American Express", "En Route", "Diner's CLub/Carte Blanche", "Discover", "JCB1", "JCB2", "BankCard", "Maestro", "Solo", "Switch", "Airplus", "Laser", "Voyager"};
    private static final String[] NotValidCardNames = new String[]{BaseMessages.getString(PKG, (String)"CreditCardValidator.Log.NotValidVisa", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CreditCardValidator.Log.NotValidMastercard", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CreditCardValidator.Log.NotValidAmericanExpress", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CreditCardValidator.Log.NotValidEnRoute", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CreditCardValidator.Log.NotValidDiners", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CreditCardValidator.Log.NotValidDiscover", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CreditCardValidator.Log.NotValidJcb1", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CreditCardValidator.Log.NotValidJcb2", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CreditCardValidator.Log.NotValidBankCard", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CreditCardValidator.Log.NotValidMaestro", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CreditCardValidator.Log.NotValidSolo", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CreditCardValidator.Log.NotValidSwitch", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CreditCardValidator.Log.NotValidAirplus", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CreditCardValidator.Log.NotValidLaser", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CreditCardValidator.Log.NotValidVoyager", (String[])new String[0])};

    public static String getCardName(int id) {
        return id > -1 && id < cardNames.length ? cardNames[id] : null;
    }

    public static String getNotValidCardNames(int id) {
        return id > -1 && id < NotValidCardNames.length ? NotValidCardNames[id] : null;
    }

    public static ReturnIndicator CheckCC(String CardNumber) {
        ReturnIndicator ri = new ReturnIndicator();
        if (Utils.isEmpty((CharSequence)CardNumber)) {
            ri.UnValidMsg = BaseMessages.getString(PKG, (String)"CreditCardValidator.Log.EmptyNumber", (String[])new String[0]);
            return ri;
        }
        Matcher m = Pattern.compile("[^\\d\\s.-]").matcher(CardNumber);
        if (m.find()) {
            ri.UnValidMsg = BaseMessages.getString(PKG, (String)"CreditCardValidator.OnlyNumbers", (String[])new String[0]);
            return ri;
        }
        int cardId = CreditCardVerifier.getCardID(CardNumber);
        if (cardId > -1) {
            if (CreditCardVerifier.luhnValidate(CardNumber)) {
                ri.CardValid = true;
                ri.CardType = CreditCardVerifier.getCardName(cardId);
            } else {
                ri.CardValid = false;
                ri.UnValidMsg = CreditCardVerifier.getNotValidCardNames(cardId);
            }
        } else if (CreditCardVerifier.luhnValidate(CardNumber)) {
            ri.CardValid = true;
        } else {
            ri.UnValidMsg = BaseMessages.getString(PKG, (String)"CreditCardValidator.Log.CardNotValid", (String[])new String[0]);
        }
        return ri;
    }

    public static boolean luhnValidate(String numberString) {
        try {
            int j = numberString.length();
            String[] s1 = new String[j];
            for (int i = 0; i < j; ++i) {
                s1[i] = "" + numberString.charAt(i);
            }
            int checksum = 0;
            for (int i = s1.length - 1; i >= 0; i -= 2) {
                int k = 0;
                if (i > 0) {
                    k = Integer.valueOf(s1[i - 1]) * 2;
                    if (k > 9) {
                        String s = "" + k;
                        k = Integer.valueOf(s.substring(0, 1)) + Integer.valueOf(s.substring(1));
                    }
                    checksum += Integer.valueOf(s1[i]) + k;
                    continue;
                }
                checksum += Integer.valueOf(s1[0]).intValue();
            }
            return checksum % 10 == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getCardID(String number) {
        int valid = -1;
        String digit1 = number.substring(0, 1);
        String digit2 = number.substring(0, 2);
        String digit3 = number.substring(0, 3);
        String digit4 = number.substring(0, 4);
        if (CreditCardVerifier.isNumber(number)) {
            if (digit4.equals("4903") || digit4.equals("4905") || digit4.equals("4911") || digit4.equals("4936") || digit4.equals("564182") || digit4.equals("633110") || digit4.equals("6333") || digit4.equals("6759")) {
                if (number.length() == 16 || number.length() == 18 || number.length() == 19) {
                    valid = 11;
                }
            } else if (digit4.equals("6304") || digit4.equals("6706") || digit4.equals("6771") || digit4.equals("6709")) {
                if (number.length() >= 16 && number.length() <= 19) {
                    valid = 13;
                }
            } else if (digit1.equals("4")) {
                if (number.length() == 13 || number.length() == 16) {
                    valid = 0;
                }
            } else if (digit2.compareTo("51") >= 0 && digit2.compareTo("55") <= 0) {
                if (number.length() == 16) {
                    valid = 1;
                }
            } else if (digit2.equals("34") || digit2.equals("37")) {
                if (number.length() == 15) {
                    valid = 2;
                }
            } else if (digit4.equals("2014") || digit4.equals("2149")) {
                if (number.length() == 15) {
                    valid = 3;
                }
            } else if (digit2.equals("36") || digit2.equals("38") || digit3.compareTo("300") >= 0 && digit3.compareTo("305") <= 0) {
                if (number.length() == 14) {
                    valid = 4;
                }
            } else if (digit4.equals("6011")) {
                if (number.length() == 16) {
                    valid = 5;
                }
            } else if (digit1.equals("3")) {
                if (number.length() == 16) {
                    valid = 6;
                }
            } else if (digit4.equals("2131") || digit4.equals("1800")) {
                if (number.length() == 15) {
                    valid = 7;
                }
            } else if (digit4.equals("5610") || digit4.equals("560221") || digit4.equals("560222") || digit4.equals("560223") || digit4.equals("560224") || digit4.equals("560225")) {
                if (number.length() == 16) {
                    valid = 8;
                }
            } else if (digit4.equals("5018") || digit4.equals("5020") || digit4.equals("5038") || digit4.equals("6304") || digit4.equals("6759") || digit4.equals("6761") || digit4.equals("6763")) {
                if (number.length() == 12 || number.length() == 13 || number.length() >= 14 && number.length() <= 19) {
                    valid = 9;
                }
            } else if (digit4.equals("6334") || digit4.equals("6767")) {
                if (number.length() == 16 || number.length() == 18 || number.length() == 19) {
                    valid = 10;
                }
            } else if (digit3.equals("192") || digit3.equals("122")) {
                valid = 12;
            } else if (digit4.equals("8699") && number.length() == 15) {
                valid = 14;
            }
        }
        return valid;
    }

    public static boolean isNumber(String n) {
        try {
            Double.valueOf(n).doubleValue();
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

