/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sftpput;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.sftpput.JobEntrySFTPPUT;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sftpput.SFTPPut;
import org.pentaho.di.trans.steps.sftpput.SFTPPutData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class SFTPPutMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SFTPPutMeta.class;
    private String serverName;
    private String serverPort;
    private String userName;
    private String password;
    private String sourceFileFieldName;
    private String remoteDirectoryFieldName;
    private boolean addFilenameResut;
    private boolean inputIsStream;
    private boolean usekeyfilename;
    private String keyfilename;
    private String keyfilepass;
    private String compression;
    private boolean createRemoteFolder;
    private String proxyType;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String destinationfolderFieldName;
    private boolean createDestinationFolder;
    private int afterFTPS;
    private String remoteFilenameFieldName;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.serverName = XMLHandler.getTagValue((Node)stepnode, (String)"servername");
            this.serverPort = XMLHandler.getTagValue((Node)stepnode, (String)"serverport");
            this.userName = XMLHandler.getTagValue((Node)stepnode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"password"));
            this.sourceFileFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"sourceFileFieldName");
            this.remoteDirectoryFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"remoteDirectoryFieldName");
            this.inputIsStream = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"inputIsStream"));
            this.addFilenameResut = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addFilenameResut"));
            this.usekeyfilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"usekeyfilename"));
            this.keyfilename = XMLHandler.getTagValue((Node)stepnode, (String)"keyfilename");
            this.keyfilepass = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"keyfilepass"));
            this.compression = XMLHandler.getTagValue((Node)stepnode, (String)"compression");
            this.proxyType = XMLHandler.getTagValue((Node)stepnode, (String)"proxyType");
            this.proxyHost = XMLHandler.getTagValue((Node)stepnode, (String)"proxyHost");
            this.proxyPort = XMLHandler.getTagValue((Node)stepnode, (String)"proxyPort");
            this.proxyUsername = XMLHandler.getTagValue((Node)stepnode, (String)"proxyUsername");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"proxyPassword"));
            this.createRemoteFolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"createRemoteFolder"));
            boolean remove = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"remove"));
            this.setAfterFTPS(JobEntrySFTPPUT.getAfterSFTPPutByCode(Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"aftersftpput"), (String)"")));
            if (remove && this.getAfterFTPS() == 0) {
                this.setAfterFTPS(1);
            }
            this.destinationfolderFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"destinationfolderFieldName");
            this.createDestinationFolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"createdestinationfolder"));
            this.remoteFilenameFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"remoteFilenameFieldName");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.serverName = null;
        this.serverPort = "22";
        this.inputIsStream = false;
        this.addFilenameResut = false;
        this.usekeyfilename = false;
        this.keyfilename = null;
        this.keyfilepass = null;
        this.compression = "none";
        this.proxyType = null;
        this.proxyHost = null;
        this.proxyPort = null;
        this.proxyUsername = null;
        this.proxyPassword = null;
        this.createRemoteFolder = false;
        this.afterFTPS = 0;
        this.destinationfolderFieldName = null;
        this.createDestinationFolder = false;
        this.remoteFilenameFieldName = null;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"serverport", (String)this.serverPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sourceFileFieldName", (String)this.sourceFileFieldName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"remoteDirectoryFieldName", (String)this.remoteDirectoryFieldName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"inputIsStream", (boolean)this.inputIsStream));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addFilenameResut", (boolean)this.addFilenameResut));
        retval.append("      ").append(XMLHandler.addTagValue((String)"usekeyfilename", (boolean)this.usekeyfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"keyfilename", (String)this.keyfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"keyfilepass", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.keyfilepass)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"compression", (String)this.compression));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxyType", (String)this.proxyType));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxyHost", (String)this.proxyHost));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxyPort", (String)this.proxyPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxyUsername", (String)this.proxyUsername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxyPassword", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createRemoteFolder", (boolean)this.createRemoteFolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"aftersftpput", (String)JobEntrySFTPPUT.getAfterSFTPPutCode(this.getAfterFTPS())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destinationfolderFieldName", (String)this.destinationfolderFieldName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createdestinationfolder", (boolean)this.createDestinationFolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"remoteFilenameFieldName", (String)this.remoteFilenameFieldName));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.serverName = rep.getStepAttributeString(id_step, "servername");
            this.serverPort = rep.getStepAttributeString(id_step, "serverport");
            this.userName = rep.getStepAttributeString(id_step, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "password"));
            this.sourceFileFieldName = rep.getStepAttributeString(id_step, "sourceFileFieldName");
            this.remoteDirectoryFieldName = rep.getStepAttributeString(id_step, "remoteDirectoryFieldName");
            this.inputIsStream = rep.getStepAttributeBoolean(id_step, "inputIsStream");
            this.addFilenameResut = rep.getStepAttributeBoolean(id_step, "addFilenameResut");
            this.usekeyfilename = rep.getStepAttributeBoolean(id_step, "usekeyfilename");
            this.keyfilename = rep.getStepAttributeString(id_step, "keyfilename");
            this.keyfilepass = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "keyfilepass"));
            this.compression = rep.getStepAttributeString(id_step, "compression");
            this.proxyType = rep.getStepAttributeString(id_step, "proxyType");
            this.proxyHost = rep.getStepAttributeString(id_step, "proxyHost");
            this.proxyPort = rep.getStepAttributeString(id_step, "proxyPort");
            this.proxyUsername = rep.getStepAttributeString(id_step, "proxyUsername");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "proxyPassword"));
            this.createRemoteFolder = rep.getStepAttributeBoolean(id_step, "createRemoteFolder");
            boolean remove = rep.getStepAttributeBoolean(id_step, "remove");
            this.setAfterFTPS(JobEntrySFTPPUT.getAfterSFTPPutByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "aftersftpput"), (String)"")));
            if (remove && this.getAfterFTPS() == 0) {
                this.setAfterFTPS(1);
            }
            this.destinationfolderFieldName = rep.getStepAttributeString(id_step, "destinationfolderFieldName");
            this.createDestinationFolder = rep.getStepAttributeBoolean(id_step, "createdestinationfolder");
            this.remoteFilenameFieldName = rep.getStepAttributeString(id_step, "remoteFilenameFieldName");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "servername", this.serverName);
            rep.saveStepAttribute(id_transformation, id_step, "serverport", this.serverPort);
            rep.saveStepAttribute(id_transformation, id_step, "username", this.userName);
            rep.saveStepAttribute(id_transformation, id_step, "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveStepAttribute(id_transformation, id_step, "sourceFileFieldName", this.sourceFileFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "remoteDirectoryFieldName", this.remoteDirectoryFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "inputIsStream", this.inputIsStream);
            rep.saveStepAttribute(id_transformation, id_step, "addFilenameResut", this.addFilenameResut);
            rep.saveStepAttribute(id_transformation, id_step, "usekeyfilename", this.usekeyfilename);
            rep.saveStepAttribute(id_transformation, id_step, "keyfilename", this.keyfilename);
            rep.saveStepAttribute(id_transformation, id_step, "keyfilepass", Encr.encryptPasswordIfNotUsingVariables((String)this.keyfilepass));
            rep.saveStepAttribute(id_transformation, id_step, "compression", this.compression);
            rep.saveStepAttribute(id_transformation, id_step, "proxyType", this.proxyType);
            rep.saveStepAttribute(id_transformation, id_step, "proxyHost", this.proxyHost);
            rep.saveStepAttribute(id_transformation, id_step, "proxyPort", this.proxyPort);
            rep.saveStepAttribute(id_transformation, id_step, "proxyUsername", this.proxyUsername);
            rep.saveStepAttribute(id_transformation, id_step, "proxyPassword", Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword));
            rep.saveStepAttribute(id_transformation, id_step, "aftersftpput", JobEntrySFTPPUT.getAfterSFTPPutCode(this.getAfterFTPS()));
            rep.saveStepAttribute(id_transformation, id_step, "createRemoteFolder", this.createRemoteFolder);
            rep.saveStepAttribute(id_transformation, id_step, "destinationfolderFieldName", this.destinationfolderFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "createdestinationfolder", this.createDestinationFolder);
            rep.saveStepAttribute(id_transformation, id_step, "remoteFilenameFieldName", this.remoteFilenameFieldName);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"SFTPPutMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SFTPPutMeta.CheckResult.StepRecevingData", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SFTPPutMeta.CheckResult.StepRecevingData2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SFTPPutMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new SFTPPut(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SFTPPutData();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public int getAfterFTPS() {
        return this.afterFTPS;
    }

    public void setAfterFTPS(int value) {
        this.afterFTPS = value;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public boolean isUseKeyFile() {
        return this.usekeyfilename;
    }

    public void setUseKeyFile(boolean value) {
        this.usekeyfilename = value;
    }

    public String getKeyFilename() {
        return this.keyfilename;
    }

    public void setKeyFilename(String value) {
        this.keyfilename = value;
    }

    public String getKeyPassPhrase() {
        return this.keyfilepass;
    }

    public void setKeyPassPhrase(String value) {
        this.keyfilepass = value;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(String value) {
        this.proxyType = value;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String value) {
        this.proxyHost = value;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String value) {
        this.proxyPort = value;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String value) {
        this.proxyUsername = value;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String value) {
        this.proxyPassword = value;
    }

    public boolean isCreateRemoteFolder() {
        return this.createRemoteFolder;
    }

    public void setCreateRemoteFolder(boolean value) {
        this.createRemoteFolder = value;
    }

    public boolean isAddFilenameResut() {
        return this.addFilenameResut;
    }

    public void setAddFilenameResut(boolean addFilenameResut) {
        this.addFilenameResut = addFilenameResut;
    }

    public boolean isInputStream() {
        return this.inputIsStream;
    }

    public void setInputStream(boolean value) {
        this.inputIsStream = value;
    }

    public void setCreateDestinationFolder(boolean createDestinationFolder) {
        this.createDestinationFolder = createDestinationFolder;
    }

    public boolean isCreateDestinationFolder() {
        return this.createDestinationFolder;
    }

    public String getRemoteDirectoryFieldName() {
        return this.remoteDirectoryFieldName;
    }

    public void setRemoteDirectoryFieldName(String value) {
        this.remoteDirectoryFieldName = value;
    }

    public void setSourceFileFieldName(String value) {
        this.sourceFileFieldName = value;
    }

    public String getSourceFileFieldName() {
        return this.sourceFileFieldName;
    }

    public void setDestinationFolderFieldName(String value) {
        this.destinationfolderFieldName = value;
    }

    public String getDestinationFolderFieldName() {
        return this.destinationfolderFieldName;
    }

    public String getRemoteFilenameFieldName() {
        return this.remoteFilenameFieldName;
    }

    public void setRemoteFilenameFieldName(String value) {
        this.remoteFilenameFieldName = value;
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

