/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.encoder.Encode;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.WebResult;

public class StopJobServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static Class<?> PKG = StopJobServlet.class;
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/stopJob";

    public StopJobServlet() {
    }

    public StopJobServlet(JobMap jobMap) {
        super(jobMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"StopJobServlet.log.StopJobRequested", (String[])new String[0]));
        }
        String jobName = request.getParameter("name");
        String id = request.getParameter("id");
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        PrintWriter out = response.getWriter();
        try {
            Job job;
            if (useXML) {
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
            } else {
                response.setContentType("text/html;charset=UTF-8");
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<TITLE>Stop job</TITLE>");
                out.println("<META http-equiv=\"Refresh\" content=\"2;url=" + this.convertContextPath("/kettle/jobStatus") + "?name=" + URLEncoder.encode(jobName, "UTF-8") + "\">");
                out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                out.println("</HEAD>");
                out.println("<BODY>");
            }
            if (Utils.isEmpty((CharSequence)id)) {
                CarteObjectEntry entry = this.getJobMap().getFirstCarteObjectEntry(jobName);
                if (entry == null) {
                    job = null;
                } else {
                    id = entry.getId();
                    job = this.getJobMap().getJob(entry);
                }
            } else {
                CarteObjectEntry entry = new CarteObjectEntry(jobName, id);
                job = this.getJobMap().getJob(entry);
            }
            if (job != null) {
                job.stopAll();
                String message = BaseMessages.getString(PKG, (String)"JobStatusServlet.Log.JobStopRequested", (String[])new String[]{jobName});
                if (useXML) {
                    out.println(new WebResult("OK", message).getXML());
                } else {
                    out.println("<H1>" + Encode.forHtml((String)message) + "</H1>");
                    out.println("<a href=\"" + this.convertContextPath("/kettle/jobStatus") + "?name=" + URLEncoder.encode(jobName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">" + BaseMessages.getString(PKG, (String)"JobStatusServlet.BackToJobStatusPage", (String[])new String[0]) + "</a><p>");
                }
            } else {
                String message = BaseMessages.getString(PKG, (String)"StopJobServlet.Log.CoundNotFindJob", (String[])new String[]{jobName});
                if (useXML) {
                    out.println(new WebResult("ERROR", message).getXML());
                } else {
                    out.println("<H1>" + Encode.forHtml((String)message) + "</H1>");
                    out.println("<a href=\"" + this.convertContextPath("/kettle/status") + ">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
                    response.setStatus(400);
                }
            }
        }
        catch (Exception ex) {
            if (useXML) {
                out.println(new WebResult("ERROR", Const.getStackTracker((Throwable)ex)).getXML());
            }
            out.println("<p>");
            out.println("<pre>");
            out.println(Encode.forHtml((String)Const.getStackTracker((Throwable)ex)));
            out.println("</pre>");
            response.setStatus(400);
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Stop job";
    }

    @Override
    public String getService() {
        return "/kettle/stopJob (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

