CREATE OR REPLACE PROCEDURE proc_upgrade_delete_base_class_columns()
AS
    sqlStr VARCHAR(4000);
    Rows1 INT;
    classNamePostfix VARCHAR(256);
    CURSOR metaAttrs IS SELECT ID, NAME from meta_attr where name in ('collectorId', 'reportSn');
BEGIN
    for metaAttr in metaAttrs loop
        sqlStr := CONCAT('DELETE FROM META_CLASS_TO_ATTR WHERE ATTR_ID = ', metaAttr.ID);
        EXECUTE IMMEDIATE sqlStr;
        COMMIT;
    END LOOP;
    Rows1 := 0;
    SELECT COUNT(*) INTO Rows1 FROM MY_TAB_COLS WHERE TABLE_NAME='BASE_CLASS' AND COLUMN_NAME='collectorId';
    IF Rows1 > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE BASE_CLASS DROP COLUMN `collectorId`';
    END IF;
    
    Rows1 := 0;
    SELECT COUNT(*) INTO Rows1 FROM MY_TAB_COLS WHERE TABLE_NAME='BASE_CLASS' AND COLUMN_NAME='reportSn';
    IF Rows1 > 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE BASE_CLASS DROP COLUMN `reportSn`';
    END IF;
END;
/

CREATE OR REPLACE PROCEDURE proc_upgrade_add_base_class_history_time()
AS
    isExists INT;
BEGIN
    EXECUTE IMMEDIATE 'MERGE INTO META_ATTR A USING (
    select 2 as ID,''id'' as NAME, ''INSTANCE ID'' as DESCRIPTION, ''uuid'' as DATA_TYPE,TRUE as IS_UNIQUE,TRUE as MANDATORY,FALSE as WRITEABLE,0 as LEN, ''{"zh_CN":"ID","en_US":"ID"}'' AS DISPLAY_NAME, FALSE as CUSTOM from SYS_DUMMY
    UNION ALL
    select 3 as ID,''class_Name'' as NAME,''CLASS NAME'' as DESCRIPTION, ''string'' as DATA_TYPE,FALSE as IS_UNIQUE,TRUE as MANDATORY,FALSE as WRITEABLE,60 as LEN, ''{"zh_CN":"CI类型名","en_US":"Class Name"}'' AS DISPLAY_NAME,FALSE as CUSTOM from SYS_DUMMY
    UNION ALL
    select 4 as ID,''class_Id'' as NAME,''CLASS ID'' as DESCRIPTION, ''long'' as DATA_TYPE,FALSE as IS_UNIQUE,TRUE as MANDATORY,FALSE as WRITEABLE,0 as LEN, ''{"zh_CN":"CI类型ID","en_US":"Class ID"}'' AS DISPLAY_NAME, FALSE as CUSTOM from SYS_DUMMY
    UNION ALL
    select 5 as ID,''last_Modified'' as NAME,''LAST MODIFIED'' as DESCRIPTION, ''long'' as DATA_TYPE,FALSE as IS_UNIQUE,TRUE as MANDATORY,TRUE as WRITEABLE,0 as LEN, ''{"zh_CN":"最近修改时间","en_US":"Last Modified"}'' AS DISPLAY_NAME, FALSE as CUSTOM from SYS_DUMMY
    UNION ALL
    select 6 as ID,''status_marker'' as NAME,''STATUS MARKER'' as DESCRIPTION, ''long'' as DATA_TYPE,FALSE as IS_UNIQUE,TRUE as MANDATORY,TRUE as WRITEABLE,0 as LEN, ''{"zh_CN":"状态标识","en_US":"Status Marker"}'' AS DISPLAY_NAME,FALSE as CUSTOM from SYS_DUMMY
    UNION ALL
    select 7 as ID,''history_begin_time'' as NAME,''HISTORY BEGIN TIME'' as DESCRIPTION, ''long'' as DATA_TYPE,FALSE as IS_UNIQUE,TRUE as MANDATORY,TRUE as WRITEABLE,0 as LEN, ''{"zh_CN":"历史起始时间","en_US":"History Begin Time"}'' AS DISPLAY_NAME, FALSE as CUSTOM from SYS_DUMMY
    UNION ALL
    select 8 as ID,''history_end_time'' as NAME,''HISTORY END TIME'' as DESCRIPTION, ''long'' as DATA_TYPE,FALSE as IS_UNIQUE,TRUE as MANDATORY,TRUE as WRITEABLE,0 as LEN, ''{"zh_CN":"历史终止时间","en_US":"History End Time"}'' AS DISPLAY_NAME, FALSE as CUSTOM from SYS_DUMMY
    UNION ALL
    select 9 as ID,''tenantId'' as NAME,''Tenant ID'' as DESCRIPTION, ''string'' as DATA_TYPE,FALSE as IS_UNIQUE,FALSE as MANDATORY,TRUE as WRITEABLE,64 as LEN, ''{"zh_CN":"租户ID","en_US":"Tenant ID"}'' AS DISPLAY_NAME, FALSE as CUSTOM from SYS_DUMMY
    ) B ON (A.ID=B.ID) 
    WHEN MATCHED THEN UPDATE SET A.NAME=B.NAME,A.DESCRIPTION=B.DESCRIPTION,A.DATA_TYPE=B.DATA_TYPE,A.IS_UNIQUE=B.IS_UNIQUE,A.MANDATORY=B.MANDATORY,A.WRITEABLE=B.WRITEABLE,A.LEN=B.LEN,A.DISPLAY_NAME=B.DISPLAY_NAME,A.CUSTOM=B.CUSTOM
    WHEN NOT MATCHED THEN INSERT (ID,NAME,DESCRIPTION,DATA_TYPE,IS_UNIQUE,MANDATORY,WRITEABLE,LEN,DISPLAY_NAME,CUSTOM) VALUES (B.ID,B.NAME,B.DESCRIPTION,B.DATA_TYPE,B.IS_UNIQUE,B.MANDATORY,B.WRITEABLE,B.LEN,B.DISPLAY_NAME,B.CUSTOM)';
    
    EXECUTE IMMEDIATE 'MERGE INTO META_CLASS_TO_ATTR A USING (
    select 1 as CLASS_ID,2 as ATTR_ID, 1 as VERSION_ID from SYS_DUMMY
    UNION ALL
    select 1 as CLASS_ID,3 as ATTR_ID, 2 as VERSION_ID from SYS_DUMMY
    UNION ALL
    select 1 as CLASS_ID,4 as ATTR_ID, 3 as VERSION_ID from SYS_DUMMY
    UNION ALL
    select 1 as CLASS_ID,5 as ATTR_ID, 4 as VERSION_ID from SYS_DUMMY
    UNION ALL
    select 1 as CLASS_ID,6 as ATTR_ID, 5 as VERSION_ID from SYS_DUMMY
    UNION ALL
    select 1 as CLASS_ID,7 as ATTR_ID, 6 as VERSION_ID from SYS_DUMMY
    UNION ALL
    select 1 as CLASS_ID,8 as ATTR_ID, 7 as VERSION_ID from SYS_DUMMY
    UNION ALL
    select 1 as CLASS_ID,9 as ATTR_ID, 8 as VERSION_ID from SYS_DUMMY   
    ) B ON (A.CLASS_ID=B.CLASS_ID AND A.ATTR_ID=B.ATTR_ID) 
    WHEN MATCHED THEN UPDATE SET A.CLASS_ID=B.CLASS_ID,A.ATTR_ID=B.ATTR_ID,A.VERSION_ID=B.VERSION_ID
    WHEN NOT MATCHED THEN INSERT (CLASS_ID, ATTR_ID, VERSION_ID) VALUES (B.CLASS_ID, B.ATTR_ID, B.VERSION_ID)';
	
    SELECT COUNT(1) INTO isExists FROM META_ATTR WHERE NAME = 'sandbox_id' AND ID = 10;
    IF isExists > 0 THEN
    	EXECUTE IMMEDIATE 'DELETE FROM META_CLASS_TO_ATTR WHERE CLASS_ID = 1 AND ATTR_ID = 10';
    END IF;
    COMMIT;
END;
/

CREATE OR REPLACE PROCEDURE proc_upgrade_add_base_class_history_time_column()
AS
    Rows1 INT;
BEGIN
    Rows1 := 0;
    SELECT COUNT(*) INTO Rows1  FROM MY_TABLES WHERE TABLE_NAME='BASE_CLASS';
    IF Rows1 > 0 THEN
        Rows1 := 0;
        SELECT COUNT(*) INTO Rows1 FROM MY_TAB_COLS WHERE TABLE_NAME='BASE_CLASS' AND COLUMN_NAME='history_begin_time';
        IF Rows1 <= 0 THEN
            EXECUTE IMMEDIATE 'ALTER TABLE BASE_CLASS ADD `history_begin_time` BIGINT NOT NULL DEFAULT 0';
        END IF;

        Rows1 := 0;
        SELECT COUNT(*) INTO Rows1 FROM MY_TAB_COLS WHERE TABLE_NAME='BASE_CLASS' AND COLUMN_NAME='history_end_time';
        IF Rows1 <= 0 THEN
            EXECUTE IMMEDIATE 'ALTER TABLE BASE_CLASS ADD `history_end_time` BIGINT NOT NULL DEFAULT -1';
        END IF;
    END IF;
END;
/

CREATE OR REPLACE PROCEDURE proc_upgrade_add_base_relation_history_time()
AS
BEGIN
    EXECUTE IMMEDIATE 'MERGE INTO META_ATTR A USING (
    select 102 as ID,''id'' as NAME,''ID'' as DESCRIPTION,''uuid'' as DATA_TYPE,TRUE as IS_UNIQUE,TRUE as MANDATORY,FALSE as WRITEABLE,0 as LEN, ''{"zh_CN":"ID","en_US":"ID"}'' AS DISPLAY_NAME, FALSE as CUSTOM from SYS_DUMMY
    UNION ALL
    select 103 as ID,''relation_Name'' as NAME,''RELATION NAME'' as DESCRIPTION,''string'' as DATA_TYPE,FALSE as IS_UNIQUE,TRUE as MANDATORY,FALSE as WRITEABLE,60 as LEN, ''{"zh_CN":"CI关系类型名","en_US":"Relation Name"}'' AS DISPLAY_NAME, FALSE as CUSTOM from SYS_DUMMY
    UNION ALL
    select 104 as ID,''relation_Id'' as NAME,''RELATION ID'' as DESCRIPTION,''long'' as DATA_TYPE,FALSE as IS_UNIQUE,TRUE as MANDATORY,FALSE as WRITEABLE,0 as LEN, ''{"zh_CN":"CI关系类型ID","en_US":"Relation ID"}'' AS DISPLAY_NAME, FALSE as CUSTOM from SYS_DUMMY
    UNION ALL
    select 105 as ID,''source_Instance_Id'' as NAME,''SOURCE INSTANCE ID'' as DESCRIPTION,''uuid'' as DATA_TYPE,FALSE as IS_UNIQUE,TRUE as MANDATORY,FALSE as WRITEABLE,0 as LEN, ''{"zh_CN":"源端CI实例ID","en_US":"Source Instance ID"}'' AS DISPLAY_NAME, FALSE as CUSTOM from SYS_DUMMY
    UNION ALL
    select 106 as ID,''target_Instance_Id'' as NAME,''TARGET INSTANCE ID'' as DESCRIPTION,''uuid'' as DATA_TYPE,FALSE as IS_UNIQUE,TRUE as MANDATORY,FALSE as WRITEABLE,0 as LEN, ''{"zh_CN":"目的端CI实例ID","en_US":"Target Instance ID"}'' AS DISPLAY_NAME, FALSE as CUSTOM from SYS_DUMMY
    UNION ALL
    select 107 as ID,''last_Modified'' as NAME,''LAST MODIFIED'' as DESCRIPTION,''long'' as DATA_TYPE,FALSE as IS_UNIQUE,TRUE as MANDATORY,TRUE as WRITEABLE,0 as LEN, ''{"zh_CN":"最近修改时间","en_US":"Last Modified"}'' AS DISPLAY_NAME, FALSE as CUSTOM from SYS_DUMMY
    UNION ALL
    select 108 as ID,''sandbox_id'' as NAME,''SANDBOX ID'' as DESCRIPTION,''long'' as DATA_TYPE,FALSE as IS_UNIQUE,TRUE as MANDATORY,FALSE as WRITEABLE,0 as LEN, ''{"zh_CN":"CI沙箱ID","en_US":"Sandbox ID"}'' AS DISPLAY_NAME, FALSE as CUSTOM from SYS_DUMMY
    UNION ALL
    select 109 as ID,''status_marker'' as NAME,''STATUS MARKER'' as DESCRIPTION,''long'' as DATA_TYPE,FALSE as IS_UNIQUE,TRUE as MANDATORY,FALSE as WRITEABLE,0 as LEN, ''{"zh_CN":"状态标识","en_US":"Status Marker"}'' AS DISPLAY_NAME, FALSE as CUSTOM from SYS_DUMMY
    UNION ALL
    select 110 as ID,''history_begin_time'' as NAME,''HISTORY BEGIN TIME'' as DESCRIPTION,''long'' as DATA_TYPE,FALSE as IS_UNIQUE,TRUE as MANDATORY,FALSE as WRITEABLE,0 as LEN, ''{"zh_CN":"历史起始时间","en_US":"History Begin Time"}'' AS DISPLAY_NAME, FALSE as CUSTOM from SYS_DUMMY
    UNION ALL
    select 111 as ID,''history_end_time'' as NAME,''HISTORY END TIME'' as DESCRIPTION,''long'' as DATA_TYPE,FALSE as IS_UNIQUE,TRUE as MANDATORY,FALSE as WRITEABLE,0 as LEN, ''{"zh_CN":"历史结束时间","en_US":"History End Time"}'' AS DISPLAY_NAME, FALSE as CUSTOM from SYS_DUMMY
    UNION ALL
    select 112 as ID,''tenantId'' as NAME,''Tenant ID'' as DESCRIPTION,''string'' as DATA_TYPE,FALSE as IS_UNIQUE,FALSE as MANDATORY,TRUE as WRITEABLE,64 as LEN, ''{"zh_CN":"租户ID","en_US":"Tenant ID"}'' AS DISPLAY_NAME, FALSE as CUSTOM from SYS_DUMMY
    ) B ON (A.ID=B.ID) 
WHEN MATCHED THEN UPDATE SET A.NAME=B.NAME,A.DESCRIPTION=B.DESCRIPTION,A.DATA_TYPE=B.DATA_TYPE,A.IS_UNIQUE=B.IS_UNIQUE,A.MANDATORY=B.MANDATORY,A.WRITEABLE=B.WRITEABLE,A.LEN=B.LEN,A.DISPLAY_NAME=B.DISPLAY_NAME,A.CUSTOM=B.CUSTOM
WHEN NOT MATCHED THEN INSERT (ID,NAME,DESCRIPTION,DATA_TYPE,IS_UNIQUE,MANDATORY,WRITEABLE,LEN,DISPLAY_NAME,CUSTOM) VALUES (B.ID,B.NAME,B.DESCRIPTION,B.DATA_TYPE,B.IS_UNIQUE,B.MANDATORY,B.WRITEABLE,B.LEN,B.DISPLAY_NAME,B.CUSTOM)';

    EXECUTE IMMEDIATE 'MERGE INTO META_RELATION_TO_ATTR A USING (
    select 101 as RELATION_ID,102 as ATTR_ID, 100 as VERSION_ID from SYS_DUMMY
    UNION ALL
    select 101 as RELATION_ID,103 as ATTR_ID, 101 as VERSION_ID  from SYS_DUMMY
    UNION ALL
    select 101 as RELATION_ID,104 as ATTR_ID, 102 as VERSION_ID  from SYS_DUMMY
    UNION ALL
    select 101 as RELATION_ID,105 as ATTR_ID, 103 as VERSION_ID  from SYS_DUMMY
    UNION ALL
    select 101 as RELATION_ID,106 as ATTR_ID, 104 as VERSION_ID  from SYS_DUMMY
    UNION ALL
    select 101 as RELATION_ID,107 as ATTR_ID, 105 as VERSION_ID  from SYS_DUMMY
    UNION ALL
    select 101 as RELATION_ID,108 as ATTR_ID, 106 as VERSION_ID  from SYS_DUMMY
    UNION ALL
    select 101 as RELATION_ID,109 as ATTR_ID, 107 as VERSION_ID  from SYS_DUMMY
    UNION ALL
    select 101 as RELATION_ID,110 as ATTR_ID, 108 as VERSION_ID  from SYS_DUMMY
    UNION ALL
    select 101 as RELATION_ID,111 as ATTR_ID, 109 as VERSION_ID  from SYS_DUMMY
    UNION ALL
    select 101 as RELATION_ID,112 as ATTR_ID, 110 as VERSION_ID  from SYS_DUMMY 
    ) B ON (A.RELATION_ID=B.RELATION_ID AND A.ATTR_ID=B.ATTR_ID) 
    WHEN MATCHED THEN UPDATE SET A.RELATION_ID=B.RELATION_ID, A.ATTR_ID=B.ATTR_ID, A.VERSION_ID=B.VERSION_ID
    WHEN NOT MATCHED THEN INSERT (RELATION_ID, ATTR_ID, VERSION_ID) VALUES (B.RELATION_ID, B.ATTR_ID, B.VERSION_ID)';
    COMMIT;
END;
/

CREATE OR REPLACE PROCEDURE proc_upgrade_delete_relation_model_and_table()
AS
    Rows1 INT;
    sqlStr VARCHAR(4000);
    relationNamePostfix VARCHAR(256);
    CURSOR metaRelations IS SELECT ID, NAME from meta_relation where name != '#baseRelation';
BEGIN
    Rows1 := 0;
    SELECT COUNT(*) INTO Rows1 FROM MY_TABLES WHERE TABLE_NAME='T_EDGE';
    IF Rows1 > 0 THEN
        EXECUTE IMMEDIATE 'DROP TABLE IF EXISTS T_EDGE';
    END IF;
            
    for metaRelation in metaRelations loop
        SELECT REGEXP_SUBSTR(SUBSTRING_INDEX(metaRelation.NAME,'_',-1), '^[[:digit:]]+$') INTO relationNamePostfix FROM sys_dummy;
        IF relationNamePostfix IS NULL OR LENGTH(relationNamePostfix) = 0 THEN
            sqlStr := CONCAT('DELETE FROM META_RELATION WHERE ID = ', metaRelation.ID);
            EXECUTE IMMEDIATE sqlStr;
            COMMIT;
        END IF;
    END LOOP;
END;
/

CREATE OR REPLACE PROCEDURE proc_upgrade_delete_resource_model_and_table()
AS
    sqlStr VARCHAR(4000);
    classNamePostfix VARCHAR(256);
    CURSOR metaClasses IS SELECT ID, NAME from meta_class where name != 'BaseClass';
BEGIN
    for metaClass in metaClasses loop
        SELECT REGEXP_SUBSTR(SUBSTRING_INDEX(metaClass.NAME,'_',-1), '^[[:digit:]]+$') INTO classNamePostfix FROM sys_dummy;
        IF classNamePostfix IS NULL OR LENGTH(classNamePostfix) = 0 THEN
            sqlStr := CONCAT('DROP TABLE IF EXISTS I_', metaClass.NAME);
            EXECUTE IMMEDIATE sqlStr;
            sqlStr := CONCAT('DELETE FROM META_CLASS WHERE ID = ', metaClass.ID);
            EXECUTE IMMEDIATE sqlStr;
            COMMIT;
        END IF;
    END LOOP;
END;
/

CREATE OR REPLACE PROCEDURE proc_upgrade_sandbox_management_rule_column()
AS
    concatSqlStr VARCHAR(4000);
    dataType     VARCHAR(128);
    counter INT;
BEGIN
    SELECT COUNT(1) INTO counter FROM MY_TAB_COLUMNS WHERE TABLE_NAME = 'SANDBOX_MANAGEMENT' AND COLUMN_NAME = 'RULE';
    IF counter > 0 THEN
        SELECT data_type INTO dataType FROM MY_TAB_COLUMNS WHERE TABLE_NAME = 'SANDBOX_MANAGEMENT' AND COLUMN_NAME = 'RULE';
        IF dataType = 'VARCHAR' THEN
            SELECT COUNT(1) INTO counter FROM MY_TAB_COLUMNS WHERE TABLE_NAME = 'SANDBOX_MANAGEMENT' AND COLUMN_NAME = 'RULE_BAK';
            IF counter <= 0 THEN
                concatSqlStr := 'ALTER TABLE SANDBOX_MANAGEMENT RENAME COLUMN RULE TO RULE_BAK';
                EXECUTE IMMEDIATE concatSqlStr;
            END IF;
        END IF;
    END IF;

    SELECT COUNT(1) INTO counter FROM MY_TAB_COLUMNS WHERE TABLE_NAME = 'SANDBOX_MANAGEMENT' AND COLUMN_NAME = 'RULE';
    IF counter <= 0 THEN
        concatSqlStr := 'ALTER TABLE SANDBOX_MANAGEMENT ADD COLUMN RULE CLOB DEFAULT NULL';
        EXECUTE IMMEDIATE concatSqlStr;
    END IF;

    SELECT COUNT(1) INTO counter FROM MY_TAB_COLUMNS WHERE TABLE_NAME = 'SANDBOX_MANAGEMENT' AND COLUMN_NAME = 'RULE';
    IF counter > 0 THEN
        SELECT COUNT(1) INTO counter FROM MY_TAB_COLUMNS WHERE TABLE_NAME = 'SANDBOX_MANAGEMENT' AND COLUMN_NAME = 'RULE_BAK';
        IF counter > 0 THEN
            concatSqlStr := 'UPDATE SANDBOX_MANAGEMENT SET RULE = RULE_BAK';
            EXECUTE IMMEDIATE concatSqlStr;
        END IF;
    END IF;

    SELECT COUNT(1) INTO counter FROM MY_TAB_COLUMNS WHERE TABLE_NAME = 'SANDBOX_MANAGEMENT' AND COLUMN_NAME = 'RULE_BAK';
    IF counter > 0 THEN
        concatSqlStr := 'ALTER TABLE SANDBOX_MANAGEMENT DROP COLUMN RULE_BAK';
        EXECUTE IMMEDIATE concatSqlStr;
    END IF;
END;
/

CREATE OR REPLACE PROCEDURE proc_upgrade_invmirrordb()
AS
    counter INT;
    concatSqlStr VARCHAR(4000);
BEGIN
    SELECT COUNT(1) INTO counter FROM MY_TAB_COLUMNS WHERE TABLE_NAME = 'CONFIGURE_CUSTOM';
    IF counter > 0 THEN
        concatSqlStr := 'TRUNCATE TABLE CONFIGURE_CUSTOM';
        EXECUTE IMMEDIATE concatSqlStr;
    END IF;
    EXECUTE IMMEDIATE 'CALL proc_upgrade_delete_base_class_columns()';
    EXECUTE IMMEDIATE 'CALL proc_upgrade_add_base_class_history_time()';
    EXECUTE IMMEDIATE 'CALL proc_upgrade_add_base_class_history_time_column()';
    EXECUTE IMMEDIATE 'CALL proc_upgrade_add_base_relation_history_time()';
    EXECUTE IMMEDIATE 'CALL proc_upgrade_delete_relation_model_and_table()';
    EXECUTE IMMEDIATE 'CALL proc_upgrade_delete_resource_model_and_table()';
    EXECUTE IMMEDIATE 'CALL proc_upgrade_sandbox_management_rule_column()';
END;
/
CALL proc_upgrade_invmirrordb()
/

DROP PROCEDURE IF EXISTS proc_upgrade_delete_base_class_columns
/
DROP PROCEDURE IF EXISTS proc_upgrade_add_base_class_history_time
/
DROP PROCEDURE IF EXISTS proc_upgrade_add_base_class_history_time_column
/
DROP PROCEDURE IF EXISTS proc_upgrade_add_base_relation_history_time
/
DROP PROCEDURE IF EXISTS proc_upgrade_delete_relation_model_and_table
/
DROP PROCEDURE IF EXISTS proc_upgrade_delete_resource_model_and_table
/
DROP PROCEDURE IF EXISTS proc_upgrade_sandbox_management_rule_column
/
DROP PROCEDURE IF EXISTS proc_upgrade_invmirrordb
/