#!/bin/bash

#
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
#

handle_type=$1
log "handle_type is : ${handle_type}"
run_log=${MIGRATE_DATA_DIR}/logs/run.log
OLD_SERVICE=Product-NorthboundCommunicationService
NEW_SERVICE=NBIFrmNotifyService
CERT_FILE_BACK_PATH=${MIGRATE_DATA_DIR}/data/file/NorthboundCommunicationService

function export_nbi_cert_file()
{
    LATEST_APP_DIR=$(ls -lt /opt/oss/envs/${OLD_SERVICE}/ | tail -1 | awk '{print $9}')
    # 如果证书目录不存在，则不做导出动作
    if [[ ! -d /opt/oss/envs/${OLD_SERVICE}/${LATEST_APP_DIR}/etc/ssl/er/ ]] || [[ ! -d /opt/oss/envs/${OLD_SERVICE}/${LATEST_APP_DIR}/controller/configuration/ ]]
    then
        log "etc or controller certificate manager is not exist."
        return
    fi 
        
    if [[ ! -d ${CERT_FILE_BACK_PATH} ]]; then
        mkdir -p ${CERT_FILE_BACK_PATH}
        chmod -R 777 ${CERT_FILE_BACK_PATH}/../
    fi
    # 把证书copy到CERT_FILE_BACK_PATH目录
    log "begin upgrade the certificate."
    # 拷贝证书前，先将目录清空
    sudo -u ossuser sh -c "rm -rf ${CERT_FILE_BACK_PATH}/*"
    sudo -u ossuser sh -c "cp -rf /opt/oss/envs/${OLD_SERVICE}/${LATEST_APP_DIR}/etc/ssl/er ${CERT_FILE_BACK_PATH}"
    sudo -u ossuser sh -c "cp -rf /opt/oss/envs/${OLD_SERVICE}/${LATEST_APP_DIR}/controller/configuration/cert ${CERT_FILE_BACK_PATH}"
    sudo -u ossuser sh -c "chmod 770 ${CERT_FILE_BACK_PATH}/cert ${CERT_FILE_BACK_PATH}/er"
    sudo -u ossuser sh -c "chmod 640 ${CERT_FILE_BACK_PATH}/*/*"
}

function convert_ipv6()
{
    tmp_ip=$1
    if [[ $tmp_ip =~ "[" ]]; then
        echo ${tmp_ip}
    elif [[ "$tmp_ip" != "${tmp_ip#*[0-9].[0-9]}" ]]; then
        echo ${tmp_ip}
    elif [[ "$tmp_ip" != "${tmp_ip#*:[0-9a-fA-F]}" ]];then
        echo "[${tmp_ip}]"
    else
        echo ${tmp_ip}
    fi
}

function import_nbi_cert_file()
{
    NCE_PRODUCT_NAME=$(python -c "from uniep.utils.node import nodelist; tenant=[ten for ten in nodelist.get_all_tenants() if ten != 'manager']; print(tenant[0])")
    NCE_APP_SHARE=${_APP_SHARE_DIR}/../../${NCE_PRODUCT_NAME}
    get_service_nodes_ip_file_dir=${MIGRATE_ROOT}/src/utils/get_service_nodesip.py
    nbi_service_share=$(ls -d ${NCE_APP_SHARE}/${NEW_SERVICE} 2>/dev/null | head -n1)
    if [[ ! -z "${nbi_service_share}" ]]
    then
        log "nbi_service_share is: ${nbi_service_share}"
        export SERVICE_SHARE_DIR=${nbi_service_share}
    else
        log "nbi_service_share is null."
        return
    fi
    
    # 获取目标服务所在节点
    nbi_service_ip_list=$(/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global |grep nbifrmnotifyservice | awk '$3=="NBIFrmNotifyService" {print $6}')
    log "nbi_service_ip_list is ${nbi_service_ip_list}"
    if [[ -z "$nbi_service_ip_list" ]]
    then
        nbi_service_ip_list=$(python ${get_service_nodes_ip_file_dir} ${NCE_PRODUCT_NAME} ${NEW_SERVICE})
        if [[ -z "${nbi_service_ip_list}" ]]
        then
            log "nbi_service_ip_list not exist."
            return
        fi
    fi

    # 把证书从源节点copy到目标节点指定目录，并修改属组和权限
    for service_ip in ${nbi_service_ip_list}
    do
        log "execute ip: ${service_ip}"
        scp -r -o 'StrictHostKeyChecking no' -o 'BatchMode yes' -o 'ConnectTimeout 5' ${CERT_FILE_BACK_PATH} $(convert_ipv6 ${service_ip}):/tmp/
        ssh -o StrictHostKeyChecking=no ossadm@${service_ip} << EOF
sudo -u ossuser sh -c "mkdir ${SERVICE_SHARE_DIR}/old"
sudo -u ossuser sh -c "chmod 700 ${SERVICE_SHARE_DIR}/old"
sudo -u ossuser sh -c "mkdir ${SERVICE_SHARE_DIR}/old/syslog"
sudo -u ossuser sh -c "mkdir ${SERVICE_SHARE_DIR}/old/kafka"
sudo -u ossuser sh -c "mkdir ${SERVICE_SHARE_DIR}/old/websocket"
sudo -u ossuser sh -c "chmod 700 ${SERVICE_SHARE_DIR}/old/syslog ${SERVICE_SHARE_DIR}/old/kafka ${SERVICE_SHARE_DIR}/old/websocket"
sudo -u ossuser sh -c "cp -rfp /tmp/NorthboundCommunicationService/er/server.jks ${SERVICE_SHARE_DIR}/old/syslog"
sudo -u ossuser sh -c "cp -rfp /tmp/NorthboundCommunicationService/cert/nb_cert.conf ${SERVICE_SHARE_DIR}/old/syslog"
sudo -u ossuser sh -c "cp -rfp /tmp/NorthboundCommunicationService/er/server.jks ${SERVICE_SHARE_DIR}/old/kafka"
sudo -u ossuser sh -c "cp -rfp /tmp/NorthboundCommunicationService/er/trust.jks ${SERVICE_SHARE_DIR}/old/kafka"
sudo -u ossuser sh -c "cp -rfp /tmp/NorthboundCommunicationService/cert/nb_cert.conf ${SERVICE_SHARE_DIR}/old/kafka"
sudo -u ossuser sh -c "cp -rfp /tmp/NorthboundCommunicationService/er/server.jks ${SERVICE_SHARE_DIR}/old/websocket"
sudo -u ossuser sh -c "cp -rfp /tmp/NorthboundCommunicationService/er/trust.jks ${SERVICE_SHARE_DIR}/old/websocket"
sudo -u ossuser sh -c "cp -rfp /tmp/NorthboundCommunicationService/cert/nb_cert.conf ${SERVICE_SHARE_DIR}/old/websocket"
sudo -u ossuser sh -c "chmod 600 ${SERVICE_SHARE_DIR}/old/syslog/* ${SERVICE_SHARE_DIR}/old/kafka/* ${SERVICE_SHARE_DIR}/old/websocket/*"
exit
EOF
    done
    # 删除tmp目录下的数据
    rm -rf /tmp/NorthboundCommunicationService/
}

if [[ ${handle_type} = 'import_data' ]]
then
    import_nbi_cert_file >> ${run_log} 2>&1
elif [[ ${handle_type} = 'export_data' ]]; then
    export_nbi_cert_file >> ${run_log} 2>&1
fi