#!/bin/bash
. ./controller.inc
################################################################################
# Function    : check_cpu_num
# Description : check the cpu_num.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_cpu_num
{
    #idle CPU
    total_cpu=`cat /proc/cpuinfo | grep "processor" | sort -u | wc -l`

    if [ "X${cpu_num}" == "X" ];then
		print_log "WARNING" "CPU num to be checked is not configured, skip check CPU num."
        return 0
    fi
	print_log "INFO" "Expected CPU num is ${cpu_num}."
    if [  $total_cpu -lt ${cpu_num} ]; then
		print_log "ERROR" "The logic CPU number is ${total_cpu}, less than ${cpu_num}."
        return 1
    fi
	print_log "INFO" "CPU check successfully. The logic CPU number is ${total_cpu}, Expected CPU number is ${cpu_num}."
    return 0
}