#!/bin/bash
. ./controller.inc
################################################################################
# Function    : check_node_ip_config
# Description : check the node ip config.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function get_networknumber()
{
    ip=$1
    mask=$2
    out=''
    for index in {1..4}; do
        si=$(echo $ip | cut -d "." -f $index)
        sm=$(echo $mask | cut -d "." -f $index)
        if [ $index -ne 1 ]; then
            out="$out."
        fi
        out="$out$[$si&$sm]"
    done
    echo $out
}

function check_ip_on_same_segment()
{
    ip1=$1
    ip2=$2
    mask=$3
    ip1_networknumber=`get_networknumber $ip1 $mask`
    ip2_networknumber=`get_networknumber $ip2 $mask`
    if [ ${ip1_networknumber} != ${ip2_networknumber} ]; then
        print_log "ERROR" "Please check whether the IP(${ip1}) is the same as network segment as the IP(${ip2})."
        ((error_fail_num=error_fail_num+1))
    fi
}

function compipv6(){
    orig_address=$1
    shortmode=`echo "${orig_address}" | grep -c "::"`
    allnum=`echo "${orig_address}" | grep -o ":" | wc -l`
    tmp=""
    if [ ${shortmode} -gt 0 ]; then
        len=`expr 9 - $allnum`
        for((i=1;i<len;i++)); 
        do   
          tmp=$tmp":0000"
        done
    fi
    tmp=$tmp":"
    address=${orig_address/::/$tmp}
    if [[ ${address:0:1} == ":"  ]]; then
        address="0000"$address
    fi
    
    if [[ ${address: -1} == ":"  ]]; then
        address=$address"0000"
    fi
      
    arr=(${address//:/ })
    alladdress=""
    for arrstr in ${arr[@]};   
    do    
        strlen=`echo $arrstr | wc -L`
        tmpstr=""
        if [[ $strlen == 1 ]];then
            tmpstr=':000'$arrstr
        elif [[ $strlen == 2 ]];then
            tmpstr=':00'$arrstr
        elif [[ $strlen == 3 ]];then
            tmpstr=':0'$arrstr
        else
            tmpstr=':'$arrstr
        fi
        alladdress=$alladdress$tmpstr
    done
    alladdress=${alladdress#:}
    echo $alladdress
}

function checkSameIpv6
{
    configIP=$1
	nodeIp=$2
	#벢תȫСд
	configIP=`compipv6 $configIP`
	configIP=`echo ${configIP,,}`
	nodeIp=`compipv6 $nodeIp`
	nodeIp=`echo ${nodeIp,,}`
    if [[ ${configIP} != ${nodeIp} ]]; then
       return 1
	else
		return 0
    fi
}

function check_node_ip_config
{
    typeset -i error_fail_num=0

    if [[ ${netcard_internal_single} != "" && ${netcard_internal_single} != "user_netcard_internal_single" ]];
    then
        internal_nic=${netcard_internal_single}
        south_nic=${netcard_internal_single}
        north_nic=${netcard_internal_single}
        bgp_netcard=${bgp_south_netcard_single}       
    elif [[ ${netcard_south_double} != "" ]] && [[ ${netcard_internal_double} != "" ]] && [[ ${netcard_internal_double} != "user_netcard_internal_double" ]];
    then
        internal_nic=${netcard_internal_double}
        south_nic=${netcard_south_double}
        north_nic=${netcard_internal_double}
        bgp_netcard=${bgp_south_netcard_double}
        second_south_nic=${netcard_second_south_double}
    elif [[ ${netcard_north_triple} != "" ]] && [[ ${netcard_north_triple} != "user_netcard_north_triple" ]] && [[ ${netcard_south_triple} != "" ]] && [[ ${netcard_internal_triple} != "" ]];
    then
        internal_nic=${netcard_internal_triple}
        south_nic=${netcard_south_triple}
        north_nic=${netcard_north_triple}
        bgp_netcard=${bgp_south_netcard_triple}
        second_south_nic=${netcard_second_south_triple}
    fi

    if [[ ${south_mask} != "" ]] || [[ ${north_mask} != "" ]];
    then
        north_vis_ip_mask=${north_mask}
        south_floatip_mask2=${south_mask}
    fi
    
    #ڲͨѶipv4У
    if [ "X${internal_netcard_ip}" != "X"  ];then
        internal_netcard_ip_check=`ifconfig ${internal_nic} | grep ${internal_netcard_ip}`
        if [[ -z ${internal_netcard_ip_check} ]]; then
            print_log "ERROR" "The internal netcard [${internal_nic}] may be wrong. Please check if the internal netcard of the internal ip [${internal_netcard_ip}] is [${internal_nic}]."
            ((error_fail_num=error_fail_num+1))
        fi
    fi 

    #ڲͨѶipv6У
    if [[ "${internal_netcard_ipv6}" != ""  ]] && [[ "${internal_netcard_ipv6}" != "user_internal_netcard_v6ip"  ]];then
        internal_netcard_ipv6_check=`ifconfig ${internal_nic} | grep -i ${internal_netcard_ipv6}`
        if [[ -z ${internal_netcard_ipv6_check} ]]; then
            internal_netcard_ipv6_node=`ifconfig ${internal_nic} | grep inet6 | grep -v link  | awk '/inet/ {print $2}'`
            typeset -i issameip=1
			for arrstr in ${internal_netcard_ipv6_node[@]};
			do
				 checkSameIpv6 $internal_netcard_ipv6 $arrstr
				if [[ $? -eq 0  ]]; then
					issameip=0
					break
				else
					issameip=1
				fi
			done
			if [[ $issameip != 0  ]]; then
				print_log "ERROR" "The internal netcard [${internal_nic}] may be wrong. Please check if the internal netcard of the internal ip [${internal_netcard_ipv6}] is [${internal_nic}]."
                ((error_fail_num=error_fail_num+1))
			fi
        fi
    fi 


    #ipv4У
    if [ "X${south_netcard_ip}" != "X"  ];then
        south_netcard_ip_check=`ifconfig ${south_nic} | grep ${south_netcard_ip}`
        if [[ -z ${south_netcard_ip_check} ]]; then
            print_log "ERROR" "The south netcard [${south_nic}] may be wrong. Please check if the south netcard of the south ip [${south_netcard_ip}] is [${south_nic}]."
            ((error_fail_num=error_fail_num+1))
        fi
    fi    

    #ipv6У
    if  [[ "${south_netcard_ipv6}" != ""  ]] && [[ "${south_netcard_ipv6}" != "user_south_netcard_v6ip"  ]];then
        south_netcard_ipv6_check=`ifconfig ${south_nic} | grep -i ${south_netcard_ipv6}`
        if [[ -z ${south_netcard_ipv6_check} ]]; then
            south_netcard_ipv6_node=`ifconfig ${south_nic} | grep inet6 | grep -v link  | awk '/inet/ {print $2}'`			
            typeset -i issouthsameip=1
			for arrstr in ${south_netcard_ipv6_node[@]};
			do
				 checkSameIpv6 $south_netcard_ipv6 $arrstr
				if [[ $? -eq 0  ]]; then
					issouthsameip=0
					break
				else
					issouthsameip=1
				fi
			done
			if [[ $issouthsameip != 0  ]]; then
                print_log "ERROR" "The south netcard [${south_nic}] may be wrong. Please check if the south netcard of the south ip [${south_netcard_ipv6}] is [${south_nic}]."
                ((error_fail_num=error_fail_num+1))
            fi
        fi
    fi

    #ڶipv4У
    if [ "X${second_south_netcard_ip}" != "X"  ] && [ "X${second_south_nic}" != "X"  ];then
        second_south_netcard_ip_check=`ifconfig ${second_south_nic} | grep ${second_south_netcard_ip}`
        if [[ -z ${second_south_netcard_ip_check} ]]; then
            print_log "ERROR" "The south netcard [${second_south_nic}] may be wrong. Please check if the second south netcard of the south ip [${second_south_netcard_ip}] is [${second_south_nic}]."
            ((error_fail_num=error_fail_num+1))
        fi
    fi    

    #ڶipv6У
    if [[ "${second_south_netcard_ipv6}" != ""  ]] && [[ "${second_south_nic}" != ""  ]] && [[ "${second_south_netcard_ipv6}" != "user_second_south_netcard_v6ip"  ]];then
        second_south_netcard_ipv6_check=`ifconfig ${second_south_nic} | grep -i ${second_south_netcard_ipv6}`
        if [[ -z ${second_south_netcard_ipv6_check} ]]; then
            second_south_netcard_ipv6_node=`ifconfig ${second_south_nic} | grep inet6 | grep -v link  | awk '/inet/ {print $2}'`
			typeset -i issecondsouthsameip=1
			for arrstr in ${second_south_netcard_ipv6_node[@]};
			do
				 checkSameIpv6 $second_south_netcard_ipv6 $arrstr
				if [[ $? -eq 0  ]]; then
					issecondsouthsameip=0
					break
				else
					issecondsouthsameip=1
				fi
			done
			if [[ $issecondsouthsameip != 0  ]]; then
                print_log "ERROR" "The south netcard [${second_south_nic}] may be wrong. Please check if the second south netcard of the south ip [${second_south_netcard_ipv6}] is [${second_south_nic}]."
                ((error_fail_num=error_fail_num+1))
            fi
        fi
    fi

    #ipv4У
    if [ "X${north_netcard_ip}" != "X"  ];then
        north_netcard_ip_check=`ifconfig ${north_nic} | grep ${north_netcard_ip}`
        if [[ -z ${north_netcard_ip_check} ]]; then
            print_log "ERROR" "The north netcard [${north_nic}] may be wrong. Please check if the north netcard of the north ip [${north_netcard_ip}] is [${north_nic}]."
            ((error_fail_num=error_fail_num+1))
        fi
    fi

    #ipv6У
    if [[ "${north_netcard_ipv6}" != ""  ]] && [[ "${north_netcard_ipv6}" != "user_north_netcard_v6ip"  ]];then
        north_netcard_ipv6_check=`ifconfig ${north_nic} | grep -i ${north_netcard_ipv6}`
        if [[ -z ${north_netcard_ipv6_check} ]]; then
            north_netcard_ipv6_node=`ifconfig ${north_nic} | grep inet6 | grep -v link  | awk '/inet/ {print $2}'`
			
			typeset -i isnorthsameip=1
			for arrstr in ${north_netcard_ipv6_node[@]};
			do
				 checkSameIpv6 $north_netcard_ipv6 $arrstr
				if [[ $? -eq 0  ]]; then
					isnorthsameip=0
					break
				else
					isnorthsameip=1
				fi
			done
			if [[ $isnorthsameip != 0  ]]; then
                print_log "ERROR" "The north netcard [${north_nic}] may be wrong. Please check if the north netcard of the north ip [${north_netcard_ipv6}] is [${north_nic}]."
                ((error_fail_num=error_fail_num+1))
            fi
        fi
    fi

    #֤ipv4
    if [ "X${north_vis_ip_mask}" != "X"  ];then
        north_mask_check=`ifconfig ${north_nic} | grep ${north_vis_ip_mask}`
        if [[ -z ${north_mask_check} ]]; then
            print_log "ERROR" "The north mask ip [${north_vis_ip_mask}] is wrong. Please check if the mask of the northbound network card is [${north_vis_ip_mask}]."
            ((error_fail_num=error_fail_num+1))
        fi
    fi

    #֤ipv6
    if [[ "${north_vis_ipv6_mask}" != "" ]] && [[ "${north_vis_ipv6_mask}" != "user_north_visipv6_mask" ]];then
        north_maskv6_check=`ifconfig ${north_nic} | grep ${north_vis_ipv6_mask}`
        if [[ -z ${north_maskv6_check} ]]; then
            print_log "ERROR" "The north mask ip [${north_vis_ipv6_mask}] is wrong. Please check if the mask of the northbound network card is [${north_vis_ipv6_mask}]."
            ((error_fail_num=error_fail_num+1))
        fi
    fi

    #֤ipv4
    if [ "X${south_floatip_mask2}" != "X"  ];then
        south_mask_check=`ifconfig ${south_nic} | grep ${south_floatip_mask2}`
        if [[ -z ${south_mask_check} ]]; then
            print_log "ERROR" "The south mask ip [${south_floatip_mask2}] is wrong. Please check if the mask of the southbound network card is [${south_floatip_mask2}]."
            ((error_fail_num=error_fail_num+1))
        fi
    fi

    #֤ipv6
    if [[ "${south_floatip_v6mask2}" != "" ]] && [[ "${south_floatip_v6mask2}" != "user_south_float_ip_v6mask2" ]];then
        south_maskv6_check=`ifconfig ${south_nic} | grep ${south_floatip_v6mask2}`
        if [[ -z ${south_maskv6_check} ]]; then
            print_log "ERROR" "The south mask ip [${south_floatip_v6mask2}] is wrong. Please check if the mask of the southbound network card is [${south_floatip_v6mask2}]."
            ((error_fail_num=error_fail_num+1))
        fi
    fi

    #򸡶ipv4ͳһУ
    if [ "X${north_vis_ip_mask}" != "X"  ] && [ "X${north_netcard_ip}" != "X"  ] && [ "X${north_vis_ip}" != "X"  ];then
        check_ip_on_same_segment $north_netcard_ip $north_vis_ip $north_vis_ip_mask
    fi

    #򸡶ipv4ͳһУ
    if [ "X${south_floatip}" != "X"  ] && [ "X${south_netcard_ip}" != "X"  ] && [ "X${south_floatip_mask2}" != "X"  ];then
        check_ip_on_same_segment $south_netcard_ip $south_floatip $south_floatip_mask2
    fi

    #ڶ򸡶ipv4ͳһУ
    if [[ $second_south_nic != "" ]];then
        if [[ $second_south_nic == $south_nic ]];then
            print_log "ERROR" "The second southbound netcard should not be the same as the southbound netcard."
            ((error_fail_num=error_fail_num+1))
        else
            if [[ $second_south_netcard_ip != "" ]] && [[ $second_south_float_ip != "" ]] && [[ $user_second_south_floatip_mask != "" ]];then
                check_ip_on_same_segment $second_south_netcard_ip $second_south_float_ip $user_second_south_floatip_mask
            fi
        fi
    fi
    if [[ ${bgp_south_float_ip} != "" ]] && [[ ${south_netcard_ip} != "" ]] && [[ ${south_floatip_mask2} != "" ]] && [[ ${bgp_netcard} == ${south_nic} ]]; then
        check_ip_on_same_segment $south_netcard_ip $bgp_south_float_ip $south_floatip_mask2
    fi

    if [ ${error_fail_num} -gt 0 ]; then
        return 1
    fi

    return 0
}
