#!/bin/bash
. ./controller_bond.inc
################################################################################
# Function    : check_node_ip_config
# Description : check the node ip config.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_linux_kernel()
{
    kernel=$(uname -a)
    uname=""
    if [[ $kernel =~ "aarch" ]];then
        uname="ARM"
    elif [[ $kernel =~ "x86" ]];then
        uname="x86"
    fi
    if [[ $uname != $cpu_type ]];then
        print_log "ERROR" "Linux kernel is ${uname} but Config is ${cpu_type}."
        ((error_fail_num=error_fail_num+1))
    fi
}

ostype=""

function check_os()
{
    if [ -f /etc/SuSE-release ]; then
        ostype="suse"
    elif [ -f /etc/centos-release ] && [ "$(grep CentOS /etc/centos-release)" ]
    then
        ostype="centos"
    elif [ -f /etc/euleros-release ] && [ "$(grep EulerOS /etc/euleros-release)" ]
    then
        ostype="EulerOS"
    fi
}

function get_networknumber()
{
    ip=$1
    mask=$2
    out=''
    for index in {1..4}; do
        si=$(echo $ip | cut -d "." -f $index)
        sm=$(echo $mask | cut -d "." -f $index)
        if [ $index -ne 1 ]; then
            out="$out."
        fi
        out="$out$[$si&$sm]"
    done
    echo $out
}

function check_ip_on_same_segment()
{
    ip1=$1
    ip2=$2
    mask=$3
    south=$4
    ip1_networknumber=`get_networknumber $ip1 $mask`
    ip2_networknumber=`get_networknumber $ip2 $mask`
    #单节点南向浮动IP校验
    if [[ "$install_nodes" == "node_single" ]] ;then
        if [[ "$south" == "south" ]] ;then
            if [[ ${ip1} == ${ip2} ]] ;then
                print_log "ERROR" "Please check whether the SouthFloatIP(${ip2}) is the same as the IP(${ip1})."
                ((error_fail_num=error_fail_num+1))
            fi
        else
            return 0
        fi
    fi

    if [ ${ip1_networknumber} != ${ip2_networknumber} ]; then
        print_log "ERROR" "Please check whether the IP(${ip1}) is the same as network segment as the IP(${ip2})."
        ((error_fail_num=error_fail_num+1))
    fi
}

function compipv6(){
    orig_address=$1
    shortmode=`echo "${orig_address}" | grep -c "::"`
    allnum=`echo "${orig_address}" | grep -o ":" | wc -l`
    tmp=""
    if [ ${shortmode} -gt 0 ]; then
        len=`expr 9 - $allnum`
        for((i=1;i<len;i++)); 
        do   
          tmp=$tmp":0000"
        done
    fi
    tmp=$tmp":"
    address=${orig_address/::/$tmp}
    if [[ ${address:0:1} == ":"  ]]; then
        address="0000"$address
    fi
    
    if [[ ${address: -1} == ":"  ]]; then
        address=$address"0000"
    fi
      
    arr=(${address//:/ })
    alladdress=""
    for arrstr in ${arr[@]};   
    do    
        strlen=`echo $arrstr | wc -L`
        tmpstr=""
        if [[ $strlen == 1 ]];then
            tmpstr=':000'$arrstr
        elif [[ $strlen == 2 ]];then
            tmpstr=':00'$arrstr
        elif [[ $strlen == 3 ]];then
            tmpstr=':0'$arrstr
        else
            tmpstr=':'$arrstr
        fi
        alladdress=$alladdress$tmpstr
    done
    alladdress=${alladdress#:}
    echo $alladdress
}

function checkSameIpv6
{
    configIP=$1
    nodeIp=$2
    #补齐并转换成全小写
    configIP=`compipv6 $configIP`
    configIP=`echo ${configIP,,}`
    nodeIp=`compipv6 $nodeIp`
    nodeIp=`echo ${nodeIp,,}`
    if [[ ${configIP} != ${nodeIp} ]]; then
       return 1
    else
        return 0
    fi
}

function transposition(){
    configIP=$1
	array=(`echo $configIP | tr ':' ' '`)
	newIp=""
	for var in ${array[@]}
	do
	    for((i=1;i<5;i++));
		do
		    string=`echo $var |awk -F "" '{print $'$i'}'`
			string=`cat /tmp/install_check/16_to_2.txt |grep "$string=" |awk -F "=" '{print $2}'`
			newIp=$newIp$string
		done
        done
        echo $newIp
}

function check_ipv6_on_same_segment(){


    ip1=$1
	ip2=$2
	mask=$3
	south=$4
	ip1_sixt=`compipv6 $ip1`
	ip1_sixt=`echo ${ip1_sixt,,}`
	ip2_sixt=`compipv6 $ip2`
	ip2_sixt=`echo ${ip2_sixt,,}`
	ip1_two=`transposition $ip1_sixt`
	ip2_two=`transposition $ip2_sixt`
	masktype=`echo $mask |grep ":"`
	
	if [[ "$install_nodes" == "node_single" ]] ;then
		if [[ "$south" == "south" ]] ;then
			if [[ ${ip1_sixt} == ${ip2_sixt} ]] ;then
				print_log "ERROR" "Please check whether the SouthFloatIP(${ip2}) is the same as the IP(${ip1})."
				((error_fail_num=error_fail_num+1))
			fi
		else
			return 0
		fi
	fi
	
	if [ -z ${masktype} ]; then
	    ip1_finally=`echo ${ip1_two:0:$mask}`
		ip2_finally=`echo ${ip2_two:0:$mask}`
	else
	    mask_sixt=`compipv6 $mask`
		mask_sixt=`echo ${mask_sixt,,}`
		mask_two=`transposition $mask_sixt`
		array1=(`echo $mask_two |sed 's/./& /g'`)
		mask_num="0"
		for var in ${array1[@]}
		do
		    if [ $var -eq 1 ]; then
			    mask_num=$[mask_num+=1]
			else
			    break
			fi
		done
		ip1_finally=`echo ${ip1_two:0:$mask_num}`
		ip2_finally=`echo ${ip2_two:0:$mask_num}`
	fi
	if [ ${ip1_finally} != ${ip2_finally} ]; then
        print_log "ERROR" "Please check whether the IP(${ip1}) is the same as network segment as the IP(${ip2})."
        ((error_fail_num=error_fail_num+1))
    fi
}

function get_netcard_ipv6
{
    netcard=$1
    ipv6_num=`ifconfig ${netcard} | awk "$inet6name" | cut -f1 -d "$sign" | wc -l`
    if [[ ${ipv6_num} -eq 1 ]] ; then
        netcard_v6ip_real=`ifconfig ${netcard} | awk "$inet6name" | cut -f1 -d "$sign" |awk 'NR==1 {print $1}'`
        echo ${netcard_v6ip_real}
    elif [[ ${ipv6_num} -gt 1 ]];then
            for arrstr in `ifconfig ${netcard} | awk "$inet6name"| cut -f1 -d "$sign" `
            do
                tmp_str=`cat  ${ipcfgpath}ifcfg-${netcard} | grep -wi ${arrstr}`
                if [[ ! -z ${tmp_str} ]]; then
                    netcard_v6ip_real=${arrstr}
                    echo ${netcard_v6ip_real}
                    break
                fi
            done
            if [[ ${netcard_v6ip_real} == "" ]];then
                tmp_ipv6=`cat  ${ipcfgpath}ifcfg-${netcard} | grep -wi "IPV6ADDR"`
                tmp_ipv6=`echo $tmp_ipv6|awk -F '=' '{print $2}'`
                tmp_ipv6=`echo $tmp_ipv6 |sed 's/\"//g' |sed $'s/\'//g'`
                netcard_v6ip_real_file=`echo $tmp_ipv6|awk -F '/' '{print $1}'`
                for arrstr in `ifconfig ${netcard} | awk "$inet6name"| cut -f1 -d "$sign" `
                do
                    checkSameIpv6 ${netcard_v6ip_real_file}  ${arrstr}
                    if [[ $? == 0 ]]; then
                        netcard_v6ip_real=${arrstr}
                        echo ${netcard_v6ip_real}
                        break
                    fi
                done
            fi
    fi
}

#检查节点ip和浮动ip是否为网络地址或者广播地址，如果是则屏蔽
function check_broadcast_or_net
{
    check_ip=$1
    check_mask=$2
	#将掩码从10进制转换为2进制
	array1=(`echo $check_mask |sed 's/\./\ /g'`)
	array2=(`echo $check_ip |sed 's/\./\ /g'`)
	mask_num=0
	mask_two=""
	check_ip_two=""
	for var1 in ${array1[@]}
	do
		mask_two_all=`echo "obase=2;$var1"|bc`
		num=`echo ${#mask_two_all}`
		while [ $num -lt 8 ]
		do
			mask_two_all="0"$mask_two_all
			num=$[num+=1]
		done
		mask_two=$mask_two$mask_two_all
	done
	for var2 in ${array2[@]}
	do
		check_ip_two_all=`echo "obase=2;$var2"|bc`
		num=`echo ${#check_ip_two_all}`
		while [ $num -lt 8 ]
		do
			check_ip_two_all="0"$check_ip_two_all
			num=$[num+=1]
		done
		check_ip_two=$check_ip_two$check_ip_two_all
	done
	array3=(`echo $mask_two |sed 's/./& /g'`)
	for var3 in ${array3[@]}
	do
		if [[ $var3 -eq 1 ]]; then
			mask_num=$[mask_num+=1]
		else
			break
		fi
	done
	
	host_num=$[32-$mask_num]
	host_num_check=$((2^$host_num-1))
	array4=(`echo $check_ip_two |sed 's/./& /g'`)
	check_ip_two_net=""
	check_ip_two_broadcast=""
	for index in {1..32}
	do
		if [[ ${array3[$index-1]} == "0" || ${array4[$index-1]} == "0" ]]; then
			check_ip_two_net=$check_ip_two_net"0"
		else
			check_ip_two_net=$check_ip_two_net"1"
		fi
		if [[ $index -eq $mask_num ]]; then
			check_ip_two_broadcast=$check_ip_two_net
		fi
		if [[ $index -gt $mask_num ]]; then
			check_ip_two_broadcast=$check_ip_two_broadcast"1"
		fi
	done
    if [[ $check_ip_two -eq $check_ip_two_net ]]; then
		print_log "ERROR" "The IP ($check_ip) is Network Address.Mask is ${check_mask}. Please Check again"
        ((error_fail_num=error_fail_num+1))
	fi
    if [[ $check_ip_two -eq $check_ip_two_broadcast ]]; then
		print_log "ERROR" "The IP ($check_ip) is Broadcast address. Mask is ${check_mask} Please Check again"
        ((error_fail_num=error_fail_num+1))
	fi
    
}

#检查bond网卡环境中是否存在，存在则报错；提示用户已经配置过bond；bond的成员口在环境中是否存在;以及bond的成员口是否已被原有bond使用
function check_bond_netcard(){
   bond_enable=$1
   bond_name=$2
   bond_first=$3
   bond_second=$4
   if [[ ${bond_enable} == "bond_enable" ]];
    then
        bond_name_real=`ifconfig ${bond_name}`
        if [[ ! -z ${bond_name_real} ]]; then
            print_log "ERROR" "The NIC [${bond_name}] already exists on the node. To configure [${bond_name}], log in to the iBMC of the node and run the [ bash /usr/local/ostools/bond_tools/config_netcard.sh deletebond:${bond_name} ] command to delete ${bond_name}. If no bond is required, modify the product installation planning parameters and set Configure Bond to No."
            ((error_fail_num=error_fail_num+1))
        fi
        bond_first_real=`ifconfig -a | grep ${bond_first}`
        if [[ -z ${bond_first_real} ]]; then
            print_log "ERROR" "The first netcard [${bond_first}] may be not existed. Please check."
            ((error_fail_num=error_fail_num+1))
        fi
        
        #校验bond成员口是否已被bond网卡使用
        bond_first_inbond=`grep -i "Slave Interface" /proc/net/bonding/* | grep -w ${bond_first}`
        if [[ ! -z ${bond_first_inbond} ]]; then
            inbond=`grep -i "Slave Interface" /proc/net/bonding/* | grep -w ${bond_first} | cut -f1 -d ":" | cut -f5 -d "/"`
            print_log "ERROR" "The first netcard [${bond_first}] is already in [${inbond}]. To configure [${bond_name}], log in to the iBMC of the node and run the [ bash /usr/local/ostools/bond_tools/config_netcard.sh deletebond:${inbond} ] command to delete ${inbond}. If no bond is required, modify the product installation planning parameters and set Configure Bond to No."
            ((error_fail_num=error_fail_num+1))
        fi
        
        bond_second_real=`ifconfig -a | grep ${bond_second}`
        if [[ -z ${bond_second_real} ]]; then
            print_log "ERROR" "The second netcard [${bond_second}] may be not existed. Please check."
            ((error_fail_num=error_fail_num+1))
        fi
        
        bond_second_inbond=`grep -i "Slave Interface" /proc/net/bonding/* | grep -w ${bond_second}`
        if [[ ! -z ${bond_second_inbond} ]]; then
            inbond=`grep -i "Slave Interface" /proc/net/bonding/* | grep -w ${bond_second} | cut -f1 -d ":" | cut -f5 -d "/"`
            print_log "ERROR" "The second netcard [${bond_second}] is already in [${inbond}]. To configure [${bond_name}], log in to the iBMC of the node and run the [ bash /usr/local/ostools/bond_tools/config_netcard.sh deletebond:${inbond} ] command to delete ${inbond}. If no bond is required, modify the product installation planning parameters and set Configure Bond to No."
            ((error_fail_num=error_fail_num+1))
        fi 
   fi
}

    check_os
    maskname="netmask"
    inetname="/inet/"
    ipcfgpath="/etc/sysconfig/network-scripts/"
    if [[ ${ostype} == "suse" ]]; then
        maskname="Mask"
        ipcfgpath="/etc/sysconfig/network/"
    fi
    mask6name="/inet6/ {print \$4}"
    inet6name="/inet6/ {print \$2}"
    sign=" "
    if [[ ${ostype} == "suse" ]]; then
        mask6name="/inet6/ {print \$3}"
        inet6name="/inet6/ {print \$3}"
        sign="/"
    fi

function check_node_ip_config_bond
{
    typeset -i error_fail_num=0
    #bond_configs_file文件记录需要校验的网卡配置;
    rm -rf /tmp/install_check/bond_configs_file
    touch /tmp/install_check/bond_configs_file
    echo  ${netcard_north} >> /tmp/install_check/bond_configs_file
    echo  ${netcard_north_first} >> /tmp/install_check/bond_configs_file
    echo  ${netcard_north_second} >> /tmp/install_check/bond_configs_file

    #检查系统内核是否和界面配置匹配
    check_linux_kernel

    #mkdir install
    if [ ! -d "/opt/install" ]; then
        mkdir -p /opt/install
    fi

    #根据规划的平面配置;校验对应的网卡信息
    check_bond_netcard ${netcard_north_bond_toggle} ${netcard_north} ${netcard_north_first} ${netcard_north_second}
    if [[ ${plane} == "plane_double"  ||  ${plane} == "plane_triple" ]]; then
        echo  ${netcard_south} >> /tmp/install_check/bond_configs_file
        echo  ${netcard_south_first} >> /tmp/install_check/bond_configs_file
        echo  ${netcard_south_second} >> /tmp/install_check/bond_configs_file
        check_bond_netcard ${netcard_south_bond_toggle} ${netcard_south} ${netcard_south_first} ${netcard_south_second}
        
    fi
    if [[ ${plane} == "plane_triple" ]]; then
        echo  ${netcard_internal} >> /tmp/install_check/bond_configs_file
        echo  ${netcard_internal_first} >> /tmp/install_check/bond_configs_file
        echo  ${netcard_internal_second} >> /tmp/install_check/bond_configs_file
        check_bond_netcard ${netcard_internal_bond_toggle} ${netcard_internal} ${netcard_internal_first} ${netcard_internal_second}
    fi
    if [[ ${double_south} == "double_south_enable" ]]; then
        echo  ${netcard_second_south} >> /tmp/install_check/bond_configs_file
        echo  ${netcard_second_south_first} >> /tmp/install_check/bond_configs_file
        echo  ${netcard_second_south_second} >> /tmp/install_check/bond_configs_file
        check_bond_netcard ${netcard_second_south_bond_toggle} ${netcard_second_south} ${netcard_second_south_first} ${netcard_second_south_second}
    fi
    if [[ ${is_bgp_enable} == "bgp_enable" && ${bgp_south_same_netcard} == "bgp_not_same" ]]; then
        echo  ${bgp_south_netcard} >> /tmp/install_check/bond_configs_file
        echo  ${netcard_bgp_south_first} >> /tmp/install_check/bond_configs_file
        echo  ${netcard_bgp_south_second} >> /tmp/install_check/bond_configs_file
        check_bond_netcard ${netcard_bgp_south_bond_toggle} ${bgp_south_netcard} ${netcard_bgp_south_first} ${netcard_bgp_south_second}
    fi
    
    #检查配置的bond网卡以及网卡成员口是否重复
    repeat_str=""
    for arrstr in `cat /tmp/install_check/bond_configs_file`   
    do   
        count=`cat bond_configs_file | grep -w $arrstr | wc -l`
        if [[ $count -gt 1 ]]; then
            tmp_str=`echo ${repeat_str} | grep -w ${arrstr}`
            if [[ -z ${tmp_str} ]]; then
                repeat_str=${repeat_str}" ${arrstr}"
            fi
        fi
    done
    
    if [[ ! -z ${repeat_str} ]]; then
            print_log "ERROR" "The netcard [${repeat_str}] is repeat. Please check."
            ((error_fail_num=error_fail_num+1))
    fi


    #校验浮动ip是否和实际的网卡同网段，区分是否bond的情况，浮动IP防呆
    #北向ipv4
    if [[ ${netcard_north_bond_toggle} == "bond_enable" ]];
    then
        check_ip_on_same_segment ${node_north_netcard_ip} ${north_vis_ip} ${network_north_mask}
        if [[ "$install_nodes" != "node_single" ]] ;then
            check_broadcast_or_net ${north_vis_ip} ${network_north_mask}
        fi
        check_broadcast_or_net ${node_north_netcard_ip} ${network_north_mask}
    elif [[ ${north_stack_mode} == "ipv4" ]] && [[ ${netcard_north_bond_toggle} == "bond_disable" ]]; 
    then
        node_north_netcard_ip_real=`ifconfig ${netcard_north} | grep "$maskname" | awk ''$inetname' {print $2}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
        network_north_mask_real=`ifconfig ${netcard_north} | grep "$maskname" | awk ''$inetname' {print $4}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
        check_ip_on_same_segment ${node_north_netcard_ip_real} ${north_vis_ip} ${network_north_mask_real}
        if [[ "$install_nodes" != "node_single" ]] ;then
            check_broadcast_or_net ${north_vis_ip} ${network_north_mask_real}
        fi
    elif [[ ${north_stack_mode} == "ipv6" ]] && [[ ${netcard_north_bond_toggle} == "bond_disable" ]]; 
    then
        node_north_netcard_ip_real=`get_netcard_ipv6 ${netcard_north}`
        network_north_mask_real=`ifconfig ${netcard_north} | awk "$mask6name" | cut -f2 -d "$sign" | head -n 1`
        check_ipv6_on_same_segment ${node_north_netcard_ip_real} ${north_vis_ipv6} ${network_north_mask_real}
	elif [[ ${north_stack_mode} == "dual_stack" ]] && [[ ${netcard_north_bond_toggle} == "bond_disable" ]]; 
	then
		node_north_netcard_ip_real=`ifconfig ${netcard_north} | grep "$maskname" | awk ''$inetname' {print $2}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
        network_north_mask_real=`ifconfig ${netcard_north} | grep "$maskname" | awk ''$inetname' {print $4}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
        check_ip_on_same_segment ${node_north_netcard_ip_real} ${north_vis_ip} ${network_north_mask_real}
        if [[ "$install_nodes" != "node_single" ]] ;then
            check_broadcast_or_net ${north_vis_ip} ${network_north_mask_real}
        fi
		node_north_netcard_ipv6_real=`get_netcard_ipv6 ${netcard_north}`
        network_north_maskv6_real=`ifconfig ${netcard_north} | awk "$mask6name" | cut -f2 -d "$sign" | head -n 1`
        check_ipv6_on_same_segment ${node_north_netcard_ipv6_real} ${north_vis_ipv6} ${network_north_maskv6_real}
    fi
    
    #南向ipv4
    if [[ ${netcard_south_bond_toggle} == "bond_enable" ]] && [[  ${plane} == "plane_double"  ||  ${plane} == "plane_triple" ]];
    then
        check_ip_on_same_segment ${node_south_netcard_ip} ${south_floatip2} ${network_south_mask} "south"
        check_broadcast_or_net ${south_floatip2} ${network_south_mask}
        check_broadcast_or_net ${node_south_netcard_ip} ${network_south_mask}
    elif [[ ${netcard_north_bond_toggle} == "bond_enable" ]] && [[ ${plane} == "plane_single" ]];
    then
        check_ip_on_same_segment ${node_north_netcard_ip} ${south_floatip2} ${network_north_mask} "south"
        check_broadcast_or_net ${south_floatip2} ${network_north_mask}
    elif [[ ${south_stack_mode} == "ipv4" ]] && [[ ${netcard_south_bond_toggle} == "bond_disable" ]] && [[  ${plane} == "plane_double"  ||  ${plane} == "plane_triple" ]]; 
    then
        node_south_netcard_ip_real=`ifconfig ${netcard_south} | grep "$maskname" | awk ''$inetname' {print $2}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
        network_south_mask_real=`ifconfig ${netcard_south} | grep "$maskname" | awk ''$inetname' {print $4}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
        check_ip_on_same_segment ${node_south_netcard_ip_real} ${south_floatip2} ${network_south_mask_real} "south"
        check_broadcast_or_net ${south_floatip2} ${network_south_mask_real}
	elif [[ ${south_stack_mode} == "ipv6" ]] && [[ ${netcard_south_bond_toggle} == "bond_disable" ]] && [[  ${plane} == "plane_double"  ||  ${plane} == "plane_triple" ]]; 
    then
        node_south_netcard_ip_real=`get_netcard_ipv6 ${netcard_south}`
        network_south_mask_real=`ifconfig ${netcard_south} | awk "$mask6name" | cut -f2 -d "$sign" | head -n 1`
        check_ipv6_on_same_segment ${node_south_netcard_ip_real} ${south_float_v6ip2} ${network_south_mask_real} "south"
	elif [[ ${south_stack_mode} == "dual_stack" ]] && [[ ${netcard_south_bond_toggle} == "bond_disable" ]] && [[  ${plane} == "plane_double"  ||  ${plane} == "plane_triple" ]]; 
	then
		node_south_netcard_ip_real=`ifconfig ${netcard_south} | grep "$maskname" | awk ''$inetname' {print $2}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
        network_south_mask_real=`ifconfig ${netcard_south} | grep "$maskname" | awk ''$inetname' {print $4}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
        check_ip_on_same_segment ${node_south_netcard_ip_real} ${south_floatip2} ${network_south_mask_real} "south"
        check_broadcast_or_net ${south_floatip2} ${network_south_mask_real}
		node_south_netcard_ipv6_real=`get_netcard_ipv6 ${netcard_south}`
        network_south_maskv6_real=`ifconfig ${netcard_south} | awk "$mask6name" | cut -f2 -d "$sign" | head -n 1`
        check_ipv6_on_same_segment ${node_south_netcard_ipv6_real} ${south_float_v6ip2} ${network_south_maskv6_real} "south"
	elif [[ ${north_stack_mode} == "ipv4" ]] && [[  ${plane} == "plane_single" ]] && [[ -n ${south_floatip2} ]]; 
    then
        node_south_netcard_ip_real=`ifconfig ${netcard_north} | grep "$maskname" | awk ''$inetname' {print $2}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
        network_south_mask_real=`ifconfig ${netcard_north} | grep "$maskname" | awk ''$inetname' {print $4}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
        check_ip_on_same_segment ${node_south_netcard_ip_real} ${south_floatip2} ${network_south_mask_real} "south"
        check_broadcast_or_net ${south_floatip2} ${network_south_mask_real}
	elif [[ ${north_stack_mode} == "ipv6" ]] && [[  ${plane} == "plane_single" ]] && [[ -n ${south_float_v6ip2} ]]; 
    then
        node_south_netcard_ip_real=`get_netcard_ipv6 ${netcard_north}`
        network_south_mask_real=`ifconfig ${netcard_north} | awk "$mask6name" | cut -f2 -d "$sign" | head -n 1`
        check_ipv6_on_same_segment ${node_south_netcard_ip_real} ${south_float_v6ip2} ${network_south_mask_real} "south"
    fi
    #内部通信ipv4，IP防呆
    if [[ ${netcard_internal_bond_toggle} == "bond_enable" ]] && [[ ${plane} == "plane_triple" ]];
    then
        check_broadcast_or_net ${node_internal_netcard_ip} ${network_internal_mask}
    fi
        
    #南向双网卡ipv4
    if [[ ${netcard_second_south_bond_toggle} == "bond_enable" ]] && [[ ${double_south} == "double_south_enable" ]];
    then
        check_ip_on_same_segment ${node_second_south_netcard_ip} ${second_south_float_ip} ${network_second_south_mask}
        check_broadcast_or_net ${second_south_float_ip} ${network_second_south_mask}
        check_broadcast_or_net ${node_second_south_netcard_ip} ${network_second_south_mask}
    elif [[ ${south_stack_mode} == "ipv4" ]] && [[ ${netcard_second_south_bond_toggle} == "bond_disable" ]] && [[ ${double_south} == "double_south_enable" ]] ; 
    then
        node_second_south_netcard_ip_real=`ifconfig ${netcard_second_south} | grep "$maskname" | awk ''$inetname' {print $2}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
        network_second_south_mask_real=`ifconfig ${netcard_second_south} | grep "$maskname" | awk ''$inetname' {print $4}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
        check_ip_on_same_segment ${node_second_south_netcard_ip_real} ${second_south_float_ip} ${network_second_south_mask_real}
        check_broadcast_or_net ${second_south_float_ip} ${network_second_south_mask_real}
    elif [[ ${south_stack_mode} == "ipv6" ]] && [[ ${netcard_second_south_bond_toggle} == "bond_disable" ]] && [[ ${double_south} == "double_south_enable" ]] ; 
    then
        node_second_south_netcard_ip_real=`get_netcard_ipv6 ${netcard_second_south}`
        network_second_south_mask_real=`ifconfig ${netcard_second_south} | awk "$mask6name" | cut -f2 -d "$sign" | head -n 1`
        check_ipv6_on_same_segment ${node_second_south_netcard_ip_real} ${south_second_v6floatip} ${network_second_south_mask_real}
	elif [[ ${south_stack_mode} == "dual_stack" ]] && [[ ${netcard_second_south_bond_toggle} == "bond_disable" ]] && [[  ${plane} == "plane_double"  ||  ${plane} == "plane_triple" ]]; 
	then
		node_second_south_netcard_ip_real=`ifconfig ${netcard_second_south} | grep "$maskname" | awk ''$inetname' {print $2}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
        network_second_south_mask_real=`ifconfig ${netcard_second_south} | grep "$maskname" | awk ''$inetname' {print $4}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
        check_ip_on_same_segment ${node_second_south_netcard_ip_real} ${second_south_float_ip} ${network_second_south_mask_real} 
        check_broadcast_or_net ${second_south_float_ip} ${network_second_south_mask_real}
		node_second_south_netcard_ipv6_real=`get_netcard_ipv6 ${netcard_second_south}`
        network_second_south_maskv6_real=`ifconfig ${netcard_second_south} | awk "$mask6name" | cut -f2 -d "$sign" | head -n 1`
        check_ipv6_on_same_segment ${node_second_south_netcard_ipv6_real} ${south_second_v6floatip} ${network_second_south_maskv6_real} 
    fi
    
    #bgp南向同网卡场景校验
    if [[  ${is_bgp_enable} == "bgp_enable" && ${bgp_south_same_netcard} == "bgp_same" ]];
    then
        #ipv4做bond场景
        if [[ ${netcard_south_bond_toggle} == "bond_enable" ]] && [[ ${plane} == "plane_double"  ||  ${plane} == "plane_triple" ]] && [[ ${south_stack_mode} == "ipv4" ]];
        then
            node_bgp_south_netcard_ip_real=${node_south_netcard_ip}
            network_bgp_south_mask_real=${network_south_mask}
            check_ip_on_same_segment ${node_bgp_south_netcard_ip_real} ${bgp_south_float_ip} ${network_bgp_south_mask_real}
            check_broadcast_or_net ${bgp_south_float_ip} ${network_bgp_south_mask_real}
        fi
        if [[ ${netcard_north_bond_toggle} == "bond_enable" ]] && [[ ${plane} == "plane_single" ]] && [[ ${north_stack_mode} == "ipv4" ]];then
            node_bgp_south_netcard_ip_real=${node_north_netcard_ip}
            network_bgp_south_mask_real=${network_north_mask}
            check_ip_on_same_segment ${node_bgp_south_netcard_ip_real} ${bgp_south_float_ip} ${network_bgp_south_mask_real}
            check_broadcast_or_net ${bgp_south_float_ip} ${network_bgp_south_mask_real}
        fi
        #ipv4不做bond场景
        if [[ ${netcard_south_bond_toggle} == "bond_disable" ]] && [[ ${plane} == "plane_double"  ||  ${plane} == "plane_triple" ]] && [[ ${south_stack_mode} == "ipv4" ]];
        then
            node_bgp_south_netcard_ip_real=`ifconfig ${netcard_south} | grep "$maskname" | awk ''$inetname' {print $2}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
            network_bgp_south_mask_real=`ifconfig ${netcard_south} | grep "$maskname" | awk ''$inetname' {print $4}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
            check_ip_on_same_segment ${node_bgp_south_netcard_ip_real} ${bgp_south_float_ip} ${network_bgp_south_mask_real}
            check_broadcast_or_net ${bgp_south_float_ip} ${network_bgp_south_mask_real}
        fi
        if [[ ${netcard_north_bond_toggle} == "bond_disable" ]] && [[ ${plane} == "plane_single" ]] && [[ ${north_stack_mode} == "ipv4" ]];then
            node_bgp_south_netcard_ip_real=`ifconfig ${netcard_north} | grep "$maskname" | awk ''$inetname' {print $2}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
            network_bgp_south_mask_real=`ifconfig ${netcard_north} | grep "$maskname" | awk ''$inetname' {print $4}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
            check_ip_on_same_segment ${node_bgp_south_netcard_ip_real} ${bgp_south_float_ip} ${network_bgp_south_mask_real}
            check_broadcast_or_net ${bgp_south_float_ip} ${network_bgp_south_mask_real}
        fi

        #ipv6场景不做bond
        if [[ ${netcard_south_bond_toggle} == "bond_disable" ]] && [[ ${plane} == "plane_double"  ||  ${plane} == "plane_triple" ]] && [[ ${south_stack_mode} == "ipv6" ]];
        then
            node_bgp_south_netcard_ip_real=`get_netcard_ipv6 ${netcard_south}`
            network_bgp_south_mask_real=`ifconfig ${netcard_south} | awk "$mask6name" | cut -f2 -d "$sign" | head -n 1`
            check_ipv6_on_same_segment ${node_bgp_south_netcard_ip_real} ${bgp_south_float_v6ip} ${network_bgp_south_mask_real}
        fi
        if [[ ${netcard_north_bond_toggle} == "bond_disable" ]] && [[ ${plane} == "plane_single" ]] && [[ ${north_stack_mode} == "ipv6" ]];then
            node_bgp_south_netcard_ip_real=`get_netcard_ipv6 ${netcard_north}`
            network_bgp_south_mask_real=`ifconfig ${netcard_north} | awk "$mask6name" | cut -f2 -d "$sign" | head -n 1`
            check_ipv6_on_same_segment ${node_bgp_south_netcard_ip_real} ${bgp_south_float_v6ip} ${network_bgp_south_mask_real}
        fi
    fi
    #bgp南向不同网卡场景校验
    if [[ ${is_bgp_enable} == "bgp_enable" && ${bgp_south_same_netcard} == "bgp_not_same" ]];then
        if [[ ${netcard_bgp_south_bond_toggle} == "bond_enable" && ${bgp_stack_mode} == "ipv4" ]];
        then
            check_ip_on_same_segment ${node_bgp_south_netcard_ip} ${bgp_south_float_ip} ${network_bgp_south_mask}
            check_broadcast_or_net ${bgp_south_float_ip} ${network_bgp_south_mask}
            check_broadcast_or_net ${node_bgp_south_netcard_ip} ${network_bgp_south_mask}
        elif [[ ${netcard_bgp_south_bond_toggle} == "bond_disable" ]];then
            #不做bond的ipv4场景
            if [[ ${bgp_stack_mode} == "ipv4" ]];
            then
                node_bgp_south_netcard_ip_real=`ifconfig ${bgp_south_netcard} | grep "$maskname" | awk ''$inetname' {print $2}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
                network_bgp_south_mask_real=`ifconfig ${bgp_south_netcard} | grep "$maskname" | awk ''$inetname' {print $4}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
                check_ip_on_same_segment ${node_bgp_south_netcard_ip_real} ${bgp_south_float_ip} ${network_bgp_south_mask_real}
                check_broadcast_or_net ${bgp_south_float_ip} ${network_bgp_south_mask_real}
            fi
            if [[ ${bgp_stack_mode} == "ipv6" ]];
            then
                node_bgp_south_netcard_ip_real=`get_netcard_ipv6 ${bgp_south_netcard}`
                network_bgp_south_mask_real=`ifconfig ${bgp_south_netcard} | awk "$mask6name" | cut -f2 -d "$sign" | head -n 1`
                check_ipv6_on_same_segment ${node_bgp_south_netcard_ip_real} ${bgp_south_float_v6ip} ${network_bgp_south_mask_real}
            fi  
        fi
    fi
    
    #校验easysuite通信ip要和北向ip相同，区分ipv4和ipv6场景
     if [[ $easysuite_ip =~ ':' ]]
     then
         node1_north_netcard_v6ip_real=`get_netcard_ipv6 ${netcard_north}`
         checkSameIpv6 ${node1_north_netcard_v6ip_real} $easysuite_ip
         if [[ $? == 1 ]]; then
             print_log "ERROR" "The easysuite ip [${easysuite_ip}] is not the same as the north netcard ip [$node1_north_netcard_v6ip_real]. Please check."
            ((error_fail_num=error_fail_num+1))
         fi
     else
         if [[ ${netcard_north_bond_toggle} == "bond_enable" ]]
         then
            if [ $easysuite_ip != $node_north_netcard_ip ] ;then
                print_log "ERROR" "The easysuite ip [${easysuite_ip}] is not the same as the north netcard ip [$node_north_netcard_ip]. Please check."
                ((error_fail_num=error_fail_num+1))
            fi
         else
            node_north_netcard_ip_real=`ifconfig ${netcard_north} | grep "$maskname" | awk ''$inetname' {print $2}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
            if [ $easysuite_ip != $node_north_netcard_ip_real ] ;then
                print_log "ERROR" "The easysuite ip [${easysuite_ip}] is not the same as the north netcard ip [$node_north_netcard_ip_real]. Please check."
                ((error_fail_num=error_fail_num+1))
            fi
         fi       
     fi


    #获取easysuite通信ip对应的网卡信息;要确保easysuite通信ip在做bond之后还是能继续ping通
    if [[ ${netcard_north_bond_toggle} == "bond_enable" ]]
    then
        easysuite_nic=`grep -ri $easysuite_ip ${ipcfgpath}ifcfg-* | cut -f1 -d ":" |awk 'NR==1 {print $1}' | cut -f5 -d "/" | cut -f2 -d "-"`
        if [[ $easysuite_nic != "$netcard_north_first" &&  $easysuite_nic != "$netcard_north_second" ]] ;then       
            print_log "ERROR" "The easysuite netcard [${easysuite_nic}] is not the sub north bond netcard .Config bond for northbound netcard will make the easysuite connection failed. Please check."
            ((error_fail_num=error_fail_num+1))
        fi
    fi
     
    #校验非bond场景下实际环境中的ip是否已配置,广播地址防呆
    #北向
    if [[ ${netcard_north_bond_toggle} == "bond_disable" ]]; 
    then
        netcard_real=`ifconfig -a | grep ${netcard_north}`
        if [[ -z ${netcard_real} ]]; then
            print_log "ERROR" "The north netcard [${netcard_north}] may be not existed. Please check."
            ((error_fail_num=error_fail_num+1))
        else      
            if [[ ${north_stack_mode} == "ipv4" || ${north_stack_mode} == "dual_stack" ]] ;then
                node_north_netcard_ip_real=`ifconfig ${netcard_north} | grep "$maskname" | awk ''$inetname' {print $2}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
                network_north_mask_real=`ifconfig ${netcard_north} | grep "$maskname" | awk ''$inetname' {print $4}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
                check_broadcast_or_net $node_north_netcard_ip_real $network_north_mask_real
                if [[ $node_north_netcard_ip_real == "" ]] ;then
                    print_log "ERROR" "The IP of the north nic [${netcard_north}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
                if [[ $network_north_mask_real == "" ]] ;then
                    print_log "ERROR" "The Mask of the north nic [${netcard_north}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
                if [[ $node_north_netcard_ip_real == "$north_vis_ip" ]] ;then
                    print_log "ERROR" "The IP(${node_north_netcard_ip_real}) of the north nic [${netcard_north}] is the same as the northbound floating IP(${north_vis_ip})"
                    ((error_fail_num=error_fail_num+1))
                fi
            fi         
            if [[ ${north_stack_mode} == "ipv6" || ${north_stack_mode} == "dual_stack" ]] ;then
                node1_north_netcard_v6ip_real=`get_netcard_ipv6 ${netcard_north}`
                node1_north_netcard_v6mask_real=`ifconfig ${netcard_north} | grep ${node1_north_netcard_v6ip_real} |  awk "$mask6name" | cut -f2 -d "$sign" |awk 'NR==1 {print $1}'`
                if [[ $node1_north_netcard_v6ip_real == "" ]] ;then
                    print_log "ERROR" "The IP of the north nic [${netcard_north}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
                if [[ $node1_north_netcard_v6mask_real == "" ]] ;then
                    print_log "ERROR" "The Mask of the north nic [${netcard_north}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
                if [[ $node1_north_netcard_v6ip_real == "$north_vis_ipv6" ]] ;then
                    print_log "ERROR" "The IP(${node1_north_netcard_v6ip_real}) of the north nic [${netcard_north}] is the same as the northbound floating IP(${north_vis_ipv6})"
                    ((error_fail_num=error_fail_num+1))
                fi
            fi
        fi
    fi
    
    #南向
    if [[ ${netcard_south_bond_toggle} == "bond_disable" ]] && [[ ${plane} == "plane_triple" || ${plane} == "plane_double" ]] ; 
    then
        netcard_real=`ifconfig -a | grep ${netcard_south}`
        if [[ -z ${netcard_real} ]]; then
            print_log "ERROR" "The south netcard [${netcard_south}] may be not existed. Please check."
            ((error_fail_num=error_fail_num+1))
        else
            if [[ ${south_stack_mode} == "ipv4" || ${south_stack_mode} == "dual_stack" ]] ;then
                node_north_netcard_ip_real=`ifconfig ${netcard_south} | grep "$maskname" | awk ''$inetname' {print $2}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
                network_north_mask_real=`ifconfig ${netcard_south} | grep "$maskname" | awk ''$inetname' {print $4}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
                check_broadcast_or_net $node_north_netcard_ip_real $network_north_mask_real
                if [[ $node_north_netcard_ip_real == "" ]] ;then
                    print_log "ERROR" "The IP of the south nic [${netcard_south}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
                if [[ $network_north_mask_real == "" ]] ;then
                    print_log "ERROR" "The Mask of the south nic [${netcard_south}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
                if [[ $node_north_netcard_ip_real == "$south_floatip2" ]] ;then
                    print_log "ERROR" "The IP(${node_north_netcard_ip_real}) of the south nic [${netcard_south}] is the same as the southbound floating IP(${south_floatip2})"
                    ((error_fail_num=error_fail_num+1))
                fi
            fi         
            if [[ ${south_stack_mode} == "ipv6" || ${south_stack_mode} == "dual_stack" ]] ;then
                node1_north_netcard_v6ip_real=`get_netcard_ipv6 ${netcard_south}`
                node1_north_netcard_v6mask_real=`ifconfig ${netcard_south} | grep ${node1_north_netcard_v6ip_real} |  awk "$mask6name" | cut -f2 -d "$sign" |awk 'NR==1 {print $1}'`
                if [[ $node1_north_netcard_v6ip_real == "" ]] ;then
                    print_log "ERROR" "The IP of the south nic [${netcard_south}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
                if [[ $node1_north_netcard_v6mask_real == "" ]] ;then
                    print_log "ERROR" "The Mask of the south nic [${netcard_south}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
                if [[ $node1_north_netcard_v6ip_real == "$south_float_v6ip2" ]] ;then
                    print_log "ERROR" "The IP(${node1_north_netcard_v6ip_real}) of the south nic [${netcard_south}] is the same as the southbound floating IP(${south_float_v6ip2})"
                    ((error_fail_num=error_fail_num+1))
                fi
            fi
        fi
    fi
    
    #内部通信
    if [[ ${netcard_internal_bond_toggle} == "bond_disable" ]] && [[ ${plane} == "plane_triple" || ${plane} == "plane_double" ]]; 
    then
        netcard_real=`ifconfig -a | grep ${netcard_internal}`
        if [[ -z ${netcard_real} ]]; then
            print_log "ERROR" "The internal netcard [${netcard_internal}] may be not existed. Please check."
            ((error_fail_num=error_fail_num+1))
        else
            if [[ ${internal_stack_mode} == "ipv4" ]] ;then
                node_north_netcard_ip_real=`ifconfig ${netcard_internal} | grep "$maskname" | awk ''$inetname' {print $2}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
                network_north_mask_real=`ifconfig ${netcard_internal} | grep "$maskname" | awk ''$inetname' {print $4}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
                check_broadcast_or_net $node_north_netcard_ip_real $network_north_mask_real
                if [[ $node_north_netcard_ip_real == "" ]] ;then
                    print_log "ERROR" "The IP of the internal nic [${netcard_internal}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
                if [[ $network_north_mask_real == "" ]] ;then
                    print_log "ERROR" "The Mask of the internal nic [${netcard_internal}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
            fi         
            if [[ ${internal_stack_mode} == "ipv6" ]] ;then
                node1_north_netcard_v6ip_real=`get_netcard_ipv6 ${netcard_internal}`
                node1_north_netcard_v6mask_real=`ifconfig ${netcard_internal} | grep ${node1_north_netcard_v6ip_real} |  awk "$mask6name" | cut -f2 -d "$sign" |awk 'NR==1 {print $1}'`
                if [[ $node1_north_netcard_v6ip_real == "" ]] ;then
                    print_log "ERROR" "The IP of the internal nic [${netcard_internal}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
                if [[ $node1_north_netcard_v6mask_real == "" ]] ;then
                    print_log "ERROR" "The Mask of the internal nic [${netcard_internal}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
            fi
        fi    
    fi
    
    #南向第二网卡
    if [[ ${netcard_second_south_bond_toggle} == "bond_disable" ]] && [[ ${double_south} == "double_south_enable" ]]; 
    then
        netcard_real=`ifconfig -a | grep ${netcard_second_south}`
        if [[ -z ${netcard_real} ]]; then
            print_log "ERROR" "The second south netcard [${netcard_second_south}] may be not existed. Please check."
            ((error_fail_num=error_fail_num+1))
        else
            if [[ ${south_stack_mode} == "ipv4" ]] ;then
                node_north_netcard_ip_real=`ifconfig ${netcard_second_south} | grep "$maskname" | awk ''$inetname' {print $2}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
                network_north_mask_real=`ifconfig ${netcard_second_south} | grep "$maskname" | awk ''$inetname' {print $4}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
                check_broadcast_or_net $node_north_netcard_ip_real $network_north_mask_real
                if [[ $node_north_netcard_ip_real == "" ]] ;then
                    print_log "ERROR" "The IP of the second south nic [${netcard_second_south}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
                if [[ $network_north_mask_real == "" ]] ;then
                    print_log "ERROR" "The Mask of the second south nic [${netcard_second_south}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
                if [[ $node_north_netcard_ip_real == "$second_south_float_ip" ]] ;then
                    print_log "ERROR" "The IP(${node_north_netcard_ip_real}) of the second south nic [${netcard_second_south}] is the same as the second south floating IP(${second_south_float_ip})"
                    ((error_fail_num=error_fail_num+1))
                fi
            fi         
            if [[ ${south_stack_mode} == "ipv6" ]] ;then
                node1_north_netcard_v6ip_real=`get_netcard_ipv6 ${netcard_second_south}`
                node1_north_netcard_v6mask_real=`ifconfig ${netcard_second_south} | grep ${node1_north_netcard_v6ip_real} |  awk "$mask6name" | cut -f2 -d "$sign" |awk 'NR==1 {print $1}'`
                if [[ $node1_north_netcard_v6ip_real == "" ]] ;then
                    print_log "ERROR" "The IP of the second south nic [${netcard_second_south}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
                if [[ $node1_north_netcard_v6mask_real == "" ]] ;then
                    print_log "ERROR" "The Mask of the second south nic [${netcard_second_south}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
                if [[ $node1_north_netcard_v6ip_real == "$south_second_v6floatip" ]] ;then
                    print_log "ERROR" "The IP(${node1_north_netcard_v6ip_real}) of the second south nic [${netcard_second_south}] is the same as the second south floating IP(${south_second_v6floatip})"
                    ((error_fail_num=error_fail_num+1))
                fi           
            fi
        fi
    fi
    
    
    #BGP南向网卡
    if [[ ${netcard_bgp_south_bond_toggle} == "bond_disable" ]] && [[ ${is_bgp_enable} == "bgp_enable" ]] && [[ ${bgp_south_same_netcard} == "bgp_not_same" ]] ; 
    then
        netcard_real=`ifconfig -a | grep ${bgp_south_netcard}`
        if [[ -z ${netcard_real} ]]; then
            print_log "ERROR" "The bgp south netcard [${bgp_south_netcard}] may be not existed. Please check."
            ((error_fail_num=error_fail_num+1))
        else
            if [[ ${bgp_stack_mode} == "ipv4" ]] ;then
                node_north_netcard_ip_real=`ifconfig ${bgp_south_netcard} | grep "$maskname" | awk ''$inetname' {print $2}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
                network_north_mask_real=`ifconfig ${bgp_south_netcard} | grep "$maskname" | awk ''$inetname' {print $4}' | cut -f2 -d ":" |awk 'NR==1 {print $1}'`
                check_broadcast_or_net $node_north_netcard_ip_real $network_north_mask_real
                if [[ $node_north_netcard_ip_real == "" ]] ;then
                    print_log "ERROR" "The IP of the bgp south nic [${bgp_south_netcard}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
                if [[ $network_north_mask_real == "" ]] ;then
                    print_log "ERROR" "The Mask of the bgp south nic [${bgp_south_netcard}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
                if [[ $node_north_netcard_ip_real == "$bgp_south_float_ip" ]] ;then
                    print_log "ERROR" "The IP(${node_north_netcard_ip_real}) of the bgp nic [${bgp_south_netcard}] is the same as the bgp floating IP(${bgp_south_float_ip})"
                    ((error_fail_num=error_fail_num+1))
                fi
            fi         
            if [[ ${bgp_stack_mode} == "ipv6" ]] ;then
                node1_north_netcard_v6ip_real=`get_netcard_ipv6 ${bgp_south_netcard}`
                node1_north_netcard_v6mask_real=`ifconfig ${bgp_south_netcard} | grep ${node1_north_netcard_v6ip_real} |  awk "$mask6name" | cut -f2 -d "$sign" |awk 'NR==1 {print $1}'`
                if [[ $node1_north_netcard_v6ip_real == "" ]] ;then
                    print_log "ERROR" "The IP of the bgp south nic [${bgp_south_netcard}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
                if [[ $node1_north_netcard_v6mask_real == "" ]] ;then
                    print_log "ERROR" "The Mask of the bgp south nic [${bgp_south_netcard}] is not existed. Please check."
                    ((error_fail_num=error_fail_num+1))
                fi
                if [[ $node1_north_netcard_v6ip_real == "$bgp_south_float_v6ip" ]] ;then
                    print_log "ERROR" "The IP(${node1_north_netcard_v6ip_real}) of the bgp nic [${bgp_south_netcard}] is the same as the bgp floating IP(${bgp_south_float_v6ip})"
                    ((error_fail_num=error_fail_num+1))
                fi
            fi
        fi
    fi
    
    function check_floatip_exist_ipv4
    {
        checkedIP=$1
        checkedNetcard=$2
        IP=`ip a | grep ${north_vis_ip}`
        if [[ -z $IP ]];
        then
            existIP=`cat /tmp/install_check/node2.tmp | grep "$checkedIP"`
            if [[ -z $existIP ]];
            then
                existIP=`cat /tmp/install_check/node3.tmp | grep "$checkedIP"`
                if [[ -z $existIP ]];
                then
                    return 1
                else
                    return 0
                fi
            else
                return 0    
            fi
        else
           return 0
        fi
    }
    
    function check_floatip_exist_ipv6
    {
        checkedIPV6=$1
        checkedNetcard=$2
        IP=`ifconfig ${checkedNetcard} | grep ${checkedIPV6}`
        if [[ -z $IP ]];
        then
            for arrstr in `ifconfig ${checkedNetcard} | awk "$inet6name"| cut -f1 -d "$sign" `
            do
                result="not_exist"
                checkSameIpv6 ${checkedIPV6}  ${arrstr}
                if [[ $? == 0 ]]; then
                    result="exist"
                    break
                fi
            done
            if [[ $result == "exist" ]];
            then
               return 0
            else    
                for arrstr in `cat /tmp/install_check/node2${checkedNetcard}.tmp | awk "$inet6name"| cut -f1 -d "$sign" `
                do
                    checkSameIpv6 ${checkedIPV6}  ${arrstr}
                    if [[ $? == 0 ]]; then
                        result="exist"
                        break
                    fi
                done
                if [[ $result == "exist" ]];
                then
                    return 0
                else
                    for arrstr in `cat /tmp/install_check/node3${checkedNetcard}.tmp | awk "$inet6name"| cut -f1 -d "$sign" `
                    do
                        checkSameIpv6 ${checkedIPV6}  ${arrstr}
                        if [[ $? == 0 ]]; then
                            result="exist"
                            break
                        fi
                    done
                    if [[ $result == "exist" ]];
                    then
                        return 0
                    else
                        return 1
                    fi    
                fi
            fi     
        else
            return 0
        fi
    }


    if [[ ${north_stack_mode} == "ipv4" && ${easysuite_ip} == ${node_1_ip} ]]; then
        check_ip=`ping $north_vis_ip -c 2 |grep -q "ttl=" && echo "yes" || echo "no"`
        if [[ ${check_ip} == "yes" ]]; then
            check_floatip_exist_ipv4 $north_vis_ip $netcard_north
            if [[ $? != 0 ]]; then
                print_log "ERROR" "The northbound floating IP(${north_vis_ip}) address is occupied. Please check."
                ((error_fail_num=error_fail_num+1))
            fi
        fi
    fi

    if [[ ${north_stack_mode} == "ipv6" && ${easysuite_ip} == ${node_1_ip} ]]; then
        check_ip=`ping -6 $north_vis_ipv6 -c 2 |grep -q "ttl=" && echo "yes" || echo "no"`
         if [[ ${check_ip} == "yes" ]]; then
            check_floatip_exist_ipv6 $north_vis_ipv6 $netcard_north
            if [[ $? != 0 ]]; then
                print_log "ERROR" "The northbound floating IP(${north_vis_ipv6}) address is occupied. Please check."
                ((error_fail_num=error_fail_num+1))
            fi
        fi
    fi
    if [[ ${north_stack_mode} == "dual_stack" && ${easysuite_ip} == ${node_1_ip} ]]; then
        check_ip=`ping $north_vis_ip -c 2 |grep -q "ttl=" && echo "yes" || echo "no"`
        if [[ ${check_ip} == "yes" ]]; then
            check_floatip_exist_ipv4 $north_vis_ip $netcard_north
            if [[ $? != 0 ]]; then
                print_log "ERROR" "The northbound floating IP(${north_vis_ip}) address is occupied. Please check."
                ((error_fail_num=error_fail_num+1))
            fi
        fi
        check_ipv6=`ping -6 $north_vis_ipv6 -c 2 |grep -q "ttl=" && echo "yes" || echo "no"`
         if [[ ${check_ipv6} == "yes" ]]; then
            check_floatip_exist_ipv6 $north_vis_ipv6 $netcard_north
            if [[ $? != 0 ]]; then
                print_log "ERROR" "The northbound floating IP(${north_vis_ipv6}) address is occupied. Please check."
                ((error_fail_num=error_fail_num+1))
            fi
        fi
    fi

    if [ ${error_fail_num} -gt 0 ]; then
        return 1
    fi

    return 0
}
