#!/bin/bash

##########################################################################
#                                                                        # 
#                       以下参数请根据规划修改                           #
#                                                                        #
##########################################################################
precheckSharePath="/opt/pre-check"
CheckResultFile="${precheckSharePath}/CheckResultFile.txt"

suse_supported_version=("11.3" "12.2" "12.4" "12.5")
euler_supported_version[0]="2.0 (SP3)"
euler_supported_version[1]="2.0 (SP5)"
euler_supported_version[2]="2.0 (SP7)"
euler_supported_version[3]="2.0 (SP8)"
euler_supported_version[4]="2.0 (SP9)"
centos_supported_version=("7.3" "7.4" "7.5" "7.6")
bclinux_supported_version[0]="7 (Core)"
cpu_num="6"
memory_space="64"
disk_size="600"
add_disk=""
#disk_io="disk_io_value"
target_direction_list=('/boot' '/' '/home' '/tmp' '/usr' '/var' '/var/log' '/var/log/audit' '/var/tmp')
_tmp_size="5*1024"
_var_size="3*1024"
_usr_size="5*1024"
_var_log_size="9.6*1024"
_var_log_audit_size="2*1024"
swap_size="32*1024"
_reserved_size="10*1024"
_home_size="1020"
_boot_size="1020"
_var_tmp_size="4.5*1024"
_root_size="20*1024"
_opt_minimum_size="50*1024"
# 读写大文件速率基线（100MB/s）
disk_io="100"
hostname=""
ip_list=""

plane="user_plane"
internal_nic="user_internal_nic"
south_nic="user_south_nic"
north_nic="user_north_nic"
south_mask="user_south_mask"
north_mask="user_north_mask"
is_bgp_enable="user_is_bgp_enable"
bgp_netcard="user_bgp_netcard"
second_south_nic="user_second_south_nic"
second_south_mask="user_second_south_mask"


north_netcard_ip="user_north_netcard_ip"
north_netcard_ipv6="user_north_netcard_v6ip"
south_netcard_ip="user_south_netcard_ip"
south_netcard_ipv6="user_south_netcard_v6ip"
internal_netcard_ip="user_internal_netcard_ip"
internal_netcard_ipv6="user_internal_netcard_v6ip"
second_south_netcard_ip="user_second_south_netcard_ip"
second_south_netcard_ipv6="user_second_south_netcard_v6ip"
north_vis_ip="user_north_vis_ip"
north_vis_ipv6="user_north_vis_v6ip"
south_floatip="user_south_floatip"
south_float_v6ip2="user_south_float_v6ip2"
second_south_float_ip="user_second_south_float_ip"
south_second_v6floatip="user_south_second_v6floatip"
bgp_south_float_ip="user_bgp_south_float_ip"
netcard_internal_single="user_netcard_internal_single"
netcard_south_double="user_netcard_south_double"
netcard_internal_double="user_netcard_internal_double"
netcard_internal_triple="user_netcard_internal_triple"
netcard_south_triple="user_netcard_south_triple"
netcard_north_triple="user_netcard_north_triple"
bgp_south_netcard_single="user_bgp_south_netcard_single"
netcard_second_south_double="user_netcard_second_south_double"
bgp_south_netcard_double="user_bgp_south_netcard_double"
netcard_second_south_triple="user_netcard_second_south_triple"
bgp_south_netcard_triple="user_bgp_south_netcard_triple"
north_vis_ip_mask="user_north_visip_mask"
north_vis_ipv6_mask="user_north_visipv6_mask"
south_floatip_mask2="user_south_float_ip_mask2"
south_floatip_v6mask2="user_south_float_ip_v6mask2"
second_south_float_ip_mask="user_second_south_floatip_mask"
south_second_v6floatip_mask="user_south_second_v6float_mask"
bgp_node="user_bgp_node"

#==============================================================
## @Usage func_name  size(P,T,G,M,K,B)
## @Return ${SUCCESS_CODE}
## @Description transfer the disk size in GB format.
## input is $1(with unit), $2(GB format)
#==============================================================
function fn_get_size_GB()
{
	local quant=`echo $1 | grep -E '[0-9.]+' -o`
	local unit=`echo $1 | grep -E '[PTGMKB]' -o`
	case ${unit} in
	"P")
		echo `echo "${quant}*1024*1024" | bc`
		;;
	"T")
		echo `echo "${quant}*1024" | bc`
		;;
	"G")
		echo `echo "${quant}" | bc`
		;;
	"M")
		echo `echo "scale=2;${quant}/1024" | bc`
		;;
	"K")
		echo `echo "scale=2;${quant}/1024/1024" | bc`
		;;
	"B")
		echo `echo "scale=2;${quant}/1024/1024/1024" | bc`
		;;
	esac
	return 0
}

function print_log()
{
	level=$1
	message=$2
	current_time=`date '+%Y-%m-%d %H:%M:%S'`
	echo "${current_time} ${level} ${message}"
}