#!/bin/bash

. ./controller.inc
. ./check_disk_space.sh
. ./check_partition_space.sh
. ./check_memory_space.sh
. ./check_os_version.sh
. ./check_cpu_num.sh
. ./check_disk_file_system.sh
. ./check_disk_io.sh
. ./check_os_components.sh
. ./check_old_AC.sh
. ./expansion_check_node_ip_config.sh

################################################################################
# name    :    main
# describe:    main function of check environment about MDSP
# parameter list: null
# input      : null
# output  : 0 success 1 failure
# rerurn  : null
# invoker : main
################################################################################
#step1: check OS_version
#step2: check CPU_NO
#step3: check Memory
#step4: check Disk_Capacity
#step5: check Partition
#step6: check filesystem format
#step7: check IP
#step8: check Hostname
#step9: check DiskIO
#step10: check Os components


function main
{
    #the variable count the fail time of check step
    typeset -i fail_num=0
    #step1： 检查操作系统版本
    print_log "INFO" "custom_check_os_version"
    check_os_version 2>/dev/null
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
		print_log "SUCCESS" "Checking OS successfully."
    fi
    print_log "INFO" "custom_check_os_version"
    #step2: 检查操作系统CPU个数
    print_log "INFO" "custom_check_cpu"
    check_cpu_num 2>/dev/null
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        print_log "SUCCESS" "Checking CPU number successfully."
    fi
    print_log "INFO" "custom_check_cpu"
    #step3: 检查操作系统内存大小
    print_log "INFO" "custom_check_memory"
    check_memory_space 2>/dev/null
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        print_log "SUCCESS" "Checking memory successfully."
    fi
    print_log "INFO" "custom_check_memory"
    #step4: 检查操作系统分区大小
    print_log "INFO" "custom_check_partition"
    check_partition_space 2>/dev/null
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        print_log "SUCCESS" "Checking partition space successfully."
    fi
    print_log "INFO" "custom_check_partition"
    #step5: 检查操作系统磁盘大小
    print_log "INFO" "custom_check_disk_space"
    check_disk_space 2>/dev/null
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        print_log "SUCCESS" "Checking disk space successfully."
    fi
    print_log "INFO" "custom_check_disk_space"
    #step6: 检查操作系统分区格式
    print_log "INFO" "custom_check_filesystem"
    check_file_system 2>/dev/null
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        print_log "SUCCESS" "Checking file system type successfully."
    fi
    print_log "INFO" "custom_check_filesystem"
    #step9: 检查磁盘IO
    print_log "INFO" "custom_check_disk_io"
    check_disk_io 2>/dev/null
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        print_log "SUCCESS" "Checking disk io successfully."
    fi
    print_log "INFO" "custom_check_disk_io"

    #step10: 检查操作系统组件
    print_log "INFO" "custom_check_os_components"
    check_os_components 2>/dev/null
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        print_log "SUCCESS" "Checking os components successfully."
    fi
    print_log "INFO" "custom_check_os_components"
    #step11: 检查是否有iDeploy安装的AC
    print_log "INFO" "custom_check_old_ac"
    check_old_AC 2>/dev/null
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        print_log "SUCCESS" "Checking old AC exist successfully."
    fi
    print_log "INFO" "custom_check_old_ac"
    #step12: 检查节点ip配置
    print_log "INFO" "custom_check_node_ip_config"
    check_node_ip_config 2>/dev/null
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1)) 
    else
        print_log "SUCCESS" "Checking node ip config successfully."
    fi
    print_log "INFO" "custom_check_node_ip_config"

    if [ ${fail_num} -gt 0 ]
    then
		print_log "ERROR" "===========================CHECKING ENVIRONMENT FAILED=============================="
		print_log "ERROR" "===================================================================================="
        return 1
    else
        print_log "INFO" "===========================CHECKING ENVIRONMENT SUCCESSFULLY========================"
        print_log "INFO" "===================================================================================="
        return 0
    fi
}

#execute main function
main "$@"
exit_code=$?
if [[ ${exit_code} -ne 0 ]];then
    print_log "ERROR" "Error ocurred during check os environment." >&2
	rm -rf /opt/install_check
    exit 1
fi
exit 0