#!/bin/bash
FileName="`basename $0`"
MODULE_NAME="`echo ${FileName} | sed 's/.sh//g'`"
RELATIVE_PATH="`dirname $0`"
function clean_vgs()
{
    vgs=$(vgs | grep -v "VG" | awk '{ print $1}' | xargs )
    for vg in ${vgs}
    do
       [ ${vg} != "vg_root" ] && vgremove -y ${vg}
    done
}

function clean_pvs()
{
    pvs=$(pvs | grep -v "PV" | awk '{ print $1}' | xargs )
    for pv in ${pvs}
    do
        echo ${pv}|grep "da" &>/dev/null
        [ $? -ne 0 ] && pvremove -y ${pv}
    done
}

function clean_part()
{
    disks=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}'| xargs)
    disk_1=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | sed -n "1p")
    for disk in ${disks}
    do
        [ ${disk} == ${disk_1} ] && continue
        number=$(parted /dev/${disk} p 2>/dev/null |grep -n "Number" |awk -F: '{print $1}')
        [ -z ${number} ] && continue
        let number++
        numbers=$(parted /dev/${disk} p 2>/dev/null |tail -n +${number} | sed '/^\s*$/d' | awk '{print $1}' | xargs)
        for part in ${numbers}
        do
            echo ${part} | grep "^[0-9]\+" &>/dev/null
            [ $? -eq 0 ] && parted -s /dev/${disk} rm ${part} 
        done
    done        
}



function makelvm_uefi()
{
    diskcount=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | wc -l)
    disk_1=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | sed -n "1p")
    systemd-detect-virt | grep -i "none" >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        if [ ${diskcount} -eq 1 -o ${diskcount} -eq 2 ]
        then
            change_space
        elif [ ${diskcount} -eq 3 -o ${diskcount} -eq 4 -o ${diskcount} -ge 5 ]
        then
            disk_2=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | sed -n "2p")
            disk_3=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | sed -n "3p")
            parted -s /dev/${disk_2} mklabel gpt
            parted -s /dev/${disk_2} mkpart primary 1 100%
            partprobe
            pvdb_1="${disk_2}1"
            pvcreate -f /dev/${pvdb_1}
            vgcreate vg_sdb /dev/${pvdb_1}
            lvcreate -y -l 50%VG -n opt vg_sdb
            mkfs.ext4 /dev/mapper/vg_sdb-opt
            [ ! -d /opt ] && mkdir -p /opt
            mount /dev/mapper/vg_sdb-opt /opt
            grep "^/dev/mapper/vg_sdb-opt" /etc/fstab &>/dev/null
            [ $? -ne 0 ] && echo "/dev/mapper/vg_sdb-opt /opt ext4 defaults 1 2" >> /etc/fstab
            echo "mount /dev/mapper/vg_sdb-opt to /opt successfully."
            lvcreate -y -l 50%VG -n backup vg_sdb
            mkfs.ext4 /dev/mapper/vg_sdb-backup
            [ ! -d /opt/backup ] && mkdir -p /opt/backup
            mount /dev/mapper/vg_sdb-backup /opt/backup
            grep "^/dev/mapper/vg_sdb-backup" /etc/fstab &>/dev/null
            [ $? -ne 0 ] && echo "/dev/mapper/vg_sdb-backup /opt/backup ext4 defaults 1 2" >> /etc/fstab
            echo "mount /dev/mapper/vg_sdb-backup to /opt/backup successfully."
            lvcreate -y -l 100%VG -n spare vg_root
            mkfs.ext4 -F /dev/mapper/vg_root-spare
            [ ! -d /spare ] && mkdir -p /spare
            mount /dev/mapper/vg_root-spare /spare
            grep "^/dev/mapper/vg_root-spare" /etc/fstab &>/dev/null
            [ $? -ne 0 ] && echo "/dev/mapper/vg_root-spare /spare ext4 defaults 1 2" >> /etc/fstab
            echo "mount /dev/mapper/vg_root-spare to /spare successfully."
            parted -s /dev/${disk_3} mklabel gpt
            parted -s /dev/${disk_3} mkpart primary 1 100%
            partprobe
            pvdc_1="${disk_3}1"
            pvcreate -f /dev/${pvdc_1}
            vgcreate vg_sdc /dev/${pvdc_1}
            lvcreate -y -l 100%VG -n systembackup vg_sdc
            mkfs.ext4 /dev/mapper/vg_sdc-systembackup
            [ ! -d /opt/systembackup ] && mkdir -p /opt/systembackup
            mount /dev/mapper/vg_sdc-systembackup /opt/systembackup
            grep "^/dev/mapper/vg_sdc-systembackup" /etc/fstab &>/dev/null
            [ $? -ne 0 ] && echo "/dev/mapper/vg_sdc-systembackup /opt/systembackup ext4 defaults 1 2" >> /etc/fstab     
            echo "mount /dev/mapper/vg_sdc-systembackup to /opt/systembackup successfully."
            disk_4=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | sed -n "4p")
            if [ -n "${disk_4}" ]
            then
                parted -s /dev/${disk_4} mklabel gpt
                parted -s /dev/${disk_4} mkpart primary 1 100%
                partprobe
                pvdd_1="${disk_4}1"
                pvcreate -f /dev/${pvdd_1}
                vgcreate vg_sdd /dev/${pvdd_1}
                lvcreate -y -l 100%VG -n databackup vg_sdd
                mkfs.ext4 /dev/mapper/vg_sdd-databackup
                [ ! -d /opt/databackup ] && mkdir -p /opt/databackup
                mount /dev/mapper/vg_sdd-databackup /opt/databackup
                grep "^/dev/mapper/vg_sdd-databackup" /etc/fstab &>/dev/null
                [ $? -ne 0 ] && echo "/dev/mapper/vg_sdd-databackup /opt/databackup ext4 defaults 1 2" >> /etc/fstab
                echo "mount /dev/mapper/vg_sdd-databackup to /opt/databackup successfully."
            fi
        else
            echo "Error:The number of disk groups is not supported,exit!"
            exit 1
        fi
    fi
}


function makelvm_bios()
{
    diskcount=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | wc -l)
    disk_1=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | sed -n "1p")
    systemd-detect-virt | grep -i "none" >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        if [ ${diskcount} -eq 1 -o ${diskcount} -eq 2 ]
        then
            change_space
        elif [ ${diskcount} -eq 3 -o ${diskcount} -eq 4 -o ${diskcount} -ge 5 ]
        then
            disk_2=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | sed -n "2p")
            disk_3=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | sed -n "3p")
            /sbin/fdisk /dev/${disk_2}  <<EOF
n
p
1


t

8e
w
EOF
            partprobe
            pvdb_1="${disk_2}1"
            pvcreate -f /dev/${pvdb_1}
            vgcreate vg_sdb /dev/${pvdb_1}
            lvcreate -y -l 50%VG -n opt vg_sdb
            mkfs.ext4 /dev/mapper/vg_sdb-opt
            [ ! -d /opt ] && mkdir -p /opt
            mount /dev/mapper/vg_sdb-opt /opt
            grep "^/dev/mapper/vg_sdb-opt" /etc/fstab &>/dev/null
            [ $? -ne 0 ] && echo "/dev/mapper/vg_sdb-opt /opt ext4 defaults 1 2" >> /etc/fstab
            echo "mount /dev/mapper/vg_sdb-opt to /opt successfully."
            lvcreate -y -l 50%VG -n backup vg_sdb
            mkfs.ext4 /dev/mapper/vg_sdb-backup
            [ ! -d /opt/backup ] && mkdir -p /opt/backup
            mount /dev/mapper/vg_sdb-backup /opt/backup
            grep "^/dev/mapper/vg_sdb-backup" /etc/fstab &>/dev/null
            [ $? -ne 0 ] && echo "/dev/mapper/vg_sdb-backup /opt/backup ext4 defaults 1 2" >> /etc/fstab
            echo "mount /dev/mapper/vg_sdb-backup to /opt/backup successfully."
            lvcreate -y -l 100%VG -n spare vg_root
            mkfs.ext4 /dev/mapper/vg_root-spare
            [ ! -d /spare ] && mkdir -p /spare
            mount /dev/mapper/vg_root-spare /spare
            grep "^/dev/mapper/vg_root-spare" /etc/fstab &>/dev/null
            [ $? -ne 0 ] && echo "/dev/mapper/vg_root-spare /spare ext4 defaults 1 2" >> /etc/fstab
            echo "mount /dev/mapper/vg_root-spare to /spare successfully."
            /sbin/fdisk /dev/${disk_3}  <<EOF
n
p
1


t

8e
w
EOF
            partprobe
            pvdc_1="${disk_3}1"
            pvcreate -f /dev/${pvdc_1}
            vgcreate vg_sdc /dev/${pvdc_1}
            lvcreate -y -l 100%VG -n systembackup vg_sdc
            mkfs.ext4 /dev/mapper/vg_sdc-systembackup
            [ ! -d /opt/systembackup ] && mkdir -p /opt/systembackup
            mount /dev/mapper/vg_sdc-systembackup /opt/systembackup
            grep "^/dev/mapper/vg_sdc-systembackup" /etc/fstab &>/dev/null
            [ $? -ne 0 ] && echo "/dev/mapper/vg_sdc-systembackup /opt/systembackup ext4 defaults 1 2" >> /etc/fstab
            echo "mount /dev/mapper/vg_sdc-systembackup to /opt/systembackup successfully."
            disk_4=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | sed -n "4p")
            if [ -n "${disk_4}" ]
            then
                /sbin/fdisk /dev/${disk_4}  <<EOF
n
p
1


t

8e
w
EOF
                partprobe
                pvdd_1="${disk_4}1"
                pvcreate -f /dev/${pvdd_1}
                vgcreate vg_sdd /dev/${pvdd_1}
                lvcreate -y -l 100%VG -n databackup vg_sdd
                mkfs.ext4 /dev/mapper/vg_sdd-databackup
                [ ! -d /opt/databackup ] && mkdir -p /opt/databackup
                mount /dev/mapper/vg_sdd-databackup /opt/databackup
                grep "^/dev/mapper/vg_sdd-databackup" /etc/fstab &>/dev/null
                [ $? -ne 0 ] && echo "/dev/mapper/vg_sdd-databackup /opt/databackup ext4 defaults 1 2" >> /etc/fstab
                echo "mount /dev/mapper/vg_sdd-databackup to /opt/databackup successfully."
            fi
        else
            echo "Error:The number of disk groups is not supported,exit!"
            exit 1
        fi
    fi
}


function change_space()
{
            vg_root_size=`vgs | awk -F ' ' '{print $6}'| awk -F 'VSize' '{print $1}'`
            size_code=${vg_root_size:0-1:1}
            size_num=$(echo "${vg_root_size}" | tr -cd "[0-9][.]")
                if [[ "$size_code" == "T" &&  $size_num*1024 > 123 ]] || [[ "$size_code" == "t" &&  $size_num*1024 > 123 ]] || [[ "$size_code" == "G" &&  $size_num > 123 ]] || [[ "$size_code" == "g" &&  $size_num > 123 ]]
                then
                    fuser -m -v /dev/mapper/vg_root-opt &>/dev/null
                    umount /dev/mapper/vg_root-opt &>/dev/null
                    lvremove -y /dev/mapper/vg_root-opt &>/dev/null
                    lvcreate -y -l 100%VG -n opt vg_root
                    mkfs.ext4 /dev/mapper/vg_root-opt
                    [ ! -d /opt ] && mkdir -p /opt
                    mount /dev/mapper/vg_root-opt /opt
                    grep "^/dev/mapper/vg_root-opt" /etc/fstab &>/dev/null
                    [ $? -ne 0 ] && echo "/dev/mapper/vg_root-opt /opt ext4 defaults 1 2" >> /etc/fstab
                    echo "mount /dev/mapper/vg_root-opt to /opt successfully."
                else
                     fdisk /dev/sda <<EOF
n
p



w
EOF
                     sda=`fdisk -l /dev/sda | tail -1 | awk -F ' ' '{print $1}'`
                     [ ! -e $sda ] && {
                         echo "$sda is not exist.";
                         return 1 
                     }
                     pvcreate $sda
                     vgextend vg_root $sda
                     fuser -m -v /dev/mapper/vg_root-opt &>/dev/null
                     umount /dev/mapper/vg_root-opt &>/dev/null
                     lvremove -y /dev/mapper/vg_root-opt &>/dev/null
                     lvcreate -y -l 100%VG -n opt vg_root
                     mkfs.ext4 /dev/mapper/vg_root-opt
                     [ ! -d /opt ] && mkdir -p /opt
                     mount /dev/mapper/vg_root-opt /opt
                     grep "^/dev/mapper/vg_root-opt" /etc/fstab &>/dev/null
                     [ $? -ne 0 ] && echo "/dev/mapper/vg_root-opt /opt ext4 defaults 1 2" >> /etc/fstab
                     echo "mount /dev/mapper/vg_root-opt to /opt successfully."
                fi
}


function makelvm()
{
    clean_vgs
    clean_pvs
    clean_part
    lsblk | grep "/boot/efi$" &>/dev/null
    if [ $? -eq 0 ]
    then
        makelvm_uefi
    else
        makelvm_bios
    fi
}
makelvm $@
RET_MAIN=$?
if [[ "${RET_MAIN}" == "0" ]]
then
    logger -t $USER -p local0.info "$FileName;Successful;${OPERIP:-127.0.0.1};Excute execution $FileName."
else
    logger -t $USER -p local0.err "$FileName;Failed;${OPERIP:-127.0.0.1};Excute execution $FileName."
fi
exit ${RET_MAIN}
