#!/bin/bash
. ./controller.inc
################################################################################
# Function    : check_cpu_num
# Description : check the cpu_num.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_cpu_num
{
    #idle cpu
    total_cpu=`cat /proc/cpuinfo | grep "processor" | sort -u | wc -l`

    if [ "X${cpu_num}" == "X" ];then
        echo "[cpu check warning]Expected cpu num is not provided, skip check cpu num" >&1
        return 0
    fi    
    
    if [  $total_cpu -lt ${cpu_num} ]; then
        echo "[cpu check failed]The logic CPU number is ${total_cpu} , less than ${cpu_num} !"
        echo " " >&2
        return 1
    fi

    echo "The logic CPU number is ${total_cpu} !"

    typeset -i nproc_fail_num=0

    if [ ${nproc_fail_num} -gt 0 ];then
        return 1
    fi

    return 0
}