#!/bin/bash

. ./controller.inc
. ./check_disk_space.sh
. ./check_memory_space.sh
. ./check_os_version.sh
. ./migrate_check_cpu_num.sh
. ./check_disk_file_system.sh
. ./check_disk_io.sh
. ./check_os_components.sh

installDir=/tmp/install_check
createCheckFile()
{
   
    echo "#!/bin/bash
echo  RESULT:1   
   ">${installDir}/migrate_check_env_check.sh
 
   chmod 755 ${installDir}/migrate_check_env_check.sh
}

#封装业务侧错误,只需确保EasySuite框架识别到真正的检查错误,防止出现各个检查项都通过,出现其他异常导致页面显示总的检查项不通过
getcheckResult()
{
   if [ $1 -eq 0 ]
   then
       echo "#!/bin/bash
echo  RESULT:100 && rm -rf ${installDir}/migrate_check_env_check.sh
   ">${installDir}/migrate_check_env_check.sh
   else
       echo "#!/bin/bash
echo  RESULT:255 && rm -rf ${installDir}/migrate_check_env_check.sh
   ">${installDir}/migrate_check_env_check.sh
   fi
   chmod 755 ${installDir}/migrate_check_env_check.sh > /dev/null 2>&1
}

################################################################################
# name    :    main
# describe:    main function of check environment about MDSP
# parameter list: null
# input      : null
# output  : 0 success 1 failure
# rerurn  : null
# invoker : main
################################################################################
#step1: check OS_version
#step2: check CPU_NO
#step3: check Memory
#step4: check Disk_Capacity
#step5: check filesystem format
#step6: check Hostname
#step7: check DiskIO


function main
{
    createCheckFile
    
    #the variable count the fail time of check step
    typeset -i fail_num=0
    #step1： 检查操作系统版本检查操作系统版本是否为Redhat7.4/CentOS7.3/Suse11 SP3/Suse12 SP2/Suse12 SP3/Suse12 SP4/EulerOS2.0 SP3/EulerOS2.0 SP5
    echo "custom_check_os_version"
    check_os_version 2>/dev/null
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        echo "[os check successfully] Checking OS successfully !"
    fi
    echo "custom_check_os_version"
    #step2: 检查操作系统CPU个数
    echo "custom_check_cpu"
    check_cpu_num
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        echo "[cpu check successfully] Checking CPU number successfully !"
    fi
    echo "custom_check_cpu"
    #step3: 检查操作系统内存大小
    echo "custom_check_memory"
    check_memory_space
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        echo "[memory check successfully] Checking memory successfully !"
    fi
    echo "custom_check_memory"
    #step4: 检查操作系统磁盘大小
    echo "custom_check_disk_space"
    check_disk_space
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        echo "[disk_space check successfully] Checking disk space successfully !"
    fi
    echo "custom_check_disk_space"
    #step5: 检查操作系统分区格式
    echo "custom_check_filesystem"
    check_file_system
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        echo "[filesystem check successfully] Checking file system successfully !"
    fi
    echo "custom_check_filesystem"
    #step6: 检查磁盘IO
    echo "custom_check_disk_io"
    check_disk_io
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        echo "[disk io check successfully]Checking disk io successfully !"
    fi
    echo "custom_check_disk_io"
     #step10: 检查操作系统组件
    echo "custom_check_os_components"
    check_os_components
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        echo "[os components check successfully]Checking os components successfully !"
    fi
    echo "custom_check_os_components"
   

    if [ ${fail_num} -gt 0 ]
    then
        echo "===========================CHECKING ENVIRONMENT FAILED=============================="
        echo "===================================================================================="
        return 1
    else
        echo "===========================CHECKING ENVIRONMENT SUCCESSFULLY========================"
        echo "===================================================================================="
        return 0
    fi
}

#execute main function
main "$@"
exit_code=$?
getcheckResult $exit_code

if [[ ${exit_code} -ne 0 ]];then
    echo "Error ocurred during check os environment" >&2
    exit 1
fi
exit 0