#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
root_pwd=$1
root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' -- "${root_pwd}")
os_pkg_tar=$2
os_pkg_gz=$3
os_pkg_patch=$4
self_name="${0##*/}"
log_dir=`sh ${CUR_PATH}/../scripts/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log
temporary_dir=$(sh ${CUR_PATH}/../scripts/get_temporary_dir.sh)
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is ${2} ${3} ${4}" >> ${log_file}
master_ip=`. /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "import sys;sys.path.append('${CUR_PATH}/../scripts/pyscripts/');import get_ip_by_num;print(get_ip_by_num.get_ip('0'))"`


function start_install_os_patch()
{
    local ip=${1}
    local patch_dir=${2}
    local file_name=${3}
    export TMOUT=100000
    expect <<EOF
        set timeout -1
        spawn ssh -o ServerAliveInterval=60 ossadm@${ip}
        expect {
            ">" { send "su - root\n";}
            "~]" { send "su - root\n";}
        }
        expect "Password:" { send -- "${root_pwd}\r" }
        expect "#" { send "chown -R root:root ${patch_dir}/${file_name}\r" }
        expect "#" { send "sh ${patch_dir}/${file_name}\r" }
        expect "#" { send "exit\r" } expect eof
EOF
}

function main()
{
    file_name=ospatch_start2.sh
    ospatch_start2=${CUR_PATH}/${file_name}
    [[ -f ${ospatch_start2} ]] && rm -rf ${ospatch_start2}
    cp ${CUR_PATH}/ospatch_start.sh ${ospatch_start2}

    patch_dir=/opt/patch

    # 获取节点IP（线上版）
    . /opt/oss/manager/agent/bin/engr_profile.sh
    IPS_UN_ORDER=$(python ${CUR_PATH}/../scripts/pyscripts/updatenodes_NCE.py)
    result=$?
    if [[ ${result} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get IPS_UN_ORDER successfully: ${IPS_UN_ORDER}" | tee -a ${log_file}
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get IPS_UN_ORDER failed" | tee -a ${log_file}
            exit 1
    fi

    # 对IP进行排序，omp节点IP排在最后面
    IPS=`${PYTHONHOME}/bin/python -c "ip_list=[ip for ip in '${IPS_UN_ORDER}'.split(',') if '${master_ip}' != ip.rsplit(':', 1)[0]];ip_list.append('${master_ip}'+':9094');print(','.join(ip_list))"`
    result=$?
    if [[ ${result} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get IPS successfully: ${IPS}" | tee -a ${log_file}
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get IPS failed" | tee -a ${log_file}
            exit 1
    fi

    # ospatch_start2.sh中的变量替换为具体的值
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "sed file ${ospatch_start2}"
    sed -i "s/{os_pkg_tar}/${os_pkg_tar}/g" ${ospatch_start2}
    sed -i "s/{os_pkg_gz}/${os_pkg_gz}/g" ${ospatch_start2}
    sed -i "s/{os_pkg_patch}/${os_pkg_patch}/g" ${ospatch_start2}
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "success sed file ${ospatch_start2}"

    # 创建/opt/patch
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "mkdir ${patch_dir}"
    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        expect <<EOF
            set timeout -1
            spawn ssh ossadm@${ip}
            expect {
                ">" { send "su - root\n";}
                "~]" { send "su - root\n";}
            }
            expect "Password:" { send -- "${root_pwd}\r" }
            expect "#" { send "bash /opt/SEK/cmd/SetEnv.sh\r" }
            expect "#" { send "\[\[ -d ${patch_dir} \]\] && rm -rf ${patch_dir} \r" }
            expect "#" { send "mkdir ${patch_dir}\r" }
            expect "#" { send "chown -R ossadm:ossgroup ${patch_dir}\r" }
            expect "#" { send "\[\[ -f /opt/upgrade/${os_pkg_tar} \]\] && chown -h ossadm:ossgroup /opt/upgrade/${os_pkg_tar} \r" }
            expect "#" { send "exit\r" } expect eof
EOF
    done
    wait
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "success mkdir /opt/patch"


    # 关闭db主备倒换
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start ignore db switch"
    /opt/oss/manager/apps/CloudbMgmtService/bin/switchtool.sh -cmd set-ignore-nodes -nodes all
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "end ignore db switch"

    # 停止服务
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "success stop service"
    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        ssh -o StrictHostKeyChecking=no ossadm@${ip} << EOF
            . /opt/oss/manager/bin/engr_profile.sh
            ipmc_adm -cmd stopnode
            exit
EOF
        retry_times=5
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start copy file"
        for((i=1;i<=${retry_times};i++))
        do
            scp /opt/upgrade/${os_pkg_tar} ossadm@[$ip]:${patch_dir}
            result1=$?
            scp ${ospatch_start2} ossadm@[$ip]:${patch_dir}
            result2=$?
            if [[ ${result1} == "0" ]] && [[ ${result2} == "0" ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "success copy file"
                break
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "failed copy file, retry_times: ${i}"
                if [[ ${i} -eq ${retry_times} ]]
                then
                    exit 1
                fi
                sleep 10
            fi
        done
    done
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "end stop service"


    #确认升级是否执行成功
    #创建结果文件夹
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start install os_patch"
    retry_times=3
    failed_ips=${IPS}
    for((i=1;i<=${retry_times};i++))
    do
        # os升级
        failed_ips_array=(${failed_ips//,/ })
        for ip_port in ${failed_ips_array[@]}
        do
            {
            ip_port_array=(${ip_port//:9094/ })
            ip=${ip_port_array[0]}
            start_install_os_patch ${ip} ${patch_dir} ${file_name}
            }&
        sleep 15
        done
        wait

        result_set_install="${temporary_dir}/query_os_install"
        result_install_dir="${patch_dir}/os_patch/script"
        rm -rf ${result_set_install}
        mkdir -p ${result_set_install}

        IPS_array=(${IPS//,/ })
        for ip_port in ${IPS_array[@]}
        do
            ip_port_array=(${ip_port//:9094/ })
            ip=${ip_port_array[0]}
            expect <<EOF
            set timeout -1
            spawn ssh ossadm@${ip}
            expect {
                ">" { send "su - root\n";}
                "~]" { send "su - root\n";}
            }
            expect "Password:" { send -- "${root_pwd}\r" }
            expect "#" { send "cp ${result_install_dir}/result.* ${temporary_dir}/result_install_${ip}.txt 2>${temporary_dir}/result_install_${ip}.txt\n" }
            expect "#" { send "chown ossadm:ossgroup ${temporary_dir}/result_install_${ip}.txt\n" }
            expect "#" { send "exit\n" } expect eof
EOF
        wait
        done

        #将结果取回omp
        for ip_port in ${IPS_array[@]}
        do
            ip_port_array=(${ip_port//:9094/ })
            ip=${ip_port_array[0]}
            scp ossadm@\[$ip\]:${temporary_dir}/result_install_${ip}.txt ${result_set_install}
        done

        #判断结果
        failed_ips=""
        is_success=0
        for file in ${result_set_install}/*;do
            result=`cat $file | grep "success"`
            if [[ "${result}X" != "X" ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "os install $file successful"
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "os install $file faield"
                is_success=1
                failed_ip=`${PYTHONHOME}/bin/python -c "print('$file'.split('.txt')[0].split('_')[-1])"`
                result=$?
                if [[ ${result} == "0" ]]
                    then
                        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get failed_ip successfully: ${failed_ip}"
                    else
                        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get failed_ip failed"
                        exit 1
                fi
                failed_ips=${failed_ips},${failed_ip}:9094
            fi
        done

        # 判断是否成功
        if [[ ${is_success} -eq 0 ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "os install successful"
            break
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "os install failed, retry_times: ${i}, failed_ips: ${failed_ips}"
            if [[ ${i} -eq ${retry_times} ]]
            then
                exit 1
            fi
            # 处理failed_ips(逗号和顺序)
            failed_ips=`${PYTHONHOME}/bin/python -c "print('${failed_ips}'.strip(','))"`
            failed_ips=`${PYTHONHOME}/bin/python -c "ip_list=[ip for ip in '${failed_ips}'.split(',') if '${master_ip}' != ip.rsplit(':', 1)[0]];ip_list.append('${master_ip}'+':9094');print(','.join(ip_list))"`
            result=$?
            if [[ ${result} == "0" ]]
                then
                    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get failed_ips successfully: ${failed_ips}"
                else
                    echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get failed_ips failed"
                    exit 1
            fi
            sleep 10
        fi
    done

    #恢复db主备倒换
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start restore db switch"
    /opt/oss/manager/apps/CloudbMgmtService/bin/switchtool.sh -cmd del-ignore-nodes
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "end restore db switch"

    #重启os，重启之前做如下规避
    # lsblk 的回显如果含有 lv_root, 继续如下执行；否则不需要继续执行
    # ll /sys/firmware/ | grep efi
    # 如果有回显内容，执行以下命令：
    # grub2-mkconfig -o /boot/efi/EFI/euleros/grub.cfg
    # 如果无回显内容，执行以下命令：
    # grub2-mkconfig -o /boot/grub2/grub.cfg

    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start restart"
    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        {
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        expect <<EOF
            set timeout -1
            spawn ssh ossadm@${ip}
            expect {
                ">" { send "su - root\n";}
                "~]" { send "su - root\n";}
            }
            expect "Password:" { send -- "${root_pwd}\r" }
            expect "#" { send "\[\[ ! -z $\(lsblk | grep lv_root\) \]\] && \[\[ -z $\(ls /sys/firmware/ | grep efi\) \]\] && grub2-mkconfig -o /boot/grub2/grub.cfg \r" }
            expect "#" { send "\[\[ ! -z $\(lsblk | grep lv_root\) \]\] && \[\[ ! -z $\(ls /sys/firmware/ | grep efi\) \]\] && grub2-mkconfig -o /boot/efi/EFI/euleros/grub.cfg \r" }
            expect "#" { send "chown -R root:root ${patch_dir}/*\r" }
            expect "#" { send "shutdown -r +1\r" }
            expect "#" { send "bash /opt/SEK/cmd/RollBackEnv.sh\r" }
            expect "#" { send "exit\r" } expect eof
EOF
        }
    done
    wait
}

main >> ${log_file} 2>&1
