import subprocess
import time
from datetime import datetime
import os
import sys
sys.path.append(os.path.split(os.path.abspath(__file__))[0])
import set_log
from func.upgrade.upgrade_operation_mgr.dao.upgrade_childtask_dao import UpgradeChildTaskDao


def exe(kvs):
    cur_path = os.path.split(__file__)[0]
    cur_file_name = os.path.split(__file__)[1]
    get_log_shell = os.path.join(cur_path, "..", "scripts", "get_log_dir.sh")
    _, log_dir = subprocess.getstatusoutput("sh %s" % get_log_shell)
    my_log = set_log.set_log(filename=os.path.join(log_dir, "%s.log" % cur_file_name))
    start_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
    msg = "[%s] Start upgrade os online" % start_time
    try:
        cur_path = os.path.split(__file__)[0]
        my_log.info(__file__)
        easysuite_upgrade_params = kvs.get('easysuite_upgrade_params')
        task_id = easysuite_upgrade_params.get('task_id')
        sub_task_id = easysuite_upgrade_params.get('sub_task_id')
        child_task_id = easysuite_upgrade_params.get('child_task_id')
        simple_kvs = easysuite_upgrade_params.get('simple_kvs')
        standby_ip = simple_kvs.get('standby').get('0').get('ip')
        standby_ip_pwd = simple_kvs.get('standby').get('0').get('ossadm')
        sopuser_pwd = simple_kvs.get('standby').get('0').get('sopuser')
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'status': 'running'})
        time.sleep(10)
        root_pwd = easysuite_upgrade_params.get('adminpwd')
        os_pkg_tar = easysuite_upgrade_params["whole_pro_pkgs"]["ospatchpackage"]
        os_pkg_gz = "%s.tar.gz" % os_pkg_tar.split("_pkg.tar")[0]
        os_pkg_patch = os_pkg_tar.split("-")[0]
        upgrade_step = "after"
        command = "sh %s %s %s %s %s %s %s %s %s %s" % (
            os.path.join(cur_path, "ssh_exec.sh"), upgrade_step, standby_ip, standby_ip_pwd, sopuser_pwd, "install_ospatch_online", root_pwd, os_pkg_tar, os_pkg_gz, os_pkg_patch)
        result = subprocess.call(command.split(), stdout=subprocess.PIPE, stdin=subprocess.PIPE)
    except:
        my_log.exception("Excepion logged")
        result = 1
    if result != 0:
        end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        msg = msg + '\n' + "[%s] upgrade_os_online failed" % end_time
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'remain_time': '0'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'progress': '100'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'status': 'error'})
        print(UpgradeChildTaskDao.query(task_id, sub_task_id, child_task_id))
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg})
        return False
    else:
        end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        msg = msg + '\n' + "[%s] upgrade_os_online success" % end_time
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'remain_time': '0'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'progress': '100'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'status': 'finish'})
        print(UpgradeChildTaskDao.query(task_id, sub_task_id, child_task_id))
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg})
        return True
