#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
log_dir=`sh ${EXEC_HOME}/../scripts/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log
root_info=$1
root_info=$(perl -e 'print quotemeta shift(@ARGV)' -- "${root_info}")
master_ip=`. /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "import sys;sys.path.append('${EXEC_HOME}/../scripts/pyscripts/');import get_ip_by_num;print(get_ip_by_num.get_ip('0'))"`
slave_ip=`. /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "import sys;sys.path.append('${EXEC_HOME}/../scripts/pyscripts/');import get_ip_by_num;print(get_ip_by_num.get_ip('1'))"`

function main()
{
    # 获取节点IP（线上版）
    . /opt/oss/manager/agent/bin/engr_profile.sh
    IPS=$(python ${EXEC_HOME}/../scripts/pyscripts/updatenodes_NCE.py)
    result=$?
    if [[ ${result} == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get IPS successfully: ${IPS}" | tee -a ${log_file}
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get IPS failed" | tee -a ${log_file}
        exit 1
    fi
    #增加数据库句柄数
    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        expect <<EOF
            set timeout -1
            spawn ssh ossadm@${ip}
            expect {
                ">" { send "su - root\n";}
                "~]" { send "su - root\n";}
            }
            expect "Password:" { send -- "${root_info}\n" }
            expect "#" { send "ulimit  -n 200000\n" }
            expect "#" { send "sed -i '/^*\[\[:space:\]\]*soft\[\[:space:\]\]*nofile/d' /etc/security/limits.conf\n" }
            expect "#" { send "echo '*               soft    nofile         200000'   >>/etc/security/limits.conf\n" }
            expect "#" { send "sed -i '/vm.panic_on_oom/d' /etc/sysctl.conf\n" }
            expect "#" { send "echo 'vm.panic_on_oom=0' >>/etc/sysctl.conf\n" }
            expect "#" { send "sysctl -p >/dev/null 2>&1\n" }
            expect "#" { send "sed -i '/MALLOC_MMAP_THRESHOLD_/d' /etc/profile\n" }
            expect "#" { send "sed -i '/MALLOC_TRIM_THRESHOLD_/d' /etc/profile\n" }
            expect "#" { send "sed -i '/MALLOC_TOP_PAD_/d' /etc/profile\n" }
            expect "#" { send "sed -i '/MALLOC_MMAP_MAX_/d' /etc/profile\n" }
            expect "#" { send "sed -i '/MALLOC_ARENA_MAX/d' /etc/profile\n" }
            expect "#" { send "echo 'export MALLOC_MMAP_THRESHOLD_=131072' >>/etc/profile\n" }
            expect "#" { send "echo 'export MALLOC_TRIM_THRESHOLD_=131072' >>/etc/profile\n" }
            expect "#" { send "echo 'export MALLOC_TOP_PAD_=131072' >>/etc/profile\n" }
            expect "#" { send "echo 'export MALLOC_MMAP_MAX_=65536' >>/etc/profile\n" }
            expect "#" { send "echo 'export MALLOC_ARENA_MAX=2' >>/etc/profile\n" }
            expect "#" { send "source /etc/profile\n" }
            expect "#" { send "bash /opt/install/logic_tool_kill.sh\n" }
            expect "#" { send "exit\n" } expect eof
EOF
wait
    done

     # 【问题背景】产生BGP服务无主
     # 【问题根因】 BGP节点从3变2后，第2个节点需要删除残留的文件，后续残留，产生无主告警
     /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "ElectionAgentService" | grep "electionagentservice" | awk '{print $6}' | while read line
     do
        echo "deal ElectionAgentService in ${line}"
        file_name=/opt/oss/share/NCECOMMONE/ElectionAgentService/BgpService-0
        if [ -d "/opt/oss/NCE/apps/DCNService" ] 
        then
            file_name=/opt/oss/share/NCE/ElectionAgentService/BgpService-0
        fi
        ssh ossadm@"$line" << remotessh
            if [[ -d ${file_name} ]] || [[ -f ${file_name} ]]
            then
              echo "${file_name} exists, remove it"
              sudo -u ossuser rm -rf ${file_name}
            fi
            exit
remotessh
     done

     # 执行租户ID删除
    retry_times=8
    cd ${EXEC_HOME}/../scripts/plugins/delete_tenant_id
    for((i=1;i<=${retry_times};i++))
    do
        . /opt/oss/manager/bin/engr_profile.sh; bash migrate_common.sh
        result=$?
        if [[ "${result}" == "0" ]]
        then
            echo "delete tanant id successfully."
            break
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "delete_tenant_id failed, retry_times: ${i}"
            if [[ ${i} -eq ${retry_times} ]]
            then
                exit 1
            fi
            sleep 5
        fi
    done
}

main >> ${log_file} 2>&1
