#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
log_dir=`sh ${EXEC_HOME}/../scripts/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log
root_info=$1
root_info=$(perl -e 'print quotemeta shift(@ARGV)' -- "${root_info}")
master_ip=`. /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "import sys;sys.path.append('${EXEC_HOME}/../scripts/pyscripts/');import get_ip_by_num;print(get_ip_by_num.get_ip('0'))"`
slave_ip=`. /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "import sys;sys.path.append('${EXEC_HOME}/../scripts/pyscripts/');import get_ip_by_num;print(get_ip_by_num.get_ip('1'))"`


function main()
{
    expect <<EOF
        set timeout 60
        spawn ssh ossadm@${master_ip}
        expect {
            ">" { send "su - root\n";}
            "~]" { send "su - root\n";}
        }
        expect "Password:"
        send -- "$root_info\r"
        expect "#"
        send "rm -rf /opt/install\r"
        expect {
            "#" {send "\n";}
            "yes/no" {send "yes\n";exp_continue}
        }
        expect "#"
        send "mkdir -p /opt/install\r"
        expect "#"
        send "cp -rf $EXEC_HOME/logicrep/logic_tool_kill.sh /opt/install\r"
        expect "#"
        send "cd /opt/install\r"
        expect "#"
        send "chown -R root:root /opt/install\r"
        expect "#"
        send "sh logic_tool_kill.sh\r"
        expect "#" { send "exit\r" } expect eof
EOF
wait
    if [ -n "$slave_ip" ];then
        ssh -o StrictHostKeyChecking=no ossadm@${slave_ip} rm -rf /opt/oss/logicrep
        scp -r $EXEC_HOME/logicrep ossadm@[$slave_ip]:/opt/oss
        expect <<EOF
        set timeout 60
        spawn ssh ossadm@${slave_ip}
        expect {
            ">" { send "su - root\n";}
            "~]" { send "su - root\n";}
        }
        expect "Password:"
        send -- "$root_info\r"
        expect "#"
        send "rm -rf /opt/install\r"
        expect {
            "#" {send "\n";}
            "yes/no" {send "yes\n";exp_continue}
        }
        expect "#"
        send "mkdir -p /opt/install\r"
        expect "#"
        send "cp -rf /opt/oss/logicrep/* /opt/install\r"
        expect "#"
        send "cd /opt/install\r"
        expect "#"
        send "chown -R root:root /opt/install\r"
        expect "#"
        send "sh logic_tool_kill.sh\r"
        expect "#" { send "exit\r" } expect eof
EOF
wait
    fi
}
main >> ${log_file} 2>&1
