#!/bin/bash

if [ ! -d "/opt/oss/NCE/apps/DTAgentService" ]&&[ ! -d "/opt/oss/NCECOMMONE/apps/DTAgentService" ]; then
  echo "============================== skip logicrep installation ===================================="
  exit 0
fi

echo "============================== start install logicrep ===================================="

if [ -f "/opt/zenith/app/admin/plugin/logicrep/shutdown.sh" ]; then
  echo "Stop the logicrep tool process."
  su - dbuser -c 'nohup bash /opt/zenith/app/admin/plugin/logicrep/watchdog_shutdown.sh -n logicrep > /dev/null 2>&1'
  su - dbuser -c 'nohup bash /opt/zenith/app/admin/plugin/logicrep/shutdown.sh -n logicrep > /dev/null 2>&1'
  sleep 10
fi

ps -aux | grep logicrep | grep -v 'grep' | grep -v 'logicrep_install.sh' | awk '{print $2}' | xargs kill -9 > /dev/null 2>&1


if [ -f "/opt/install/GaussDB_T_1.2.1-LOGICREP.tar.gz" ]; then
  rm -rf /opt/software/tools
  mkdir -p /opt/software/tools

  echo "unzip the logicrep."
  tar -zxvf /opt/install/GaussDB_T_1.2.1-LOGICREP.tar.gz -C /opt/software/tools

  is_suse=$(cat /etc/*release |grep SUSE | wc -l)

  if [ $is_suse -ge 1 ]&&[ -f "/opt/install/SUSE/GaussDB_T_1.2.1-LOGICREP.tar.gz" ]; then
    rm -rf /opt/software/tools/*
    tar -zxvf /opt/install/SUSE/GaussDB_T_1.2.1-LOGICREP.tar.gz -C /opt/software/tools
  fi

  cp /opt/install/kafka-clients-*.jar /opt/software/tools/GaussDB_T_*-LOGICREP/logicrep/lib

  if [ -d "/opt/zenith/app/admin/plugin/logicrep" ]; then
    rm -rf /opt/zenith/app/admin/plugin/logicrep
  fi

  mkdir -p /opt/zenith/app/admin/plugin
  cp -r /opt/software/tools/GaussDB_T_*-LOGICREP/logicrep /opt/zenith/app/admin/plugin
  chown -R dbuser:  /opt/zenith/app/admin/
  chmod -R 770 /opt/zenith/app/admin/plugin
  rm -rf /opt/software/tools
else
  echo "The logicrep tool version does not match"
  exit 1
fi


if [ -f "/opt/install/logicrep_install.py" ]||[ -f "/opt/install/logicrep_install.pyc" ]; then
  echo "starting the logical replication tool."
  cp /opt/install/logicrep_install.py /opt/software/

  if [ -f "/opt/oss/NCE/apps/DTAgentService/rtsp/python/bin/python" ]||[ -f "/opt/oss/NCECOMMONE/apps/DTAgentService/rtsp/python/bin/python" ]; then
    rm -rf /opt/software/python
    cp -rL /opt/oss/NCE*/apps/DTAgentService/rtsp/python /opt/software
    chown root: /opt/software/python
    chmod 500 /opt/software/python
    nohup /opt/software/python/bin/python -u /opt/install/logicrep_install.py* "$1" >logicrep_install.log 2>&1 &
  else
    echo "The Python environment is abnormal"
    exit 1
  fi
  sleep 3
fi


cp /opt/install/start_logicrep.sh /opt/software/

while [ ! -f "/opt/software/port" ]
do
  sleep 1
done
port=$(cat /opt/software/port)

if [ -f "/etc/rc.d/after.local" ];then
  sed -i '/start_logicrep/d' /etc/rc.d/after.local
  echo "nohup bash /opt/software/start_logicrep.sh $1 $port  > /dev/null 2>&1 &" >> /etc/rc.d/after.local
elif [ -f "/etc/rc.d/rc.local" ];then
  sed -i '/start_logicrep/d' /etc/rc.d/rc.local
  echo "nohup bash /opt/software/start_logicrep.sh $1 $port  > /dev/null 2>&1 &" >> /etc/rc.d/rc.local
fi
nohup bash /opt/software/start_logicrep.sh "$1" "$port"  > /dev/null 2>&1 &
sleep 10

echo "=============================== end install logicrep ==================================="
exit 0
