#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
log_dir=`sh ${EXEC_HOME}/../scripts/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log

function main()
{
    des_dir=/opt/oss/easysuite/easysuite/var/temp/iMasterNCE-Fabric_zip_dir
    plugin_dir=/opt/oss/easysuite/easysuite/easysuite/plugins/iMasterNCE-Fabric
    upgrade_online_dir=${plugin_dir}/upgrade_online
    service_dir=${plugin_dir}/upgrade_online/service
    upload_zip_dir=/opt/oss/easysuite/easysuite/var/temp/upgrade/upgrade

    # 如果目录存在说明不需要解压脚本
    if [[ -d ${service_dir}/scripts/pyscripts ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "do not need unzip file"
        exit 0
    fi

    if [[ ! -d ${service_dir}/scripts/pyscripts ]] && [[ ! -f ${des_dir}/scripts.zip ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "can not find ${des_dir}/scripts.zip"
        exit 1
    fi

    if [[ ! -d ${upgrade_online_dir}/databasemigrate ]] && [[ ! -f ${des_dir}/databasemigrate.zip ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "can not find ${des_dir}/databasemigrate.zip"
        exit 1
    fi

    unzip -o ${des_dir}/databasemigrate.zip -d ${upgrade_online_dir}
    result1=$?
    unzip -o ${des_dir}/extend.zip -d ${service_dir}
    result2=$?
    unzip -o ${des_dir}/scripts.zip -d ${service_dir}
    result3=$?
    if [[ ${result1} != "0" ]] || [[ ${result2} != "0" ]] || [[ ${result3} != "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "unzip file failed: result1: ${result1}, result2: ${result2}, result3: ${result3}"
        exit 1
    fi

    # 重新压缩 /opt/oss/easysuite/easysuite/var/temp/upgrade/upgrade下的zip包
    if [[ ! -d ${upload_zip_dir}/iMasterNCE-Fabric ]]
    then
        mkdir -p ${upload_zip_dir}/iMasterNCE-Fabric
    fi
    cp -raf ${service_dir}/scripts/* ${upload_zip_dir}/iMasterNCE-Fabric

    cd ${upload_zip_dir}
    if [[ -f ${upload_zip_dir}/upload_pkg.zip ]]
    then
        # 向压缩包中追加目录
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "upload_pkg exists, zip file to upload_pkg.zip"
        zip -u -rq upload_pkg.zip iMasterNCE-Fabric
    else
        # 重新压缩
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "upload_pkg dose not exists, start zip upload_pkg.zip"
        zip -rq upload_pkg.zip *
    fi
    if [[ $? != "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "zip upload_pkg.zip，failed"
        exit 1
    fi


}
main >> ${log_file} 2>&1
