import os
import sys
import subprocess
from datetime import datetime
sys.path.append(os.path.split(os.path.abspath(__file__))[0])
import set_log
import get_temporary_path
from func.upgrade.upgrade_operation_mgr.dao.upgrade_childtask_dao import UpgradeChildTaskDao


def exe(kvs):
    temporary_path = get_temporary_path.get_temporary_path()
    modify_dict = {'remain_time': '0', 'progress': '100', 'status': 'finish'}
    cur_path = os.path.split(__file__)[0]
    cur_file_name = os.path.split(__file__)[1]
    get_log_shell = os.path.join(cur_path, "..", "scripts", "get_log_dir.sh")
    _, log_dir = subprocess.getstatusoutput("sh %s" % get_log_shell)
    my_log = set_log.set_log(filename=os.path.join(log_dir, "%s.log" % cur_file_name))
    easysuite_upgrade_params = kvs.get('easysuite_upgrade_params')
    task_id = easysuite_upgrade_params.get('task_id')
    sub_task_id = easysuite_upgrade_params.get('sub_task_id')
    child_task_id = easysuite_upgrade_params.get('child_task_id')
    simple_kvs = easysuite_upgrade_params.get('simple_kvs')
    standby_ip = simple_kvs.get('standby').get('0').get('ip')
    standby_ip_pwd = simple_kvs.get('standby').get('0').get('ossadm')
    sopuser_pwd = simple_kvs.get('standby').get('0').get('sopuser')
    root_pwd = easysuite_upgrade_params.get('adminpwd')
    result = 1
    start_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
    msg = "[%s] Start query os after upgrade" % start_time
    cur_path = os.path.split(__file__)[0]
    try:
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg})
        upgrade_step = "after"
        command = "sh %s %s %s %s %s %s %s" % (
            os.path.join(cur_path, "ssh_exec.sh"), upgrade_step, standby_ip, standby_ip_pwd, sopuser_pwd, "query_os_after_rollback", root_pwd)
        subprocess.call(command.split(), stdout=subprocess.PIPE, stdin=subprocess.PIPE)
        command = "sh %s %s %s %s %s %s %s" % (
            os.path.join(cur_path, "get_os_result.sh"), standby_ip, standby_ip_pwd, sopuser_pwd, root_pwd,
            temporary_path, "os_result_after_rollback")
        subprocess.call(command.split(), stdout=subprocess.PIPE, stdin=subprocess.PIPE)
        flag_path = os.path.join(temporary_path, "os_result_after_rollback_standy.flag")
        if os.path.exists(flag_path):
            with open(flag_path, 'r') as f:
                if "failed" in f.read():
                    result = 1
                else:
                    result = 0
        else:
            result = 1
    except:
        my_log.exception("Excepion logged")
    if result != 0:
        end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        msg = msg + '\n' + "[%s] Query os after rollback failed" % end_time
        modify_dict["status"] = "error"
        modify_dict["msg"] = msg
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, modify_dict)
        return False
    else:
        end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        msg = msg + '\n' + "[%s] Query os after rollback successfully" % end_time
        modify_dict["msg"] = msg
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, modify_dict)
        return True
