import time
import os
import subprocess
from datetime import datetime
from func.upgrade.upgrade_operation_mgr.dao.upgrade_childtask_dao import UpgradeChildTaskDao



def exe(kvs):
    cur_path = os.path.split(__file__)[0]
    easysuite_upgrade_params = kvs.get('easysuite_upgrade_params')
    task_id = easysuite_upgrade_params.get('task_id')
    sub_task_id = easysuite_upgrade_params.get('sub_task_id')
    child_task_id = easysuite_upgrade_params.get('child_task_id')
    root_pwd = easysuite_upgrade_params.get('adminpwd')
    simple_kvs = easysuite_upgrade_params.get('simple_kvs')
    standby_ip = simple_kvs.get('standby').get('0').get('ip')
    standby_ip_pwd = simple_kvs.get('standby').get('0').get('ossadm')
    sopuser_pwd = simple_kvs.get('standby').get('0').get('sopuser')
    upgrade_step = "after"
    start_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
    msg = "[%s] Start query os before upgrade" % start_time
    UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg})
    time.sleep(10)
    command = "sh %s %s %s %s %s %s %s" % (
        os.path.join(cur_path, "ssh_exec.sh"), upgrade_step, standby_ip, standby_ip_pwd, sopuser_pwd, "query_os_src", root_pwd)
    result = subprocess.call(command.split(), stdout=subprocess.PIPE, stdin=subprocess.PIPE)
    if result != 0:
        end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        msg = msg + '\n' + "[%s] Query os before upgrade failed" % end_time
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'remain_time': '0'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'progress': '100'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'status': 'error'})
        print(UpgradeChildTaskDao.query(task_id, sub_task_id, child_task_id))
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg})
        return False
    else:
        end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        msg = msg + '\n' + "[%s] Query os before upgrade successfully" % end_time
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'remain_time': '0'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'progress': '100'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'status': 'finish'})
        print(UpgradeChildTaskDao.query(task_id, sub_task_id, child_task_id))
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg})
        return True