import time
import os
import subprocess
from datetime import datetime
from func.upgrade.upgrade_operation_mgr.dao.upgrade_childtask_dao import UpgradeChildTaskDao

def exe(kvs):
    cur_path = os.path.split(__file__)[0]
    easysuite_upgrade_params = kvs.get('easysuite_upgrade_params')
    task_id = easysuite_upgrade_params.get('task_id')
    sub_task_id = easysuite_upgrade_params.get('sub_task_id')
    child_task_id = easysuite_upgrade_params.get('child_task_id')
    root_pwd = easysuite_upgrade_params.get('adminpwd')
    start_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
    msg = "[%s] Start rollback os" % start_time
    UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg})
    UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'status': 'running'})
    time.sleep(10)
    command = "sh %s %s" % (
        os.path.join(cur_path, "rollback_os.sh"), root_pwd)
    result = subprocess.call(command.split(), stdout=subprocess.PIPE, stdin=subprocess.PIPE)
    # 这个判断待定
    if result != 0:
        end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        msg = msg + '\n' + "[%s] Rollback os failed" % end_time
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'remain_time': '0'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'progress': '100'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'status': 'finish'})
        print(UpgradeChildTaskDao.query(task_id, sub_task_id, child_task_id))
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg})
        return True
    else:
        end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        msg = msg + '\n' + "[%s] Rollback os successfully.The environment is about to restart. Restart EasySuite after the environment restarts" % end_time
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'remain_time': '0'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'progress': '100'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'status': 'finish'})
        print(UpgradeChildTaskDao.query(task_id, sub_task_id, child_task_id))
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg})
        return True