#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
log_dir=`sh ${CUR_PATH}/../scripts/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}


function main()
{

    # 获取节点IP（线上版）
    . /opt/oss/manager/agent/bin/engr_profile.sh
    IPS=$(python ${CUR_PATH}/../scripts/pyscripts/updatenodes_NCE.py)
    result=$?
    if [[ ${result} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get IPS successfully: ${IPS}" | tee -a ${log_file}
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get IPS failed" | tee -a ${log_file}
            exit 1
    fi


    # 升级osconfig --可能要区分升级路径
    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:/ })
        ip=${ip_port_array[0]}
        ssh -o StrictHostKeyChecking=no ossadm@${ip} << EOF
            bash /opt/oss/manager/var/osconfig/osconfig_upgrade.sh -oldinstallpath /usr/local/osconfig -newinstallpath /usr/local/osconfig -newsudobin /usr/local/uniepsudobin
EOF
    done

}

main >> ${log_file} 2>&1
