#!/bin/bash

ip=${1}
temporary_dir=${2}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@"

function main()
{
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start to prepare /opt/os_patch_online"
    # 解压目录
    os_patch_online=/opt/os_patch_online

    # 结果目录
    os_patch_online_result=${temporary_dir}/os_online_rollback_result_${ip}.txt
    if [[ -f ${os_patch_online_result} ]]
    then
        su - ossadm - c "rm -rf ${os_patch_online_result}"
    fi

    # 重启的记录
    if [[ -f ${temporary_dir}/os_online_reboot_for_rollback.flag ]]
    then
        su - ossadm -c "rm -rf -f ${temporary_dir}/os_online_reboot_for_rollback.flag"
    fi

    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start to unzip os_patch.tar"
    cd ${os_patch_online}/os_patch
    sleep 1
    bash os_rollback_online.sh
    result=$?
    if [[ ${result} -eq 0 ]];then
        echo "success install, result_code: ${result}" > ${os_patch_online_result}
    elif [[ ${result} -eq 9 ]];then
        echo "success skip, result_code: ${result}" > ${os_patch_online_result}
    else
        echo "failed install, result_code: ${result}" > ${os_patch_online_result}
    fi
    chown ossadm: ${os_patch_online_result}
}

main
