'''
compare
'''

import os
import csv
import json
from openpyxl import Workbook

TITLES = {
    "DB_TAB_COLUMNS": ["变更类型", 'INSTANCE', 'OWNER', 'table_name', 'COLUMN_NAME', '变更说明',
                       "upgrade_data_type", "upgrade_data_default", "upgrade_nullable",
                       "install_data_type", "install_data_default", "install_nullable"],
    "DB_INDEXES": ["变更类型", 'INSTANCE', 'OWNER', 'TABLE_NAME', 'COLUMN_NAME', '变更说明',
                   "upgrade_index_name", "install_index_name"],
    "DB_PROCEDURES": ["变更类型", 'INSTANCE', 'OWNER', 'OBJECT_NAME', '基线_SOURCE', '升级_SOURCE', '变更说明',
                      "upgrade_object_type", "upgrade_source", "install_object_type", "install_source"],
    "PRIMARY_KEY": ["变更类型", 'INSTANCE', 'OWNER', 'TABLE_NAME', '变更说明']
}


def main(base_line, upgrade, db_report):
    '''
    main
    :return:
    '''
    # 打开工作表格
    wb = Workbook()
    # 删除默认的工作表格
    wb.remove(wb.active)

    has_difference = False
    for select_type_file in os.listdir(base_line):
        none_all = []
        select_type = os.path.splitext(select_type_file)[0]
        base_line_select_type = os.path.join(base_line, select_type_file)
        upgrade_select_type = os.path.join(upgrade, select_type_file)
        with open(base_line_select_type, "rb") as f_base, open(upgrade_select_type, "rb") as f_upgrade:
            json_base = json.load(f_base)
            json_upgrade = json.load(f_upgrade)
        # 循环基线中的所有的实例、db、表、字段，与升级上来的进行比较
        for db_instance in json_base.keys():
            if db_instance not in json_upgrade:
                continue
            # 比较实例下的所有db（升级有，基线没有的）
            none_all.extend(
                compare(
                    set(json_base[db_instance].keys()),
                    set(json_upgrade[db_instance].keys()),
                    select_type,
                    ["升级后新增用户(升级残留)", db_instance]
                )
            )
            for db_name in json_base[db_instance].keys():
                if db_name not in json_upgrade[db_instance]:
                    none_all.append(["升级后缺少用户", db_instance, db_name] + [""] * (len(TITLES[select_type]) - 2))
                    continue
                # 比较db下的所有table_name(升级有，基线没有的),db_index不比较表新增，因为在DB_TAB_COLUMNS中有体现
                if select_type != "DB_INDEXES" or select_type == "PRIMARY_KEY":
                    none_all.extend(
                        compare(
                            set(json_base[db_instance][db_name].keys()),
                            set(json_upgrade[db_instance][db_name].keys()),
                            select_type,
                            ["升级后新增表(升级残留)", db_instance, db_name]
                        )
                    )
                for table_name in json_base[db_instance][db_name].keys():
                    if table_name not in json_upgrade[db_instance][db_name]:
                        # db_index不比较表缺失，因为在DB_TAB_COLUMNS中有体现
                        if select_type != "DB_INDEXES" or select_type == "PRIMARY_KEY":
                            none_all.append(["升级后缺少表", db_instance, db_name, table_name] + [""] * (len(TITLES[select_type]) - 3))
                        continue
                    if select_type == "DB_TAB_COLUMNS" or select_type == "DB_INDEXES":
                        # 比较table_name下的所有column_name(对于索引来讲就是index_name)（升级有，基线没有的）
                        none_all.extend(
                            compare(
                                set(json_base[db_instance][db_name][table_name].keys()),
                                set(json_upgrade[db_instance][db_name][table_name].keys()),
                                select_type,
                                ["升级后新增字段/索引(升级残留)", db_instance, db_name, table_name]
                            )
                        )
                        for column_name in json_base[db_instance][db_name][table_name].keys():
                            if column_name not in json_upgrade[db_instance][db_name][table_name]:
                                none_all.append(["升级后缺少字段/索引", db_instance, db_name, table_name, column_name] + [""] * (len(TITLES[select_type]) - 4))
                                continue
                            result_str = ""
                            dict_base_line = json_base[db_instance][db_name][table_name][column_name]
                            dict_upgrade = json_upgrade[db_instance][db_name][table_name][column_name]
                            for key, value in dict_base_line.items():
                                if value != dict_upgrade[key]:
                                    if select_type == "DB_TAB_COLUMNS" and key == "data_default":
                                        upgrade_value = dict_upgrade[key]
                                        install_value = value
                                        if upgrade_value is None:
                                            upgrade_value = ""
                                        if install_value is None:
                                            install_value = ""
                                        if upgrade_value.strip() != install_value.strip():
                                            result_str += "\n%s: 基线: %s  升级: %s" % (key, value, dict_upgrade[key])
                                    else:
                                        result_str += "\n%s: 基线: %s  升级: %s" % (key, value, dict_upgrade[key])
                            if result_str:
                                result_data = ["变更", db_instance, db_name, table_name, column_name, result_str.strip()]
                                result_data += [""] * (len(TITLES[select_type]) - len(result_data))
                                none_all.append(result_data)
                    else:
                        # 对于DB_PROCEDURES 下 SOURCE字段的特殊处理
                        source = []
                        result_str = ""
                        dict_base_line = json_base[db_instance][db_name][table_name]
                        dict_upgrade = json_upgrade[db_instance][db_name][table_name]
                        for key, value in dict_base_line.items():
                            if value.strip() != dict_upgrade[key].strip():
                                if select_type == "DB_PROCEDURES" and key == "SOURCE":
                                    source.append(value)
                                    source.append(dict_upgrade[key])
                                else:
                                    result_str += "\n%s: 基线: %s  升级: %s" % (key, value, dict_upgrade[key])
                        if result_str or source:
                            result_data = ["变更", db_instance, db_name, table_name] + source + [result_str.strip()]
                            result_data += [""] * (len(TITLES[select_type]) - len(result_data))
                            none_all.append(result_data)
        if none_all:
            none_all = deal_result(select_type, none_all, json_base, json_upgrade)
            none_all.sort(key=lambda change_type: (change_type[0], change_type[1], change_type[2], change_type[3]))
            sheet = wb.create_sheet("%s,升级相对于安装" % select_type)
            has_difference = True
            titles = TITLES[select_type]
            sheet.append(titles)
            for row in none_all:
                sheet.append(row)

    file_dir_path = os.path.join(db_report, "result")
    if not os.path.exists(file_dir_path):
        os.makedirs(file_dir_path)
    if not has_difference:
        with open(os.path.join(file_dir_path, "no_difference.txt"), "w") as _f:
            _f.write("There is no db difference between the upgrade environment and the installation environment")
    else:
        file_dir_path = os.path.join(db_report, "result")
        if not os.path.exists(file_dir_path):
            os.makedirs(file_dir_path)
        wb.save(os.path.join(file_dir_path, "db_difference_report.xlsx"))


def deal_result(select_type, none_all, json_base, json_upgrade):
    '''
    :param select_type:
    :param none_all:
    :param json_base:
    :param json_upgrade:
    :return:
    '''
    title = TITLES[select_type]
    upgrade = "upgrade_"
    install = "install_"
    index1 = title.index("变更说明") - 1
    for data in none_all:
        if data[index1]:
            if "新增" in data[0]:
                dic = get_dict(json_upgrade, data, index1)
                for index, value in enumerate(title):
                    if upgrade in value:
                        data[index] = dic[value.split(upgrade)[1]]
            elif "缺少" in data[0]:
                dic = get_dict(json_base, data, index1)
                for index, value in enumerate(title):
                    if install in value:
                        data[index] = dic[value.split(install)[1]]
            else:
                dic_upgrade = get_dict(json_upgrade, data, index1)
                dic_install = get_dict(json_base, data, index1)
                for index, value in enumerate(title):
                    if upgrade in value:
                        data[index] = dic_upgrade[value.split(upgrade)[1]]
                for index, value in enumerate(title):
                    if install in value:
                        data[index] = dic_install[value.split(install)[1]]
    return none_all


def get_dict(dic, data, index1):
    '''
    :param dic:
    :param data:
    :param index1:
    :return:
    '''
    start = 1
    while start <= index1:
        dic = dic[data[start]]
        start += 1
    return dic


def compare(base_line, upgrade, select_type, base_list):
    '''
    :param base_line:
    :param upgrade:
    :param select_type:
    :param base_list:
    :return:
    '''
    result = []
    for data in upgrade.difference(base_line):
        result.append(base_list + [data] + [""] * (len(TITLES[select_type]) - len(base_list)))
    return result


def write_csv(titles, csv_name, data):
    '''
    :param titles: 
    :param csv_name: 
    :param data: 
    :return: 
    '''
    file_dir_path = os.path.join(db_report, "result")
    if not os.path.exists(file_dir_path):
        os.makedirs(file_dir_path)
    with open(os.path.join(file_dir_path, csv_name), "w", newline='', encoding="GB18030") as _f:
        csv_writer = csv.writer(_f)
        csv_writer.writerow(titles)
        csv_writer.writerows(data)


if __name__ == '__main__':
    main("base_line", "upgrade", db_report=r"D:\NCE\code_hub\R21C00_ES_master1\deployment\product_apps\iMasterNCE-Fabric\upgrade_online\service\scripts\compare_database")
